/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.testapi.execute;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import org.pitest.testapi.Configuration;
import org.pitest.testapi.TestListener;
import org.pitest.testapi.TestResult;
import org.pitest.testapi.TestUnit;
import org.pitest.testapi.execute.Container;
import org.pitest.testapi.execute.FindTestUnits;
import org.pitest.testapi.execute.ResultType;
import org.pitest.util.Log;
import org.pitest.util.PitError;

public class Pitest {
    private static final Logger LOG = Log.getLogger();
    private final TestListener listener;

    public Pitest(TestListener listener) {
        this.listener = listener;
    }

    public void run(Container container, List<? extends TestUnit> testUnits) {
        LOG.fine("Running " + testUnits.size() + " units");
        this.signalRunStartToAllListeners();
        this.executeTests(container, testUnits);
        this.signalRunEndToAllListeners();
    }

    private void executeTests(Container container, List<? extends TestUnit> testUnits) {
        for (TestUnit testUnit : testUnits) {
            List<TestResult> results = container.execute(testUnit);
            this.processResults(results);
        }
    }

    @Deprecated
    public void run(Container defaultContainer, Configuration config, Class<?> ... classes) {
        this.run(defaultContainer, config, Arrays.asList(classes));
    }

    private void run(Container container, Configuration config, Collection<Class<?>> classes) {
        FindTestUnits find = new FindTestUnits(config);
        this.run(container, find.findTestUnitsForAllSuppliedClasses(classes));
    }

    private void processResults(List<TestResult> results) {
        for (TestResult result : results) {
            ResultType classifiedResult = this.classify(result);
            classifiedResult.getListenerFunction(result).accept(this.listener);
        }
    }

    private void signalRunStartToAllListeners() {
        this.listener.onRunStart();
    }

    private void signalRunEndToAllListeners() {
        this.listener.onRunEnd();
    }

    private ResultType classify(TestResult result) {
        switch (result.getState()) {
            case STARTED: {
                return ResultType.STARTED;
            }
            case NOT_RUN: {
                return ResultType.SKIPPED;
            }
            case FINISHED: {
                return this.classifyFinishedTest(result);
            }
        }
        throw new PitError("Unhandled state");
    }

    private ResultType classifyFinishedTest(TestResult result) {
        if (result.getThrowable() != null) {
            return ResultType.FAIL;
        }
        return ResultType.PASS;
    }
}

