/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.testapi.execute;

import java.util.function.Consumer;
import java.util.function.Function;
import org.pitest.testapi.TestListener;
import org.pitest.testapi.TestResult;

public enum ResultType {
    PASS(ResultType::success),
    FAIL(ResultType::failure),
    SKIPPED(ResultType::skipped),
    STARTED(ResultType::started);

    private final Function<TestResult, Consumer<TestListener>> function;

    private ResultType(ResultToListenerSideEffect f) {
        this.function = f;
    }

    public Consumer<TestListener> getListenerFunction(TestResult result) {
        return this.function.apply(result);
    }

    public static Consumer<TestListener> success(TestResult result) {
        return a -> a.onTestSuccess(result);
    }

    public static Consumer<TestListener> failure(TestResult result) {
        return a -> a.onTestFailure(result);
    }

    public static Consumer<TestListener> skipped(TestResult result) {
        return a -> a.onTestSkipped(result);
    }

    public static Consumer<TestListener> started(TestResult result) {
        return a -> a.onTestStart(result.getDescription());
    }

    private static interface ResultToListenerSideEffect
    extends Function<TestResult, Consumer<TestListener>> {
    }
}

