/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.testng;

import java.util.Collection;
import java.util.Optional;
import org.pitest.extension.common.NoTestSuiteFinder;
import org.pitest.help.Help;
import org.pitest.help.PitHelpError;
import org.pitest.testapi.Configuration;
import org.pitest.testapi.TestGroupConfig;
import org.pitest.testapi.TestSuiteFinder;
import org.pitest.testapi.TestUnitFinder;
import org.pitest.testng.TestNGTestUnitFinder;

public class TestNGConfiguration
implements Configuration {
    private final TestGroupConfig config;
    private final Collection<String> includedTestMethods;

    public TestNGConfiguration(TestGroupConfig config, Collection<String> includedTestMethods) {
        this.config = config;
        this.includedTestMethods = includedTestMethods;
    }

    @Override
    public TestUnitFinder testUnitFinder() {
        return new TestNGTestUnitFinder(this.config, this.includedTestMethods);
    }

    @Override
    public TestSuiteFinder testSuiteFinder() {
        return new NoTestSuiteFinder();
    }

    @Override
    public Optional<PitHelpError> verifyEnvironment() {
        try {
            Class.forName("org.testng.annotations.Test");
        }
        catch (ClassNotFoundException | NoClassDefFoundError er) {
            return Optional.ofNullable(new PitHelpError(Help.NO_TEST_LIBRARY, new Object[0]));
        }
        return Optional.empty();
    }
}

