/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz;

import org.tukaani.xz.ArrayCache;
import org.tukaani.xz.BCJCoder;
import org.tukaani.xz.BCJOptions;
import org.tukaani.xz.FilterEncoder;
import org.tukaani.xz.FinishableOutputStream;

class BCJEncoder
extends BCJCoder
implements FilterEncoder {
    private final BCJOptions options;
    private final long filterID;
    private final byte[] props;

    BCJEncoder(BCJOptions bCJOptions, long l) {
        assert (BCJEncoder.isBCJFilterID(l));
        int n = bCJOptions.getStartOffset();
        if (n == 0) {
            this.props = new byte[0];
        } else {
            this.props = new byte[4];
            for (int j = 0; j < 4; ++j) {
                this.props[j] = (byte)(n >>> j * 8);
            }
        }
        this.filterID = l;
        this.options = (BCJOptions)bCJOptions.clone();
    }

    public long getFilterID() {
        return this.filterID;
    }

    public byte[] getFilterProps() {
        return this.props;
    }

    public boolean supportsFlushing() {
        return false;
    }

    public FinishableOutputStream getOutputStream(FinishableOutputStream finishableOutputStream, ArrayCache arrayCache) {
        return this.options.getOutputStream(finishableOutputStream, arrayCache);
    }
}

