/*
 * Decompiled with CFR 0.152.
 */
package spoon;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import spoon.reflect.CtModelImpl;
import spoon.reflect.code.CtArrayWrite;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldWrite;
import spoon.reflect.code.CtLambda;
import spoon.reflect.code.CtVariableWrite;
import spoon.reflect.cu.CompilationUnit;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.declaration.CtAnonymousExecutable;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtModifiable;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtShadowable;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeParameter;
import spoon.reflect.declaration.ParentNotInitializedException;
import spoon.reflect.path.CtPath;
import spoon.reflect.path.CtPathException;
import spoon.reflect.path.CtPathStringBuilder;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtBiScannerDefault;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.JavaIdentifiers;
import spoon.reflect.visitor.PrinterHelper;
import spoon.reflect.visitor.filter.TypeFilter;
import spoon.support.Experimental;
import spoon.support.Internal;
import spoon.support.reflect.CtExtendedModifier;
import spoon.support.sniper.internal.ElementSourceFragment;
import spoon.support.visitor.equals.EqualsVisitor;
import spoon.testing.utils.Check;

@Experimental
public class ContractVerifier {
    private CtPackage _rootPackage;

    public ContractVerifier(CtPackage rootPackage) {
        this._rootPackage = rootPackage;
    }

    public ContractVerifier() {
    }

    public void verify() {
        this.checkShadow();
        this.checkParentContract();
        this.checkParentConsistency();
        this.checkModifiers();
        this.checkAssignmentContracts();
        this.checkContractCtScanner();
        this.checkBoundAndUnboundTypeReference();
        this.checkModelIsTree();
        this.checkContractCtScanner();
        this.checkElementIsContainedInAttributeOfItsParent();
        this.checkElementToPathToElementEquivalence();
        this.checkRoleInParent();
        this.checkJavaIdentifiers();
    }

    public void checkModifiers() {
        for (CtModifiable modifiable : this._rootPackage.getElements(new TypeFilter<CtModifiable>(CtModifiable.class))) {
            for (CtExtendedModifier modifier : modifiable.getExtendedModifiers()) {
                if (modifier.isImplicit()) continue;
                SourcePosition position = modifier.getPosition();
                CompilationUnit compilationUnit = position.getCompilationUnit();
                String originalSourceCode = compilationUnit.getOriginalSourceCode();
                this.assertEquals(modifier.getKind().toString(), originalSourceCode.substring(position.getSourceStart(), position.getSourceEnd() + 1));
            }
        }
    }

    private static void assertTrue(String msg, boolean conditionThatMustHold) {
        if (!conditionThatMustHold) {
            throw new AssertionError((Object)msg);
        }
    }

    private void assertFalse(boolean condition) {
        ContractVerifier.assertTrue("", !condition);
    }

    private void assertEquals(Object expected, Object actual) {
        this.assertEquals("assertEquals violation", expected, actual);
    }

    private void assertEquals(String msg, Object expected, Object actual) {
        if (!expected.equals(actual)) {
            throw new AssertionError((Object)msg);
        }
    }

    private void assertNotSame(Object element, Object other) {
        if (element == other) {
            throw new AssertionError((Object)"assertSame violation");
        }
    }

    private void assertSame(Object element, Object other) {
        this.assertSame("assertSame violation", element, other);
    }

    private void assertSame(String msg, Object element, Object other) {
        if (element != other) {
            throw new AssertionError((Object)msg);
        }
    }

    private void fail(String msg) {
        throw new AssertionError((Object)msg);
    }

    public void checkParentContract() {
        this._rootPackage.filterChildren(null).forEach(elem -> ContractVerifier.assertTrue("no parent for " + elem.getClass() + "-" + elem.getPosition(), elem.isParentInitialized()));
        new CtScanner(){
            Deque<CtElement> elementStack = new ArrayDeque<CtElement>();

            @Override
            public void scan(CtElement e) {
                if (e == null) {
                    return;
                }
                if (e instanceof CtReference) {
                    return;
                }
                if (!this.elementStack.isEmpty()) {
                    ContractVerifier.this.assertEquals(this.elementStack.peek(), e.getParent());
                }
                this.elementStack.push(e);
                e.accept(this);
                this.elementStack.pop();
            }
        }.scan(this._rootPackage);
    }

    public void checkBoundAndUnboundTypeReference() {
        new CtScanner(){

            @Override
            public void visitCtTypeParameterReference(CtTypeParameterReference ref) {
                CtTypeParameter declaration = ref.getDeclaration();
                if (declaration != null) {
                    ContractVerifier.this.assertEquals(ref.getSimpleName(), declaration.getSimpleName());
                }
                super.visitCtTypeParameterReference(ref);
            }
        }.scan(this._rootPackage);
    }

    public void checkShadow() {
        new CtScanner(){

            @Override
            public void scan(CtElement element) {
                if (element != null && CtShadowable.class.isAssignableFrom(element.getClass())) {
                    ContractVerifier.this.assertFalse(((CtShadowable)((Object)element)).isShadow());
                }
                super.scan(element);
            }

            @Override
            public <T> void visitCtTypeReference(CtTypeReference<T> reference) {
                Check.assertNotNull(reference);
                if ("<nulltype>".equals(reference.getSimpleName()) || "?".equals(reference.getSimpleName())) {
                    super.visitCtTypeReference(reference);
                    return;
                }
                CtType<T> typeDeclaration = reference.getTypeDeclaration();
                Check.assertNotNull(reference.toString() + " cannot be found in ", typeDeclaration);
                ContractVerifier.this.assertEquals(reference.getSimpleName(), typeDeclaration.getSimpleName());
                ContractVerifier.this.assertEquals(reference.getQualifiedName(), typeDeclaration.getQualifiedName());
                if (reference.getDeclaration() == null) {
                    ContractVerifier.assertTrue("typeDeclaration must be shadow", typeDeclaration.isShadow());
                }
                super.visitCtTypeReference(reference);
            }

            @Override
            public <T> void visitCtExecutableReference(CtExecutableReference<T> reference) {
                super.visitCtExecutableReference(reference);
                Check.assertNotNull(reference);
                if (this.isLanguageExecutable(reference)) {
                    return;
                }
                CtExecutable<T> executableDeclaration = reference.getExecutableDeclaration();
                Check.assertNotNull("cannot find decl for " + reference.toString(), executableDeclaration);
                ContractVerifier.this.assertEquals(reference.getSimpleName(), executableDeclaration.getSimpleName());
                for (int i2 = 0; i2 < reference.getParameters().size(); ++i2) {
                    if (executableDeclaration instanceof CtLambda) {
                        return;
                    }
                    CtTypeReference methodParamTypeRef = executableDeclaration.getParameters().get(i2).getType();
                    ContractVerifier.this.assertEquals(reference.getParameters().get(i2).getQualifiedName(), methodParamTypeRef.getTypeErasure().getQualifiedName());
                }
                if (reference.getActualTypeArguments().isEmpty() && executableDeclaration instanceof CtMethod && !((CtMethod)executableDeclaration).getFormalCtTypeParameters().isEmpty()) {
                    ContractVerifier.this.assertEquals(reference.getSignature(), executableDeclaration.getSignature());
                }
                if (reference.getActualTypeArguments().isEmpty() && executableDeclaration instanceof CtConstructor && !((CtConstructor)executableDeclaration).getFormalCtTypeParameters().isEmpty()) {
                    ContractVerifier.this.assertEquals(reference.getSignature(), executableDeclaration.getSignature());
                }
                if (reference.getDeclaration() == null && CtShadowable.class.isAssignableFrom(executableDeclaration.getClass())) {
                    ContractVerifier.assertTrue("execDecl at " + reference.toString() + " must be shadow ", ((CtShadowable)((Object)executableDeclaration)).isShadow());
                }
            }

            private <T> boolean isLanguageExecutable(CtExecutableReference<T> reference) {
                return "values".equals(reference.getSimpleName());
            }

            @Override
            public <T> void visitCtFieldReference(CtFieldReference<T> reference) {
                Check.assertNotNull(reference);
                if (this.isLanguageField(reference) || this.isDeclaredInSuperClass(reference)) {
                    super.visitCtFieldReference(reference);
                    return;
                }
                CtField<T> fieldDeclaration = reference.getFieldDeclaration();
                Check.assertNotNull(fieldDeclaration);
                ContractVerifier.this.assertEquals(reference.getSimpleName(), fieldDeclaration.getSimpleName());
                ContractVerifier.this.assertEquals(reference.getType().getQualifiedName(), fieldDeclaration.getType().getQualifiedName());
                if (reference.getDeclaration() == null) {
                    ContractVerifier.assertTrue("fieldDecl must be shadow", fieldDeclaration.isShadow());
                }
                super.visitCtFieldReference(reference);
            }

            private <T> boolean isLanguageField(CtFieldReference<T> reference) {
                return "class".equals(reference.getSimpleName()) || "length".equals(reference.getSimpleName());
            }

            private <T> boolean isDeclaredInSuperClass(CtFieldReference<T> reference) {
                CtType<?> typeDeclaration = reference.getDeclaringType().getTypeDeclaration();
                return typeDeclaration != null && typeDeclaration.getField(reference.getSimpleName()) == null;
            }
        }.visitCtPackage(this._rootPackage);
    }

    public void checkContractCtScanner() {
        class Counter {
            int scan;
            int enter;
            int exit;

            Counter() {
            }
        }
        final Counter counter = new Counter();
        final Counter counterInclNull = new Counter();
        new CtScanner(){
            {
            }

            @Override
            public void scan(CtElement element) {
                ++counterInclNull.scan;
                if (element != null) {
                    ++counter.scan;
                }
                super.scan(element);
            }

            @Override
            public void enter(CtElement element) {
                ++counter.enter;
                super.enter(element);
            }

            @Override
            public void exit(CtElement element) {
                ++counter.exit;
                super.exit(element);
            }
        }.scan(this._rootPackage);
        ContractVerifier.assertTrue("violated contract: when enter is called, exit is also called", counter.enter == counter.exit);
        ContractVerifier.assertTrue(" violated contract: all scanned elements ust call enter", counter.enter == counter.scan);
        final Counter counterBiScan = new Counter();
        class ActualCounterScanner
        extends CtBiScannerDefault {
            ActualCounterScanner() {
            }

            @Override
            public void biScan(CtElement element, CtElement other) {
                super.biScan(element, other);
                ++counterBiScan.scan;
                if (element == null) {
                    if (other != null) {
                        ContractVerifier.this.fail("element can't be null if other isn't null.");
                    }
                } else if (other == null) {
                    ContractVerifier.this.fail("other can't be null if element isn't null.");
                } else {
                    EqualsVisitor ev = new EqualsVisitor();
                    boolean res = ev.checkEquals(element, other);
                    Object notEqualOther = ev.getNotEqualOther();
                    String pb = "";
                    if (notEqualOther != null) {
                        notEqualOther.toString();
                    }
                    if (notEqualOther instanceof CtElement) {
                        pb = pb + " " + ((CtElement)notEqualOther).getPosition().toString();
                    }
                    ContractVerifier.assertTrue("not equal: " + pb, res);
                    ContractVerifier.this.assertNotSame(element, other);
                }
            }
        }
        ActualCounterScanner actual = new ActualCounterScanner();
        actual.biScan(this._rootPackage, this._rootPackage.clone());
        this.assertEquals(counterInclNull.scan, counterBiScan.scan);
        final Counter counterBiScan2 = new Counter();
        new CtBiScannerDefault(){
            {
            }

            @Override
            public void biScan(CtElement element, CtElement other) {
                ++counterBiScan2.scan;
                ContractVerifier.this.assertSame(element, other);
                super.biScan(element, other);
            }
        }.biScan(this._rootPackage, this._rootPackage);
        this.assertEquals(counterInclNull.scan, counterBiScan2.scan);
    }

    public void checkAssignmentContracts() {
        for (CtAssignment assign : this._rootPackage.getElements(new TypeFilter<CtAssignment>(CtAssignment.class))) {
            CtExpression assigned = assign.getAssigned();
            if (!(assigned instanceof CtFieldWrite || assigned instanceof CtVariableWrite || assigned instanceof CtArrayWrite)) {
                throw new AssertionError((Object)("AssignmentContract error:" + assign.getPosition() + "\n" + assign.toString() + "\nAssigned is " + assigned.getClass()));
            }
        }
    }

    public void checkParentConsistency() {
        this.checkParentConsistency(this._rootPackage);
    }

    @Internal
    public void checkParentConsistency(CtElement element) {
        final HashSet inconsistentParents = new HashSet();
        new CtScanner(){
            private Deque<CtElement> previous = new ArrayDeque<CtElement>();

            @Override
            protected void enter(CtElement e) {
                if (e != null) {
                    if (!this.previous.isEmpty()) {
                        try {
                            if (e.getParent() != this.previous.getLast()) {
                                inconsistentParents.add(e);
                            }
                        }
                        catch (ParentNotInitializedException ignore) {
                            inconsistentParents.add(e);
                        }
                    }
                    this.previous.add(e);
                }
                super.enter(e);
            }

            @Override
            protected void exit(CtElement e) {
                if (e == null) {
                    return;
                }
                if (!e.equals(this.previous.getLast())) {
                    throw new RuntimeException("Inconsistent stack");
                }
                this.previous.removeLast();
                super.exit(e);
            }
        }.scan(element);
        this.assertEquals("All parents have to be consistent", 0, inconsistentParents.size());
    }

    public void checkModelIsTree() {
        Exception dummyException = new Exception("STACK");
        PrinterHelper problems = new PrinterHelper(this._rootPackage.getFactory().getEnvironment());
        IdentityHashMap allElements = new IdentityHashMap();
        this._rootPackage.filterChildren(null).forEach(ele -> {
            Exception secondStack = dummyException;
            Exception firstStack = allElements.put(ele, secondStack);
            if (firstStack != null) {
                if (firstStack == dummyException) {
                    this.fail("The Spoon model is not a tree. The " + ele.getClass().getSimpleName() + ":" + ele.toString() + " is shared");
                }
                problems.write("The element " + ele.getClass().getSimpleName()).writeln().incTab().write(ele.toString()).writeln().write("Is linked by these stacktraces").writeln().write("1) " + this.getStackTrace(firstStack)).writeln().write("2) " + this.getStackTrace(secondStack)).writeln().decTab();
            }
        });
        String report = problems.toString();
        if (!report.isEmpty()) {
            this.fail(report);
        }
    }

    private String getStackTrace(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public void checkRoleInParent() {
        this._rootPackage.accept(new CtScanner(){

            @Override
            public void scan(CtRole role, CtElement element) {
                if (element != null) {
                    ContractVerifier.this.assertSame((Object)role, (Object)element.getRoleInParent());
                }
                super.scan(role, element);
            }
        });
    }

    private int assertSourcePositionTreeIsCorrectlyOrder(ElementSourceFragment sourceFragment, int minOffset, int maxOffset) {
        int nr = 0;
        int pos = minOffset;
        while (sourceFragment != null) {
            ++nr;
            ContractVerifier.assertTrue("min(" + pos + ") <= fragment.start(" + sourceFragment.getStart() + ")", pos <= sourceFragment.getStart());
            ContractVerifier.assertTrue("fragment.start(" + sourceFragment.getStart() + ") <= fragment.end(" + sourceFragment.getEnd() + ")", sourceFragment.getStart() <= sourceFragment.getEnd());
            pos = sourceFragment.getEnd();
            nr += this.assertSourcePositionTreeIsCorrectlyOrder(sourceFragment.getFirstChild(), sourceFragment.getStart(), sourceFragment.getEnd());
            sourceFragment = sourceFragment.getNextSibling();
        }
        ContractVerifier.assertTrue("lastFragment.end(" + pos + ") <= max(" + maxOffset + ")", pos <= maxOffset);
        return nr;
    }

    public void checkElementToPathToElementEquivalence() {
        this._rootPackage.getPackage("spoon").getElements(e -> true).parallelStream().forEach(element -> {
            CtPath path = element.getPath();
            String pathStr = path.toString();
            try {
                CtPath pathRead = new CtPathStringBuilder().fromString(pathStr);
                this.assertEquals(pathStr, pathRead.toString());
                List returnedElements = pathRead.evaluateOn(this._rootPackage);
                this.assertEquals(1, returnedElements.size());
                CtElement actualElement = (CtElement)returnedElements.toArray()[0];
                this.assertSame(element, actualElement);
            }
            catch (CtPathException e) {
                throw new AssertionError("Path " + pathStr + " is either incorrectly generated or incorrectly read", e);
            }
            catch (AssertionError e) {
                throw new AssertionError("Path " + pathStr + " detection failed on " + element.getClass().getSimpleName() + ": " + element.toString(), (Throwable)((Object)e));
            }
        });
    }

    public void checkElementIsContainedInAttributeOfItsParent() {
        this._rootPackage.accept(new CtScanner(){

            @Override
            public void scan(CtRole role, CtElement element) {
                if (element != null) {
                    CtElement parent = element.getParent();
                    Object attributeOfParent = parent.getValueByRole(role);
                    if (attributeOfParent instanceof CtElement) {
                        ContractVerifier.this.assertSame("Element of type " + element.getClass().getName() + " is not the value of attribute of role " + role.name() + " of parent type " + parent.getClass().getName(), element, attributeOfParent);
                    } else if (attributeOfParent instanceof Collection) {
                        ContractVerifier.assertTrue("Element of type " + element.getClass().getName() + " not found in Collection value of attribute of role " + role.name() + " of parent type " + parent.getClass().getName(), ((Collection)attributeOfParent).stream().anyMatch(e -> e == element));
                    } else if (attributeOfParent instanceof Map) {
                        ContractVerifier.assertTrue("Element of type " + element.getClass().getName() + " not found in Map#values of attribute of role " + role.name() + " of parent type " + parent.getClass().getName(), ((Map)attributeOfParent).values().stream().anyMatch(e -> e == element));
                    } else {
                        ContractVerifier.this.fail("Attribute of Role " + (Object)((Object)role) + " not checked");
                    }
                }
                super.scan(role, element);
            }
        });
    }

    public void checkGenericContracts() {
        this.checkParentContract();
        this.checkAssignmentContracts();
        this.checkContractCtScanner();
        this.checkBoundAndUnboundTypeReference();
    }

    public void checkJavaIdentifiers() {
        this._rootPackage.getElements(new TypeFilter<CtPackage>(CtPackage.class)).parallelStream().forEach(element -> {
            if (element instanceof CtModelImpl.CtRootPackage) {
                return;
            }
            ContractVerifier.assertTrue("isLegalJavaPackageIdentifier is broken for " + element.getSimpleName() + " " + element.getPosition(), JavaIdentifiers.isLegalJavaPackageIdentifier(element.getSimpleName()));
        });
        this._rootPackage.getElements(new TypeFilter<CtExecutable>(CtExecutable.class)).parallelStream().forEach(element -> {
            if (element instanceof CtAnonymousExecutable) {
                return;
            }
            ContractVerifier.assertTrue("isLegalJavaExecutableIdentifier is broken " + element.getSimpleName() + " " + element.getPosition(), JavaIdentifiers.isLegalJavaExecutableIdentifier(element.getSimpleName()));
        });
    }
}

