/*
 * Decompiled with CFR 0.152.
 */
package spoon;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.codehaus.plexus.util.CollectionUtils;
import spoon.Launcher;
import spoon.SpoonException;
import spoon.SpoonModelBuilder;
import spoon.reflect.cu.CompilationUnit;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtType;
import spoon.reflect.factory.Factory;
import spoon.reflect.reference.CtTypeReference;
import spoon.support.SerializationModelStreamer;

public class IncrementalLauncher
extends Launcher {
    private final Set<File> mInputSources;
    private final File mIncrementalCacheDirectory;
    private final File mModelFile;
    private final File mCacheInfoFile;
    private final File mClassFilesDir;
    private final boolean mChangesPresent;
    private Set<String> mSourceClasspath;
    private Set<File> mRemovedSources = new HashSet<File>();
    private Set<File> mAddedSources = new HashSet<File>();
    private Set<File> mCommonSources = new HashSet<File>();
    private CacheInfo mCacheInfo = null;

    /*
     * Enabled aggressive exception aggregation
     */
    private static CacheInfo loadCacheInfo(File file) throws InvalidClassException {
        try (FileInputStream fileStream = new FileInputStream(file);){
            CacheInfo cacheInfo;
            try (ObjectInputStream objectStream = new ObjectInputStream(new BufferedInputStream(fileStream));){
                cacheInfo = (CacheInfo)objectStream.readObject();
            }
            return cacheInfo;
        }
        catch (InvalidClassException e) {
            throw e;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new SpoonException("unable to load cache info");
        }
    }

    private static void saveCacheInfo(CacheInfo cacheInfo, File file) {
        try (FileOutputStream fileStream = new FileOutputStream(file);
             ObjectOutputStream objectStream = new ObjectOutputStream(new BufferedOutputStream(fileStream));){
            objectStream.writeObject(cacheInfo);
            objectStream.flush();
        }
        catch (IOException e) {
            throw new SpoonException("unable to save cache info");
        }
    }

    private static Factory loadFactory(File file) {
        try {
            return new SerializationModelStreamer().load(new FileInputStream(file));
        }
        catch (IOException e) {
            throw new SpoonException("unable to load factory from cache");
        }
    }

    private static void saveFactory(Factory factory, File file) {
        try {
            new SerializationModelStreamer().save(factory, new FileOutputStream(file));
        }
        catch (IOException e) {
            throw new SpoonException("unable to save factory");
        }
    }

    private static Set<File> getAllJavaFiles(Set<File> resources) {
        HashSet<File> javaFiles = new HashSet<File>();
        for (File e : resources) {
            if (e.isDirectory()) {
                Collection<File> files = FileUtils.listFiles(e, new SuffixFileFilter(".java"), TrueFileFilter.INSTANCE);
                files.forEach(f -> {
                    try {
                        javaFiles.add(f.getCanonicalFile());
                    }
                    catch (IOException e1) {
                        throw new SpoonException("unable to locate input source file: " + f);
                    }
                });
                continue;
            }
            if (!e.isFile() || !e.getName().endsWith(".java")) continue;
            try {
                javaFiles.add(e.getCanonicalFile());
            }
            catch (IOException e1) {
                throw new SpoonException("unable to locate input source file: " + e);
            }
        }
        return javaFiles;
    }

    public IncrementalLauncher(Set<File> inputResources, Set<String> sourceClasspath, File cacheDirectory, boolean forceRebuild) {
        if (cacheDirectory == null) {
            throw new IllegalArgumentException("unable to create incremental launcher with null cache directory");
        }
        this.mInputSources = IncrementalLauncher.getAllJavaFiles(inputResources);
        this.mSourceClasspath = new HashSet<String>(sourceClasspath);
        this.mIncrementalCacheDirectory = cacheDirectory;
        this.mModelFile = new File(cacheDirectory, "model");
        this.mCacheInfoFile = new File(cacheDirectory, "cache-info");
        this.mClassFilesDir = new File(cacheDirectory, "class-files");
        if (!(this.mIncrementalCacheDirectory.exists() && this.mModelFile.exists() && this.mCacheInfoFile.exists() && this.mClassFilesDir.exists())) {
            forceRebuild = true;
        } else {
            try {
                this.mCacheInfo = IncrementalLauncher.loadCacheInfo(this.mCacheInfoFile);
            }
            catch (InvalidClassException | SpoonException e) {
                forceRebuild = true;
            }
        }
        if (!this.mIncrementalCacheDirectory.exists() && !this.mIncrementalCacheDirectory.mkdirs()) {
            throw new SpoonException("unable to create cache directory");
        }
        if (!this.mClassFilesDir.exists() && !this.mClassFilesDir.mkdirs()) {
            throw new SpoonException("unable to create class files directory");
        }
        if (forceRebuild) {
            this.factory = this.createFactory();
            this.processArguments();
            this.mInputSources.forEach(f -> this.addInputResource(f.getPath()));
            this.mChangesPresent = true;
            this.setBinaryOutputDirectory(this.mClassFilesDir);
        } else {
            File typeFile;
            Factory oldFactory = IncrementalLauncher.loadFactory(this.mModelFile);
            oldFactory.getModel().setBuildModelIsFinished(false);
            this.mRemovedSources = new HashSet<File>(CollectionUtils.subtract(this.mCacheInfo.inputSourcesMap.keySet(), this.mInputSources));
            this.mAddedSources = new HashSet<File>(CollectionUtils.subtract(this.mInputSources, this.mCacheInfo.inputSourcesMap.keySet()));
            this.mCommonSources = new HashSet<File>(CollectionUtils.intersection(this.mCacheInfo.inputSourcesMap.keySet(), this.mInputSources));
            HashSet<File> incrementalSources = new HashSet<File>(this.mAddedSources);
            for (File e : this.mCommonSources) {
                if (e.lastModified() < this.mCacheInfo.lastBuildTime) continue;
                incrementalSources.add(e);
            }
            List<CtType<?>> oldTypes = oldFactory.Type().getAll();
            HashSet changedTypes = new HashSet();
            for (CtType<?> type : oldTypes) {
                typeFile = type.getPosition().getFile();
                if (!incrementalSources.contains(typeFile)) continue;
                changedTypes.add(type);
            }
            block6: for (CtType<?> type : oldTypes) {
                typeFile = type.getPosition().getFile();
                if (this.mRemovedSources.contains(typeFile)) {
                    type.delete();
                    continue;
                }
                Set<CtTypeReference<?>> referencedTypes = type.getReferencedTypes();
                for (CtType ctType : changedTypes) {
                    if (!referencedTypes.contains(ctType.getReference())) continue;
                    incrementalSources.add(typeFile);
                    type.delete();
                    continue block6;
                }
            }
            try {
                this.mSourceClasspath.add(this.mClassFilesDir.getCanonicalPath());
            }
            catch (IOException e2) {
                throw new SpoonException("unable to locate class files dir: " + this.mClassFilesDir);
            }
            Collection<CtPackage> oldPackages = oldFactory.Package().getAll();
            for (CtPackage pkg : oldPackages) {
                if (!pkg.getTypes().isEmpty() || !pkg.getPackages().isEmpty() || pkg.isUnnamedPackage()) continue;
                pkg.delete();
            }
            this.factory = oldFactory;
            this.processArguments();
            incrementalSources.forEach(f -> this.addInputResource(f.getPath()));
            this.mChangesPresent = !this.mRemovedSources.isEmpty() || !this.mAddedSources.isEmpty() || !incrementalSources.isEmpty();
            this.setBinaryOutputDirectory(this.mClassFilesDir);
        }
        this.getEnvironment().setSourceClasspath(this.mSourceClasspath.toArray(new String[0]));
    }

    public IncrementalLauncher(Set<File> inputResources, Set<String> sourceClasspath, File cacheDirectory) {
        this(inputResources, sourceClasspath, cacheDirectory, false);
    }

    public boolean changesPresent() {
        return this.mChangesPresent;
    }

    public void saveCache() {
        if (this.mIncrementalCacheDirectory == null) {
            throw new SpoonException("incremental cache directory is null");
        }
        Factory factory = this.getFactory();
        if (factory == null) {
            throw new SpoonException("factory is null");
        }
        this.getModelBuilder().compile(SpoonModelBuilder.InputType.FILES);
        IncrementalLauncher.saveFactory(factory, this.mModelFile);
        CacheInfo newCacheInfo = new CacheInfo();
        newCacheInfo.lastBuildTime = System.currentTimeMillis();
        HashMap<File, Set<File>> newSourcesMap = new HashMap<File, Set<File>>();
        for (Map.Entry<String, CompilationUnit> e : factory.CompilationUnit().getMap().entrySet()) {
            newSourcesMap.put(new File(e.getKey()), new HashSet<File>(e.getValue().getBinaryFiles()));
        }
        if (this.mCacheInfo != null) {
            newSourcesMap.putAll(this.mCacheInfo.inputSourcesMap);
            for (File r : this.mRemovedSources) {
                ((Set)newSourcesMap.get(r)).forEach(File::delete);
                newSourcesMap.remove(r);
            }
        }
        Collection<File> dirs = FileUtils.listFilesAndDirs(this.mClassFilesDir, DirectoryFileFilter.INSTANCE, TrueFileFilter.INSTANCE);
        dirs.stream().filter(d -> d.exists() && FileUtils.listFiles(d, TrueFileFilter.INSTANCE, TrueFileFilter.INSTANCE).isEmpty()).forEach(FileUtils::deleteQuietly);
        newCacheInfo.inputSourcesMap = newSourcesMap;
        IncrementalLauncher.saveCacheInfo(newCacheInfo, this.mCacheInfoFile);
    }

    private static class CacheInfo
    implements Serializable {
        public static final long serialVersionUID = 1L;
        public long lastBuildTime;
        public Map<File, Set<File>> inputSourcesMap;

        private CacheInfo() {
        }
    }
}

