/*
 * Decompiled with CFR 0.152.
 */
package spoon.compiler.builder;

import java.io.File;
import spoon.compiler.builder.Options;

public class ClasspathOptions<T extends ClasspathOptions<T>>
extends Options<T> {
    public ClasspathOptions() {
        super(ClasspathOptions.class);
    }

    public T classpath(String classpath) {
        if (classpath == null) {
            return (T)((ClasspathOptions)this.myself);
        }
        this.args.add("-cp");
        this.args.add(classpath);
        return (T)((ClasspathOptions)this.myself);
    }

    public T classpath(String ... classpaths) {
        if (classpaths == null || classpaths.length == 0) {
            return (T)((ClasspathOptions)this.myself);
        }
        return this.classpath(this.join(File.pathSeparator, classpaths));
    }

    public T bootclasspath(String bootclasspath) {
        if (bootclasspath == null) {
            return (T)((ClasspathOptions)this.myself);
        }
        this.args.add("-bootclasspath");
        this.args.add(bootclasspath);
        return (T)((ClasspathOptions)this.myself);
    }

    public T bootclasspath(String ... bootclasspaths) {
        if (bootclasspaths == null || bootclasspaths.length == 0) {
            return (T)((ClasspathOptions)this.myself);
        }
        return this.bootclasspath(this.join(File.pathSeparator, bootclasspaths));
    }

    public T binaries(String directory) {
        if (directory == null) {
            return this.binaries((File)null);
        }
        return this.binaries(new File(directory));
    }

    public T binaries(File directory) {
        if (directory == null) {
            this.args.add("-d");
            this.args.add("none");
        } else {
            this.args.add("-d");
            this.args.add(directory.getAbsolutePath());
        }
        return (T)((ClasspathOptions)this.myself);
    }

    public T encoding(String encoding) {
        if (encoding == null || encoding.isEmpty()) {
            return (T)((ClasspathOptions)this.myself);
        }
        this.args.add("-encoding");
        this.args.add(encoding);
        return (T)((ClasspathOptions)this.myself);
    }
}

