/*
 * Decompiled with CFR 0.152.
 */
package spoon.compiler.builder;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import spoon.compiler.SpoonFile;
import spoon.compiler.builder.Options;

public class SourceOptions<T extends SourceOptions<T>>
extends Options<T> {
    public SourceOptions() {
        super(SourceOptions.class);
    }

    public T sources(String sources) {
        if (sources == null || sources.isEmpty()) {
            return (T)((SourceOptions)this.myself);
        }
        return this.sources(sources.split(File.pathSeparator));
    }

    public T sources(String ... sources) {
        if (sources == null || sources.length == 0) {
            this.args.add(".");
            return (T)((SourceOptions)this.myself);
        }
        this.args.addAll(Arrays.asList(sources));
        return (T)((SourceOptions)this.myself);
    }

    public T sources(List<SpoonFile> sources) {
        if (sources == null || sources.isEmpty()) {
            this.args.add(".");
            return (T)((SourceOptions)this.myself);
        }
        for (SpoonFile source : sources) {
            if (source.isActualFile()) {
                this.args.add(source.toString());
                continue;
            }
            try {
                File file = File.createTempFile(source.getName(), ".java");
                file.deleteOnExit();
                try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                    IOUtils.copy(source.getContent(), (OutputStream)fileOutputStream);
                }
                this.args.add(file.toString());
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return (T)((SourceOptions)this.myself);
    }
}

