/*
 * Decompiled with CFR 0.152.
 */
package spoon.experimental;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.lang3.StringEscapeUtils;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtComment;
import spoon.reflect.code.CtLabelledFlowBreak;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtOperatorAssignment;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtModifiable;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtIntersectionTypeReference;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtWildcardReference;
import spoon.reflect.visitor.CtInheritanceScanner;
import spoon.reflect.visitor.CtScanner;

public class SpoonifyVisitor
extends CtScanner {
    StringBuilder result = new StringBuilder();
    Map<String, Integer> variableCount = new HashMap<String, Integer>();
    Stack<String> parentName = new Stack();
    Stack<Map<CtRole, String>> roleContainer = new Stack();
    PropertyScanner propertyScanner = new PropertyScanner();
    public boolean printTabs;
    int tabs = 0;

    public SpoonifyVisitor() {
        this(true);
    }

    public SpoonifyVisitor(boolean printTabs) {
        this.printTabs = printTabs;
    }

    public String getResult() {
        return this.result.toString();
    }

    private boolean isLeafTypeReference(CtElement element) {
        if (!(element instanceof CtTypeReference)) {
            return false;
        }
        if (element instanceof CtArrayTypeReference || element instanceof CtWildcardReference || element instanceof CtTypeParameterReference || element instanceof CtIntersectionTypeReference) {
            return false;
        }
        CtTypeReference reference = (CtTypeReference)element;
        return reference.getDeclaringType() == null && reference.getActualTypeArguments().isEmpty() && reference.getAnnotations().isEmpty() && reference.getComments().isEmpty();
    }

    @Override
    public void enter(CtElement element) {
        if (element instanceof CtPackageReference && this.isLeafTypeReference(element.getParent())) {
            return;
        }
        ++this.tabs;
        String elementClass = element.getClass().getSimpleName();
        if (elementClass.endsWith("Impl")) {
            elementClass = elementClass.replace("Impl", "");
        }
        String variableName = null;
        if (this.isLeafTypeReference(element)) {
            CtTypeReference typeRef = (CtTypeReference)element;
            if (typeRef.isPrimitive()) {
                switch (typeRef.getSimpleName()) {
                    case "int": {
                        variableName = "factory.Type().INTEGER_PRIMITIVE";
                        break;
                    }
                    case "char": {
                        variableName = "factory.Type().CHARACTER_PRIMITIVE";
                        break;
                    }
                    default: {
                        variableName = "factory.Type()." + typeRef.getSimpleName().toUpperCase() + "_PRIMITIVE";
                        break;
                    }
                }
            } else {
                variableName = typeRef.getSimpleName().equals("<nulltype>") ? "factory.Type().NULL_TYPE" : (typeRef.getPackage().isImplicit() ? "factory.Type().createSimplyQualifiedReference(\"" + typeRef.getQualifiedName() + "\")" : "factory.Type().createReference(\"" + typeRef.getQualifiedName() + "\")");
            }
        } else {
            variableName = this.getVariableName(elementClass);
            this.result.append(this.printTabs() + elementClass + " " + variableName + " = factory.create" + elementClass.replaceFirst("Ct", "") + "();");
            this.result.append("\n");
            if (element.isImplicit()) {
                this.result.append(this.printTabs() + variableName + ".setImplicit(true);\n");
            }
            this.propertyScanner.variableName = variableName;
            element.accept(this.propertyScanner);
        }
        if (element.isParentInitialized() && !this.parentName.isEmpty()) {
            CtRole elementRoleInParent = element.getRoleInParent();
            CtElement parent = element.getParent();
            Object o = parent.getValueByRole(elementRoleInParent);
            if (o instanceof Map) {
                this.handleContainer(element, parent, elementRoleInParent, variableName, "Map");
            } else if (o instanceof List) {
                this.handleContainer(element, parent, elementRoleInParent, variableName, "List");
            } else if (o instanceof Set) {
                this.handleContainer(element, parent, elementRoleInParent, variableName, "Set");
            } else {
                this.result.append(this.printTabs() + this.parentName.peek() + ".setValueByRole(CtRole." + elementRoleInParent.name() + ", " + variableName + ");\n");
            }
        }
        this.parentName.push(variableName);
        this.roleContainer.push(new HashMap());
    }

    private String getVariableName(String className) {
        if (!this.variableCount.containsKey(className)) {
            this.variableCount.put(className, 0);
        }
        int count = this.variableCount.get(className);
        String variableName = className.substring(0, 1).toLowerCase() + className.substring(1) + count;
        this.variableCount.put(className, count + 1);
        return variableName;
    }

    private void handleContainer(CtElement element, CtElement parent, CtRole elementRoleInParent, String variableName, String container) {
        String containerName;
        String concreteClass = null;
        switch (container) {
            case "Map": {
                concreteClass = "HashMap";
                break;
            }
            case "List": {
                concreteClass = "ArrayList";
                break;
            }
            case "Set": {
                concreteClass = "HashSet";
            }
        }
        if (!this.roleContainer.peek().containsKey((Object)elementRoleInParent)) {
            containerName = this.parentName.peek() + elementRoleInParent.toString().substring(0, 1).toUpperCase() + elementRoleInParent.toString().substring(1) + "s";
            this.roleContainer.peek().put(elementRoleInParent, containerName);
            this.result.append(this.printTabs() + container + " " + containerName + " = new " + concreteClass + "();\n");
        } else {
            containerName = this.roleContainer.peek().get((Object)elementRoleInParent);
        }
        if (container.equals("Map")) {
            ArrayList<String> keys = new ArrayList<String>();
            Map m = (Map)parent.getValueByRole(elementRoleInParent);
            for (Map.Entry e : m.entrySet()) {
                Map.Entry entry = e;
                if (!entry.getValue().equals(element)) continue;
                keys.add((String)entry.getKey());
            }
            for (String key : keys) {
                this.result.append(this.printTabs() + containerName + ".put(\"" + key + "\", " + variableName + ");\n");
            }
        } else {
            this.result.append(this.printTabs() + containerName + ".add(" + variableName + ");\n");
        }
    }

    @Override
    public void exit(CtElement element) {
        if (element instanceof CtPackageReference && this.isLeafTypeReference(element.getParent())) {
            return;
        }
        if (!this.roleContainer.peek().isEmpty()) {
            for (CtRole role : this.roleContainer.peek().keySet()) {
                String variableName = this.roleContainer.peek().get((Object)role);
                this.result.append(this.printTabs() + this.parentName.peek() + ".setValueByRole(CtRole." + role.name() + ", " + variableName + ");\n");
            }
        }
        this.parentName.pop();
        this.roleContainer.pop();
        --this.tabs;
    }

    private String printTabs() {
        String res = "";
        if (this.printTabs) {
            for (int i2 = 0; i2 < this.tabs; ++i2) {
                res = res + "\t";
            }
        }
        return res;
    }

    class PropertyScanner
    extends CtInheritanceScanner {
        public String variableName;

        PropertyScanner() {
        }

        public void visitCtLiteral(CtLiteral element) {
            if (element.getType().isPrimitive()) {
                SpoonifyVisitor.this.result.append(SpoonifyVisitor.this.printTabs() + this.variableName + ".setValue((" + element.getType().getSimpleName() + ") " + element.toString() + ");\n");
                if (element.getBase() != null) {
                    SpoonifyVisitor.this.result.append(SpoonifyVisitor.this.printTabs() + this.variableName + ".setBase(LiteralBase." + element.getBase().name() + ");\n");
                }
            } else if (element.getType().getQualifiedName().equals("java.lang.String")) {
                SpoonifyVisitor.this.result.append(SpoonifyVisitor.this.printTabs() + this.variableName + ".setValue(\"" + StringEscapeUtils.escapeJava((String)element.getValue()) + "\");\n");
            }
            super.visitCtLiteral(element);
        }

        public void visitCtBinaryOperator(CtBinaryOperator element) {
            SpoonifyVisitor.this.result.append(SpoonifyVisitor.this.printTabs() + this.variableName + ".setKind(BinaryOperatorKind." + element.getKind().name() + ");\n");
            super.visitCtBinaryOperator(element);
        }

        public void visitCtUnaryOperator(CtUnaryOperator element) {
            SpoonifyVisitor.this.result.append(SpoonifyVisitor.this.printTabs() + this.variableName + ".setKind(UnaryOperatorKind." + element.getKind().name() + ");\n");
            super.visitCtUnaryOperator(element);
        }

        public void visitCtOperatorAssignment(CtOperatorAssignment element) {
            SpoonifyVisitor.this.result.append(SpoonifyVisitor.this.printTabs() + this.variableName + ".setKind(BinaryOperatorKind." + element.getKind().name() + ");\n");
            super.visitCtOperatorAssignment(element);
        }

        @Override
        public void visitCtComment(CtComment element) {
            SpoonifyVisitor.this.result.append(SpoonifyVisitor.this.printTabs() + this.variableName + ".setCommentType(CtComment.CommentType." + element.getCommentType().name() + ");\n");
            SpoonifyVisitor.this.result.append(SpoonifyVisitor.this.printTabs() + this.variableName + ".setContent(\"" + StringEscapeUtils.escapeJava(element.getContent()) + "\");\n");
            super.visitCtComment(element);
        }

        public void visitCtParameter(CtParameter element) {
            if (element.isVarArgs()) {
                SpoonifyVisitor.this.result.append(SpoonifyVisitor.this.printTabs() + this.variableName + ".setVarArgs(true);\n");
            }
            super.visitCtParameter(element);
        }

        public void visitCtMethod(CtMethod element) {
            if (element.isDefaultMethod()) {
                SpoonifyVisitor.this.result.append(SpoonifyVisitor.this.printTabs() + this.variableName + ".setDefaultMethod(true);\n");
            }
            super.visitCtMethod(element);
        }

        @Override
        public void scanCtReference(CtReference element) {
            SpoonifyVisitor.this.result.append(SpoonifyVisitor.this.printTabs() + this.variableName + ".setSimpleName(\"" + element.getSimpleName() + "\");\n");
        }

        @Override
        public void scanCtNamedElement(CtNamedElement element) {
            SpoonifyVisitor.this.result.append(SpoonifyVisitor.this.printTabs() + this.variableName + ".setSimpleName(\"" + element.getSimpleName() + "\");\n");
        }

        @Override
        public void scanCtModifiable(CtModifiable element) {
            if (!element.getModifiers().isEmpty()) {
                SpoonifyVisitor.this.result.append(SpoonifyVisitor.this.printTabs() + "Set<ModifierKind> " + this.variableName + "Modifiers = new HashSet<>();\n");
                for (ModifierKind mod : element.getModifiers()) {
                    SpoonifyVisitor.this.result.append(SpoonifyVisitor.this.printTabs() + this.variableName + "Modifiers.add(ModifierKind." + mod.name() + ");\n");
                }
                SpoonifyVisitor.this.result.append(SpoonifyVisitor.this.printTabs() + this.variableName + ".setModifiers(" + this.variableName + "Modifiers);\n");
            }
        }

        @Override
        public void scanCtStatement(CtStatement element) {
            if (element.getLabel() != null) {
                SpoonifyVisitor.this.result.append(SpoonifyVisitor.this.printTabs() + this.variableName + ".setLabel(\"" + element.getLabel() + "\");\n");
            }
        }

        @Override
        public void scanCtLabelledFlowBreak(CtLabelledFlowBreak element) {
            if (element.getTargetLabel() != null) {
                SpoonifyVisitor.this.result.append(SpoonifyVisitor.this.printTabs() + this.variableName + ".setTargetLabel(\"" + element.getTargetLabel() + "\");\n");
            }
        }
    }
}

