/*
 * Decompiled with CFR 0.152.
 */
package spoon.javadoc.internal;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import spoon.javadoc.internal.JavadocBlockTag;
import spoon.javadoc.internal.JavadocDescription;
import spoon.javadoc.internal.JavadocInlineTag;
import spoon.javadoc.internal.JavadocSnippet;
import spoon.javadoc.internal.Pair;

public class Javadoc
implements Serializable {
    private JavadocDescription description;
    private List<JavadocBlockTag> blockTags;
    private static String BLOCK_TAG_PREFIX = "@";
    private static Pattern BLOCK_PATTERN = Pattern.compile("^\\s*" + BLOCK_TAG_PREFIX, 8);

    public Javadoc() {
        this(new JavadocDescription());
    }

    public Javadoc(JavadocDescription description) {
        this.description = description;
        this.blockTags = new LinkedList<JavadocBlockTag>();
    }

    public Javadoc addBlockTag(JavadocBlockTag blockTag) {
        this.blockTags.add(blockTag);
        return this;
    }

    public Javadoc addBlockTag(String tagName, String parameter, String content) {
        return this.addBlockTag(tagName, parameter, content);
    }

    public Javadoc addBlockTag(String tagName) {
        return this.addBlockTag(tagName, "", "");
    }

    public String toText() {
        StringBuilder sb = new StringBuilder();
        if (!this.description.isEmpty()) {
            sb.append(this.description.toText());
            sb.append(System.lineSeparator());
        }
        if (!this.blockTags.isEmpty()) {
            sb.append(System.lineSeparator());
        }
        this.blockTags.forEach(bt -> {
            sb.append(bt.toText());
            sb.append(System.lineSeparator());
        });
        return sb.toString();
    }

    public JavadocDescription getDescription() {
        return this.description;
    }

    public List<JavadocBlockTag> getBlockTags() {
        return this.blockTags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Javadoc document = (Javadoc)o;
        return this.description.equals(document.description) && this.blockTags.equals(document.blockTags);
    }

    public int hashCode() {
        int result = this.description.hashCode();
        result = 31 * result + this.blockTags.hashCode();
        return result;
    }

    public String toString() {
        return "Javadoc{description=" + this.description + ", blockTags=" + this.blockTags + '}';
    }

    public static JavadocDescription parseText(String text) {
        Pair<Integer, Integer> nextInlineTagPos;
        JavadocDescription instance = new JavadocDescription();
        int index = 0;
        while ((nextInlineTagPos = Javadoc.indexOfNextInlineTag(text, index)) != null) {
            if ((Integer)nextInlineTagPos.a != index) {
                instance.addElement(new JavadocSnippet(text.substring(index, (Integer)nextInlineTagPos.a)));
            }
            instance.addElement(JavadocInlineTag.fromText(text.substring((Integer)nextInlineTagPos.a, (Integer)nextInlineTagPos.b + 1)));
            index = (Integer)nextInlineTagPos.b + 1;
        }
        if (index < text.length()) {
            instance.addElement(new JavadocSnippet(text.substring(index)));
        }
        return instance;
    }

    private static Pair<Integer, Integer> indexOfNextInlineTag(String text, int start) {
        int index = text.indexOf("{@", start);
        if (index == -1) {
            return null;
        }
        int closeIndex = text.indexOf("}", index);
        if (closeIndex == -1) {
            return null;
        }
        return new Pair<Integer, Integer>(index, closeIndex);
    }

    public static Javadoc parse(String commentContent) {
        List<String> blockLines;
        String descriptionText;
        List<String> cleanLines = Arrays.asList(commentContent.split("\n"));
        int indexOfFirstBlockTag = cleanLines.stream().filter(Javadoc::isABlockLine).map(cleanLines::indexOf).findFirst().orElse(-1);
        if (indexOfFirstBlockTag == -1) {
            descriptionText = Javadoc.trimRight(String.join((CharSequence)"\n", cleanLines));
            blockLines = Collections.emptyList();
        } else {
            descriptionText = Javadoc.trimRight(String.join((CharSequence)"\n", cleanLines.subList(0, indexOfFirstBlockTag)));
            String tagBlock = cleanLines.subList(indexOfFirstBlockTag, cleanLines.size()).stream().collect(Collectors.joining("\n"));
            blockLines = BLOCK_PATTERN.splitAsStream(tagBlock).filter(x -> !x.isEmpty()).map(s -> BLOCK_TAG_PREFIX + s).collect(Collectors.toList());
        }
        Javadoc document = new Javadoc(Javadoc.parseText(descriptionText));
        blockLines.forEach(l -> document.addBlockTag(Javadoc.parseBlockTag(l)));
        return document;
    }

    private static JavadocBlockTag parseBlockTag(String line) {
        line = line.trim().substring(1);
        String tagName = JavadocInlineTag.nextWord(line);
        String rest = line.substring(tagName.length()).trim();
        return new JavadocBlockTag(tagName, rest);
    }

    private static boolean isABlockLine(String line) {
        return line.trim().startsWith(BLOCK_TAG_PREFIX);
    }

    private static String trimRight(String string) {
        while (!string.isEmpty() && Character.isWhitespace(string.charAt(string.length() - 1))) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }
}

