/*
 * Decompiled with CFR 0.152.
 */
package spoon.metamodel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import spoon.SpoonException;
import spoon.metamodel.MMMethodKind;
import spoon.metamodel.MetamodelConcept;
import spoon.metamodel.MetamodelProperty;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.reference.CtTypeReference;
import spoon.support.visitor.MethodTypingContext;

public class MMMethod {
    private final MetamodelProperty ownerField;
    private final CtMethod<?> method;
    private final List<CtMethod<?>> ownMethods = new ArrayList();
    private final String signature;
    private final MMMethodKind methodKind;

    MMMethod(MetamodelProperty field, CtMethod<?> method) {
        this.ownerField = field;
        MethodTypingContext mtc = new MethodTypingContext().setClassTypingContext(field.getOwner().getTypeContext()).setMethod(method);
        this.method = (CtMethod)mtc.getAdaptationScope();
        this.signature = this.method.getSignature();
        this.methodKind = MMMethodKind.kindOf(this.method);
        this.addRelatedMethod(method);
    }

    public CtMethod<?> getActualCtMethod() {
        return this.method;
    }

    public String getName() {
        return this.method.getSimpleName();
    }

    public String getSignature() {
        return this.signature;
    }

    public MMMethodKind getKind() {
        return this.methodKind;
    }

    CtMethod<?> getCompatibleMethod(MetamodelConcept targetType) {
        for (CtMethod<?> ctMethod : this.ownMethods) {
            if (!targetType.getTypeContext().isSubtypeOf((CtTypeReference<?>)ctMethod.getDeclaringType().getReference())) continue;
            return ctMethod;
        }
        throw new SpoonException("No own method exists in type " + this.ownerField);
    }

    public boolean overrides(CtMethod<?> method) {
        return this.ownerField.getOwner().getTypeContext().isOverriding(this.method, method);
    }

    public MetamodelProperty getProperty() {
        return this.ownerField;
    }

    public MetamodelConcept getOwner() {
        return this.getProperty().getOwner();
    }

    public List<CtMethod<?>> getDeclaredMethods() {
        return Collections.unmodifiableList(this.ownMethods);
    }

    void addRelatedMethod(CtMethod<?> method) {
        if (method.getDeclaringType().getSimpleName().endsWith("Impl")) {
            throw new SpoonException("the metametamodel should be entirely specified in the Spoon interfaces");
        }
        this.ownMethods.add(method);
    }

    public CtTypeReference<?> getReturnType() {
        return this.method.getType();
    }

    public CtTypeReference<?> getValueType() {
        if (this.method.getParameters().isEmpty()) {
            return this.method.getType();
        }
        return this.method.getParameters().get(this.method.getParameters().size() - 1).getType();
    }

    public String toString() {
        return this.getOwner().getName() + "#" + this.getSignature();
    }
}

