/*
 * Decompiled with CFR 0.152.
 */
package spoon.metamodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import spoon.SpoonException;
import spoon.metamodel.ConceptKind;
import spoon.metamodel.Metamodel;
import spoon.metamodel.MetamodelProperty;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.path.CtRole;
import spoon.support.visitor.ClassTypingContext;

public class MetamodelConcept {
    private ConceptKind kind;
    private final String name;
    private final Map<CtRole, MetamodelProperty> role2Property = new LinkedHashMap<CtRole, MetamodelProperty>();
    private final List<MetamodelConcept> superConcepts = new ArrayList<MetamodelConcept>();
    private final List<MetamodelConcept> subConcepts = new ArrayList<MetamodelConcept>();
    private CtClass<?> modelClass;
    private CtInterface<?> modelInterface;
    private ClassTypingContext typeContext;
    final List<CtMethod<?>> otherMethods = new ArrayList();

    MetamodelConcept(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    MetamodelProperty getOrCreateMMField(CtRole role) {
        return Metamodel.getOrCreate(this.role2Property, role, () -> new MetamodelProperty(role.getCamelCaseName(), role, this));
    }

    public ConceptKind getKind() {
        if (this.kind == null) {
            if (this.modelClass == null && this.modelInterface == null) {
                return null;
            }
            this.kind = this.modelClass == null ? ConceptKind.ABSTRACT : (this.modelClass.hasModifier(ModifierKind.ABSTRACT) ? ConceptKind.ABSTRACT : ConceptKind.LEAF);
        }
        return this.kind;
    }

    public Map<CtRole, MetamodelProperty> getRoleToProperty() {
        return Collections.unmodifiableMap(this.role2Property);
    }

    public Collection<MetamodelProperty> getProperties() {
        return Collections.unmodifiableCollection(this.role2Property.values());
    }

    public MetamodelProperty getProperty(CtRole role) {
        return this.role2Property.get((Object)role);
    }

    public List<MetamodelConcept> getSuperConcepts() {
        return this.superConcepts;
    }

    void addSuperConcept(MetamodelConcept superType) {
        if (superType == this) {
            throw new SpoonException("Cannot add supertype to itself");
        }
        if (Metamodel.addUniqueObject(this.superConcepts, superType)) {
            superType.subConcepts.add(this);
            superType.role2Property.forEach((role, superMMField) -> {
                MetamodelProperty mmField = this.getOrCreateMMField((CtRole)((Object)role));
                mmField.addSuperField((MetamodelProperty)superMMField);
            });
        }
    }

    public CtClass<?> getImplementationClass() {
        return this.modelClass;
    }

    void setModelClass(CtClass<?> modelClass) {
        this.modelClass = modelClass;
    }

    public CtInterface<?> getMetamodelInterface() {
        return this.modelInterface;
    }

    void setModelInterface(CtInterface<?> modelInterface) {
        this.modelInterface = modelInterface;
    }

    ClassTypingContext getTypeContext() {
        if (this.typeContext == null) {
            this.typeContext = new ClassTypingContext(this.modelClass != null ? this.modelClass : this.modelInterface);
        }
        return this.typeContext;
    }

    public String toString() {
        return this.getName();
    }
}

