/*
 * Decompiled with CFR 0.152.
 */
package spoon.pattern;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import spoon.SpoonException;
import spoon.pattern.ConflictResolutionMode;
import spoon.pattern.PatternBuilder;
import spoon.pattern.internal.node.ForEachNode;
import spoon.pattern.internal.node.ListOfNodes;
import spoon.pattern.internal.node.ParameterNode;
import spoon.pattern.internal.node.PrimitiveMatcher;
import spoon.pattern.internal.node.RootNode;
import spoon.pattern.internal.node.SwitchNode;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtForEach;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtStatement;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.path.CtRole;
import spoon.reflect.visitor.CtAbstractVisitor;
import spoon.support.Experimental;

@Experimental
public class InlinedStatementConfigurator {
    private final PatternBuilder patternBuilder;
    private boolean failOnMissingParameter = true;
    private ConflictResolutionMode conflictResolutionMode = ConflictResolutionMode.FAIL;

    public InlinedStatementConfigurator(PatternBuilder patternBuilder) {
        this.patternBuilder = patternBuilder;
    }

    public ConflictResolutionMode getConflictResolutionMode() {
        return this.conflictResolutionMode;
    }

    public InlinedStatementConfigurator setConflictResolutionMode(ConflictResolutionMode conflictResolutionMode) {
        this.conflictResolutionMode = conflictResolutionMode;
        return this;
    }

    public InlinedStatementConfigurator inlineIfOrForeachReferringTo(String variableName) {
        this.patternBuilder.patternQuery.filterChildren(varRef -> variableName.equals(varRef.getSimpleName())).forEach(this::byElement);
        return this;
    }

    InlinedStatementConfigurator byElement(CtElement element) {
        CtStatement stmt = element instanceof CtStatement ? (CtStatement)element : element.getParent(CtStatement.class);
        stmt.accept(new CtAbstractVisitor(){

            @Override
            public void visitCtForEach(CtForEach foreach) {
                InlinedStatementConfigurator.this.markAsInlined(foreach);
            }

            @Override
            public void visitCtIf(CtIf ifElement) {
                InlinedStatementConfigurator.this.markAsInlined(ifElement);
            }
        });
        return this;
    }

    public InlinedStatementConfigurator markAsInlined(CtForEach foreach) {
        RootNode vr = this.patternBuilder.getPatternNode(foreach.getExpression(), new CtRole[0]);
        if (!(vr instanceof PrimitiveMatcher)) {
            throw new SpoonException("Each inline `for(x : iterable)` statement must have defined pattern parameter for `iterable` expression");
        }
        PrimitiveMatcher parameterOfExpression = (PrimitiveMatcher)vr;
        ForEachNode mvr = new ForEachNode();
        mvr.setIterableParameter(parameterOfExpression);
        CtLocalVariable<?> lv = foreach.getVariable();
        String paramName = lv.getSimpleName();
        this.patternBuilder.configureLocalParameters(pb -> {
            pb.parameter(paramName).byVariable(lv);
            mvr.setLocalParameter(pb.getCurrentParameter());
        });
        mvr.setNestedModel(this.patternBuilder.getPatternNode(foreach, CtRole.BODY, CtRole.STATEMENT));
        this.patternBuilder.setNodeOfElement(foreach, mvr, this.conflictResolutionMode);
        return this;
    }

    public InlinedStatementConfigurator markAsInlined(CtIf ifElement) {
        SwitchNode osp = new SwitchNode();
        boolean[] canBeInline = new boolean[]{true};
        this.forEachIfCase(ifElement, (expression, block) -> {
            if (expression != null) {
                RootNode vrOfExpression = this.patternBuilder.getPatternNode((CtElement)expression, new CtRole[0]);
                if (!(vrOfExpression instanceof ParameterNode)) {
                    if (this.failOnMissingParameter) {
                        throw new SpoonException("Each inline `if` statement must have defined pattern parameter in expression. If you want to ignore this, then call InlinedStatementConfigurator#setFailOnMissingParameter(false) first.");
                    }
                    canBeInline[0] = false;
                    return;
                }
                if (!(vrOfExpression instanceof PrimitiveMatcher)) throw new SpoonException("Inline `if` statement have defined single value pattern parameter in expression. But there is " + vrOfExpression.getClass().getName());
                osp.addCase((PrimitiveMatcher)vrOfExpression, this.getPatternNode(PatternBuilder.bodyToStatements(block)));
                return;
            } else {
                osp.addCase(null, this.getPatternNode(PatternBuilder.bodyToStatements(block)));
            }
        });
        if (canBeInline[0]) {
            this.patternBuilder.setNodeOfElement(ifElement, osp, this.conflictResolutionMode);
        }
        return this;
    }

    private ListOfNodes getPatternNode(List<? extends CtElement> template) {
        ArrayList<RootNode> nodes = new ArrayList<RootNode>(template.size());
        for (CtElement ctElement : template) {
            nodes.add(this.patternBuilder.getPatternNode(ctElement, new CtRole[0]));
        }
        return new ListOfNodes(nodes);
    }

    private void forEachIfCase(CtIf ifElement, BiConsumer<CtExpression<Boolean>, CtStatement> consumer) {
        consumer.accept(ifElement.getCondition(), (CtStatement)ifElement.getThenStatement());
        CtStatement elseStmt = this.getElseIfStatement((CtStatement)ifElement.getElseStatement());
        if (elseStmt instanceof CtIf) {
            this.forEachIfCase((CtIf)elseStmt, consumer);
        } else if (elseStmt != null) {
            consumer.accept(null, elseStmt);
        }
    }

    private CtStatement getElseIfStatement(CtStatement elseStmt) {
        List<CtStatement> stmts;
        CtBlock block;
        if (elseStmt instanceof CtBlock && (block = (CtBlock)elseStmt).isImplicit() && (stmts = block.getStatements()).size() == 1 && stmts.get(0) instanceof CtIf) {
            return stmts.get(0);
        }
        return elseStmt;
    }

    public boolean isFailOnMissingParameter() {
        return this.failOnMissingParameter;
    }

    public InlinedStatementConfigurator setFailOnMissingParameter(boolean failOnMissingParameter) {
        this.failOnMissingParameter = failOnMissingParameter;
        return this;
    }
}

