/*
 * Decompiled with CFR 0.152.
 */
package spoon.pattern.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import spoon.metamodel.Metamodel;
import spoon.metamodel.MetamodelConcept;
import spoon.metamodel.MetamodelProperty;
import spoon.pattern.internal.DefaultGenerator;
import spoon.pattern.internal.ResultHolder;
import spoon.pattern.internal.node.ConstantNode;
import spoon.pattern.internal.node.ElementNode;
import spoon.pattern.internal.node.InlineNode;
import spoon.pattern.internal.node.ListOfNodes;
import spoon.pattern.internal.node.ParameterNode;
import spoon.pattern.internal.node.RootNode;
import spoon.pattern.internal.parameter.ParameterInfo;
import spoon.reflect.code.CtComment;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.factory.Factory;
import spoon.reflect.factory.FactoryImpl;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.PrinterHelper;
import spoon.support.DefaultCoreFactory;
import spoon.support.StandardEnvironment;
import spoon.support.util.ImmutableMap;

public class PatternPrinter
extends DefaultGenerator {
    private static final Factory DEFAULT_FACTORY = new FactoryImpl(new DefaultCoreFactory(), new StandardEnvironment());
    private List<ParamOnElement> params = new ArrayList<ParamOnElement>();
    private boolean printParametersAsComments = true;

    public PatternPrinter() {
        super(DEFAULT_FACTORY, null);
    }

    public String printNode(RootNode node) {
        List generated = this.generateTargets(node, (ImmutableMap)null, null);
        StringBuilder sb = new StringBuilder();
        for (Object ele : generated) {
            sb.append(ele.toString()).append(System.getProperty("line.separator"));
        }
        return sb.toString();
    }

    @Override
    public <T> void generateTargets(RootNode node, ResultHolder<T> result, ImmutableMap parameters) {
        int firstResultIdx = result.getResults().size();
        if (node instanceof InlineNode) {
            ((InlineNode)node).generateInlineTargets(this, result, parameters);
        } else {
            super.generateTargets(node, result, parameters);
        }
        Object firstResult = this.getFirstResult(result, firstResultIdx);
        if (firstResult instanceof CtElement) {
            if (node instanceof ElementNode) {
                ElementNode elementNode = (ElementNode)node;
                ArrayList paramsOnElement = new ArrayList();
                for (Map.Entry<MetamodelProperty, RootNode> e : elementNode.getRoleToNode().entrySet()) {
                    MetamodelProperty mmField = e.getKey();
                    this.foreachNode(e.getValue(), attrNode -> {
                        if (attrNode instanceof ConstantNode || attrNode instanceof ElementNode) {
                            return;
                        }
                        paramsOnElement.add(new ParamOnElement((CtElement)firstResult, mmField.getRole(), (RootNode)attrNode));
                    });
                }
                this.addParameterCommentTo((CtElement)firstResult, paramsOnElement.toArray(new ParamOnElement[0]));
            } else if (node instanceof ParameterNode) {
                this.addParameterCommentTo((CtElement)firstResult, new ParamOnElement((CtElement)firstResult, node));
            }
        }
    }

    private void foreachNode(RootNode rootNode, Consumer<RootNode> consumer) {
        if (rootNode instanceof ListOfNodes) {
            ListOfNodes list = (ListOfNodes)rootNode;
            for (RootNode node : list.getNodes()) {
                this.foreachNode(node, consumer);
            }
        } else {
            consumer.accept(rootNode);
        }
    }

    private boolean isCommentVisible(Object obj) {
        if (obj instanceof CtElement) {
            MetamodelConcept mmType = Metamodel.getInstance().getConcept(obj.getClass());
            MetamodelProperty mmCommentField = mmType.getProperty(CtRole.COMMENT);
            return mmCommentField != null && !mmCommentField.isDerived();
        }
        return false;
    }

    private <T> T getFirstResult(ResultHolder<T> result, int firstResultIdx) {
        List<T> results = result.getResults();
        if (firstResultIdx < results.size()) {
            return results.get(firstResultIdx);
        }
        return null;
    }

    @Override
    public <T> void getValueAs(ParameterInfo parameterInfo, ResultHolder<T> result, ImmutableMap parameters) {
        T obj = this.generatePatternParameterElement(parameterInfo, result.getRequiredClass());
        if (obj != null) {
            result.addResult(obj);
        }
    }

    private void addParameterCommentTo(CtElement ele, ParamOnElement ... paramsOnElement) {
        for (ParamOnElement paramOnElement : paramsOnElement) {
            if (this.isNodeContained(paramOnElement.node)) continue;
            this.params.add(paramOnElement);
        }
        if (this.isPrintParametersAsComments() && this.isCommentVisible(ele) && !this.params.isEmpty()) {
            ele.addComment(ele.getFactory().Code().createComment(this.getSubstitutionRequestsDescription(ele, this.params), CtComment.CommentType.BLOCK));
            this.params.clear();
        }
    }

    private boolean isNodeContained(RootNode node) {
        for (ParamOnElement paramOnElement : this.params) {
            if (paramOnElement.node != node) continue;
            return true;
        }
        return false;
    }

    private <T> T generatePatternParameterElement(ParameterInfo parameterInfo, Class<T> type) {
        if (type != null) {
            if (type.isAssignableFrom(CtInvocation.class)) {
                return (T)this.factory.createInvocation(this.factory.createThisAccess(this.factory.Type().objectType(), true), (CtExecutableReference)this.factory.createExecutableReference().setSimpleName(parameterInfo.getName()), new CtExpression[0]);
            }
            if (type.isAssignableFrom(CtLocalVariable.class)) {
                return (T)this.factory.createLocalVariable(this.factory.Type().objectType(), parameterInfo.getName(), null);
            }
            if (type.isAssignableFrom(String.class)) {
                return (T)parameterInfo.getName();
            }
            if (type.isAssignableFrom(CtTypeReference.class)) {
                return (T)this.factory.Type().createReference(parameterInfo.getName());
            }
        }
        return null;
    }

    private String getSubstitutionRequestsDescription(CtElement ele, List<ParamOnElement> requestsOnPos) {
        TreeMap<String, ParamOnElement> reqByPath = new TreeMap<String, ParamOnElement>();
        StringBuilder sb = new StringBuilder();
        for (ParamOnElement reqPos : requestsOnPos) {
            sb.setLength(0);
            this.appendPathIn(sb, reqPos.sourceElement, ele);
            if (reqPos.role != null) {
                sb.append("/").append(reqPos.role.getCamelCaseName());
            }
            String path = sb.toString();
            reqByPath.put(path, reqPos);
        }
        PrinterHelper printer = new PrinterHelper(this.getFactory().getEnvironment());
        printer.setLineSeparator("\n");
        printer.write(PatternPrinter.getElementTypeName(ele)).incTab();
        for (Map.Entry e : reqByPath.entrySet()) {
            printer.writeln();
            printer.write((String)e.getKey()).write('/');
            printer.write(" <= ").write(((ParamOnElement)e.getValue()).node.toString());
        }
        return printer.toString();
    }

    private boolean appendPathIn(StringBuilder sb, CtElement element, CtElement parent) {
        if (element != parent && element != null) {
            CtRole roleInParent = element.getRoleInParent();
            if (roleInParent == null) {
                return false;
            }
            if (this.appendPathIn(sb, element.getParent(), parent)) {
                sb.append("/").append(PatternPrinter.getElementTypeName(element.getParent()));
            }
            sb.append(".").append(roleInParent.getCamelCaseName());
            return true;
        }
        return false;
    }

    static String getElementTypeName(CtElement element) {
        String name = element.getClass().getSimpleName();
        if (name.endsWith("Impl")) {
            return name.substring(0, name.length() - 4);
        }
        return name;
    }

    public PatternPrinter setPrintParametersAsComments(boolean printParametersAsComments) {
        this.printParametersAsComments = printParametersAsComments;
        return this;
    }

    public boolean isPrintParametersAsComments() {
        return this.printParametersAsComments;
    }

    static {
        DEFAULT_FACTORY.getEnvironment().setCommentEnabled(true);
    }

    private static class ParamOnElement {
        final CtElement sourceElement;
        final RootNode node;
        final CtRole role;

        ParamOnElement(CtElement sourceElement, RootNode node) {
            this(sourceElement, null, node);
        }

        ParamOnElement(CtElement sourceElement, CtRole role, RootNode node) {
            this.sourceElement = sourceElement;
            this.role = role;
            this.node = node;
        }

        public String toString() {
            if (this.role == null) {
                return this.sourceElement.getClass().getName() + ": ${" + this.node.toString() + "}";
            }
            return this.sourceElement.getClass().getName() + "/" + (Object)((Object)this.role) + ": " + this.node.toString();
        }
    }
}

