/*
 * Decompiled with CFR 0.152.
 */
package spoon.pattern.internal;

import java.util.List;
import spoon.SpoonException;
import spoon.pattern.internal.ValueConvertor;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.code.CtStatement;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtType;
import spoon.reflect.factory.Factory;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.support.visitor.SignaturePrinter;

public class ValueConvertorImpl
implements ValueConvertor {
    @Override
    public <T> T getValueAs(Factory factory, String parameterName, Object value, Class<T> valueClass) {
        if (valueClass.isInstance(value)) {
            return this.cloneIfNeeded(valueClass.cast(value));
        }
        if (CtExpression.class.isAssignableFrom(valueClass)) {
            if (value instanceof Class) {
                return (T)factory.Code().createClassAccess(factory.Type().createReference((Class)value));
            }
            if (value instanceof CtTypeReference) {
                CtTypeReference tr = (CtTypeReference)value;
                return (T)factory.Code().createClassAccess(tr);
            }
            if (value == null || value instanceof String || value instanceof Number || value instanceof Boolean || value instanceof Character) {
                return (T)factory.Code().createLiteral(value);
            }
            if (value.getClass().isArray()) {
                Class<?> itemClass = value.getClass().getComponentType();
                if (CtExpression.class.isAssignableFrom(itemClass)) {
                    CtNewArray arr = (CtNewArray)factory.Core().createNewArray().setType(factory.Type().objectType());
                    for (CtExpression expr : (CtExpression[])value) {
                        arr.addElement(expr);
                    }
                    return (T)arr;
                }
                CtNewArray arr = (CtNewArray)factory.Core().createNewArray().setType(factory.Type().createArrayReference(itemClass.getName()));
                for (Object v : (Object[])value) {
                    if (!(v == null || v instanceof String || v instanceof Number || v instanceof Boolean || v instanceof Character)) {
                        throw new SpoonException("Parameter value item class: " + v.getClass().getName() + " cannot be converted to class is: " + valueClass.getName());
                    }
                    arr.addElement(factory.Code().createLiteral(v));
                }
                return (T)arr;
            }
        }
        if (CtStatement.class.isAssignableFrom(valueClass)) {
            if (value == null) {
                return null;
            }
            if (value instanceof List) {
                List list = (List)value;
                if (list.isEmpty()) {
                    return null;
                }
                if (list.size() == 1) {
                    return (T)list.get(0);
                }
                CtBlock block = factory.createBlock();
                block.setImplicit(true);
                for (CtStatement statement : (Iterable)value) {
                    block.addStatement(statement);
                }
                return (T)block;
            }
        }
        if (valueClass.equals(String.class)) {
            if (value instanceof CtNamedElement) {
                return (T)((CtNamedElement)value).getSimpleName();
            }
            if (value instanceof CtReference) {
                return (T)((CtReference)value).getSimpleName();
            }
            if (value instanceof Class) {
                return (T)((Class)value).getSimpleName();
            }
            if (value instanceof CtInvocation) {
                return (T)ValueConvertorImpl.getShortSignatureForJavadoc(((CtInvocation)value).getExecutable());
            }
            if (value instanceof CtExecutableReference) {
                return (T)ValueConvertorImpl.getShortSignatureForJavadoc((CtExecutableReference)value);
            }
            if (value instanceof CtExecutable) {
                return (T)ValueConvertorImpl.getShortSignatureForJavadoc(((CtExecutable)value).getReference());
            }
            if (value instanceof CtLiteral) {
                Object val = ((CtLiteral)value).getValue();
                return (T)(val == null ? null : val.toString());
            }
            if (value instanceof Enum) {
                return (T)((Enum)value).name();
            }
            if (value == null) {
                throw new SpoonException("Missing parameter value for parameter `" + parameterName + "`");
            }
            throw new SpoonException("Parameter value has unexpected class: " + value.getClass().getName() + ", whose conversion to String is not supported");
        }
        if (CtTypeReference.class.isAssignableFrom(valueClass)) {
            if (value == null) {
                throw new SpoonException("The null value is not valid substitution for CtTypeReference");
            }
            if (value instanceof Class) {
                return (T)factory.Type().createReference((Class)value);
            }
            if (value instanceof CtTypeReference) {
                return (T)((CtTypeReference)value).clone();
            }
            if (value instanceof CtType) {
                return (T)((CtType)value).getReference();
            }
            if (value instanceof String) {
                return (T)factory.Type().createReference((String)value);
            }
            throw new RuntimeException("unsupported reference substitution");
        }
        throw new SpoonException("Parameter value class: " + value.getClass().getName() + " cannot be converted to class is: " + valueClass.getName());
    }

    private static String getShortSignatureForJavadoc(CtExecutableReference<?> ref) {
        SignaturePrinter sp = new SignaturePrinter();
        sp.writeNameAndParameters(ref);
        return ref.getDeclaringType().getSimpleName() + "#" + sp.getSignature();
    }

    protected <T> T cloneIfNeeded(T value) {
        if (value instanceof CtElement) {
            return (T)((CtElement)value).clone();
        }
        return value;
    }
}

