/*
 * Decompiled with CFR 0.152.
 */
package spoon.pattern.internal.node;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import spoon.SpoonException;
import spoon.metamodel.Metamodel;
import spoon.metamodel.MetamodelConcept;
import spoon.metamodel.MetamodelProperty;
import spoon.pattern.Quantifier;
import spoon.pattern.internal.DefaultGenerator;
import spoon.pattern.internal.ResultHolder;
import spoon.pattern.internal.matcher.TobeMatched;
import spoon.pattern.internal.node.AbstractPrimitiveMatcher;
import spoon.pattern.internal.node.ConstantNode;
import spoon.pattern.internal.node.ListOfNodes;
import spoon.pattern.internal.node.MapEntryNode;
import spoon.pattern.internal.node.ParameterNode;
import spoon.pattern.internal.node.RootNode;
import spoon.pattern.internal.parameter.ParameterInfo;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.meta.ContainerKind;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtExecutableReference;
import spoon.support.util.ImmutableMap;

public class ElementNode
extends AbstractPrimitiveMatcher {
    private CtElement templateElement;
    private MetamodelConcept elementType;
    private Map<MetamodelProperty, RootNode> roleToNode = new HashMap<MetamodelProperty, RootNode>();
    private static final Map<CtRole, Class[]> roleToSkippedClass = new HashMap<CtRole, Class[]>();

    public static ElementNode create(CtElement element, Map<CtElement, RootNode> patternElementToSubstRequests) {
        MetamodelConcept mmConcept = Metamodel.getInstance().getConcept(element.getClass());
        ElementNode elementNode = new ElementNode(mmConcept, element);
        if (patternElementToSubstRequests.put(element, elementNode) != null) {
            throw new SpoonException("Each pattern element can have only one implicit Node.");
        }
        for (MetamodelProperty mmField : mmConcept.getProperties()) {
            if (mmField.isDerived()) continue;
            elementNode.setNodeOfRole(mmField.getRole(), ElementNode.create(mmField.getContainerKind(), mmField.getValue(element), patternElementToSubstRequests));
        }
        return elementNode;
    }

    public static ListOfNodes create(List<?> objects, Map<CtElement, RootNode> patternElementToSubstRequests) {
        if (objects == null) {
            objects = Collections.emptyList();
        }
        return ElementNode.listOfNodesToNode(objects.stream().map(i2 -> ElementNode.create(i2, patternElementToSubstRequests)).collect(Collectors.toList()));
    }

    public static ListOfNodes create(Set<?> templates, Map<CtElement, RootNode> patternElementToSubstRequests) {
        if (templates == null) {
            templates = Collections.emptySet();
        }
        ArrayList<RootNode> constantMatchers = new ArrayList<RootNode>(templates.size());
        ArrayList<RootNode> variableMatchers = new ArrayList<RootNode>();
        for (Object template : templates) {
            RootNode matcher = ElementNode.create(template, patternElementToSubstRequests);
            if (matcher instanceof ElementNode) {
                constantMatchers.add(matcher);
                continue;
            }
            variableMatchers.add(matcher);
        }
        constantMatchers.addAll(variableMatchers);
        return ElementNode.listOfNodesToNode(constantMatchers);
    }

    public static ListOfNodes create(Map<String, ?> map, Map<CtElement, RootNode> patternElementToSubstRequests) {
        if (map == null) {
            map = Collections.emptyMap();
        }
        ArrayList<MapEntryNode> constantMatchers = new ArrayList<MapEntryNode>(map.size());
        ArrayList<MapEntryNode> variableMatchers = new ArrayList<MapEntryNode>();
        Object last = null;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            MapEntryNode mem = new MapEntryNode(ElementNode.create(entry.getKey(), patternElementToSubstRequests), ElementNode.create(entry.getValue(), patternElementToSubstRequests));
            if (mem.getKey() == entry.getKey()) {
                constantMatchers.add(mem);
                continue;
            }
            variableMatchers.add(mem);
        }
        constantMatchers.addAll(variableMatchers);
        return ElementNode.listOfNodesToNode(constantMatchers);
    }

    private static RootNode create(Object object, Map<CtElement, RootNode> patternElementToSubstRequests) {
        if (object instanceof CtElement) {
            return ElementNode.create((CtElement)object, patternElementToSubstRequests);
        }
        return new ConstantNode<Object>(object);
    }

    private static RootNode create(ContainerKind containerKind, Object templates, Map<CtElement, RootNode> patternElementToSubstRequests) {
        switch (containerKind) {
            case LIST: {
                return ElementNode.create((List)templates, patternElementToSubstRequests);
            }
            case SET: {
                return ElementNode.create((Set)templates, patternElementToSubstRequests);
            }
            case MAP: {
                return ElementNode.create((Map)templates, patternElementToSubstRequests);
            }
            case SINGLE: {
                return ElementNode.create(templates, patternElementToSubstRequests);
            }
        }
        throw new SpoonException("Unexpected RoleHandler containerKind: " + (Object)((Object)containerKind));
    }

    private static ListOfNodes listOfNodesToNode(List<? extends RootNode> nodes) {
        return new ListOfNodes(nodes);
    }

    public ElementNode(MetamodelConcept elementType, CtElement templateElement) {
        this.elementType = elementType;
        this.templateElement = templateElement;
    }

    @Override
    public boolean replaceNode(RootNode oldNode, RootNode newNode) {
        for (Map.Entry<MetamodelProperty, RootNode> e : this.roleToNode.entrySet()) {
            RootNode node = e.getValue();
            if (node == oldNode) {
                e.setValue(newNode);
                return true;
            }
            if (!node.replaceNode(oldNode, newNode)) continue;
            return true;
        }
        return false;
    }

    public Map<MetamodelProperty, RootNode> getRoleToNode() {
        return this.roleToNode == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.roleToNode);
    }

    public RootNode getNodeOfRole(CtRole attributeRole) {
        return this.roleToNode.get(this.getFieldOfRole(attributeRole));
    }

    public RootNode setNodeOfRole(CtRole role, RootNode newAttrNode) {
        return this.roleToNode.put(this.getFieldOfRole(role), newAttrNode);
    }

    public RootNode getOrCreateNodeOfRole(CtRole role, Map<CtElement, RootNode> patternElementToSubstRequests) {
        RootNode node = this.getNodeOfRole(role);
        if (node == null) {
            MetamodelProperty mmField = this.elementType.getProperty(role);
            if (mmField == null || mmField.isDerived()) {
                throw new SpoonException("The role " + (Object)((Object)role) + " doesn't exist or is derived for " + this.elementType);
            }
            node = ElementNode.create(mmField.getContainerKind(), null, patternElementToSubstRequests);
            this.setNodeOfRole(role, node);
        }
        return node;
    }

    public <T> T getValueOfRole(CtRole role, Class<T> type) {
        ConstantNode cn;
        RootNode node = this.getNodeOfRole(role);
        if (node instanceof ConstantNode && type.isInstance((cn = (ConstantNode)node).getTemplateNode())) {
            return cn.getTemplateNode();
        }
        return null;
    }

    private MetamodelProperty getFieldOfRole(CtRole role) {
        MetamodelProperty mmField = this.elementType.getProperty(role);
        if (mmField == null) {
            throw new SpoonException("CtRole." + role.name() + " isn't available for " + this.elementType);
        }
        if (mmField.isDerived()) {
            throw new SpoonException("CtRole." + role.name() + " is derived in " + this.elementType + " so it can't be used for matching or generating");
        }
        return mmField;
    }

    @Override
    public void forEachParameterInfo(BiConsumer<ParameterInfo, RootNode> consumer) {
        if (this.roleToNode != null) {
            for (RootNode node : this.roleToNode.values()) {
                node.forEachParameterInfo(consumer);
            }
        }
    }

    public <U> void generateTargets(DefaultGenerator generator, ResultHolder<U> result, ImmutableMap parameters) {
        CtElement clone = generator.getFactory().Core().create(this.elementType.getMetamodelInterface().getActualClass());
        this.generateSingleNodeAttributes(generator, clone, parameters);
        generator.applyGeneratedBy(clone, generator.getGeneratedByComment(this.templateElement));
        result.addResult(clone);
    }

    protected void generateSingleNodeAttributes(DefaultGenerator generator, CtElement clone, ImmutableMap parameters) {
        for (Map.Entry<MetamodelProperty, RootNode> e : this.getRoleToNode().entrySet()) {
            MetamodelProperty mmField = e.getKey();
            switch (mmField.getContainerKind()) {
                case SINGLE: {
                    mmField.setValue(clone, generator.generateSingleTarget(e.getValue(), parameters, mmField.getTypeofItems().getActualClass()));
                    break;
                }
                case LIST: {
                    mmField.setValue(clone, generator.generateTargets(e.getValue(), parameters, mmField.getTypeofItems().getActualClass()));
                    break;
                }
                case SET: {
                    mmField.setValue(clone, new LinkedHashSet(generator.generateTargets(e.getValue(), parameters, mmField.getTypeofItems().getActualClass())));
                    break;
                }
                case MAP: {
                    mmField.setValue(clone, this.entriesToMap(generator.generateTargets(e.getValue(), parameters, Map.Entry.class)));
                }
            }
        }
    }

    private <T> Map<String, T> entriesToMap(List<Map.Entry> entries) {
        LinkedHashMap map = new LinkedHashMap(entries.size());
        for (Map.Entry entry : entries) {
            map.put((String)entry.getKey(), entry.getValue());
        }
        return map;
    }

    @Override
    public ImmutableMap matchTarget(Object target, ImmutableMap parameters) {
        if (target == null) {
            return null;
        }
        if (target.getClass() != this.elementType.getImplementationClass().getActualClass()) {
            return null;
        }
        for (Map.Entry<MetamodelProperty, RootNode> e : this.roleToNode.entrySet()) {
            if ((parameters = this.matchesRole(parameters, (CtElement)target, e.getKey(), e.getValue())) != null) continue;
            return null;
        }
        return parameters;
    }

    protected ImmutableMap matchesRole(ImmutableMap parameters, CtElement target, MetamodelProperty mmField, RootNode attrNode) {
        if (!ElementNode.isMatchingRole(mmField.getRole(), this.elementType.getMetamodelInterface().getActualClass())) {
            return parameters;
        }
        TobeMatched tobeMatched = attrNode instanceof ParameterNode ? TobeMatched.create(parameters, ContainerKind.SINGLE, mmField.getValue(target)) : TobeMatched.create(parameters, mmField.getContainerKind(), mmField.getValue(target));
        return TobeMatched.getMatchedParameters(attrNode.matchTargets(tobeMatched, RootNode.MATCH_ALL));
    }

    private static boolean isMatchingRole(CtRole role, Class<?> targetClass) {
        Class[] classes = roleToSkippedClass.get((Object)role);
        if (classes != null) {
            for (Class cls : classes) {
                if (!cls.isAssignableFrom(targetClass)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public String toString() {
        return this.elementType.getName() + ": " + super.toString();
    }

    public MetamodelConcept getElementType() {
        return this.elementType;
    }

    public void setElementType(MetamodelConcept elementType) {
        this.elementType = elementType;
    }

    @Override
    public Quantifier getMatchingStrategy() {
        return Quantifier.POSSESSIVE;
    }

    @Override
    public boolean isTryNextMatch(ImmutableMap parameters) {
        return false;
    }

    static {
        roleToSkippedClass.put(CtRole.COMMENT, new Class[]{Object.class});
        roleToSkippedClass.put(CtRole.POSITION, new Class[]{Object.class});
        roleToSkippedClass.put(CtRole.IS_IMPLICIT, new Class[]{Object.class});
        roleToSkippedClass.put(CtRole.CAST, new Class[]{Object.class});
        roleToSkippedClass.put(CtRole.TYPE, new Class[]{CtExecutableReference.class});
        roleToSkippedClass.put(CtRole.DECLARING_TYPE, new Class[]{CtExecutableReference.class});
    }
}

