/*
 * Decompiled with CFR 0.152.
 */
package spoon.pattern.internal.node;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import spoon.SpoonException;
import spoon.pattern.Quantifier;
import spoon.pattern.internal.DefaultGenerator;
import spoon.pattern.internal.ResultHolder;
import spoon.pattern.internal.node.AbstractPrimitiveMatcher;
import spoon.pattern.internal.node.ConstantNode;
import spoon.pattern.internal.node.RootNode;
import spoon.pattern.internal.parameter.ParameterInfo;
import spoon.support.util.ImmutableMap;

public class StringNode
extends AbstractPrimitiveMatcher {
    private final String stringValueWithMarkers;
    private final Map<String, ParameterInfo> tobeReplacedSubstrings = new LinkedHashMap<String, ParameterInfo>();
    private ParameterInfo[] params;
    private Pattern regExpPattern;

    public StringNode(String stringValueWithMarkers) {
        this.stringValueWithMarkers = stringValueWithMarkers;
    }

    private String getStringValueWithMarkers() {
        return this.stringValueWithMarkers;
    }

    @Override
    public <T> void generateTargets(DefaultGenerator generator, ResultHolder<T> result, ImmutableMap parameters) {
        Class<T> requiredClass = result.getRequiredClass();
        if (requiredClass != null && !requiredClass.isAssignableFrom(String.class)) {
            throw new SpoonException("StringValueResolver provides only String values. It doesn't support: " + requiredClass);
        }
        String stringValue = this.getStringValueWithMarkers();
        for (Map.Entry<String, ParameterInfo> requests : this.tobeReplacedSubstrings.entrySet()) {
            ParameterInfo param = requests.getValue();
            String replaceMarker = requests.getKey();
            ResultHolder.Single<String> ctx = new ResultHolder.Single<String>(String.class);
            generator.getValueAs(param, ctx, parameters);
            String substrValue = ctx.getResult() == null ? "" : ctx.getResult();
            stringValue = this.substituteSubstring(stringValue, replaceMarker, substrValue);
        }
        result.addResult(stringValue);
    }

    @Override
    public ImmutableMap matchTarget(Object target, ImmutableMap parameters) {
        if (!(target instanceof String)) {
            return null;
        }
        String targetString = (String)target;
        Pattern re = this.getMatchingPattern();
        Matcher m = re.matcher(targetString);
        if (!m.matches()) {
            return null;
        }
        ParameterInfo[] params = this.getMatchingParameterInfos();
        for (int i2 = 0; i2 < params.length; ++i2) {
            String paramValue = m.group(i2 + 1);
            if ((parameters = params[i2].addValueAs(parameters, paramValue)) != null) continue;
            return null;
        }
        return parameters;
    }

    public ParameterInfo getParameterInfo(String replaceMarker) {
        return this.tobeReplacedSubstrings.get(replaceMarker);
    }

    public void setReplaceMarker(String replaceMarker, ParameterInfo param) {
        this.tobeReplacedSubstrings.put(replaceMarker, param);
    }

    public Map<String, ParameterInfo> getReplaceMarkers() {
        return Collections.unmodifiableMap(this.tobeReplacedSubstrings);
    }

    @Override
    public void forEachParameterInfo(BiConsumer<ParameterInfo, RootNode> consumer) {
        IdentityHashMap<ParameterInfo, Boolean> visitedParams = new IdentityHashMap<ParameterInfo, Boolean>(this.tobeReplacedSubstrings.size());
        for (ParameterInfo parameterInfo : this.tobeReplacedSubstrings.values()) {
            if (visitedParams.put(parameterInfo, Boolean.TRUE) != null) continue;
            consumer.accept(parameterInfo, this);
        }
    }

    private ParameterInfo[] getMatchingParameterInfos() {
        this.getMatchingPattern();
        return this.params;
    }

    private List<Region> getRegions() {
        ArrayList<Region> regions = new ArrayList<Region>();
        for (Map.Entry<String, ParameterInfo> markers : this.tobeReplacedSubstrings.entrySet()) {
            this.addRegionsOf(regions, markers.getValue(), markers.getKey());
        }
        regions.sort((a, b) -> a.from - b.from);
        return regions;
    }

    private synchronized Pattern getMatchingPattern() {
        if (this.regExpPattern == null) {
            List<Region> regions = this.getRegions();
            StringBuilder re = new StringBuilder();
            ArrayList<ParameterInfo> paramsByRegions = new ArrayList<ParameterInfo>();
            int start = 0;
            for (Region region : regions) {
                if (region.from > start) {
                    re.append(this.escapeRegExp(this.getStringValueWithMarkers().substring(start, region.from)));
                } else if (start > 0) {
                    throw new SpoonException("Cannot detect string parts if parameter separators are missing in pattern value: " + this.getStringValueWithMarkers());
                }
                re.append("(").append(".*?").append(")");
                paramsByRegions.add(region.param);
                start = region.to;
            }
            if (start < this.getStringValueWithMarkers().length()) {
                re.append(this.escapeRegExp(this.getStringValueWithMarkers().substring(start)));
            }
            this.regExpPattern = Pattern.compile(re.toString());
            this.params = paramsByRegions.toArray(new ParameterInfo[0]);
        }
        return this.regExpPattern;
    }

    private void addRegionsOf(List<Region> regions, ParameterInfo param, String marker) {
        for (int start = 0; start < this.getStringValueWithMarkers().length(); start += marker.length()) {
            start = this.getStringValueWithMarkers().indexOf(marker, start);
            if (start < 0) {
                return;
            }
            regions.add(new Region(param, start, start + marker.length()));
        }
    }

    private String substituteSubstring(String str, String tobeReplacedSubstring, String substrValue) {
        return str.replaceAll(this.escapeRegExp(tobeReplacedSubstring), this.escapeRegReplace(substrValue));
    }

    private String escapeRegExp(String str) {
        return "\\Q" + str + "\\E";
    }

    private String escapeRegReplace(String str) {
        return str.replaceAll("\\$", "\\\\\\$");
    }

    @Override
    public boolean replaceNode(RootNode oldNode, RootNode newNode) {
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        int off = 0;
        for (Region region : this.getRegions()) {
            if (region.from > off) {
                sb.append(this.getStringValueWithMarkers().substring(off, region.from));
            }
            sb.append("${").append(region.param.getName()).append("}");
            off = region.to;
        }
        if (this.getStringValueWithMarkers().length() > off) {
            sb.append(this.getStringValueWithMarkers().substring(off));
        }
        return sb.toString();
    }

    public static StringNode setReplaceMarker(RootNode targetNode, String replaceMarker, ParameterInfo param) {
        StringNode stringNode = null;
        if (targetNode instanceof ConstantNode) {
            ConstantNode constantNode = (ConstantNode)targetNode;
            if (constantNode.getTemplateNode() instanceof String) {
                stringNode = new StringNode((String)constantNode.getTemplateNode());
            }
        } else if (targetNode instanceof StringNode) {
            stringNode = (StringNode)targetNode;
        }
        if (stringNode == null) {
            throw new SpoonException("Cannot add StringNode");
        }
        stringNode.setReplaceMarker(replaceMarker, param);
        return stringNode;
    }

    @Override
    public Quantifier getMatchingStrategy() {
        return Quantifier.POSSESSIVE;
    }

    @Override
    public boolean isTryNextMatch(ImmutableMap parameters) {
        return false;
    }

    private static class Region {
        ParameterInfo param;
        int from;
        int to;

        Region(ParameterInfo param, int from, int to) {
            this.param = param;
            this.from = from;
            this.to = to;
        }
    }
}

