/*
 * Decompiled with CFR 0.152.
 */
package spoon.pattern.internal.parameter;

import java.util.List;
import java.util.function.Function;
import spoon.SpoonException;
import spoon.pattern.internal.ResultHolder;
import spoon.pattern.internal.parameter.AbstractParameterInfo;
import spoon.pattern.internal.parameter.ParameterComputer;
import spoon.pattern.internal.parameter.ParameterInfo;
import spoon.reflect.factory.Factory;
import spoon.support.util.ImmutableMap;

public class ComputedParameterInfo
extends AbstractParameterInfo {
    private final ParameterComputer computer;

    public ComputedParameterInfo(ParameterComputer computer, ParameterInfo next) {
        super(next);
        this.computer = computer;
    }

    @Override
    protected String getPlainName() {
        return this.getWrappedName(this.getContainerName());
    }

    @Override
    protected String getWrappedName(String containerName) {
        return containerName + "$" + this.computer.getName();
    }

    @Override
    protected Object addValueAs(Object container, Function<Object, Object> merger) {
        return container;
    }

    protected List<Object> getEmptyContainer() {
        throw new SpoonException("ComputedParameterInfo#getEmptyContainer should not be used");
    }

    @Override
    public <T> void getValueAs(Factory factory, ResultHolder<T> result, ImmutableMap parameters) {
        ResultHolder<?> inputHolder = this.computer.createInputHolder();
        super.getValueAs(factory, inputHolder, parameters);
        this.computer.computeValue(result, inputHolder);
    }
}

