/*
 * Decompiled with CFR 0.152.
 */
package spoon.processing;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import spoon.Launcher;
import spoon.processing.AbstractProcessor;
import spoon.processing.AnnotationProcessor;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtElement;

public abstract class AbstractAnnotationProcessor<A extends Annotation, E extends CtElement>
extends AbstractProcessor<E>
implements AnnotationProcessor<A, E> {
    Map<String, Class<? extends A>> consumedAnnotationTypes = new TreeMap<String, Class<? extends A>>();
    Map<String, Class<? extends A>> processedAnnotationTypes = new TreeMap<String, Class<? extends A>>();

    public AbstractAnnotationProcessor() {
        this.clearProcessedElementType();
        for (Method m : this.getClass().getMethods()) {
            if (!"process".equals(m.getName()) || m.getParameterTypes().length != 2) continue;
            Class<?> c = m.getParameterTypes()[0];
            if (this.inferConsumedAnnotationType() && Annotation.class != c) {
                this.addConsumedAnnotationType(c);
            }
            if (CtElement.class == (c = m.getParameterTypes()[1])) continue;
            this.addProcessedElementType(c);
        }
        if (this.inferConsumedAnnotationType() && this.processedAnnotationTypes.isEmpty()) {
            this.addProcessedAnnotationType(Annotation.class);
        }
        if (this.processedElementTypes.isEmpty()) {
            this.addProcessedElementType(CtElement.class);
        }
    }

    protected final void addConsumedAnnotationType(Class<? extends A> annotationType) {
        this.addProcessedAnnotationType(annotationType);
        this.consumedAnnotationTypes.put(annotationType.getName(), annotationType);
    }

    protected final void addProcessedAnnotationType(Class<? extends A> annotationType) {
        this.processedAnnotationTypes.put(annotationType.getName(), annotationType);
    }

    protected final void removeProcessedAnnotationType(Class<? extends A> annotationType) {
        this.processedAnnotationTypes.remove(annotationType.getName());
    }

    protected final void clearProcessedAnnotationTypes() {
        this.processedAnnotationTypes.clear();
    }

    protected final void clearConsumedAnnotationTypes() {
        this.consumedAnnotationTypes.clear();
    }

    protected final void removeConsumedAnnotationType(Class<? extends A> annotationType) {
        this.consumedAnnotationTypes.remove(annotationType.getName());
    }

    @Override
    public final Set<Class<? extends A>> getConsumedAnnotationTypes() {
        return new HashSet<Class<? extends A>>(this.consumedAnnotationTypes.values());
    }

    @Override
    public final Set<Class<? extends A>> getProcessedAnnotationTypes() {
        return new HashSet<Class<? extends A>>(this.processedAnnotationTypes.values());
    }

    @Override
    public boolean inferConsumedAnnotationType() {
        return true;
    }

    @Override
    public final boolean isToBeProcessed(E element) {
        if (element != null && element.getAnnotations() != null) {
            for (CtAnnotation<? extends Annotation> a : element.getAnnotations()) {
                if (!this.shoudBeProcessed(a)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public final void process(E element) {
        for (CtAnnotation<? extends Annotation> annotation : new ArrayList<CtAnnotation<? extends Annotation>>(element.getAnnotations())) {
            if (!this.shoudBeProcessed(annotation)) continue;
            try {
                this.process(annotation.getActualAnnotation(), element);
            }
            catch (Exception e) {
                Launcher.LOGGER.error(e.getMessage(), (Throwable)e);
            }
            if (!this.shoudBeConsumed(annotation)) continue;
            element.removeAnnotation(annotation);
        }
    }

    @Override
    public boolean shoudBeConsumed(CtAnnotation<? extends Annotation> annotation) {
        return this.consumedAnnotationTypes.containsKey(annotation.getAnnotationType().getQualifiedName());
    }

    private boolean shoudBeProcessed(CtAnnotation<? extends Annotation> annotation) {
        return this.processedAnnotationTypes.containsKey(annotation.getAnnotationType().getQualifiedName());
    }
}

