/*
 * Decompiled with CFR 0.152.
 */
package spoon.refactoring;

import java.util.regex.Pattern;
import spoon.SpoonException;
import spoon.refactoring.CtRenameRefactoring;
import spoon.reflect.declaration.CtNamedElement;

public abstract class AbstractRenameRefactoring<T extends CtNamedElement>
implements CtRenameRefactoring<T> {
    public static final Pattern javaIdentifierRE = Pattern.compile("\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*");
    protected T target;
    protected String newName;
    protected Pattern newNameValidationRE;

    protected AbstractRenameRefactoring(Pattern newNameValidationRE) {
        this.newNameValidationRE = newNameValidationRE;
    }

    @Override
    public void refactor() {
        if (this.getTarget() == null) {
            throw new SpoonException("The target of refactoring is not defined");
        }
        if (this.getNewName() == null) {
            throw new SpoonException("The new name of refactoring is not defined");
        }
        this.detectIssues();
        this.refactorNoCheck();
    }

    protected abstract void refactorNoCheck();

    protected void detectIssues() {
        this.checkNewNameIsValid();
        this.detectNameConflicts();
    }

    protected void checkNewNameIsValid() {
    }

    protected void detectNameConflicts() {
    }

    protected boolean isJavaIdentifier(String name) {
        return javaIdentifierRE.matcher(name).matches();
    }

    @Override
    public T getTarget() {
        return this.target;
    }

    @Override
    public AbstractRenameRefactoring<T> setTarget(T target) {
        this.target = target;
        return this;
    }

    @Override
    public String getNewName() {
        return this.newName;
    }

    @Override
    public AbstractRenameRefactoring<T> setNewName(String newName) {
        if (this.newNameValidationRE != null && !this.newNameValidationRE.matcher(newName).matches()) {
            throw new SpoonException("New name \"" + newName + "\" is not valid name");
        }
        this.newName = newName;
        return this;
    }
}

