/*
 * Decompiled with CFR 0.152.
 */
package spoon.refactoring;

import java.util.Collection;
import java.util.regex.Pattern;
import spoon.SpoonException;
import spoon.refactoring.AbstractRenameRefactoring;
import spoon.refactoring.RefactoringException;
import spoon.reflect.code.CtCatchVariable;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtLocalVariableReference;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtVariableReference;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.chain.CtConsumer;
import spoon.reflect.visitor.chain.CtQueryable;
import spoon.reflect.visitor.chain.CtScannerListener;
import spoon.reflect.visitor.chain.ScanningMode;
import spoon.reflect.visitor.filter.LocalVariableReferenceFunction;
import spoon.reflect.visitor.filter.LocalVariableScopeFunction;
import spoon.reflect.visitor.filter.PotentialVariableDeclarationFunction;
import spoon.reflect.visitor.filter.SiblingsFunction;
import spoon.reflect.visitor.filter.VariableReferenceFunction;

public class CtRenameLocalVariableRefactoring
extends AbstractRenameRefactoring<CtLocalVariable<?>> {
    public static final Pattern validVariableNameRE = javaIdentifierRE;

    public CtRenameLocalVariableRefactoring() {
        super(validVariableNameRE);
    }

    @Override
    protected void refactorNoCheck() {
        ((CtLocalVariable)this.getTarget()).map(new VariableReferenceFunction()).forEach(new CtConsumer<CtReference>(){

            @Override
            public void accept(CtReference t) {
                t.setSimpleName(CtRenameLocalVariableRefactoring.this.newName);
            }
        });
        ((CtLocalVariable)this.target).setSimpleName(this.newName);
    }

    @Override
    protected void detectNameConflicts() {
        PotentialVariableDeclarationFunction potentialDeclarationFnc = new PotentialVariableDeclarationFunction(this.newName);
        CtVariable var = (CtVariable)((CtLocalVariable)this.getTarget()).map(potentialDeclarationFnc).first();
        if (var != null && !(var instanceof CtField)) {
            if (potentialDeclarationFnc.isTypeOnTheWay()) {
                CtVariableReference shadowedVar = (CtVariableReference)((CtLocalVariable)this.target).map(new SiblingsFunction().includingSelf(true).mode(SiblingsFunction.Mode.NEXT)).map(new VariableReferenceFunction(var)).first();
                if (shadowedVar != null) {
                    this.createNameConflictIssue(var, shadowedVar);
                }
            } else {
                this.createNameConflictIssue(var);
            }
        }
        final QueryDriver queryDriver = new QueryDriver();
        ((CtLocalVariable)this.getTarget()).map(new LocalVariableScopeFunction(queryDriver)).select(new Filter<CtElement>(){

            @Override
            public boolean matches(CtElement element) {
                if (element instanceof CtType) {
                    CtType localClass = (CtType)element;
                    Collection<CtFieldReference<?>> fields = localClass.getAllFields();
                    for (CtFieldReference<?> fieldRef : fields) {
                        if (!CtRenameLocalVariableRefactoring.this.newName.equals(fieldRef.getSimpleName())) continue;
                        queryDriver.ignoreChildrenOf(element);
                        CtLocalVariableReference shadowedVar = (CtLocalVariableReference)element.map(new LocalVariableReferenceFunction((CtLocalVariable)CtRenameLocalVariableRefactoring.this.target)).first();
                        if (shadowedVar != null) {
                            CtRenameLocalVariableRefactoring.this.createNameConflictIssue(fieldRef.getFieldDeclaration(), shadowedVar);
                            return true;
                        }
                        return false;
                    }
                    return false;
                }
                if (element instanceof CtVariable) {
                    CtVariable variable = (CtVariable)element;
                    if (!CtRenameLocalVariableRefactoring.this.newName.equals(variable.getSimpleName())) {
                        return false;
                    }
                    if (variable instanceof CtField) {
                        throw new SpoonException("This should not happen. The children of local class which contains a field with new name should be skipped!");
                    }
                    if (variable instanceof CtCatchVariable || variable instanceof CtLocalVariable || variable instanceof CtParameter) {
                        if (queryDriver.isInContextOfLocalClass()) {
                            queryDriver.ignoreChildrenOf(variable.getParent());
                            CtQueryable searchScope = variable instanceof CtLocalVariable ? variable.map(new SiblingsFunction().includingSelf(true).mode(SiblingsFunction.Mode.NEXT)) : variable.getParent();
                            CtLocalVariableReference shadowedVar = (CtLocalVariableReference)searchScope.map(new LocalVariableReferenceFunction((CtLocalVariable)CtRenameLocalVariableRefactoring.this.target)).first();
                            if (shadowedVar != null) {
                                CtRenameLocalVariableRefactoring.this.createNameConflictIssue(variable, shadowedVar);
                                return true;
                            }
                            return false;
                        }
                        CtRenameLocalVariableRefactoring.this.createNameConflictIssue(variable);
                        return true;
                    }
                    throw new SpoonException("Unexpected variable " + variable.getClass().getName());
                }
                return false;
            }
        }).first();
    }

    protected void createNameConflictIssue(CtVariable<?> conflictVar) {
        throw new RefactoringException(conflictVar.getClass().getSimpleName() + " with name " + conflictVar.getSimpleName() + " is in conflict.");
    }

    protected void createNameConflictIssue(CtVariable<?> conflictVar, CtVariableReference<?> shadowedVarRef) {
        throw new RefactoringException(conflictVar.getClass().getSimpleName() + " with name " + conflictVar.getSimpleName() + " would shadow local variable reference.");
    }

    private static class QueryDriver
    implements CtScannerListener {
        int nrOfNestedLocalClasses = 0;
        CtElement ignoredParent;

        private QueryDriver() {
        }

        @Override
        public ScanningMode enter(CtElement element) {
            if (this.ignoredParent != null && element != null && element.hasParent(this.ignoredParent)) {
                return ScanningMode.SKIP_ALL;
            }
            if (element instanceof CtType) {
                ++this.nrOfNestedLocalClasses;
            }
            return ScanningMode.NORMAL;
        }

        @Override
        public void exit(CtElement element) {
            if (this.ignoredParent == element) {
                this.ignoredParent = null;
            }
            if (element instanceof CtType) {
                --this.nrOfNestedLocalClasses;
            }
        }

        public void ignoreChildrenOf(CtElement element) {
            if (this.ignoredParent != null) {
                throw new SpoonException("Unexpected state. The ignoredParent is already set");
            }
            this.ignoredParent = element;
        }

        public boolean isInContextOfLocalClass() {
            return this.nrOfNestedLocalClasses > 0;
        }
    }
}

