/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.code;

import java.util.Arrays;
import spoon.reflect.annotations.PropertyGetter;
import spoon.reflect.annotations.PropertySetter;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.path.CtRole;

public interface CtJavaDocTag
extends CtElement {
    public static final String JAVADOC_TAG_PREFIX = "@";

    @PropertyGetter(role=CtRole.DOCUMENTATION_TYPE)
    public TagType getType();

    @PropertySetter(role=CtRole.DOCUMENTATION_TYPE)
    public <E extends CtJavaDocTag> E setType(String var1);

    @PropertySetter(role=CtRole.DOCUMENTATION_TYPE)
    public <E extends CtJavaDocTag> E setType(TagType var1);

    @PropertyGetter(role=CtRole.DOCUMENTATION_TYPE_REALNAME)
    public String getRealName();

    @PropertySetter(role=CtRole.DOCUMENTATION_TYPE_REALNAME)
    public <E extends CtJavaDocTag> E setRealName(String var1);

    @PropertyGetter(role=CtRole.COMMENT_CONTENT)
    public String getContent();

    @PropertySetter(role=CtRole.COMMENT_CONTENT)
    public <E extends CtJavaDocTag> E setContent(String var1);

    @PropertyGetter(role=CtRole.JAVADOC_TAG_VALUE)
    public String getParam();

    @PropertySetter(role=CtRole.JAVADOC_TAG_VALUE)
    public <E extends CtJavaDocTag> E setParam(String var1);

    @Override
    public CtJavaDocTag clone();

    public static enum TagType {
        AUTHOR("author"),
        DEPRECATED("deprecated"),
        EXCEPTION("exception"),
        PARAM("param"),
        RETURN("return"),
        SEE("see"),
        SERIAL("serial"),
        SERIAL_DATA("serialData"),
        SERIAL_FIELD("serialField"),
        SINCE("since"),
        THROWS("throws"),
        VERSION("version"),
        UNKNOWN("unknown");

        private String name;

        private TagType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean hasParam() {
            return this == PARAM || this == THROWS || this == EXCEPTION;
        }

        public static TagType tagFromName(String tagName) {
            return Arrays.stream(TagType.values()).filter(v -> v.name.equals(tagName)).findFirst().orElse(UNKNOWN);
        }

        public String toString() {
            return CtJavaDocTag.JAVADOC_TAG_PREFIX + this.name().toLowerCase();
        }
    }
}

