/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.factory;

import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import spoon.SpoonException;
import spoon.experimental.CtUnresolvedImport;
import spoon.reflect.code.CtNewClass;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.cu.position.NoSourcePosition;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtFormalTypeDeclarer;
import spoon.reflect.declaration.CtImport;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeParameter;
import spoon.reflect.factory.Factory;
import spoon.reflect.factory.FactoryImpl;
import spoon.reflect.factory.SubFactory;
import spoon.reflect.reference.CtActualTypeContainer;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtIntersectionTypeReference;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeMemberWildcardImportReference;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtAbstractVisitor;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.filter.TypeFilter;
import spoon.support.DefaultCoreFactory;
import spoon.support.SpoonClassNotFoundException;
import spoon.support.StandardEnvironment;
import spoon.support.util.internal.MapUtils;
import spoon.support.visitor.ClassTypingContext;
import spoon.support.visitor.GenericTypeAdapter;
import spoon.support.visitor.MethodTypingContext;
import spoon.support.visitor.java.JavaReflectionTreeBuilder;

public class TypeFactory
extends SubFactory {
    private static final Set<String> NULL_PACKAGE_CLASSES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("void", "boolean", "byte", "short", "char", "int", "float", "long", "double", "<nulltype>")));
    public final CtTypeReference<?> NULL_TYPE = this.createReference("<nulltype>");
    public final CtTypeReference<Void> VOID = this.createReference(Void.class);
    public final CtTypeReference<String> STRING = this.createReference(String.class);
    public final CtTypeReference<Boolean> BOOLEAN = this.createReference(Boolean.class);
    public final CtTypeReference<Byte> BYTE = this.createReference(Byte.class);
    public final CtTypeReference<Character> CHARACTER = this.createReference(Character.class);
    public final CtTypeReference<Integer> INTEGER = this.createReference(Integer.class);
    public final CtTypeReference<Long> LONG = this.createReference(Long.class);
    public final CtTypeReference<Float> FLOAT = this.createReference(Float.class);
    public final CtTypeReference<Double> DOUBLE = this.createReference(Double.class);
    public final CtTypeReference<Void> VOID_PRIMITIVE = this.createReference(Void.TYPE);
    public final CtTypeReference<Boolean> BOOLEAN_PRIMITIVE = this.createReference(Boolean.TYPE);
    public final CtTypeReference<Byte> BYTE_PRIMITIVE = this.createReference(Byte.TYPE);
    public final CtTypeReference<Character> CHARACTER_PRIMITIVE = this.createReference(Character.TYPE);
    public final CtTypeReference<Integer> INTEGER_PRIMITIVE = this.createReference(Integer.TYPE);
    public final CtTypeReference<Long> LONG_PRIMITIVE = this.createReference(Long.TYPE);
    public final CtTypeReference<Float> FLOAT_PRIMITIVE = this.createReference(Float.TYPE);
    public final CtTypeReference<Double> DOUBLE_PRIMITIVE = this.createReference(Double.TYPE);
    public final CtTypeReference<Short> SHORT = this.createReference(Short.class);
    public final CtTypeReference<Short> SHORT_PRIMITIVE = this.createReference(Short.TYPE);
    public final CtTypeReference<Date> DATE = this.createReference(Date.class);
    public final CtTypeReference<Object> OBJECT = this.createReference(Object.class);
    public final CtTypeReference<Iterable> ITERABLE = this.createReference(Iterable.class);
    public final CtTypeReference<Collection> COLLECTION = this.createReference(Collection.class);
    public final CtTypeReference<List> LIST = this.createReference(List.class);
    public final CtTypeReference<Set> SET = this.createReference(Set.class);
    public final CtTypeReference<Map> MAP = this.createReference(Map.class);
    public final CtTypeReference<Enum> ENUM = this.createReference(Enum.class);
    public final CtTypeReference<?> OMITTED_TYPE_ARG_TYPE = this.createReference("<omitted>");
    private final Map<Class<?>, CtType<?>> shadowCache = new ConcurrentHashMap();
    private static final String CACHE_KEY = TypeFactory.class.getName() + "-AnnonymousTypeCache";

    public CtTypeReference<?> nullType() {
        return this.NULL_TYPE.clone();
    }

    public CtTypeReference<Void> voidType() {
        return this.VOID.clone();
    }

    public CtTypeReference<Void> voidPrimitiveType() {
        return this.VOID_PRIMITIVE.clone();
    }

    public CtTypeReference<String> stringType() {
        return this.STRING.clone();
    }

    public CtTypeReference<Boolean> booleanType() {
        return this.BOOLEAN.clone();
    }

    public CtTypeReference<Boolean> booleanPrimitiveType() {
        return this.BOOLEAN_PRIMITIVE.clone();
    }

    public CtTypeReference<Byte> byteType() {
        return this.BYTE.clone();
    }

    public CtTypeReference<Byte> bytePrimitiveType() {
        return this.BYTE_PRIMITIVE.clone();
    }

    public CtTypeReference<Character> characterType() {
        return this.CHARACTER.clone();
    }

    public CtTypeReference<Character> characterPrimitiveType() {
        return this.CHARACTER_PRIMITIVE.clone();
    }

    public CtTypeReference<Integer> integerType() {
        return this.INTEGER.clone();
    }

    public CtTypeReference<Integer> integerPrimitiveType() {
        return this.INTEGER_PRIMITIVE.clone();
    }

    public CtTypeReference<Long> longType() {
        return this.LONG.clone();
    }

    public CtTypeReference<Long> longPrimitiveType() {
        return this.LONG_PRIMITIVE.clone();
    }

    public CtTypeReference<Float> floatType() {
        return this.FLOAT.clone();
    }

    public CtTypeReference<Float> floatPrimitiveType() {
        return this.FLOAT_PRIMITIVE.clone();
    }

    public CtTypeReference<Double> doubleType() {
        return this.DOUBLE.clone();
    }

    public CtTypeReference<Double> doublePrimitiveType() {
        return this.DOUBLE_PRIMITIVE.clone();
    }

    public CtTypeReference<Short> shortType() {
        return this.SHORT.clone();
    }

    public CtTypeReference<Short> shortPrimitiveType() {
        return this.SHORT_PRIMITIVE.clone();
    }

    public CtTypeReference<Date> dateType() {
        return this.DATE.clone();
    }

    public CtTypeReference<Object> objectType() {
        return this.OBJECT.clone();
    }

    public TypeFactory(Factory factory) {
        super(factory);
    }

    public TypeFactory() {
        this(new FactoryImpl(new DefaultCoreFactory(), new StandardEnvironment()));
    }

    public <T> CtArrayTypeReference<T[]> createArrayReference(CtType<T> type) {
        CtArrayTypeReference<T[]> array = this.factory.Core().createArrayTypeReference();
        array.setComponentType(this.createReference(type));
        return array;
    }

    public <T> CtArrayTypeReference<T[]> createArrayReference(CtTypeReference<T> reference) {
        CtArrayTypeReference<T[]> array = this.factory.Core().createArrayTypeReference();
        array.setComponentType(reference);
        return array;
    }

    public CtArrayTypeReference<?> createArrayReference(CtTypeReference<?> reference, int n) {
        if (n == 1) {
            return this.createArrayReference(reference);
        }
        CtArrayTypeReference<?> componentType = this.createArrayReference(reference, n - 1);
        CtArrayTypeReference array = this.factory.Core().createArrayTypeReference();
        array.setComponentType(componentType);
        return array;
    }

    public <T> CtArrayTypeReference<T> createArrayReference(String qualifiedName) {
        CtArrayTypeReference array = this.factory.Core().createArrayTypeReference();
        array.setComponentType(this.createReference(qualifiedName));
        return array;
    }

    public <T> CtTypeReference<T> createReference(Class<T> type) {
        return this.createReference(type, false);
    }

    public <T> CtTypeReference<T> createReference(Class<T> type, boolean includingFormalTypeParameter) {
        if (type == null) {
            return null;
        }
        if (type.isArray()) {
            CtArrayTypeReference array = this.factory.Core().createArrayTypeReference();
            array.setComponentType(this.createReference(type.getComponentType(), includingFormalTypeParameter));
            return array;
        }
        CtTypeReference<T> typeReference = this.createReference(type.getName());
        if (includingFormalTypeParameter) {
            for (TypeVariable<Class<T>> generic : type.getTypeParameters()) {
                typeReference.addActualTypeArgument(this.createTypeParameterReference(generic.getName()));
            }
        }
        return typeReference;
    }

    public <T> CtTypeReference<T> createReference(CtType<T> type) {
        return this.createReference(type, false);
    }

    public CtTypeMemberWildcardImportReference createTypeMemberWildcardImportReference(CtTypeReference typeReference) {
        CtTypeMemberWildcardImportReference ref = this.factory.Core().createTypeMemberWildcardImportReference();
        ref.setTypeReference((CtTypeReference<?>)typeReference.clone());
        return ref;
    }

    public <T> CtTypeReference<T> createReference(CtType<T> type, boolean includingFormalTypeParameter) {
        CtTypeReference ref = this.factory.Core().createTypeReference();
        if (type.getDeclaringType() != null) {
            ref.setDeclaringType(this.createReference(type.getDeclaringType(), includingFormalTypeParameter));
        } else if (type.getPackage() != null) {
            ref.setPackage(this.factory.Package().createReference(type.getPackage()));
        }
        ref.setSimpleName(type.getSimpleName());
        if (includingFormalTypeParameter) {
            for (CtTypeParameter formalTypeParam : type.getFormalCtTypeParameters()) {
                ref.addActualTypeArgument(formalTypeParam.getReference());
            }
        }
        return ref;
    }

    public CtTypeParameterReference createReference(CtTypeParameter type) {
        CtTypeParameterReference ref = this.factory.Core().createTypeParameterReference();
        ref.setSimpleName(type.getSimpleName());
        ref.setParent(type);
        return ref;
    }

    public <T> CtTypeReference<T> createReference(String qualifiedName) {
        if (qualifiedName.endsWith("[]")) {
            return this.createArrayReference(qualifiedName.substring(0, qualifiedName.length() - 2));
        }
        CtTypeReference ref = this.factory.Core().createTypeReference();
        if (this.hasInnerType(qualifiedName) > 0) {
            ref.setDeclaringType(this.createReference(this.getDeclaringTypeName(qualifiedName)));
        } else if (this.hasPackage(qualifiedName) > 0) {
            ref.setPackage(this.factory.Package().createReference(this.getPackageName(qualifiedName)));
        } else if (!NULL_PACKAGE_CLASSES.contains(qualifiedName)) {
            ref.setPackage(this.factory.Package().topLevel());
        }
        ref.setSimpleName(this.getSimpleName(qualifiedName));
        return ref;
    }

    public <T> CtTypeReference<T> createSimplyQualifiedReference(String qualifiedName) {
        CtTypeReference<T> ref = this.createReference(qualifiedName);
        ref.getPackage().setImplicit(true);
        return ref;
    }

    public <T> CtType<T> get(final String qualifiedName) {
        Object type;
        int packageIndex = qualifiedName.lastIndexOf(".");
        CtPackage pack = packageIndex > 0 ? this.factory.Package().get(qualifiedName.substring(0, packageIndex)) : this.factory.Package().getRootPackage();
        if (pack != null && (type = pack.getType(qualifiedName.substring(packageIndex + 1))) != null) {
            return type;
        }
        int inertTypeIndex = qualifiedName.lastIndexOf("$");
        if (inertTypeIndex > 0) {
            String s = qualifiedName.substring(0, inertTypeIndex);
            CtType t = this.factory.Type().get(s);
            if (t == null) {
                return null;
            }
            String className = qualifiedName.substring(inertTypeIndex + 1);
            CtReference reference = t.getReference();
            if (reference.isLocalType()) {
                List enclosingClasses = t.getElements(new TypeFilter<CtClass<T>>(CtClass.class){

                    @Override
                    public boolean matches(CtClass<T> element) {
                        return super.matches(element) && element.getQualifiedName().equals(qualifiedName);
                    }
                });
                if (enclosingClasses.isEmpty()) {
                    return null;
                }
                return (CtType)enclosingClasses.get(0);
            }
            if (this.isNumber(className)) {
                return this.getFromCache(t, className, () -> {
                    Integer.parseInt(className);
                    List<CtNewClass> anonymousClasses = t.getElements(new TypeFilter<CtNewClass>(CtNewClass.class){

                        @Override
                        public boolean matches(CtNewClass element) {
                            return super.matches(element) && element.getAnonymousClass().getQualifiedName().equals(qualifiedName);
                        }
                    });
                    if (anonymousClasses.isEmpty()) {
                        return null;
                    }
                    return anonymousClasses.get(0).getAnonymousClass();
                });
            }
            return t.getNestedType(className);
        }
        return null;
    }

    private <T, K> T getFromCache(CtElement element, K key, Supplier<T> valueResolver) {
        HashMap cache = (HashMap)element.getMetadata(CACHE_KEY);
        if (cache == null) {
            cache = new HashMap();
            element.putMetadata(CACHE_KEY, cache);
        }
        return (T)MapUtils.getOrCreate(cache, key, valueResolver);
    }

    private boolean isNumber(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        int len = str.length();
        for (int i2 = 0; i2 < len; ++i2) {
            if (Character.isDigit(str.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public List<CtType<?>> getAll() {
        return new ArrayList(this.factory.getModel().getAllTypes());
    }

    public List<CtType<?>> getAll(boolean includeNestedTypes) {
        if (!includeNestedTypes) {
            return this.getAll();
        }
        ArrayList types = new ArrayList();
        for (CtPackage pack : this.factory.Package().getAll()) {
            for (CtType<?> type : pack.getTypes()) {
                this.addNestedType(types, type);
            }
        }
        return types;
    }

    private void addNestedType(List<CtType<?>> list, CtType<?> t) {
        list.add(t);
        for (CtType<?> nt : t.getNestedTypes()) {
            this.addNestedType(list, nt);
        }
    }

    public <T> CtType<T> get(Class<?> cl) {
        CtType<T> aType = this.get(cl.getName());
        if (aType == null) {
            CtType<?> shadowClass = this.shadowCache.get(cl);
            if (shadowClass == null) {
                Object newShadowClass;
                try {
                    newShadowClass = new JavaReflectionTreeBuilder(this.createFactory()).scan(cl);
                }
                catch (Throwable e) {
                    throw new SpoonClassNotFoundException("cannot create shadow class: " + cl.getName(), e);
                }
                newShadowClass.setFactory(this.factory);
                newShadowClass.accept(new CtScanner(){

                    @Override
                    public void scan(CtElement element) {
                        if (element != null) {
                            element.setFactory(TypeFactory.this.factory);
                        }
                    }
                });
                this.shadowCache.put(cl, (CtType<?>)newShadowClass);
                return newShadowClass;
            }
            return shadowClass;
        }
        return aType;
    }

    private Factory createFactory() {
        return new FactoryImpl(new DefaultCoreFactory(), this.factory.getEnvironment());
    }

    protected String getDeclaringTypeName(String qualifiedName) {
        return qualifiedName.substring(0, this.hasInnerType(qualifiedName));
    }

    public List<CtTypeReference<?>> createReferences(List<Class<?>> classes) {
        ArrayList refs = new ArrayList(classes.size());
        for (Class<?> c : classes) {
            refs.add(this.createReference(c));
        }
        return refs;
    }

    protected String getPackageName(String qualifiedName) {
        if (this.hasPackage(qualifiedName) >= 0) {
            return qualifiedName.substring(0, this.hasPackage(qualifiedName));
        }
        return "";
    }

    protected String getSimpleName(String qualifiedName) {
        if (this.hasInnerType(qualifiedName) > 0) {
            return qualifiedName.substring(this.hasInnerType(qualifiedName) + 1);
        }
        if (this.hasPackage(qualifiedName) > 0) {
            return qualifiedName.substring(this.hasPackage(qualifiedName) + 1);
        }
        return qualifiedName;
    }

    protected int hasInnerType(String qualifiedName) {
        return qualifiedName.lastIndexOf("$");
    }

    protected int hasPackage(String qualifiedName) {
        return qualifiedName.lastIndexOf(".");
    }

    public CtTypeParameterReference createTypeParameterReference(String name) {
        if ("?".equals(name)) {
            throw new SpoonException("the Spoon metamodel has evolved, use Factory.createWildcardReference() instead");
        }
        CtTypeParameterReference typeParam = this.factory.Core().createTypeParameterReference();
        typeParam.setSimpleName(name);
        return typeParam;
    }

    public GenericTypeAdapter createTypeAdapter(CtFormalTypeDeclarer formalTypeDeclarer) {
        class Visitor
        extends CtAbstractVisitor {
            GenericTypeAdapter adapter;

            Visitor() {
            }

            @Override
            public <T> void visitCtClass(CtClass<T> ctClass) {
                this.adapter = new ClassTypingContext(ctClass);
            }

            @Override
            public <T> void visitCtInterface(CtInterface<T> intrface) {
                this.adapter = new ClassTypingContext(intrface);
            }

            @Override
            public <T> void visitCtMethod(CtMethod<T> m) {
                this.adapter = new MethodTypingContext().setMethod(m);
            }

            @Override
            public <T> void visitCtConstructor(CtConstructor<T> c) {
                this.adapter = new MethodTypingContext().setConstructor(c);
            }
        }
        Visitor visitor = new Visitor();
        formalTypeDeclarer.accept(visitor);
        return visitor.adapter;
    }

    public <T> CtIntersectionTypeReference<T> createIntersectionTypeReferenceWithBounds(List<CtTypeReference<?>> bounds) {
        CtIntersectionTypeReference intersectionRef = this.factory.Core().createIntersectionTypeReference();
        CtReference firstBound = bounds.toArray(new CtTypeReference[0])[0].clone();
        intersectionRef.setSimpleName(firstBound.getSimpleName());
        intersectionRef.setDeclaringType(firstBound.getDeclaringType());
        intersectionRef.setPackage(firstBound.getPackage());
        intersectionRef.setActualTypeArguments(firstBound.getActualTypeArguments());
        intersectionRef.setBounds(bounds);
        CtTypeReference<?> lastBound = bounds.get(bounds.size() - 1);
        if (!(firstBound.getPosition() instanceof NoSourcePosition) && !(lastBound.getPosition() instanceof NoSourcePosition)) {
            SourcePosition pos = this.factory.createSourcePosition(firstBound.getPosition().getCompilationUnit(), firstBound.getPosition().getSourceStart(), lastBound.getPosition().getSourceEnd(), firstBound.getPosition().getCompilationUnit().getLineSeparatorPositions());
            intersectionRef.setPosition(pos);
        }
        return intersectionRef;
    }

    public CtTypeReference getDefaultBoundingType() {
        return this.OBJECT;
    }

    public CtImport createImport(CtReference reference) {
        CtImport ctImport = this.factory.Core().createImport();
        CtReference importRef = reference.clone();
        new CtScanner(){

            @Override
            protected void enter(CtElement e) {
                e.setImplicit(false);
                if (e instanceof CtActualTypeContainer) {
                    CtActualTypeContainer atc = (CtActualTypeContainer)((Object)e);
                    atc.setActualTypeArguments(Collections.emptyList());
                }
            }
        }.scan(importRef);
        return ctImport.setReference(importRef);
    }

    public CtImport createUnresolvedImport(String reference, boolean isStatic) {
        CtUnresolvedImport ctUnresolvedImport = (CtUnresolvedImport)this.factory.Core().createUnresolvedImport();
        ctUnresolvedImport.setUnresolvedReference(reference);
        ctUnresolvedImport.setStatic(isStatic);
        return ctUnresolvedImport;
    }
}

