/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import spoon.reflect.code.CtAnnotationFieldAccess;
import spoon.reflect.code.CtArrayRead;
import spoon.reflect.code.CtArrayWrite;
import spoon.reflect.code.CtAssert;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtBreak;
import spoon.reflect.code.CtCase;
import spoon.reflect.code.CtCatch;
import spoon.reflect.code.CtCatchVariable;
import spoon.reflect.code.CtCodeSnippetExpression;
import spoon.reflect.code.CtCodeSnippetStatement;
import spoon.reflect.code.CtComment;
import spoon.reflect.code.CtConditional;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtContinue;
import spoon.reflect.code.CtDo;
import spoon.reflect.code.CtExecutableReferenceExpression;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtFieldWrite;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtForEach;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtJavaDoc;
import spoon.reflect.code.CtJavaDocTag;
import spoon.reflect.code.CtLambda;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.code.CtNewClass;
import spoon.reflect.code.CtOperatorAssignment;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.code.CtSuperAccess;
import spoon.reflect.code.CtSwitch;
import spoon.reflect.code.CtSwitchExpression;
import spoon.reflect.code.CtSynchronized;
import spoon.reflect.code.CtThisAccess;
import spoon.reflect.code.CtThrow;
import spoon.reflect.code.CtTry;
import spoon.reflect.code.CtTryWithResource;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.code.CtVariableWrite;
import spoon.reflect.code.CtWhile;
import spoon.reflect.code.CtYieldStatement;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtAnnotationMethod;
import spoon.reflect.declaration.CtAnnotationType;
import spoon.reflect.declaration.CtAnonymousExecutable;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtCompilationUnit;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtEnum;
import spoon.reflect.declaration.CtEnumValue;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtImport;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtModule;
import spoon.reflect.declaration.CtModuleRequirement;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtPackageDeclaration;
import spoon.reflect.declaration.CtPackageExport;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtProvidedService;
import spoon.reflect.declaration.CtTypeParameter;
import spoon.reflect.declaration.CtUsedService;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtCatchVariableReference;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtIntersectionTypeReference;
import spoon.reflect.reference.CtLocalVariableReference;
import spoon.reflect.reference.CtModuleReference;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtParameterReference;
import spoon.reflect.reference.CtTypeMemberWildcardImportReference;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtUnboundVariableReference;
import spoon.reflect.reference.CtWildcardReference;
import spoon.reflect.visitor.CtVisitor;

public abstract class CtScanner
implements CtVisitor {
    protected void enter(CtElement e) {
    }

    protected void exit(CtElement e) {
    }

    public void scan(CtRole role, Collection<? extends CtElement> elements) {
        if (elements != null) {
            for (CtElement ctElement : new ArrayList<CtElement>(elements)) {
                this.scan(role, ctElement);
            }
        }
    }

    public void scan(CtRole role, Map<String, ? extends CtElement> elements) {
        if (elements != null) {
            for (CtElement ctElement : elements.values()) {
                this.scan(role, ctElement);
            }
        }
    }

    public void scan(Collection<? extends CtElement> elements) {
        this.scan(null, elements);
    }

    public void scan(CtRole role, CtElement element) {
        this.scan(element);
    }

    public void scan(CtElement element) {
        if (element != null) {
            element.accept(this);
        }
    }

    @Override
    public <A extends Annotation> void visitCtAnnotation(CtAnnotation<A> annotation) {
        this.enter(annotation);
        this.scan(CtRole.TYPE, annotation.getType());
        this.scan(CtRole.COMMENT, annotation.getComments());
        this.scan(CtRole.ANNOTATION_TYPE, annotation.getAnnotationType());
        this.scan(CtRole.ANNOTATION, annotation.getAnnotations());
        this.scan(CtRole.VALUE, annotation.getValues());
        this.exit(annotation);
    }

    public void scan(Object o) {
        this.scan(null, o);
    }

    public void scan(CtRole role, Object o) {
        if (o instanceof CtElement) {
            this.scan(role, (CtElement)o);
        }
        if (o instanceof Collection) {
            this.scan(role, (Collection)o);
        }
        if (o instanceof Map) {
            this.scan(role, (Map)o);
        }
    }

    @Override
    public <A extends Annotation> void visitCtAnnotationType(CtAnnotationType<A> annotationType) {
        this.enter(annotationType);
        this.scan(CtRole.ANNOTATION, annotationType.getAnnotations());
        this.scan(CtRole.TYPE_MEMBER, annotationType.getTypeMembers());
        this.scan(CtRole.COMMENT, annotationType.getComments());
        this.exit(annotationType);
    }

    @Override
    public void visitCtAnonymousExecutable(CtAnonymousExecutable anonymousExec) {
        this.enter(anonymousExec);
        this.scan(CtRole.ANNOTATION, anonymousExec.getAnnotations());
        this.scan(CtRole.BODY, anonymousExec.getBody());
        this.scan(CtRole.COMMENT, anonymousExec.getComments());
        this.exit(anonymousExec);
    }

    @Override
    public <T> void visitCtArrayRead(CtArrayRead<T> arrayRead) {
        this.enter(arrayRead);
        this.scan(CtRole.ANNOTATION, arrayRead.getAnnotations());
        this.scan(CtRole.TYPE, arrayRead.getType());
        this.scan(CtRole.CAST, arrayRead.getTypeCasts());
        this.scan(CtRole.TARGET, (CtElement)arrayRead.getTarget());
        this.scan(CtRole.EXPRESSION, arrayRead.getIndexExpression());
        this.scan(CtRole.COMMENT, arrayRead.getComments());
        this.exit(arrayRead);
    }

    @Override
    public <T> void visitCtArrayWrite(CtArrayWrite<T> arrayWrite) {
        this.enter(arrayWrite);
        this.scan(CtRole.ANNOTATION, arrayWrite.getAnnotations());
        this.scan(CtRole.TYPE, arrayWrite.getType());
        this.scan(CtRole.CAST, arrayWrite.getTypeCasts());
        this.scan(CtRole.TARGET, (CtElement)arrayWrite.getTarget());
        this.scan(CtRole.EXPRESSION, arrayWrite.getIndexExpression());
        this.scan(CtRole.COMMENT, arrayWrite.getComments());
        this.exit(arrayWrite);
    }

    @Override
    public <T> void visitCtArrayTypeReference(CtArrayTypeReference<T> reference) {
        this.enter(reference);
        this.scan(CtRole.PACKAGE_REF, reference.getPackage());
        this.scan(CtRole.DECLARING_TYPE, reference.getDeclaringType());
        this.scan(CtRole.TYPE, reference.getComponentType());
        this.scan(CtRole.TYPE_ARGUMENT, reference.getActualTypeArguments());
        this.scan(CtRole.ANNOTATION, reference.getAnnotations());
        this.exit(reference);
    }

    @Override
    public <T> void visitCtAssert(CtAssert<T> asserted) {
        this.enter(asserted);
        this.scan(CtRole.ANNOTATION, asserted.getAnnotations());
        this.scan(CtRole.CONDITION, asserted.getAssertExpression());
        this.scan(CtRole.EXPRESSION, asserted.getExpression());
        this.scan(CtRole.COMMENT, asserted.getComments());
        this.exit(asserted);
    }

    @Override
    public <T, A extends T> void visitCtAssignment(CtAssignment<T, A> assignement) {
        this.enter(assignement);
        this.scan(CtRole.ANNOTATION, assignement.getAnnotations());
        this.scan(CtRole.TYPE, assignement.getType());
        this.scan(CtRole.CAST, assignement.getTypeCasts());
        this.scan(CtRole.ASSIGNED, assignement.getAssigned());
        this.scan(CtRole.ASSIGNMENT, assignement.getAssignment());
        this.scan(CtRole.COMMENT, assignement.getComments());
        this.exit(assignement);
    }

    @Override
    public <T> void visitCtBinaryOperator(CtBinaryOperator<T> operator) {
        this.enter(operator);
        this.scan(CtRole.ANNOTATION, operator.getAnnotations());
        this.scan(CtRole.TYPE, operator.getType());
        this.scan(CtRole.CAST, operator.getTypeCasts());
        this.scan(CtRole.LEFT_OPERAND, operator.getLeftHandOperand());
        this.scan(CtRole.RIGHT_OPERAND, operator.getRightHandOperand());
        this.scan(CtRole.COMMENT, operator.getComments());
        this.exit(operator);
    }

    @Override
    public <R> void visitCtBlock(CtBlock<R> block) {
        this.enter(block);
        this.scan(CtRole.ANNOTATION, block.getAnnotations());
        this.scan(CtRole.STATEMENT, block.getStatements());
        this.scan(CtRole.COMMENT, block.getComments());
        this.exit(block);
    }

    @Override
    public void visitCtBreak(CtBreak breakStatement) {
        this.enter(breakStatement);
        this.scan(CtRole.ANNOTATION, breakStatement.getAnnotations());
        this.scan(CtRole.COMMENT, breakStatement.getComments());
        this.exit(breakStatement);
    }

    @Override
    public <S> void visitCtCase(CtCase<S> caseStatement) {
        this.enter(caseStatement);
        this.scan(CtRole.ANNOTATION, caseStatement.getAnnotations());
        this.scan(CtRole.EXPRESSION, caseStatement.getCaseExpressions());
        this.scan(CtRole.STATEMENT, caseStatement.getStatements());
        this.scan(CtRole.COMMENT, caseStatement.getComments());
        this.exit(caseStatement);
    }

    @Override
    public void visitCtCatch(CtCatch catchBlock) {
        this.enter(catchBlock);
        this.scan(CtRole.ANNOTATION, catchBlock.getAnnotations());
        this.scan(CtRole.PARAMETER, catchBlock.getParameter());
        this.scan(CtRole.BODY, catchBlock.getBody());
        this.scan(CtRole.COMMENT, catchBlock.getComments());
        this.exit(catchBlock);
    }

    @Override
    public <T> void visitCtClass(CtClass<T> ctClass) {
        this.enter(ctClass);
        this.scan(CtRole.ANNOTATION, ctClass.getAnnotations());
        this.scan(CtRole.SUPER_TYPE, ctClass.getSuperclass());
        this.scan(CtRole.INTERFACE, ctClass.getSuperInterfaces());
        this.scan(CtRole.TYPE_PARAMETER, ctClass.getFormalCtTypeParameters());
        this.scan(CtRole.TYPE_MEMBER, ctClass.getTypeMembers());
        this.scan(CtRole.COMMENT, ctClass.getComments());
        this.exit(ctClass);
    }

    @Override
    public void visitCtTypeParameter(CtTypeParameter typeParameter) {
        this.enter(typeParameter);
        this.scan(CtRole.ANNOTATION, typeParameter.getAnnotations());
        this.scan(CtRole.SUPER_TYPE, typeParameter.getSuperclass());
        this.scan(CtRole.COMMENT, typeParameter.getComments());
        this.exit(typeParameter);
    }

    @Override
    public <T> void visitCtConditional(CtConditional<T> conditional) {
        this.enter(conditional);
        this.scan(CtRole.TYPE, conditional.getType());
        this.scan(CtRole.ANNOTATION, conditional.getAnnotations());
        this.scan(CtRole.CONDITION, conditional.getCondition());
        this.scan(CtRole.THEN, conditional.getThenExpression());
        this.scan(CtRole.ELSE, conditional.getElseExpression());
        this.scan(CtRole.COMMENT, conditional.getComments());
        this.scan(CtRole.CAST, conditional.getTypeCasts());
        this.exit(conditional);
    }

    @Override
    public <T> void visitCtConstructor(CtConstructor<T> c) {
        this.enter(c);
        this.scan(CtRole.ANNOTATION, c.getAnnotations());
        this.scan(CtRole.PARAMETER, c.getParameters());
        this.scan(CtRole.THROWN, c.getThrownTypes());
        this.scan(CtRole.TYPE_PARAMETER, c.getFormalCtTypeParameters());
        this.scan(CtRole.BODY, c.getBody());
        this.scan(CtRole.COMMENT, c.getComments());
        this.exit(c);
    }

    @Override
    public void visitCtContinue(CtContinue continueStatement) {
        this.enter(continueStatement);
        this.scan(CtRole.ANNOTATION, continueStatement.getAnnotations());
        this.scan(CtRole.COMMENT, continueStatement.getComments());
        this.exit(continueStatement);
    }

    @Override
    public void visitCtDo(CtDo doLoop) {
        this.enter(doLoop);
        this.scan(CtRole.ANNOTATION, doLoop.getAnnotations());
        this.scan(CtRole.EXPRESSION, doLoop.getLoopingExpression());
        this.scan(CtRole.BODY, doLoop.getBody());
        this.scan(CtRole.COMMENT, doLoop.getComments());
        this.exit(doLoop);
    }

    @Override
    public <T extends Enum<?>> void visitCtEnum(CtEnum<T> ctEnum) {
        this.enter(ctEnum);
        this.scan(CtRole.ANNOTATION, ctEnum.getAnnotations());
        this.scan(CtRole.INTERFACE, ctEnum.getSuperInterfaces());
        this.scan(CtRole.TYPE_MEMBER, ctEnum.getTypeMembers());
        this.scan(CtRole.VALUE, ctEnum.getEnumValues());
        this.scan(CtRole.COMMENT, ctEnum.getComments());
        this.exit(ctEnum);
    }

    @Override
    public <T> void visitCtExecutableReference(CtExecutableReference<T> reference) {
        this.enter(reference);
        this.scan(CtRole.DECLARING_TYPE, reference.getDeclaringType());
        this.scan(CtRole.TYPE, reference.getType());
        this.scan(CtRole.ARGUMENT_TYPE, reference.getParameters());
        this.scan(CtRole.TYPE_ARGUMENT, reference.getActualTypeArguments());
        this.scan(CtRole.ANNOTATION, reference.getAnnotations());
        this.scan(CtRole.COMMENT, reference.getComments());
        this.exit(reference);
    }

    @Override
    public <T> void visitCtField(CtField<T> f) {
        this.enter(f);
        this.scan(CtRole.ANNOTATION, f.getAnnotations());
        this.scan(CtRole.TYPE, f.getType());
        this.scan(CtRole.DEFAULT_EXPRESSION, f.getDefaultExpression());
        this.scan(CtRole.COMMENT, f.getComments());
        this.exit(f);
    }

    @Override
    public <T> void visitCtEnumValue(CtEnumValue<T> enumValue) {
        this.enter(enumValue);
        this.scan(CtRole.ANNOTATION, enumValue.getAnnotations());
        this.scan(CtRole.TYPE, enumValue.getType());
        this.scan(CtRole.DEFAULT_EXPRESSION, enumValue.getDefaultExpression());
        this.scan(CtRole.COMMENT, enumValue.getComments());
        this.exit(enumValue);
    }

    @Override
    public <T> void visitCtThisAccess(CtThisAccess<T> thisAccess) {
        this.enter(thisAccess);
        this.scan(CtRole.COMMENT, thisAccess.getComments());
        this.scan(CtRole.ANNOTATION, thisAccess.getAnnotations());
        this.scan(CtRole.TYPE, thisAccess.getType());
        this.scan(CtRole.CAST, thisAccess.getTypeCasts());
        this.scan(CtRole.TARGET, (CtElement)thisAccess.getTarget());
        this.exit(thisAccess);
    }

    @Override
    public <T> void visitCtAnnotationFieldAccess(CtAnnotationFieldAccess<T> annotationFieldAccess) {
        this.enter(annotationFieldAccess);
        this.scan(CtRole.COMMENT, annotationFieldAccess.getComments());
        this.scan(CtRole.ANNOTATION, annotationFieldAccess.getAnnotations());
        this.scan(CtRole.CAST, annotationFieldAccess.getTypeCasts());
        this.scan(CtRole.TARGET, (CtElement)annotationFieldAccess.getTarget());
        this.scan(CtRole.VARIABLE, annotationFieldAccess.getVariable());
        this.exit(annotationFieldAccess);
    }

    @Override
    public <T> void visitCtFieldReference(CtFieldReference<T> reference) {
        this.enter(reference);
        this.scan(CtRole.DECLARING_TYPE, reference.getDeclaringType());
        this.scan(CtRole.TYPE, reference.getType());
        this.scan(CtRole.ANNOTATION, reference.getAnnotations());
        this.exit(reference);
    }

    @Override
    public void visitCtFor(CtFor forLoop) {
        this.enter(forLoop);
        this.scan(CtRole.ANNOTATION, forLoop.getAnnotations());
        this.scan(CtRole.FOR_INIT, forLoop.getForInit());
        this.scan(CtRole.EXPRESSION, forLoop.getExpression());
        this.scan(CtRole.FOR_UPDATE, forLoop.getForUpdate());
        this.scan(CtRole.BODY, forLoop.getBody());
        this.scan(CtRole.COMMENT, forLoop.getComments());
        this.exit(forLoop);
    }

    @Override
    public void visitCtForEach(CtForEach foreach) {
        this.enter(foreach);
        this.scan(CtRole.ANNOTATION, foreach.getAnnotations());
        this.scan(CtRole.FOREACH_VARIABLE, foreach.getVariable());
        this.scan(CtRole.EXPRESSION, foreach.getExpression());
        this.scan(CtRole.BODY, foreach.getBody());
        this.scan(CtRole.COMMENT, foreach.getComments());
        this.exit(foreach);
    }

    @Override
    public void visitCtIf(CtIf ifElement) {
        this.enter(ifElement);
        this.scan(CtRole.ANNOTATION, ifElement.getAnnotations());
        this.scan(CtRole.CONDITION, ifElement.getCondition());
        this.scan(CtRole.THEN, (CtElement)ifElement.getThenStatement());
        this.scan(CtRole.ELSE, (CtElement)ifElement.getElseStatement());
        this.scan(CtRole.COMMENT, ifElement.getComments());
        this.exit(ifElement);
    }

    @Override
    public <T> void visitCtInterface(CtInterface<T> intrface) {
        this.enter(intrface);
        this.scan(CtRole.ANNOTATION, intrface.getAnnotations());
        this.scan(CtRole.INTERFACE, intrface.getSuperInterfaces());
        this.scan(CtRole.TYPE_PARAMETER, intrface.getFormalCtTypeParameters());
        this.scan(CtRole.TYPE_MEMBER, intrface.getTypeMembers());
        this.scan(CtRole.COMMENT, intrface.getComments());
        this.exit(intrface);
    }

    @Override
    public <T> void visitCtInvocation(CtInvocation<T> invocation) {
        this.enter(invocation);
        this.scan(CtRole.ANNOTATION, invocation.getAnnotations());
        this.scan(CtRole.CAST, invocation.getTypeCasts());
        this.scan(CtRole.TARGET, (CtElement)invocation.getTarget());
        this.scan(CtRole.EXECUTABLE_REF, invocation.getExecutable());
        this.scan(CtRole.ARGUMENT, invocation.getArguments());
        this.scan(CtRole.COMMENT, invocation.getComments());
        this.exit(invocation);
    }

    @Override
    public <T> void visitCtLiteral(CtLiteral<T> literal) {
        this.enter(literal);
        this.scan(CtRole.ANNOTATION, literal.getAnnotations());
        this.scan(CtRole.TYPE, literal.getType());
        this.scan(CtRole.CAST, literal.getTypeCasts());
        this.scan(CtRole.COMMENT, literal.getComments());
        this.exit(literal);
    }

    @Override
    public <T> void visitCtLocalVariable(CtLocalVariable<T> localVariable) {
        this.enter(localVariable);
        this.scan(CtRole.ANNOTATION, localVariable.getAnnotations());
        this.scan(CtRole.TYPE, localVariable.getType());
        this.scan(CtRole.DEFAULT_EXPRESSION, localVariable.getDefaultExpression());
        this.scan(CtRole.COMMENT, localVariable.getComments());
        this.exit(localVariable);
    }

    @Override
    public <T> void visitCtLocalVariableReference(CtLocalVariableReference<T> reference) {
        this.enter(reference);
        this.scan(CtRole.TYPE, reference.getType());
        this.scan(CtRole.ANNOTATION, reference.getAnnotations());
        this.exit(reference);
    }

    @Override
    public <T> void visitCtCatchVariable(CtCatchVariable<T> catchVariable) {
        this.enter(catchVariable);
        this.scan(CtRole.COMMENT, catchVariable.getComments());
        this.scan(CtRole.ANNOTATION, catchVariable.getAnnotations());
        this.scan(CtRole.MULTI_TYPE, catchVariable.getMultiTypes());
        this.exit(catchVariable);
    }

    @Override
    public <T> void visitCtCatchVariableReference(CtCatchVariableReference<T> reference) {
        this.enter(reference);
        this.scan(CtRole.TYPE, reference.getType());
        this.scan(CtRole.ANNOTATION, reference.getAnnotations());
        this.exit(reference);
    }

    @Override
    public <T> void visitCtMethod(CtMethod<T> m) {
        this.enter(m);
        this.scan(CtRole.ANNOTATION, m.getAnnotations());
        this.scan(CtRole.TYPE_PARAMETER, m.getFormalCtTypeParameters());
        this.scan(CtRole.TYPE, m.getType());
        this.scan(CtRole.PARAMETER, m.getParameters());
        this.scan(CtRole.THROWN, m.getThrownTypes());
        this.scan(CtRole.BODY, m.getBody());
        this.scan(CtRole.COMMENT, m.getComments());
        this.exit(m);
    }

    @Override
    public <T> void visitCtAnnotationMethod(CtAnnotationMethod<T> annotationMethod) {
        this.enter(annotationMethod);
        this.scan(CtRole.ANNOTATION, annotationMethod.getAnnotations());
        this.scan(CtRole.TYPE, annotationMethod.getType());
        this.scan(CtRole.DEFAULT_EXPRESSION, annotationMethod.getDefaultExpression());
        this.scan(CtRole.COMMENT, annotationMethod.getComments());
        this.exit(annotationMethod);
    }

    @Override
    public <T> void visitCtNewArray(CtNewArray<T> newArray) {
        this.enter(newArray);
        this.scan(CtRole.ANNOTATION, newArray.getAnnotations());
        this.scan(CtRole.TYPE, newArray.getType());
        this.scan(CtRole.CAST, newArray.getTypeCasts());
        this.scan(CtRole.EXPRESSION, newArray.getElements());
        this.scan(CtRole.DIMENSION, newArray.getDimensionExpressions());
        this.scan(CtRole.COMMENT, newArray.getComments());
        this.exit(newArray);
    }

    @Override
    public <T> void visitCtConstructorCall(CtConstructorCall<T> ctConstructorCall) {
        this.enter(ctConstructorCall);
        this.scan(CtRole.ANNOTATION, ctConstructorCall.getAnnotations());
        this.scan(CtRole.CAST, ctConstructorCall.getTypeCasts());
        this.scan(CtRole.EXECUTABLE_REF, ctConstructorCall.getExecutable());
        this.scan(CtRole.TARGET, (CtElement)ctConstructorCall.getTarget());
        this.scan(CtRole.ARGUMENT, ctConstructorCall.getArguments());
        this.scan(CtRole.COMMENT, ctConstructorCall.getComments());
        this.exit(ctConstructorCall);
    }

    @Override
    public <T> void visitCtNewClass(CtNewClass<T> newClass) {
        this.enter(newClass);
        this.scan(CtRole.ANNOTATION, newClass.getAnnotations());
        this.scan(CtRole.CAST, newClass.getTypeCasts());
        this.scan(CtRole.EXECUTABLE_REF, newClass.getExecutable());
        this.scan(CtRole.TARGET, (CtElement)newClass.getTarget());
        this.scan(CtRole.ARGUMENT, newClass.getArguments());
        this.scan(CtRole.NESTED_TYPE, newClass.getAnonymousClass());
        this.scan(CtRole.COMMENT, newClass.getComments());
        this.exit(newClass);
    }

    @Override
    public <T> void visitCtLambda(CtLambda<T> lambda) {
        this.enter(lambda);
        this.scan(CtRole.ANNOTATION, lambda.getAnnotations());
        this.scan(CtRole.TYPE, lambda.getType());
        this.scan(CtRole.CAST, lambda.getTypeCasts());
        this.scan(CtRole.PARAMETER, lambda.getParameters());
        this.scan(CtRole.BODY, lambda.getBody());
        this.scan(CtRole.EXPRESSION, lambda.getExpression());
        this.scan(CtRole.COMMENT, lambda.getComments());
        this.exit(lambda);
    }

    @Override
    public <T, E extends CtExpression<?>> void visitCtExecutableReferenceExpression(CtExecutableReferenceExpression<T, E> expression) {
        this.enter(expression);
        this.scan(CtRole.COMMENT, expression.getComments());
        this.scan(CtRole.ANNOTATION, expression.getAnnotations());
        this.scan(CtRole.TYPE, expression.getType());
        this.scan(CtRole.CAST, expression.getTypeCasts());
        this.scan(CtRole.EXECUTABLE_REF, expression.getExecutable());
        this.scan(CtRole.TARGET, (CtElement)expression.getTarget());
        this.exit(expression);
    }

    @Override
    public <T, A extends T> void visitCtOperatorAssignment(CtOperatorAssignment<T, A> assignment) {
        this.enter(assignment);
        this.scan(CtRole.ANNOTATION, assignment.getAnnotations());
        this.scan(CtRole.TYPE, assignment.getType());
        this.scan(CtRole.CAST, assignment.getTypeCasts());
        this.scan(CtRole.ASSIGNED, assignment.getAssigned());
        this.scan(CtRole.ASSIGNMENT, assignment.getAssignment());
        this.scan(CtRole.COMMENT, assignment.getComments());
        this.exit(assignment);
    }

    @Override
    public void visitCtPackage(CtPackage ctPackage) {
        this.enter(ctPackage);
        this.scan(CtRole.ANNOTATION, ctPackage.getAnnotations());
        this.scan(CtRole.SUB_PACKAGE, ctPackage.getPackages());
        this.scan(CtRole.CONTAINED_TYPE, ctPackage.getTypes());
        this.scan(CtRole.COMMENT, ctPackage.getComments());
        this.exit(ctPackage);
    }

    @Override
    public void visitCtPackageReference(CtPackageReference reference) {
        this.enter(reference);
        this.scan(CtRole.ANNOTATION, reference.getAnnotations());
        this.exit(reference);
    }

    @Override
    public <T> void visitCtParameter(CtParameter<T> parameter) {
        this.enter(parameter);
        this.scan(CtRole.ANNOTATION, parameter.getAnnotations());
        this.scan(CtRole.TYPE, parameter.getType());
        this.scan(CtRole.COMMENT, parameter.getComments());
        this.exit(parameter);
    }

    @Override
    public <T> void visitCtParameterReference(CtParameterReference<T> reference) {
        this.enter(reference);
        this.scan(CtRole.TYPE, reference.getType());
        this.scan(CtRole.ANNOTATION, reference.getAnnotations());
        this.exit(reference);
    }

    @Override
    public <R> void visitCtReturn(CtReturn<R> returnStatement) {
        this.enter(returnStatement);
        this.scan(CtRole.ANNOTATION, returnStatement.getAnnotations());
        this.scan(CtRole.EXPRESSION, returnStatement.getReturnedExpression());
        this.scan(CtRole.COMMENT, returnStatement.getComments());
        this.exit(returnStatement);
    }

    @Override
    public <R> void visitCtStatementList(CtStatementList statements) {
        this.enter(statements);
        this.scan(CtRole.ANNOTATION, statements.getAnnotations());
        this.scan(CtRole.STATEMENT, statements.getStatements());
        this.scan(CtRole.COMMENT, statements.getComments());
        this.exit(statements);
    }

    @Override
    public <S> void visitCtSwitch(CtSwitch<S> switchStatement) {
        this.enter(switchStatement);
        this.scan(CtRole.ANNOTATION, switchStatement.getAnnotations());
        this.scan(CtRole.EXPRESSION, switchStatement.getSelector());
        this.scan(CtRole.CASE, switchStatement.getCases());
        this.scan(CtRole.COMMENT, switchStatement.getComments());
        this.exit(switchStatement);
    }

    @Override
    public <T, S> void visitCtSwitchExpression(CtSwitchExpression<T, S> switchExpression) {
        this.enter(switchExpression);
        this.scan(CtRole.ANNOTATION, switchExpression.getAnnotations());
        this.scan(CtRole.EXPRESSION, switchExpression.getSelector());
        this.scan(CtRole.CASE, switchExpression.getCases());
        this.scan(CtRole.COMMENT, switchExpression.getComments());
        this.scan(CtRole.TYPE, switchExpression.getType());
        this.scan(CtRole.CAST, switchExpression.getTypeCasts());
        this.exit(switchExpression);
    }

    @Override
    public void visitCtSynchronized(CtSynchronized synchro) {
        this.enter(synchro);
        this.scan(CtRole.ANNOTATION, synchro.getAnnotations());
        this.scan(CtRole.EXPRESSION, synchro.getExpression());
        this.scan(CtRole.BODY, synchro.getBlock());
        this.scan(CtRole.COMMENT, synchro.getComments());
        this.exit(synchro);
    }

    @Override
    public void visitCtThrow(CtThrow throwStatement) {
        this.enter(throwStatement);
        this.scan(CtRole.ANNOTATION, throwStatement.getAnnotations());
        this.scan(CtRole.EXPRESSION, throwStatement.getThrownExpression());
        this.scan(CtRole.COMMENT, throwStatement.getComments());
        this.exit(throwStatement);
    }

    @Override
    public void visitCtTry(CtTry tryBlock) {
        this.enter(tryBlock);
        this.scan(CtRole.ANNOTATION, tryBlock.getAnnotations());
        this.scan(CtRole.BODY, tryBlock.getBody());
        this.scan(CtRole.CATCH, tryBlock.getCatchers());
        this.scan(CtRole.FINALIZER, tryBlock.getFinalizer());
        this.scan(CtRole.COMMENT, tryBlock.getComments());
        this.exit(tryBlock);
    }

    @Override
    public void visitCtTryWithResource(CtTryWithResource tryWithResource) {
        this.enter(tryWithResource);
        this.scan(CtRole.ANNOTATION, tryWithResource.getAnnotations());
        this.scan(CtRole.TRY_RESOURCE, tryWithResource.getResources());
        this.scan(CtRole.BODY, tryWithResource.getBody());
        this.scan(CtRole.CATCH, tryWithResource.getCatchers());
        this.scan(CtRole.FINALIZER, tryWithResource.getFinalizer());
        this.scan(CtRole.COMMENT, tryWithResource.getComments());
        this.exit(tryWithResource);
    }

    @Override
    public void visitCtTypeParameterReference(CtTypeParameterReference ref) {
        this.enter(ref);
        this.scan(CtRole.PACKAGE_REF, ref.getPackage());
        this.scan(CtRole.DECLARING_TYPE, ref.getDeclaringType());
        this.scan(CtRole.ANNOTATION, ref.getAnnotations());
        this.exit(ref);
    }

    @Override
    public void visitCtWildcardReference(CtWildcardReference wildcardReference) {
        this.enter(wildcardReference);
        this.scan(CtRole.PACKAGE_REF, wildcardReference.getPackage());
        this.scan(CtRole.DECLARING_TYPE, wildcardReference.getDeclaringType());
        this.scan(CtRole.ANNOTATION, wildcardReference.getAnnotations());
        this.scan(CtRole.BOUNDING_TYPE, wildcardReference.getBoundingType());
        this.exit(wildcardReference);
    }

    @Override
    public <T> void visitCtIntersectionTypeReference(CtIntersectionTypeReference<T> reference) {
        this.enter(reference);
        this.scan(CtRole.PACKAGE_REF, reference.getPackage());
        this.scan(CtRole.DECLARING_TYPE, reference.getDeclaringType());
        this.scan(CtRole.TYPE_ARGUMENT, reference.getActualTypeArguments());
        this.scan(CtRole.ANNOTATION, reference.getAnnotations());
        this.scan(CtRole.BOUND, reference.getBounds());
        this.exit(reference);
    }

    @Override
    public <T> void visitCtTypeReference(CtTypeReference<T> reference) {
        this.enter(reference);
        this.scan(CtRole.PACKAGE_REF, reference.getPackage());
        this.scan(CtRole.DECLARING_TYPE, reference.getDeclaringType());
        this.scan(CtRole.TYPE_ARGUMENT, reference.getActualTypeArguments());
        this.scan(CtRole.ANNOTATION, reference.getAnnotations());
        this.scan(CtRole.COMMENT, reference.getComments());
        this.exit(reference);
    }

    @Override
    public <T> void visitCtTypeAccess(CtTypeAccess<T> typeAccess) {
        this.enter(typeAccess);
        this.scan(CtRole.ANNOTATION, typeAccess.getAnnotations());
        this.scan(CtRole.CAST, typeAccess.getTypeCasts());
        this.scan(CtRole.ACCESSED_TYPE, typeAccess.getAccessedType());
        this.scan(CtRole.COMMENT, typeAccess.getComments());
        this.exit(typeAccess);
    }

    @Override
    public <T> void visitCtUnaryOperator(CtUnaryOperator<T> operator) {
        this.enter(operator);
        this.scan(CtRole.ANNOTATION, operator.getAnnotations());
        this.scan(CtRole.TYPE, operator.getType());
        this.scan(CtRole.CAST, operator.getTypeCasts());
        this.scan(CtRole.EXPRESSION, operator.getOperand());
        this.scan(CtRole.COMMENT, operator.getComments());
        this.exit(operator);
    }

    @Override
    public <T> void visitCtVariableRead(CtVariableRead<T> variableRead) {
        this.enter(variableRead);
        this.scan(CtRole.ANNOTATION, variableRead.getAnnotations());
        this.scan(CtRole.CAST, variableRead.getTypeCasts());
        this.scan(CtRole.VARIABLE, variableRead.getVariable());
        this.scan(CtRole.COMMENT, variableRead.getComments());
        this.exit(variableRead);
    }

    @Override
    public <T> void visitCtVariableWrite(CtVariableWrite<T> variableWrite) {
        this.enter(variableWrite);
        this.scan(CtRole.ANNOTATION, variableWrite.getAnnotations());
        this.scan(CtRole.CAST, variableWrite.getTypeCasts());
        this.scan(CtRole.VARIABLE, variableWrite.getVariable());
        this.scan(CtRole.COMMENT, variableWrite.getComments());
        this.exit(variableWrite);
    }

    @Override
    public void visitCtWhile(CtWhile whileLoop) {
        this.enter(whileLoop);
        this.scan(CtRole.ANNOTATION, whileLoop.getAnnotations());
        this.scan(CtRole.EXPRESSION, whileLoop.getLoopingExpression());
        this.scan(CtRole.BODY, whileLoop.getBody());
        this.scan(CtRole.COMMENT, whileLoop.getComments());
        this.exit(whileLoop);
    }

    @Override
    public <T> void visitCtCodeSnippetExpression(CtCodeSnippetExpression<T> expression) {
        this.enter(expression);
        this.scan(CtRole.TYPE, expression.getType());
        this.scan(CtRole.COMMENT, expression.getComments());
        this.scan(CtRole.ANNOTATION, expression.getAnnotations());
        this.scan(CtRole.CAST, expression.getTypeCasts());
        this.exit(expression);
    }

    @Override
    public void visitCtCodeSnippetStatement(CtCodeSnippetStatement statement) {
        this.enter(statement);
        this.scan(CtRole.COMMENT, statement.getComments());
        this.scan(CtRole.ANNOTATION, statement.getAnnotations());
        this.exit(statement);
    }

    @Override
    public <T> void visitCtUnboundVariableReference(CtUnboundVariableReference<T> reference) {
        this.enter(reference);
        this.scan(CtRole.TYPE, reference.getType());
        this.exit(reference);
    }

    @Override
    public <T> void visitCtFieldRead(CtFieldRead<T> fieldRead) {
        this.enter(fieldRead);
        this.scan(CtRole.ANNOTATION, fieldRead.getAnnotations());
        this.scan(CtRole.CAST, fieldRead.getTypeCasts());
        this.scan(CtRole.TARGET, (CtElement)fieldRead.getTarget());
        this.scan(CtRole.VARIABLE, fieldRead.getVariable());
        this.scan(CtRole.COMMENT, fieldRead.getComments());
        this.exit(fieldRead);
    }

    @Override
    public <T> void visitCtFieldWrite(CtFieldWrite<T> fieldWrite) {
        this.enter(fieldWrite);
        this.scan(CtRole.ANNOTATION, fieldWrite.getAnnotations());
        this.scan(CtRole.CAST, fieldWrite.getTypeCasts());
        this.scan(CtRole.TARGET, (CtElement)fieldWrite.getTarget());
        this.scan(CtRole.VARIABLE, fieldWrite.getVariable());
        this.scan(CtRole.COMMENT, fieldWrite.getComments());
        this.exit(fieldWrite);
    }

    @Override
    public <T> void visitCtSuperAccess(CtSuperAccess<T> f) {
        this.enter(f);
        this.scan(CtRole.COMMENT, f.getComments());
        this.scan(CtRole.ANNOTATION, f.getAnnotations());
        this.scan(CtRole.CAST, f.getTypeCasts());
        this.scan(CtRole.TARGET, (CtElement)f.getTarget());
        this.scan(CtRole.VARIABLE, f.getVariable());
        this.exit(f);
    }

    @Override
    public void visitCtComment(CtComment comment) {
        this.enter(comment);
        this.scan(CtRole.COMMENT, comment.getComments());
        this.scan(CtRole.ANNOTATION, comment.getAnnotations());
        this.exit(comment);
    }

    @Override
    public void visitCtJavaDoc(CtJavaDoc javaDoc) {
        this.enter(javaDoc);
        this.scan(CtRole.COMMENT, javaDoc.getComments());
        this.scan(CtRole.ANNOTATION, javaDoc.getAnnotations());
        this.scan(CtRole.COMMENT_TAG, javaDoc.getTags());
        this.exit(javaDoc);
    }

    @Override
    public void visitCtJavaDocTag(CtJavaDocTag docTag) {
        this.enter(docTag);
        this.scan(CtRole.COMMENT, docTag.getComments());
        this.scan(CtRole.ANNOTATION, docTag.getAnnotations());
        this.exit(docTag);
    }

    @Override
    public void visitCtImport(CtImport ctImport) {
        this.enter(ctImport);
        this.scan(CtRole.IMPORT_REFERENCE, ctImport.getReference());
        this.scan(CtRole.ANNOTATION, ctImport.getAnnotations());
        this.scan(CtRole.COMMENT, ctImport.getComments());
        this.exit(ctImport);
    }

    @Override
    public void visitCtModule(CtModule module) {
        this.enter(module);
        this.scan(CtRole.COMMENT, module.getComments());
        this.scan(CtRole.ANNOTATION, module.getAnnotations());
        this.scan(CtRole.MODULE_DIRECTIVE, module.getModuleDirectives());
        this.scan(CtRole.SUB_PACKAGE, module.getRootPackage());
        this.exit(module);
    }

    @Override
    public void visitCtModuleReference(CtModuleReference moduleReference) {
        this.enter(moduleReference);
        this.scan(CtRole.ANNOTATION, moduleReference.getAnnotations());
        this.exit(moduleReference);
    }

    @Override
    public void visitCtPackageExport(CtPackageExport moduleExport) {
        this.enter(moduleExport);
        this.scan(CtRole.COMMENT, moduleExport.getComments());
        this.scan(CtRole.PACKAGE_REF, moduleExport.getPackageReference());
        this.scan(CtRole.MODULE_REF, moduleExport.getTargetExport());
        this.scan(CtRole.ANNOTATION, moduleExport.getAnnotations());
        this.exit(moduleExport);
    }

    @Override
    public void visitCtModuleRequirement(CtModuleRequirement moduleRequirement) {
        this.enter(moduleRequirement);
        this.scan(CtRole.COMMENT, moduleRequirement.getComments());
        this.scan(CtRole.MODULE_REF, moduleRequirement.getModuleReference());
        this.scan(CtRole.ANNOTATION, moduleRequirement.getAnnotations());
        this.exit(moduleRequirement);
    }

    @Override
    public void visitCtProvidedService(CtProvidedService moduleProvidedService) {
        this.enter(moduleProvidedService);
        this.scan(CtRole.COMMENT, moduleProvidedService.getComments());
        this.scan(CtRole.SERVICE_TYPE, moduleProvidedService.getServiceType());
        this.scan(CtRole.IMPLEMENTATION_TYPE, moduleProvidedService.getImplementationTypes());
        this.scan(CtRole.ANNOTATION, moduleProvidedService.getAnnotations());
        this.exit(moduleProvidedService);
    }

    @Override
    public void visitCtUsedService(CtUsedService usedService) {
        this.enter(usedService);
        this.scan(CtRole.COMMENT, usedService.getComments());
        this.scan(CtRole.SERVICE_TYPE, usedService.getServiceType());
        this.scan(CtRole.ANNOTATION, usedService.getAnnotations());
        this.exit(usedService);
    }

    @Override
    public void visitCtCompilationUnit(CtCompilationUnit compilationUnit) {
        this.enter(compilationUnit);
        this.scan(CtRole.COMMENT, compilationUnit.getComments());
        this.scan(CtRole.ANNOTATION, compilationUnit.getAnnotations());
        this.scan(CtRole.PACKAGE_DECLARATION, compilationUnit.getPackageDeclaration());
        this.scan(CtRole.DECLARED_IMPORT, compilationUnit.getImports());
        this.scan(CtRole.DECLARED_MODULE_REF, compilationUnit.getDeclaredModuleReference());
        this.scan(CtRole.DECLARED_TYPE_REF, compilationUnit.getDeclaredTypeReferences());
        this.exit(compilationUnit);
    }

    @Override
    public void visitCtPackageDeclaration(CtPackageDeclaration packageDeclaration) {
        this.enter(packageDeclaration);
        this.scan(CtRole.COMMENT, packageDeclaration.getComments());
        this.scan(CtRole.ANNOTATION, packageDeclaration.getAnnotations());
        this.scan(CtRole.PACKAGE_REF, packageDeclaration.getReference());
        this.exit(packageDeclaration);
    }

    @Override
    public void visitCtTypeMemberWildcardImportReference(CtTypeMemberWildcardImportReference wildcardReference) {
        this.enter(wildcardReference);
        this.scan(CtRole.TYPE_REF, wildcardReference.getTypeReference());
        this.exit(wildcardReference);
    }

    @Override
    public void visitCtYieldStatement(CtYieldStatement statement) {
        this.enter(statement);
        this.scan(CtRole.ANNOTATION, statement.getAnnotations());
        this.scan(CtRole.EXPRESSION, statement.getExpression());
        this.scan(CtRole.COMMENT, statement.getComments());
        this.exit(statement);
    }
}

