/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import spoon.SpoonException;
import spoon.experimental.CtUnresolvedImport;
import spoon.javadoc.internal.JavadocDescriptionElement;
import spoon.javadoc.internal.JavadocInlineTag;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtJavaDoc;
import spoon.reflect.code.CtJavaDocTag;
import spoon.reflect.code.CtTargetedExpression;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.declaration.CtCompilationUnit;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtImport;
import spoon.reflect.declaration.CtImportKind;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeInformation;
import spoon.reflect.factory.Factory;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeMemberWildcardImportReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtAbstractImportVisitor;
import spoon.reflect.visitor.EarlyTerminatingScanner;
import spoon.reflect.visitor.ImportAnalyzer;
import spoon.reflect.visitor.filter.TypeFilter;
import spoon.support.Experimental;
import spoon.support.util.ModelList;
import spoon.support.visitor.ClassTypingContext;

@Experimental
public class ImportCleaner
extends ImportAnalyzer<Context> {
    private Comparator<CtImport> importComparator;
    private boolean canAddImports = true;
    private boolean canRemoveImports = true;

    @Override
    protected ImportCleanerScanner createScanner() {
        return new ImportCleanerScanner();
    }

    @Override
    protected Context getScannerContextInformation() {
        return ((ImportCleanerScanner)this.scanner).context;
    }

    @Override
    protected void handleTargetedExpression(CtTargetedExpression<?, ?> targetedExpression, Context context) {
        if (context == null) {
            return;
        }
        Object target = targetedExpression.getTarget();
        if (target == null) {
            if (targetedExpression instanceof CtFieldAccess && ((CtFieldAccess)targetedExpression).getVariable().getDeclaringType() != null && ((CtFieldAccess)targetedExpression).getVariable().getDeclaringType().isSimplyQualified()) {
                context.addImport(((CtFieldAccess)targetedExpression).getVariable().getDeclaringType());
            }
            return;
        }
        if (target != null && target.isImplicit()) {
            if (target instanceof CtTypeAccess) {
                CtExecutableReference execRef;
                if (targetedExpression instanceof CtFieldAccess) {
                    context.addImport(((CtFieldAccess)targetedExpression).getVariable());
                } else if (targetedExpression instanceof CtInvocation && (execRef = ((CtInvocation)targetedExpression).getExecutable()).isStatic()) {
                    context.addImport(execRef);
                }
            } else if (targetedExpression instanceof CtInvocation) {
                CtInvocation invocation = (CtInvocation)targetedExpression;
                if (invocation.getExecutable().isStatic()) {
                    context.addImport(invocation.getExecutable());
                }
            } else if (targetedExpression instanceof CtFieldAccess) {
                CtFieldAccess fieldAccess = (CtFieldAccess)targetedExpression;
                if (fieldAccess.getVariable().isStatic()) {
                    context.addImport(fieldAccess.getVariable());
                }
            } else {
                throw new SpoonException("don't know how to handle: " + targetedExpression.toStringDebug());
            }
        }
    }

    @Override
    protected void handleTypeReference(CtTypeReference<?> reference, Context context, CtRole role) {
        if (context == null) {
            return;
        }
        if (!reference.isImplicit() && reference.isSimplyQualified()) {
            context.addImport(reference);
        }
    }

    private static String getImportRefID(CtReference ref) {
        if (ref == null) {
            throw new SpoonException("Null import refrence");
        }
        if (ref instanceof CtFieldReference) {
            CtFieldReference fieldRef = (CtFieldReference)ref;
            return fieldRef.getDeclaringType().getQualifiedName() + "." + fieldRef.getSimpleName();
        }
        if (ref instanceof CtExecutableReference) {
            CtExecutableReference execRef = (CtExecutableReference)ref;
            return execRef.getDeclaringType().getQualifiedName() + "." + execRef.getSimpleName();
        }
        if (ref instanceof CtTypeMemberWildcardImportReference) {
            CtTypeMemberWildcardImportReference wildRef = (CtTypeMemberWildcardImportReference)ref;
            return wildRef.getTypeReference().getQualifiedName() + ".*";
        }
        if (ref instanceof CtTypeReference) {
            CtTypeReference typeRef = (CtTypeReference)ref;
            return typeRef.getQualifiedName();
        }
        throw new SpoonException("Unexpected import type: " + ref.getClass());
    }

    private boolean removeAllTypeImportWithPackage(Set<CtImport> imports, String packageName) {
        boolean found = false;
        Iterator<CtImport> iter = imports.iterator();
        while (iter.hasNext()) {
            CtTypeReference typeRef;
            CtImport newImport = iter.next();
            if (newImport.getImportKind() != CtImportKind.TYPE || (typeRef = (CtTypeReference)newImport.getReference()).getPackage() == null || !packageName.equals(typeRef.getPackage().getQualifiedName())) continue;
            found = true;
            if (!this.canRemoveImports) continue;
            iter.remove();
        }
        return found;
    }

    private boolean removeAllStaticTypeMembersImportWithType(Set<CtImport> imports, CtTypeReference<?> typeRef) {
        final ClassTypingContext contextOfTypeRef = new ClassTypingContext(typeRef);
        final Iterator<CtImport> iter = imports.iterator();
        class Visitor
        extends CtAbstractImportVisitor {
            boolean found = false;

            Visitor() {
            }

            @Override
            public <T> void visitFieldImport(CtFieldReference<T> fieldReference) {
                this.checkType(fieldReference.getDeclaringType());
            }

            @Override
            public <T> void visitMethodImport(CtExecutableReference<T> executableReference) {
                this.checkType(executableReference.getDeclaringType());
            }

            void checkType(CtTypeReference<?> importTypeRef) {
                if (contextOfTypeRef.isSubtypeOf(importTypeRef)) {
                    this.found = true;
                    if (ImportCleaner.this.canRemoveImports) {
                        iter.remove();
                    }
                }
            }
        }
        Visitor visitor = new Visitor();
        while (iter.hasNext()) {
            iter.next().accept(visitor);
        }
        return visitor.found;
    }

    public boolean isCanAddImports() {
        return this.canAddImports;
    }

    public ImportCleaner setCanAddImports(boolean canAddImports) {
        this.canAddImports = canAddImports;
        return this;
    }

    public boolean isCanRemoveImports() {
        return this.canRemoveImports;
    }

    public ImportCleaner setCanRemoveImports(boolean canRemoveImports) {
        this.canRemoveImports = canRemoveImports;
        return this;
    }

    public Comparator<CtImport> getImportComparator() {
        return this.importComparator;
    }

    public ImportCleaner setImportComparator(Comparator<CtImport> importComparator) {
        this.importComparator = importComparator;
        return this;
    }

    public class ImportCleanerScanner
    extends EarlyTerminatingScanner<Void> {
        Context context;

        @Override
        protected void enter(CtElement e) {
            if (e instanceof CtCompilationUnit) {
                this.context = new Context((CtCompilationUnit)e);
            }
        }

        @Override
        protected void exit(CtElement e) {
            if (e instanceof CtCompilationUnit) {
                this.context.onCompilationUnitProcessed((CtCompilationUnit)e);
            }
        }
    }

    public class Context {
        private CtCompilationUnit compilationUnit;
        private Map<String, CtImport> computedImports;
        private String packageQName;
        private Set<String> typeRefQNames;

        Context(CtCompilationUnit cu) {
            this.compilationUnit = cu;
            CtPackage pckg = cu.getDeclaredPackage();
            if (pckg != null) {
                this.packageQName = pckg.getReference().getQualifiedName();
            }
            this.typeRefQNames = cu.getDeclaredTypeReferences().stream().map(CtTypeInformation::getQualifiedName).collect(Collectors.toSet());
            this.computedImports = new HashMap<String, CtImport>();
        }

        Factory getFactory() {
            return this.compilationUnit.getFactory();
        }

        void addImport(CtReference ref) {
            CtTypeReference typeRef;
            if (ref == null) {
                return;
            }
            if (ref instanceof CtExecutableReference) {
                typeRef = ((CtExecutableReference)ref).getDeclaringType();
            } else if (ref instanceof CtFieldReference) {
                typeRef = ((CtFieldReference)ref).getDeclaringType();
            } else if (ref instanceof CtTypeReference) {
                typeRef = (CtTypeReference)ref;
            } else {
                throw new SpoonException("Unexpected reference type " + ref.getClass());
            }
            if (typeRef == null) {
                return;
            }
            CtTypeReference<?> topLevelTypeRef = typeRef.getTopLevelType();
            if (this.typeRefQNames.contains(topLevelTypeRef.getQualifiedName())) {
                return;
            }
            CtPackageReference packageRef = topLevelTypeRef.getPackage();
            if (packageRef == null) {
                return;
            }
            if ("java.lang".equals(packageRef.getQualifiedName())) {
                return;
            }
            if (Objects.equals(this.packageQName, packageRef.getQualifiedName())) {
                return;
            }
            String importRefID = ImportCleaner.getImportRefID(ref);
            if (!this.computedImports.containsKey(importRefID)) {
                this.computedImports.put(importRefID, this.getFactory().Type().createImport(ref));
            }
        }

        void onCompilationUnitProcessed(CtCompilationUnit compilationUnit) {
            ModelList<CtImport> existingImports = compilationUnit.getImports();
            HashSet<CtImport> computedImports = new HashSet<CtImport>(this.computedImports.values());
            block0: for (CtImport oldImport : new ArrayList<CtImport>(existingImports)) {
                if (computedImports.remove(oldImport)) continue;
                for (CtType<?> type : compilationUnit.getDeclaredTypes()) {
                    for (CtJavaDoc element : type.getElements(new TypeFilter<CtJavaDoc>(CtJavaDoc.class))) {
                        for (CtJavaDocTag tag : element.getTags()) {
                            if (oldImport.getReference() == null || !oldImport.getReference().getSimpleName().equals(tag.getParam())) continue;
                            continue block0;
                        }
                        for (JavadocDescriptionElement part : element.getJavadocElements()) {
                            if (!(part instanceof JavadocInlineTag)) continue;
                            String content = ((JavadocInlineTag)part).getContent();
                            if (oldImport.getReference() == null || !oldImport.getReference().getSimpleName().equals(content)) continue;
                            continue block0;
                        }
                    }
                }
                if (oldImport.getImportKind() == CtImportKind.ALL_TYPES && ImportCleaner.this.removeAllTypeImportWithPackage(computedImports, ((CtPackageReference)oldImport.getReference()).getQualifiedName()) || oldImport.getImportKind() == CtImportKind.ALL_STATIC_MEMBERS && ImportCleaner.this.removeAllStaticTypeMembersImportWithType(computedImports, ((CtTypeMemberWildcardImportReference)oldImport.getReference()).getTypeReference()) || !ImportCleaner.this.canRemoveImports || oldImport instanceof CtUnresolvedImport) continue;
                existingImports.remove(oldImport);
            }
            if (ImportCleaner.this.canAddImports) {
                existingImports.addAll(computedImports);
            }
            if (ImportCleaner.this.importComparator != null) {
                existingImports.set(existingImports.stream().sorted(ImportCleaner.this.importComparator).collect(Collectors.toList()));
            }
        }
    }
}

