/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor;

import java.util.ArrayDeque;
import java.util.Deque;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtStatement;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtType;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CacheBasedConflictFinder;

public class PrintingContext {
    private long NEXT_FOR_VARIABLE = 1L;
    private long IGNORE_GENERICS = 2L;
    private long SKIP_ARRAY = 4L;
    private long IGNORE_STATIC_ACCESS = 8L;
    private long IGNORE_ENCLOSING_CLASS = 16L;
    private long FORCE_WILDCARD_GENERICS = 32L;
    private long FIRST_FOR_VARIABLE = 64L;
    private long state;
    private CtStatement statement;
    Deque<CacheBasedConflictFinder> currentThis = new ArrayDeque<CacheBasedConflictFinder>();
    Deque<CtElement> elementStack = new ArrayDeque<CtElement>();
    Deque<CtExpression<?>> parenthesedExpression = new ArrayDeque();
    CtType<?> currentTopLevel;

    public boolean isFirstForVariable() {
        return (this.state & this.FIRST_FOR_VARIABLE) != 0L;
    }

    public boolean isNextForVariable() {
        return (this.state & this.NEXT_FOR_VARIABLE) != 0L;
    }

    public boolean ignoreGenerics() {
        return (this.state & this.IGNORE_GENERICS) != 0L;
    }

    public boolean skipArray() {
        return (this.state & this.SKIP_ARRAY) != 0L;
    }

    public boolean ignoreStaticAccess() {
        return (this.state & this.IGNORE_STATIC_ACCESS) != 0L;
    }

    public boolean ignoreEnclosingClass() {
        return (this.state & this.IGNORE_ENCLOSING_CLASS) != 0L;
    }

    public boolean forceWildcardGenerics() {
        return (this.state & this.FORCE_WILDCARD_GENERICS) != 0L;
    }

    public boolean isStatement(CtStatement stmt) {
        return this.statement == stmt;
    }

    public Writable modify() {
        return new Writable();
    }

    public CtTypeReference<?> getCurrentTypeReference() {
        if (this.currentTopLevel != null) {
            CacheBasedConflictFinder tc = this.getCurrentTypeContext();
            if (tc != null) {
                return tc.typeRef;
            }
            return this.currentTopLevel.getReference();
        }
        return null;
    }

    private CacheBasedConflictFinder getCurrentTypeContext() {
        if (this.currentThis != null && !this.currentThis.isEmpty()) {
            return this.currentThis.peek();
        }
        return null;
    }

    public void pushCurrentThis(CtType<?> type) {
        this.currentThis.push(new CacheBasedConflictFinder(type));
    }

    public void popCurrentThis() {
        this.currentThis.pop();
    }

    public String toString() {
        return "context.ignoreGenerics: " + this.ignoreGenerics() + "\n";
    }

    public boolean isInCurrentScope(CtTypeReference<?> typeRef) {
        CtTypeReference<?> currentTypeRef = this.getCurrentTypeReference();
        return typeRef.equals(currentTypeRef);
    }

    public class Writable
    implements AutoCloseable {
        private long oldState;
        private CtStatement oldStatement;

        protected Writable() {
            this.oldState = PrintingContext.this.state;
            this.oldStatement = PrintingContext.this.statement;
        }

        @Override
        public void close() {
            PrintingContext.this.state = this.oldState;
            PrintingContext.this.statement = this.oldStatement;
        }

        public <T extends Writable> T isFirstForVariable(boolean v) {
            this.setState(PrintingContext.this.FIRST_FOR_VARIABLE, v);
            return (T)this;
        }

        public <T extends Writable> T isNextForVariable(boolean v) {
            this.setState(PrintingContext.this.NEXT_FOR_VARIABLE, v);
            return (T)this;
        }

        public <T extends Writable> T ignoreGenerics(boolean v) {
            this.setState(PrintingContext.this.IGNORE_GENERICS, v);
            return (T)this;
        }

        public <T extends Writable> T skipArray(boolean v) {
            this.setState(PrintingContext.this.SKIP_ARRAY, v);
            return (T)this;
        }

        public <T extends Writable> T ignoreStaticAccess(boolean v) {
            this.setState(PrintingContext.this.IGNORE_STATIC_ACCESS, v);
            return (T)this;
        }

        public <T extends Writable> T ignoreEnclosingClass(boolean v) {
            this.setState(PrintingContext.this.IGNORE_ENCLOSING_CLASS, v);
            return (T)this;
        }

        public <T extends Writable> T forceWildcardGenerics(boolean v) {
            this.setState(PrintingContext.this.FORCE_WILDCARD_GENERICS, v);
            return (T)this;
        }

        public <T extends Writable> T setStatement(CtStatement stmt) {
            PrintingContext.this.statement = stmt;
            return (T)this;
        }

        private void setState(long mask, boolean v) {
            PrintingContext.this.state = v ? PrintingContext.this.state | mask : PrintingContext.this.state & (mask ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }
}

