/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor.filter;

import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import spoon.SpoonException;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeMember;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.Filter;

public class ExecutableReferenceFilter
implements Filter<CtExecutableReference<?>> {
    private Map<CtExecutable<?>, CtExecutable<?>> executables = new IdentityHashMap();
    private Set<String> typeQualifiedNames = new HashSet<String>();
    private Set<String> methodNames = new HashSet<String>();

    public ExecutableReferenceFilter() {
    }

    public ExecutableReferenceFilter(CtExecutable<?> executable) {
        this.addExecutable(executable);
    }

    public ExecutableReferenceFilter addExecutable(CtExecutable<?> executable) {
        this.executables.put(executable, executable);
        if (executable instanceof CtTypeMember) {
            CtType<?> declType = ((CtTypeMember)((Object)executable)).getDeclaringType();
            if (declType == null) {
                throw new SpoonException("Cannot search for executable reference, which has no declaring type");
            }
            this.typeQualifiedNames.add(declType.getQualifiedName());
            if (executable instanceof CtMethod) {
                this.methodNames.add(((CtMethod)executable).getSimpleName());
            }
        }
        return this;
    }

    @Override
    public boolean matches(CtExecutableReference<?> execRef) {
        if (execRef.getSimpleName().startsWith("lambda$")) {
            return this.executables.containsKey(execRef.getDeclaration());
        }
        CtTypeReference<?> declaringType = execRef.getDeclaringType();
        if (declaringType != null && this.typeQualifiedNames.contains(declaringType.getQualifiedName()) && ("<init>".equals(execRef.getSimpleName()) || this.methodNames.contains(execRef.getSimpleName()))) {
            return this.executables.containsKey(execRef.getDeclaration());
        }
        return false;
    }
}

