/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor.filter;

import spoon.SpoonException;
import spoon.reflect.code.CtCatchVariable;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.reference.CtLocalVariableReference;
import spoon.reflect.reference.CtVariableReference;
import spoon.reflect.visitor.CtAbstractVisitor;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.chain.CtConsumableFunction;
import spoon.reflect.visitor.chain.CtConsumer;
import spoon.reflect.visitor.chain.CtQuery;
import spoon.reflect.visitor.chain.CtScannerListener;
import spoon.reflect.visitor.chain.ScanningMode;
import spoon.reflect.visitor.filter.CatchVariableScopeFunction;
import spoon.reflect.visitor.filter.CtScannerFunction;
import spoon.reflect.visitor.filter.LocalVariableScopeFunction;
import spoon.reflect.visitor.filter.ParameterScopeFunction;
import spoon.reflect.visitor.filter.ParentFunction;

public class LocalVariableReferenceFunction
implements CtConsumableFunction<CtElement> {
    final CtVariable<?> targetVariable;
    final Class<?> variableClass;
    final Class<?> variableReferenceClass;

    public LocalVariableReferenceFunction() {
        this(CtLocalVariable.class, CtLocalVariableReference.class);
    }

    public LocalVariableReferenceFunction(CtLocalVariable<?> localVariable) {
        this(CtLocalVariable.class, CtLocalVariableReference.class, localVariable);
    }

    LocalVariableReferenceFunction(Class<?> variableClass, Class<?> variableReferenceClass) {
        this.variableClass = variableClass;
        this.variableReferenceClass = variableReferenceClass;
        this.targetVariable = null;
    }

    LocalVariableReferenceFunction(Class<?> variableClass, Class<?> variableReferenceClass, CtVariable<?> variable) {
        this.variableClass = variableClass;
        this.variableReferenceClass = variableReferenceClass;
        this.targetVariable = variable;
    }

    @Override
    public void apply(CtElement scope, CtConsumer<Object> outputConsumer) {
        CtQuery scopeQuery;
        CtVariable var = this.targetVariable;
        if (var == null) {
            if (this.variableClass.isInstance(scope)) {
                var = (CtVariable)scope;
            } else {
                throw new SpoonException("The input of " + this.getClass().getSimpleName() + " must be a " + this.variableClass.getSimpleName() + " but is " + scope.getClass().getSimpleName());
            }
        }
        final CtVariable variable = var;
        final String simpleName = variable.getSimpleName();
        final Context context = new Context();
        if (scope == variable) {
            scopeQuery = this.createScopeQuery(variable, scope, context);
        } else {
            final CtElement variableParent = variable.getParent();
            if (scope.map(new ParentFunction()).select(new Filter<CtElement>(){

                @Override
                public boolean matches(CtElement element) {
                    if (element instanceof CtType) {
                        ++context.nrTypes;
                    }
                    return variableParent == element;
                }
            }).first() == null) {
                throw new SpoonException("Cannot search for references of variable in wrong scope.");
            }
            scopeQuery = scope.map(new CtScannerFunction().setListener(context));
        }
        scopeQuery.select(new Filter<CtElement>(){

            @Override
            public boolean matches(CtElement element) {
                CtVariableReference varRef;
                if (LocalVariableReferenceFunction.this.variableReferenceClass.isInstance(element) && simpleName.equals((varRef = (CtVariableReference)element).getSimpleName())) {
                    if (context.hasLocalType()) {
                        return variable == varRef.getDeclaration();
                    }
                    return true;
                }
                return false;
            }
        }).forEach(outputConsumer);
    }

    private CtQuery createScopeQuery(CtVariable<?> variable, CtElement scope, Context context) {
        QueryCreator qc = new QueryCreator(scope, context);
        variable.accept(qc);
        if (qc.query == null) {
            throw new SpoonException("Unexpected type of variable: " + variable.getClass().getName());
        }
        return qc.query;
    }

    private static final class QueryCreator
    extends CtAbstractVisitor {
        CtElement scope;
        CtScannerListener listener;
        CtQuery query;

        QueryCreator(CtElement scope, CtScannerListener listener) {
            this.scope = scope;
            this.listener = listener;
        }

        @Override
        public <T> void visitCtLocalVariable(CtLocalVariable<T> localVariable) {
            this.query = this.scope.map(new LocalVariableScopeFunction(this.listener));
        }

        @Override
        public <T> void visitCtCatchVariable(CtCatchVariable<T> catchVariable) {
            this.query = this.scope.map(new CatchVariableScopeFunction(this.listener));
        }

        @Override
        public <T> void visitCtParameter(CtParameter<T> parameter) {
            this.query = this.scope.map(new ParameterScopeFunction(this.listener));
        }
    }

    private static class Context
    implements CtScannerListener {
        int nrTypes = 0;

        private Context() {
        }

        @Override
        public ScanningMode enter(CtElement element) {
            if (element instanceof CtType) {
                ++this.nrTypes;
            }
            return ScanningMode.NORMAL;
        }

        @Override
        public void exit(CtElement element) {
            if (element instanceof CtType) {
                --this.nrTypes;
            }
        }

        boolean hasLocalType() {
            return this.nrTypes > 0;
        }
    }
}

