/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor.filter;

import spoon.reflect.code.CtBodyHolder;
import spoon.reflect.code.CtCatch;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtModifiable;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.visitor.chain.CtConsumableFunction;
import spoon.reflect.visitor.chain.CtConsumer;
import spoon.reflect.visitor.chain.CtQuery;
import spoon.reflect.visitor.chain.CtQueryAware;
import spoon.reflect.visitor.filter.AllTypeMembersFunction;
import spoon.reflect.visitor.filter.NamedElementFilter;
import spoon.reflect.visitor.filter.SiblingsFunction;
import spoon.reflect.visitor.filter.TypeFilter;

public class PotentialVariableDeclarationFunction
implements CtConsumableFunction<CtElement>,
CtQueryAware {
    private boolean isTypeOnTheWay;
    private final String variableName;
    private CtQuery query;
    private boolean isInStaticScope;

    public PotentialVariableDeclarationFunction() {
        this.variableName = null;
    }

    public PotentialVariableDeclarationFunction(String variableName) {
        this.variableName = variableName;
    }

    @Override
    public void apply(CtElement input, CtConsumer<Object> outputConsumer) {
        this.isTypeOnTheWay = false;
        this.isInStaticScope = false;
        CtQuery siblingsQuery = input.getFactory().createQuery().map(new SiblingsFunction().mode(SiblingsFunction.Mode.PREVIOUS)).select(new TypeFilter<CtVariable>(CtVariable.class));
        if (this.variableName != null) {
            siblingsQuery = siblingsQuery.select(new NamedElementFilter<CtNamedElement>(CtNamedElement.class, this.variableName));
        }
        CtElement scopeElement = input;
        while (scopeElement != null && !(scopeElement instanceof CtPackage) && scopeElement.isParentInitialized()) {
            CtElement parent = scopeElement.getParent();
            if (parent instanceof CtType) {
                this.isTypeOnTheWay = true;
                CtQuery q = parent.map(new AllTypeMembersFunction(CtField.class));
                q.forEach(field -> {
                    if (this.isInStaticScope && !field.hasModifier(ModifierKind.STATIC)) {
                        return;
                    }
                    if (this.sendToOutput((CtVariable<?>)field, outputConsumer)) {
                        q.terminate();
                    }
                });
                if (this.query.isTerminated()) {
                    return;
                }
            } else if (parent instanceof CtBodyHolder || parent instanceof CtStatementList) {
                siblingsQuery.setInput(scopeElement).forEach(outputConsumer);
                if (this.query.isTerminated()) {
                    return;
                }
                if (parent instanceof CtCatch) {
                    CtCatch ctCatch = (CtCatch)parent;
                    if (this.sendToOutput(ctCatch.getParameter(), outputConsumer)) {
                        return;
                    }
                } else if (parent instanceof CtExecutable) {
                    CtExecutable exec = (CtExecutable)parent;
                    for (CtParameter<?> param : exec.getParameters()) {
                        if (!this.sendToOutput(param, outputConsumer)) continue;
                        return;
                    }
                }
            }
            if (parent instanceof CtModifiable) {
                this.isInStaticScope = this.isInStaticScope || ((CtModifiable)parent).hasModifier(ModifierKind.STATIC);
            }
            scopeElement = parent;
        }
    }

    private boolean sendToOutput(CtVariable<?> var, CtConsumer<Object> output) {
        if (this.variableName == null || this.variableName.equals(var.getSimpleName())) {
            output.accept(var);
        }
        return this.query.isTerminated();
    }

    public boolean isTypeOnTheWay() {
        return this.isTypeOnTheWay;
    }

    @Override
    public void setQuery(CtQuery query) {
        this.query = query;
    }
}

