/*
 * Decompiled with CFR 0.152.
 */
package spoon.support;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import spoon.Launcher;
import spoon.SpoonException;
import spoon.compiler.Environment;
import spoon.processing.AbstractProcessor;
import spoon.processing.FileGenerator;
import spoon.processing.TraversalStrategy;
import spoon.reflect.cu.CompilationUnit;
import spoon.reflect.declaration.CtModule;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtType;
import spoon.reflect.visitor.PrettyPrinter;
import spoon.support.compiler.SpoonProgress;

public class JavaOutputProcessor
extends AbstractProcessor<CtNamedElement>
implements FileGenerator<CtNamedElement> {
    PrettyPrinter printer;
    List<File> printedFiles = new ArrayList<File>();
    Map<String, Map<Integer, Integer>> lineNumberMappings = new HashMap<String, Map<Integer, Integer>>();

    public JavaOutputProcessor(PrettyPrinter printer) {
        this.printer = printer;
    }

    public JavaOutputProcessor() {
    }

    @Override
    public Environment getEnvironment() {
        return this.getFactory().getEnvironment();
    }

    public PrettyPrinter getPrinter() {
        if (this.printer == null) {
            return this.getFactory().getEnvironment().createPrettyPrinter();
        }
        return this.printer;
    }

    @Override
    public List<File> getCreatedFiles() {
        return this.printedFiles;
    }

    @Override
    public File getOutputDirectory() {
        return this.getEnvironment().getSourceOutputDirectory();
    }

    @Override
    public void init() {
        File directory = this.getOutputDirectory();
        if (directory == null) {
            throw new SpoonException("You should set output directory before printing");
        }
        if (!directory.exists() && !directory.mkdirs()) {
            throw new SpoonException("Error creating output directory");
        }
    }

    public void createJavaFile(CtType<?> element) {
        Path typePath = this.getElementPath(element);
        if (!element.isTopLevel()) {
            throw new IllegalArgumentException();
        }
        CompilationUnit cu = this.getFactory().CompilationUnit().getOrCreate(element);
        ArrayList toBePrinted = new ArrayList();
        toBePrinted.add(element);
        PrettyPrinter printer = this.getPrinter();
        printer.calculate(cu, toBePrinted);
        try {
            File file = typePath.toFile();
            file.createNewFile();
            if (!this.printedFiles.contains(file)) {
                this.printedFiles.add(file);
            }
            try (PrintStream stream = new PrintStream(file);){
                stream.print(printer.getResult());
                for (CtType ctType : toBePrinted) {
                    this.lineNumberMappings.put(ctType.getQualifiedName(), printer.getLineNumberMapping());
                }
            }
        }
        catch (IOException e) {
            Launcher.LOGGER.error(e.getMessage(), (Throwable)e);
        }
        if (this.getEnvironment().getSpoonProgress() != null) {
            this.getEnvironment().getSpoonProgress().step(SpoonProgress.Process.PRINT, element.getQualifiedName());
        }
    }

    @Override
    public boolean isToBeProcessed(CtNamedElement candidate) {
        return candidate instanceof CtType || candidate instanceof CtModule || candidate instanceof CtPackage && (!candidate.getComments().isEmpty() || !candidate.getAnnotations().isEmpty());
    }

    @Override
    public void process(CtNamedElement nameElement) {
        if (nameElement instanceof CtType && ((CtType)nameElement).isTopLevel()) {
            this.createJavaFile((CtType)nameElement);
        } else if (nameElement instanceof CtPackage) {
            this.createPackageFile((CtPackage)nameElement);
        } else if (nameElement instanceof CtModule) {
            this.createModuleFile((CtModule)nameElement);
        }
    }

    private void createPackageFile(CtPackage pack) {
        File packageAnnot = this.getElementPath(pack).toFile();
        if (!this.printedFiles.contains(packageAnnot)) {
            this.printedFiles.add(packageAnnot);
        }
        try (PrintStream stream = new PrintStream(packageAnnot);){
            stream.println(this.getPrinter().printPackageInfo(pack));
        }
        catch (FileNotFoundException e) {
            Launcher.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private void createModuleFile(CtModule module) {
        if (this.getEnvironment().getComplianceLevel() > 8 && module != this.getFactory().getModel().getUnnamedModule()) {
            File moduleFile = this.getElementPath(module).toFile();
            if (!this.printedFiles.contains(moduleFile)) {
                this.printedFiles.add(moduleFile);
            }
            try (PrintStream stream = new PrintStream(moduleFile);){
                stream.println(this.getPrinter().printModuleInfo(module));
            }
            catch (FileNotFoundException e) {
                Launcher.LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private Path getElementPath(CtModule type) {
        return this.createFolders(this.getEnvironment().getOutputDestinationHandler().getOutputPath(type, null, null));
    }

    private Path getElementPath(CtPackage type) {
        return this.createFolders(this.getEnvironment().getOutputDestinationHandler().getOutputPath(type.getDeclaringModule(), type, null));
    }

    private Path getElementPath(CtType type) {
        return this.createFolders(this.getEnvironment().getOutputDestinationHandler().getOutputPath(type.getPackage().getDeclaringModule(), type.getPackage(), type));
    }

    private Path createFolders(Path outputPath) {
        if (!outputPath.getParent().toFile().exists() && !outputPath.getParent().toFile().mkdirs()) {
            throw new RuntimeException("Error creating output directory");
        }
        return outputPath;
    }

    public Map<String, Map<Integer, Integer>> getLineNumberMappings() {
        return this.lineNumberMappings;
    }

    @Override
    public TraversalStrategy getTraversalStrategy() {
        return TraversalStrategy.PRE_ORDER;
    }
}

