/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.compiler.jdt;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.output.NullOutputStream;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.CompilationProgress;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.batch.Main;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.core.util.CommentRecorderParser;
import spoon.SpoonException;
import spoon.support.compiler.SpoonProgress;
import spoon.support.compiler.jdt.JDTBasedSpoonCompiler;
import spoon.support.compiler.jdt.JDTConstants;
import spoon.support.compiler.jdt.TreeBuilderCompiler;

public class JDTBatchCompiler
extends Main {
    protected final JDTBasedSpoonCompiler jdtCompiler;
    protected CompilationUnit[] compilationUnits;
    protected Set<String> filesToBeIgnored = new HashSet<String>();

    public JDTBatchCompiler(JDTBasedSpoonCompiler jdtCompiler) {
        this(jdtCompiler, new NullOutputStream(), new NullOutputStream());
    }

    JDTBatchCompiler(JDTBasedSpoonCompiler jdtCompiler, OutputStream outWriter, OutputStream errWriter) {
        super(new PrintWriter(outWriter), new PrintWriter(errWriter), false, null, null);
        this.jdtCompiler = jdtCompiler;
        if (jdtCompiler != null) {
            this.jdtCompiler.probs.clear();
        }
    }

    @Override
    public CompilationUnit[] getCompilationUnits() {
        HashMap<String, char[]> pathToModName = new HashMap<String, char[]>();
        for (int round = 0; round < 2; ++round) {
            block1: for (CompilationUnit compilationUnit : this.compilationUnits) {
                char[] charName = compilationUnit.getFileName();
                boolean isModuleInfo = CharOperation.endsWith(charName, JDTConstants.MODULE_INFO_FILE_NAME);
                if (isModuleInfo != (round == 0)) continue;
                String fileName = new String(charName);
                if (isModuleInfo) {
                    int lastSlash = CharOperation.lastIndexOf(File.separatorChar, charName);
                    if (lastSlash == -1) continue;
                    char[] modulePath = CharOperation.subarray(charName, 0, lastSlash);
                    lastSlash = (lastSlash = CharOperation.lastIndexOf(File.separatorChar, modulePath)) == -1 ? 0 : ++lastSlash;
                    compilationUnit.module = this.module == null ? CharOperation.subarray(modulePath, lastSlash, modulePath.length) : this.module.name();
                    pathToModName.put(String.valueOf(modulePath), compilationUnit.module);
                    continue;
                }
                for (Map.Entry entry : pathToModName.entrySet()) {
                    if (!fileName.startsWith((String)entry.getKey())) continue;
                    compilationUnit.module = (char[])entry.getValue();
                    continue block1;
                }
            }
        }
        return this.compilationUnits;
    }

    public void setCompilationUnits(CompilationUnit[] compilationUnits) {
        this.compilationUnits = compilationUnits;
    }

    @Override
    public ICompilerRequestor getBatchRequestor() {
        final ICompilerRequestor r = super.getBatchRequestor();
        return new ICompilerRequestor(){

            @Override
            public void acceptResult(CompilationResult compilationResult) {
                if (compilationResult.hasErrors()) {
                    for (CategorizedProblem problem : compilationResult.problems) {
                        if (JDTBatchCompiler.this.jdtCompiler == null) {
                            throw new SpoonException(problem.toString());
                        }
                        JDTBatchCompiler.this.jdtCompiler.reportProblem(problem);
                    }
                }
                r.acceptResult(compilationResult);
            }
        };
    }

    public void ignoreFile(String filePath) {
        this.filesToBeIgnored.add(filePath);
    }

    public CompilationUnitDeclaration[] getUnits() {
        this.startTime = System.currentTimeMillis();
        INameEnvironment environment = this.jdtCompiler.environment;
        if (environment == null) {
            environment = this.getLibraryAccess();
        }
        CompilerOptions compilerOptions = new CompilerOptions(this.options);
        compilerOptions.parseLiteralExpressionsAsConstants = false;
        IErrorHandlingPolicy errorHandlingPolicy = this.jdtCompiler.getEnvironment().getNoClasspath() ? new IErrorHandlingPolicy(){

            @Override
            public boolean proceedOnErrors() {
                return true;
            }

            @Override
            public boolean stopOnFirstError() {
                return false;
            }

            @Override
            public boolean ignoreAllErrors() {
                return false;
            }
        } : new IErrorHandlingPolicy(){

            @Override
            public boolean proceedOnErrors() {
                return false;
            }

            @Override
            public boolean stopOnFirstError() {
                return false;
            }

            @Override
            public boolean ignoreAllErrors() {
                return false;
            }
        };
        IProblemFactory problemFactory = this.getProblemFactory();
        TreeBuilderCompiler treeBuilderCompiler = new TreeBuilderCompiler(environment, errorHandlingPolicy, compilerOptions, this.jdtCompiler.requestor, problemFactory, this.out, new CompilationProgress(){
            private String currentElement = null;
            private int totalTask = -1;

            @Override
            public void begin(int i2) {
            }

            @Override
            public void done() {
            }

            @Override
            public boolean isCanceled() {
                return false;
            }

            @Override
            public void setTaskName(String s) {
                String strToFind;
                int processingPosition;
                if (JDTBatchCompiler.this.jdtCompiler.getEnvironment().getSpoonProgress() != null && (processingPosition = s.indexOf(strToFind = "Processing ")) != -1) {
                    this.currentElement = s.substring(processingPosition + strToFind.length());
                }
            }

            @Override
            public void worked(int increment, int remaining) {
                if (this.totalTask == -1) {
                    this.totalTask = remaining + 1;
                }
                if (JDTBatchCompiler.this.jdtCompiler.getEnvironment().getSpoonProgress() != null) {
                    JDTBatchCompiler.this.jdtCompiler.getEnvironment().getSpoonProgress().step(SpoonProgress.Process.COMPILE, this.currentElement, this.totalTask - remaining, this.totalTask);
                }
            }
        });
        if (this.jdtCompiler.getEnvironment().getNoClasspath()) {
            treeBuilderCompiler.lookupEnvironment.problemReporter = new ProblemReporter(errorHandlingPolicy, compilerOptions, problemFactory){

                @Override
                public int computeSeverity(int problemID) {
                    return 256;
                }
            };
            treeBuilderCompiler.lookupEnvironment.mayTolerateMissingType = true;
        }
        if (this.jdtCompiler.getEnvironment().getSpoonProgress() != null) {
            this.jdtCompiler.getEnvironment().getSpoonProgress().start(SpoonProgress.Process.COMPILE);
        }
        CompilationUnitDeclaration[] result = treeBuilderCompiler.buildUnits(this.getCompilationUnits());
        if (this.jdtCompiler.getEnvironment().getSpoonProgress() != null) {
            this.jdtCompiler.getEnvironment().getSpoonProgress().end(SpoonProgress.Process.COMPILE);
        }
        if (this.jdtCompiler.getEnvironment().isCommentsEnabled()) {
            if (this.jdtCompiler.getEnvironment().getSpoonProgress() != null) {
                this.jdtCompiler.getEnvironment().getSpoonProgress().start(SpoonProgress.Process.COMMENT);
            }
            for (int i2 = 0; i2 < result.length; ++i2) {
                CompilationUnitDeclaration unit = result[i2];
                CommentRecorderParser parser = new CommentRecorderParser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), compilerOptions, new DefaultProblemFactory(Locale.getDefault())), false);
                ICompilationUnit sourceUnit = unit.compilationResult.compilationUnit;
                CompilationResult compilationResult = new CompilationResult(sourceUnit, 0, 0, compilerOptions.maxProblemsPerUnit);
                CompilationUnitDeclaration tmpDeclForComment = parser.dietParse(sourceUnit, compilationResult);
                unit.comments = tmpDeclForComment.comments;
                if (this.jdtCompiler.getEnvironment().getSpoonProgress() == null) continue;
                this.jdtCompiler.getEnvironment().getSpoonProgress().step(SpoonProgress.Process.COMMENT, new String(unit.getFileName()), i2 + 1, result.length);
            }
            if (this.jdtCompiler.getEnvironment().getSpoonProgress() != null) {
                this.jdtCompiler.getEnvironment().getSpoonProgress().end(SpoonProgress.Process.COMMENT);
            }
        }
        return result;
    }

    public JDTBasedSpoonCompiler getJdtCompiler() {
        return this.jdtCompiler;
    }
}

