/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.compiler.jdt;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import spoon.SpoonException;
import spoon.reflect.code.CtAbstractSwitch;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtBodyHolder;
import spoon.reflect.code.CtCase;
import spoon.reflect.code.CtCatch;
import spoon.reflect.code.CtComment;
import spoon.reflect.code.CtConditional;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtLambda;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.code.CtSwitch;
import spoon.reflect.code.CtSwitchExpression;
import spoon.reflect.cu.CompilationUnit;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.cu.position.BodyHolderSourcePosition;
import spoon.reflect.cu.position.DeclarationSourcePosition;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtAnnotationType;
import spoon.reflect.declaration.CtAnonymousExecutable;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtCompilationUnit;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtImport;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtModule;
import spoon.reflect.declaration.CtModuleDirective;
import spoon.reflect.declaration.CtPackageDeclaration;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeMember;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.declaration.ParentNotInitializedException;
import spoon.reflect.factory.Factory;
import spoon.reflect.reference.CtReference;
import spoon.reflect.visitor.CtInheritanceScanner;
import spoon.reflect.visitor.EarlyTerminatingScanner;
import spoon.support.compiler.jdt.JDTTreeBuilder;

public class JDTCommentBuilder {
    private static final Logger LOGGER = LogManager.getLogger();
    private final CompilationUnitDeclaration declarationUnit;
    private String filePath;
    private CompilationUnit spoonUnit;
    private Factory factory;
    private ICompilationUnit sourceUnit;
    private char[] contents;
    private static final Pattern startCommentRE = Pattern.compile("^/\\*{1,2} ?");
    private static final Pattern middleCommentRE = Pattern.compile("^[ \t]*\\*? ?");
    private static final Pattern endCommentRE = Pattern.compile("\\*/$");

    JDTCommentBuilder(CompilationUnitDeclaration declarationUnit, Factory factory) {
        this.declarationUnit = declarationUnit;
        if (declarationUnit.comments == null) {
            return;
        }
        this.factory = factory;
        this.sourceUnit = declarationUnit.compilationResult.compilationUnit;
        this.contents = this.sourceUnit.getContents();
        this.filePath = CharOperation.charToString(this.sourceUnit.getFileName());
        this.spoonUnit = JDTTreeBuilder.getOrCreateCompilationUnit(declarationUnit, factory);
    }

    public void build() {
        if (this.declarationUnit.comments == null) {
            return;
        }
        for (int j = 0; j < this.declarationUnit.comments.length; ++j) {
            int[] positions = this.declarationUnit.comments[j];
            this.buildComment(positions);
        }
    }

    private void buildComment(int[] positions) {
        CtComment comment;
        int start = positions[0];
        int end = -positions[1];
        if (end <= 0) {
            comment = this.factory.Core().createJavaDoc();
            end = -end;
        } else {
            comment = this.factory.Core().createComment();
            comment.setCommentType(CtComment.CommentType.BLOCK);
            if (start < 0) {
                comment.setCommentType(CtComment.CommentType.INLINE);
                start = -start;
            }
        }
        comment.setContent(this.getCommentContent(start, end));
        int[] lineSeparatorPositions = this.declarationUnit.compilationResult.lineSeparatorPositions;
        SourcePosition sourcePosition = this.factory.Core().createSourcePosition(this.spoonUnit, start, end - 1, lineSeparatorPositions);
        comment.setPosition(sourcePosition);
        this.insertCommentInAST(comment);
    }

    private CtElement addCommentToNear(CtComment comment, Collection<CtElement> elements) {
        CtElement best = null;
        int smallDistance = Integer.MAX_VALUE;
        for (CtElement element : elements) {
            if (!element.getPosition().isValidPosition() || element.isImplicit() || element instanceof CtComment) continue;
            boolean isAfter = element.getPosition().getSourceEnd() < comment.getPosition().getSourceStart();
            int distance = Math.abs(element.getPosition().getSourceStart() - comment.getPosition().getSourceEnd());
            if (isAfter) {
                distance = Math.abs(element.getPosition().getSourceEnd() - comment.getPosition().getSourceStart());
            }
            int elementEndLine = element.getPosition().getEndLine();
            int commentLine = comment.getPosition().getLine();
            if (distance >= smallDistance || isAfter && elementEndLine != commentLine && !(element instanceof CtType)) continue;
            best = element;
            smallDistance = distance;
        }
        if (best != null) {
            best.addComment(comment);
        }
        return best;
    }

    private void insertCommentInAST(final CtComment comment) {
        CtElement commentParent = this.findCommentParent(comment);
        if (commentParent instanceof CtPackageDeclaration || commentParent instanceof CtCompilationUnit) {
            File file = this.spoonUnit.getFile();
            if (file == null) {
                List<CtType<?>> types = this.spoonUnit.getDeclaredTypes();
                if (types.size() > 0) {
                    types.get(0).addComment(comment);
                    return;
                }
            } else {
                if (file.getName().equals("package-info.java")) {
                    this.spoonUnit.getDeclaredPackage().addComment(comment);
                    return;
                }
                if (file.getName().equals("module-info.java")) {
                    this.spoonUnit.getDeclaredModule().addComment(comment);
                    return;
                }
            }
        }
        CtInheritanceScanner insertionVisitor = new CtInheritanceScanner(){
            private boolean isScanned = false;

            @Override
            public void scan(CtElement e) {
                if (e == null) {
                    return;
                }
                if (!this.isScanned) {
                    this.isScanned = true;
                    SourcePosition sp = e.getPosition();
                    if (sp.getSourceStart() == comment.getPosition().getSourceStart()) {
                        e.addComment(comment);
                        return;
                    }
                    if (sp instanceof DeclarationSourcePosition) {
                        DeclarationSourcePosition dsp = (DeclarationSourcePosition)sp;
                        if (comment.getPosition().getSourceEnd() < dsp.getModifierSourceEnd()) {
                            e.addComment(comment);
                            return;
                        }
                    }
                    super.scan(e);
                }
            }

            @Override
            public void scanCtReference(CtReference reference) {
                reference.addComment(comment);
                super.scanCtReference(reference);
            }

            @Override
            public <R> void visitCtStatementList(CtStatementList e) {
                JDTCommentBuilder.this.addCommentToNear(comment, new ArrayList<CtStatement>(e.getStatements()));
                try {
                    comment.getParent();
                }
                catch (ParentNotInitializedException ex) {
                    e.addStatement(comment);
                }
            }

            @Override
            public <T> void visitCtMethod(CtMethod<T> e) {
                e.addComment(comment);
            }

            @Override
            public <T> void visitCtConstructor(CtConstructor<T> e) {
                e.addComment(comment);
            }

            @Override
            public <T> void visitCtConditional(CtConditional<T> e) {
                ArrayList<CtExpression<T>> elements = new ArrayList<CtExpression<T>>();
                elements.add(e.getElseExpression());
                elements.add(e.getThenExpression());
                elements.add(e.getCondition());
                JDTCommentBuilder.this.addCommentToNear(comment, elements);
            }

            @Override
            public <T> void visitCtBinaryOperator(CtBinaryOperator<T> e) {
                ArrayList elements = new ArrayList();
                elements.add(e.getLeftHandOperand());
                elements.add(e.getRightHandOperand());
                JDTCommentBuilder.this.addCommentToNear(comment, elements);
            }

            @Override
            public <T> void visitCtClass(CtClass<T> e) {
                if (comment.getPosition().getSourceEnd() < ((BodyHolderSourcePosition)e.getPosition()).getBodyStart()) {
                    e.addComment(comment);
                    return;
                }
                ArrayList<CtTypeMember> elements = new ArrayList<CtTypeMember>();
                for (CtTypeMember typeMember : e.getTypeMembers()) {
                    if (!(typeMember instanceof CtField) && !(typeMember instanceof CtMethod) && !(typeMember instanceof CtConstructor)) continue;
                    elements.add(typeMember);
                }
                JDTCommentBuilder.this.addCommentToNear(comment, elements);
                try {
                    comment.getParent();
                }
                catch (ParentNotInitializedException ex) {
                    e.addComment(comment);
                }
            }

            private <T> void visitInterfaceType(CtType<T> e) {
                ArrayList<CtTypeMember> elements = new ArrayList<CtTypeMember>();
                for (CtTypeMember typeMember : e.getTypeMembers()) {
                    if (!(typeMember instanceof CtField) && !(typeMember instanceof CtMethod)) continue;
                    elements.add(typeMember);
                }
                JDTCommentBuilder.this.addCommentToNear(comment, elements);
                try {
                    comment.getParent();
                }
                catch (ParentNotInitializedException ex) {
                    e.addComment(comment);
                }
            }

            @Override
            public <T> void visitCtInterface(CtInterface<T> e) {
                this.visitInterfaceType(e);
            }

            @Override
            public <A extends Annotation> void visitCtAnnotationType(CtAnnotationType<A> e) {
                this.visitInterfaceType(e);
            }

            @Override
            public void visitCtCompilationUnit(CtCompilationUnit compilationUnit) {
                compilationUnit.addComment(comment);
            }

            @Override
            public void visitCtPackageDeclaration(CtPackageDeclaration packageDeclaration) {
                packageDeclaration.addComment(comment);
            }

            @Override
            public void visitCtImport(CtImport ctImport) {
                ctImport.addComment(comment);
            }

            @Override
            public <T> void scanCtVariable(CtVariable<T> e) {
                e.addComment(comment);
            }

            private <S> void visitSwitch(CtAbstractSwitch<S> e) {
                List<CtCase<S>> cases = e.getCases();
                CtCase<S> previous = null;
                for (CtCase<S> ctCase : cases) {
                    if (previous == null) {
                        if (comment.getPosition().getSourceStart() < ctCase.getPosition().getSourceStart() && e.getPosition().getSourceStart() < comment.getPosition().getSourceStart()) {
                            ctCase.addComment(comment);
                            return;
                        }
                    } else if (previous.getPosition().getSourceEnd() < comment.getPosition().getSourceStart() && ctCase.getPosition().getSourceStart() > comment.getPosition().getSourceStart()) {
                        JDTCommentBuilder.this.addCommentToNear(comment, new ArrayList<CtStatement>(previous.getStatements()));
                        try {
                            comment.getParent();
                        }
                        catch (ParentNotInitializedException ex) {
                            previous.addStatement(comment);
                        }
                        return;
                    }
                    previous = ctCase;
                }
                if (previous != null && previous.getPosition().getSourceEnd() < comment.getPosition().getSourceStart()) {
                    JDTCommentBuilder.this.addCommentToNear(comment, new ArrayList<CtStatement>(previous.getStatements()));
                    try {
                        comment.getParent();
                    }
                    catch (ParentNotInitializedException ex) {
                        previous.addStatement(comment);
                    }
                    return;
                }
                try {
                    comment.getParent();
                }
                catch (ParentNotInitializedException ex) {
                    e.addComment(comment);
                }
            }

            @Override
            public <E> void visitCtSwitch(CtSwitch<E> e) {
                this.visitSwitch(e);
            }

            @Override
            public <T, S> void visitCtSwitchExpression(CtSwitchExpression<T, S> e) {
                this.visitSwitch(e);
            }

            @Override
            public void visitCtIf(CtIf e) {
                Object thenStatement = e.getThenStatement();
                if (thenStatement != null && !(thenStatement instanceof CtBlock) && comment.getPosition().getSourceEnd() <= thenStatement.getPosition().getSourceStart()) {
                    thenStatement.addComment(comment);
                    return;
                }
                Object elseStatement = e.getElseStatement();
                if (elseStatement != null && thenStatement != null) {
                    SourcePosition elsePosition;
                    SourcePosition thenPosition = thenStatement.getPosition();
                    if (!thenPosition.isValidPosition() && thenStatement instanceof CtBlock) {
                        Object thenExpression = ((CtBlock)thenStatement).getStatement(0);
                        thenPosition = thenExpression.getPosition();
                    }
                    if (!(elsePosition = elseStatement.getPosition()).isValidPosition() && elseStatement instanceof CtBlock) {
                        Object elseExpression = ((CtBlock)elseStatement).getStatement(0);
                        elsePosition = elseExpression.getPosition();
                    }
                    if (comment.getPosition().getSourceStart() > thenPosition.getSourceEnd() && comment.getPosition().getSourceEnd() < elsePosition.getSourceStart()) {
                        elseStatement.addComment(comment);
                    }
                }
                try {
                    comment.getParent();
                }
                catch (ParentNotInitializedException ex) {
                    e.addComment(comment);
                }
            }

            @Override
            public void scanCtStatement(CtStatement s) {
                if (!(s instanceof CtStatementList || s instanceof CtSwitch || s instanceof CtVariable)) {
                    s.addComment(comment);
                }
            }

            @Override
            public void visitCtAnonymousExecutable(CtAnonymousExecutable e) {
                e.addComment(comment);
            }

            @Override
            public <T> void visitCtLambda(CtLambda<T> e) {
                if (e.getExpression() != null) {
                    CtParameter<?> lastParameter = e.getParameters().get(e.getParameters().size() - 1);
                    if (comment.getPosition().getSourceStart() > lastParameter.getPosition().getSourceEnd()) {
                        e.getExpression().addComment(comment);
                    } else {
                        e.addComment(comment);
                    }
                } else if (e.getBody() != null) {
                    e.addComment(comment);
                }
            }

            @Override
            public <T> void visitCtNewArray(CtNewArray<T> e) {
                JDTCommentBuilder.this.addCommentToNear(comment, new ArrayList(e.getElements()));
                try {
                    comment.getParent();
                }
                catch (ParentNotInitializedException ex) {
                    e.addComment(comment);
                }
            }

            @Override
            public <T> void visitCtParameter(CtParameter<T> e) {
                e.addComment(comment);
            }

            @Override
            public void visitCtCatch(CtCatch e) {
                if (comment.getPosition().getLine() <= e.getPosition().getLine()) {
                    e.addComment(comment);
                } else {
                    e.getBody().addComment(comment);
                }
            }

            @Override
            public void visitCtModule(CtModule module) {
                JDTCommentBuilder.this.addCommentToNear(comment, new ArrayList<CtModuleDirective>(module.getModuleDirectives()));
            }

            @Override
            public <A extends Annotation> void visitCtAnnotation(CtAnnotation<A> e) {
                JDTCommentBuilder.this.addCommentToNear(comment, new ArrayList<CtExpression>(e.getValues().values()));
            }
        };
        insertionVisitor.scan(commentParent);
        if (!comment.isParentInitialized()) {
            LOGGER.error("\"" + comment + "\" cannot be added into the AST, with parent " + commentParent.getClass() + " at " + commentParent.getPosition().toString() + ", please report the bug by posting on https://github.com/INRIA/spoon/issues/2482");
        }
    }

    private CtElement findCommentParent(CtComment comment) {
        class FindCommentParentScanner
        extends EarlyTerminatingScanner<Void> {
            public CtElement commentParent;
            private int start;
            private int end;

            FindCommentParentScanner(int start, int end) {
                this.start = start;
                this.end = end;
                this.setVisitCompilationUnitContent(true);
            }

            private boolean isCommentBetweenElementPosition(CtElement element) {
                return element.getPosition().isValidPosition() && element.getPosition().getSourceStart() <= this.start && element.getPosition().getSourceEnd() >= this.end;
            }

            @Override
            public void scan(CtElement element) {
                boolean bodyBetweenElementPosition;
                if (element == null) {
                    return;
                }
                if (element.isImplicit() && !(element instanceof CtBlock)) {
                    return;
                }
                CtElement body = JDTCommentBuilder.getBody(element);
                if (body != null && !body.getPosition().isValidPosition()) {
                    body = null;
                }
                boolean betweenElementPosition = this.isCommentBetweenElementPosition(element);
                boolean bl = bodyBetweenElementPosition = body != null && this.isCommentBetweenElementPosition(body);
                if (betweenElementPosition || bodyBetweenElementPosition) {
                    this.commentParent = element;
                    element.accept(this);
                }
            }
        }
        FindCommentParentScanner findCommentParentScanner = new FindCommentParentScanner(comment.getPosition().getSourceStart(), comment.getPosition().getSourceEnd());
        findCommentParentScanner.scan(this.spoonUnit);
        return findCommentParentScanner.commentParent;
    }

    static CtElement getBody(CtElement e) {
        if (e instanceof CtBodyHolder) {
            return ((CtBodyHolder)e).getBody();
        }
        return null;
    }

    private String getCommentContent(int start, int end) {
        return new String(this.contents, start, end - start);
    }

    public static String cleanComment(String comment) {
        if (comment == null) {
            return "";
        }
        return JDTCommentBuilder.cleanComment(new StringReader(comment));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String cleanComment(Reader comment) {
        StringBuilder ret = new StringBuilder();
        try (BufferedReader br = new BufferedReader(comment);){
            String line = br.readLine();
            if (line == null) {
                String string = ret.toString();
                return string;
            }
            boolean isLastLine = false;
            if (line.length() >= 2 && line.charAt(1) == '/') {
                isLastLine = true;
                line = line.substring(2);
            } else {
                if (line.endsWith("*/") && line.length() > 3) {
                    line = endCommentRE.matcher(line).replaceFirst("");
                    isLastLine = true;
                }
                line = startCommentRE.matcher(line).replaceFirst("");
            }
            ret.append(line);
            while ((line = br.readLine()) != null) {
                if (line.endsWith("*/")) {
                    line = endCommentRE.matcher(line).replaceFirst("");
                    isLastLine = true;
                }
                line = middleCommentRE.matcher(line).replaceFirst("");
                ret.append("\n");
                ret.append(line);
            }
            String string = ret.toString().trim();
            return string;
        }
        catch (IOException e) {
            throw new SpoonException(e);
        }
    }
}

