/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.compiler.jdt;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ExportsStatement;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.ModuleDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ModuleReference;
import org.eclipse.jdt.internal.compiler.ast.ModuleStatement;
import org.eclipse.jdt.internal.compiler.ast.OpensStatement;
import org.eclipse.jdt.internal.compiler.ast.ProvidesStatement;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ReferenceExpression;
import org.eclipse.jdt.internal.compiler.ast.RequiresStatement;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.UnionTypeReference;
import org.eclipse.jdt.internal.compiler.ast.UsesStatement;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MissingTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;
import spoon.SpoonException;
import spoon.reflect.code.CtCatchVariable;
import spoon.reflect.code.CtExecutableReferenceExpression;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtLambda;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtModule;
import spoon.reflect.declaration.CtModuleRequirement;
import spoon.reflect.declaration.CtPackageExport;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtProvidedService;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtUsedService;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.factory.CoreFactory;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtModuleReference;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtParameterReference;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtVariableReference;
import spoon.support.compiler.jdt.ASTPair;
import spoon.support.compiler.jdt.ContextBuilder;
import spoon.support.compiler.jdt.JDTTreeBuilder;
import spoon.support.compiler.jdt.JDTTreeBuilderQuery;
import spoon.support.compiler.jdt.PositionBuilder;
import spoon.support.compiler.jdt.ReferenceBuilder;
import spoon.support.reflect.CtExtendedModifier;

public class JDTTreeBuilderHelper {
    private final JDTTreeBuilder jdtTreeBuilder;

    JDTTreeBuilderHelper(JDTTreeBuilder jdtTreeBuilder) {
        this.jdtTreeBuilder = jdtTreeBuilder;
    }

    static String computeAnonymousName(char[] anonymousQualifiedName) {
        String poolName = CharOperation.charToString(anonymousQualifiedName);
        return poolName.substring(poolName.lastIndexOf("$") + 1);
    }

    static String createQualifiedTypeName(char[][] typeName) {
        StringBuilder s = new StringBuilder();
        for (int i2 = 0; i2 < typeName.length - 1; ++i2) {
            s.append(CharOperation.charToString(typeName[i2])).append(".");
        }
        s.append(CharOperation.charToString(typeName[typeName.length - 1]));
        return s.toString();
    }

    CtCatchVariable<Throwable> createCatchVariable(TypeReference typeReference) {
        Argument jdtCatch = (Argument)this.jdtTreeBuilder.getContextBuilder().stack.peekFirst().node;
        Set<CtExtendedModifier> modifiers = JDTTreeBuilderQuery.getModifiers(jdtCatch.modifiers, false, false);
        CtCatchVariable<Throwable> result = this.jdtTreeBuilder.getFactory().Core().createCatchVariable();
        ((CtCatchVariable)result.setSimpleName(CharOperation.charToString(jdtCatch.name))).setExtendedModifiers(modifiers);
        if (typeReference instanceof UnionTypeReference) {
            return result;
        }
        CtTypeReference ctTypeReference = typeReference.resolvedType instanceof ProblemReferenceBinding ? this.jdtTreeBuilder.getReferencesBuilder().buildTypeReference(typeReference, null) : this.jdtTreeBuilder.getReferencesBuilder().getTypeReference(typeReference.resolvedType);
        return (CtCatchVariable)result.setType(ctTypeReference);
    }

    public <T> CtVariableAccess<T> createVariableAccess(CtVariableReference<T> variableReference, boolean isReadAccess) {
        CtVariableAccess<T> variableAccess = isReadAccess ? this.jdtTreeBuilder.getFactory().Core().createVariableWrite() : this.jdtTreeBuilder.getFactory().Core().createVariableRead();
        return variableAccess.setVariable(variableReference);
    }

    <T> CtVariableAccess<T> createVariableAccess(SingleNameReference singleNameReference) {
        CtVariableAccess va = JDTTreeBuilderQuery.isLhsAssignment(this.jdtTreeBuilder.getContextBuilder(), singleNameReference) ? this.jdtTreeBuilder.getFactory().Core().createVariableWrite() : this.jdtTreeBuilder.getFactory().Core().createVariableRead();
        va.setVariable(this.jdtTreeBuilder.getReferencesBuilder().getVariableReference((VariableBinding)singleNameReference.binding));
        return va;
    }

    <T> CtVariableAccess<T> createVariableAccessNoClasspath(SingleNameReference singleNameReference) {
        CtVariableAccess variableAccess;
        CtParameterReference variableReference;
        CoreFactory coreFactory = this.jdtTreeBuilder.getFactory().Core();
        ContextBuilder contextBuilder = this.jdtTreeBuilder.getContextBuilder();
        ReferenceBuilder referenceBuilder = this.jdtTreeBuilder.getReferencesBuilder();
        PositionBuilder positionBuilder = this.jdtTreeBuilder.getPositionBuilder();
        String name = CharOperation.charToString(singleNameReference.token);
        CtVariable variable = contextBuilder.getVariableDeclaration(name);
        if (variable == null) {
            return null;
        }
        if (variable instanceof CtParameter) {
            CtParameterReference parameterReference = coreFactory.createParameterReference();
            if (!(variable.getParent() instanceof CtLambda)) {
                CtExecutable executable = (CtExecutable)variable.getParent();
                AbstractMethodDeclaration executableJDT = null;
                for (ASTPair astPair : contextBuilder.stack) {
                    if (astPair.element != executable) continue;
                    executableJDT = (AbstractMethodDeclaration)astPair.node;
                }
                assert (executableJDT != null);
                CtTypeReference ctTypeReference = executableJDT.binding == null ? coreFactory.createTypeReference() : referenceBuilder.getTypeReference(executableJDT.binding.declaringClass);
            }
            variableReference = parameterReference;
            variableAccess = JDTTreeBuilderQuery.isLhsAssignment(contextBuilder, singleNameReference) ? coreFactory.createVariableWrite() : coreFactory.createVariableRead();
        } else if (variable instanceof CtField) {
            variableReference = variable.getReference();
            variableAccess = JDTTreeBuilderQuery.isLhsAssignment(contextBuilder, singleNameReference) ? coreFactory.createFieldWrite() : coreFactory.createFieldRead();
        } else {
            variableReference = variable.getReference();
            variableAccess = JDTTreeBuilderQuery.isLhsAssignment(contextBuilder, singleNameReference) ? coreFactory.createVariableWrite() : coreFactory.createVariableRead();
        }
        variableReference.setSimpleName(name);
        variableReference.setPosition(positionBuilder.buildPosition(singleNameReference.sourceStart(), singleNameReference.sourceEnd()));
        variableAccess.setVariable(variableReference);
        return variableAccess;
    }

    <T> CtVariableAccess<T> createVariableAccess(QualifiedNameReference qualifiedNameReference) {
        CtVariableAccess va;
        CtVariableReference ref;
        boolean isOtherBinding;
        long[] positions = qualifiedNameReference.sourcePositions;
        int sourceStart = qualifiedNameReference.sourceStart();
        int sourceEnd = qualifiedNameReference.sourceEnd();
        if (qualifiedNameReference.indexOfFirstFieldBinding < positions.length) {
            sourceEnd = (int)(positions[qualifiedNameReference.indexOfFirstFieldBinding] >>> 32) - 2;
        }
        boolean fromAssignment = JDTTreeBuilderQuery.isLhsAssignment(this.jdtTreeBuilder.getContextBuilder(), qualifiedNameReference);
        boolean bl = isOtherBinding = qualifiedNameReference.otherBindings == null || qualifiedNameReference.otherBindings.length == 0;
        if (qualifiedNameReference.binding instanceof FieldBinding) {
            ref = this.jdtTreeBuilder.getReferencesBuilder().getVariableReference(qualifiedNameReference.fieldBinding());
            ref.setPosition(this.jdtTreeBuilder.getPositionBuilder().buildPosition(this.getVariableReferenceSourceStart(sourceStart, sourceEnd), sourceEnd));
            va = this.createFieldAccess(ref, this.createTargetFieldAccess(qualifiedNameReference, (CtFieldReference)ref), isOtherBinding && fromAssignment);
        } else {
            ref = this.jdtTreeBuilder.getReferencesBuilder().getVariableReference((VariableBinding)qualifiedNameReference.binding);
            ref.setPosition(this.jdtTreeBuilder.getPositionBuilder().buildPosition(this.getVariableReferenceSourceStart(sourceStart, sourceEnd), sourceEnd));
            va = this.createVariableAccess(ref, isOtherBinding && fromAssignment);
        }
        if (qualifiedNameReference.otherBindings != null) {
            int i2 = 0;
            va.setPosition(this.jdtTreeBuilder.getPositionBuilder().buildPosition(sourceStart, sourceEnd));
            sourceStart = (int)(positions[qualifiedNameReference.indexOfFirstFieldBinding - 1] >>> 32);
            for (FieldBinding b : qualifiedNameReference.otherBindings) {
                isOtherBinding = qualifiedNameReference.otherBindings.length == i2 + 1;
                CtFieldAccess other = this.createFieldAccess(this.jdtTreeBuilder.getReferencesBuilder().getVariableReference(b, qualifiedNameReference.tokens[i2 + 1]), va, isOtherBinding && fromAssignment);
                sourceEnd = i2 + qualifiedNameReference.indexOfFirstFieldBinding >= qualifiedNameReference.otherBindings.length ? qualifiedNameReference.sourceEnd() : (int)(positions[qualifiedNameReference.indexOfFirstFieldBinding + i2 + 1] >>> 32) - 2;
                other.setPosition(this.jdtTreeBuilder.getPositionBuilder().buildPosition(sourceStart, sourceEnd));
                va = other;
                ++i2;
            }
        } else if (!(qualifiedNameReference.binding instanceof FieldBinding) && qualifiedNameReference.tokens.length > 1) {
            sourceStart = (int)(positions[0] >>> 32);
            for (int i3 = 1; i3 < qualifiedNameReference.tokens.length; ++i3) {
                isOtherBinding = qualifiedNameReference.tokens.length == i3 + 1;
                CtFieldAccess other = this.createFieldAccess(this.jdtTreeBuilder.getReferencesBuilder().getVariableReference(null, qualifiedNameReference.tokens[i3]), va, isOtherBinding && fromAssignment);
                sourceEnd = (int)positions[i3];
                va.setPosition(this.jdtTreeBuilder.getPositionBuilder().buildPosition(sourceStart, sourceEnd));
                va = other;
            }
        }
        va.setPosition(this.jdtTreeBuilder.getPositionBuilder().buildPosition(qualifiedNameReference.sourceStart(), qualifiedNameReference.sourceEnd()));
        return va;
    }

    private int getVariableReferenceSourceStart(int sourceStart, int sourceEnd) {
        char[] contents = this.jdtTreeBuilder.getContextBuilder().getCompilationUnitContents();
        int lastIdentifierStart = sourceStart;
        int dotIdx;
        while ((dotIdx = PositionBuilder.findNextChar(contents, sourceEnd, lastIdentifierStart, '.')) >= 0) {
            lastIdentifierStart = dotIdx + 1;
        }
        return lastIdentifierStart;
    }

    public <T> CtFieldAccess<T> createFieldAccess(CtVariableReference<T> variableReference, CtExpression<?> target, boolean isReadAccess) {
        CtFieldAccess<T> fieldAccess = isReadAccess ? this.jdtTreeBuilder.getFactory().Core().createFieldWrite() : this.jdtTreeBuilder.getFactory().Core().createFieldRead();
        fieldAccess.setVariable(variableReference);
        fieldAccess.setTarget(target);
        return fieldAccess;
    }

    <T> CtFieldAccess<T> createFieldAccess(SingleNameReference singleNameReference) {
        CtFieldAccess va = JDTTreeBuilderQuery.isLhsAssignment(this.jdtTreeBuilder.getContextBuilder(), singleNameReference) ? this.jdtTreeBuilder.getFactory().Core().createFieldWrite() : this.jdtTreeBuilder.getFactory().Core().createFieldRead();
        va.setVariable(this.jdtTreeBuilder.getReferencesBuilder().getVariableReference(singleNameReference.fieldBinding().original()));
        if (va.getVariable() != null) {
            CtVariableReference ref = va.getVariable();
            if (ref.isStatic() && !ref.getDeclaringType().isAnonymous()) {
                va.setTarget(this.jdtTreeBuilder.getFactory().Code().createTypeAccess(ref.getDeclaringType(), true));
            } else if (!ref.isStatic()) {
                va.setTarget(this.jdtTreeBuilder.getFactory().Code().createThisAccess(this.jdtTreeBuilder.getReferencesBuilder().getTypeReference(singleNameReference.actualReceiverType), true));
            }
        }
        return va;
    }

    <T> CtFieldAccess<T> createFieldAccessNoClasspath(SingleNameReference singleNameReference) {
        CtFieldAccess va = JDTTreeBuilderQuery.isLhsAssignment(this.jdtTreeBuilder.getContextBuilder(), singleNameReference) ? this.jdtTreeBuilder.getFactory().Core().createFieldWrite() : this.jdtTreeBuilder.getFactory().Core().createFieldRead();
        va.setVariable(this.jdtTreeBuilder.getReferencesBuilder().getVariableReference((ProblemBinding)singleNameReference.binding));
        CtReference declaring = this.jdtTreeBuilder.getReferencesBuilder().getDeclaringReferenceFromImports(singleNameReference.token);
        if (declaring instanceof CtTypeReference && va.getVariable() != null) {
            CtTypeReference declaringRef = (CtTypeReference)declaring;
            va.setTarget(this.jdtTreeBuilder.getFactory().Code().createTypeAccess(declaringRef, true));
            va.getVariable().setDeclaringType(declaringRef);
            va.getVariable().setStatic(true);
        }
        return va;
    }

    <T> CtFieldAccess<T> createFieldAccessNoClasspath(QualifiedNameReference qualifiedNameReference) {
        boolean fromAssignment = JDTTreeBuilderQuery.isLhsAssignment(this.jdtTreeBuilder.getContextBuilder(), qualifiedNameReference);
        CtFieldAccess fieldAccess = this.createFieldAccess(this.jdtTreeBuilder.getReferencesBuilder().getVariableReference((ProblemBinding)qualifiedNameReference.binding), null, fromAssignment);
        char[][] declaringClass = CharOperation.subarray(qualifiedNameReference.tokens, 0, qualifiedNameReference.tokens.length - 1);
        MissingTypeBinding declaringType = this.jdtTreeBuilder.getContextBuilder().compilationunitdeclaration.scope.environment.createMissingType(null, declaringClass);
        CtTypeReference declaringRef = this.jdtTreeBuilder.getReferencesBuilder().getTypeReference(declaringType);
        fieldAccess.getVariable().setDeclaringType(declaringRef);
        fieldAccess.getVariable().setStatic(true);
        fieldAccess.setTarget(this.jdtTreeBuilder.getFactory().Code().createTypeAccess(declaringRef));
        fieldAccess.getVariable().setSimpleName(JDTTreeBuilderHelper.createQualifiedTypeName(CharOperation.subarray(qualifiedNameReference.tokens, qualifiedNameReference.tokens.length - 1, qualifiedNameReference.tokens.length)));
        return fieldAccess;
    }

    <T> CtFieldAccess<T> createFieldAccess(FieldReference fieldReference) {
        CtFieldAccess fieldAccess = JDTTreeBuilderQuery.isLhsAssignment(this.jdtTreeBuilder.getContextBuilder(), fieldReference) ? this.jdtTreeBuilder.getFactory().Core().createFieldWrite() : this.jdtTreeBuilder.getFactory().Core().createFieldRead();
        fieldAccess.setVariable(this.jdtTreeBuilder.getReferencesBuilder().getVariableReference(fieldReference.binding, fieldReference.token));
        fieldAccess.setType(this.jdtTreeBuilder.getReferencesBuilder().getTypeReference(fieldReference.resolvedType));
        return fieldAccess;
    }

    CtTypeAccess<?> createTypeAccess(QualifiedNameReference qualifiedNameReference, CtFieldReference<?> fieldReference) {
        TypeBinding receiverType = qualifiedNameReference.actualReceiverType;
        if (receiverType != null) {
            CtTypeReference qualifiedRef = this.jdtTreeBuilder.getReferencesBuilder().getQualifiedTypeReference(qualifiedNameReference.tokens, receiverType, qualifiedNameReference.fieldBinding().declaringClass.enclosingType(), new JDTTreeBuilder.OnAccessListener(){

                @Override
                public boolean onAccess(char[][] tokens, int index) {
                    return !CharOperation.equals(tokens[index + 1], tokens[tokens.length - 1]);
                }
            });
            if (qualifiedRef != null) {
                fieldReference.setDeclaringType(qualifiedRef);
            } else {
                fieldReference.setDeclaringType(this.jdtTreeBuilder.getReferencesBuilder().getTypeReference(receiverType));
            }
        }
        CtTypeAccess<?> typeAccess = this.jdtTreeBuilder.getFactory().Code().createTypeAccess(fieldReference.getDeclaringType());
        if (qualifiedNameReference.indexOfFirstFieldBinding > 1) {
            long[] positions = qualifiedNameReference.sourcePositions;
            typeAccess.setPosition(this.jdtTreeBuilder.getPositionBuilder().buildPosition(qualifiedNameReference.sourceStart(), (int)(positions[qualifiedNameReference.indexOfFirstFieldBinding - 1] >>> 32) - 2));
            JDTTreeBuilderHelper.handleImplicit(qualifiedNameReference.actualReceiverType.getPackage(), qualifiedNameReference, fieldReference.getSimpleName(), typeAccess.getAccessedType());
        } else {
            typeAccess.setImplicit(qualifiedNameReference.isImplicitThis());
        }
        return typeAccess;
    }

    static void handleImplicit(PackageBinding packageBinding, QualifiedNameReference qualifiedNameReference, String simpleName, CtTypeReference<?> typeRef) {
        JDTTreeBuilderHelper.handleImplicit(packageBinding, qualifiedNameReference.tokens, qualifiedNameReference.otherBindings == null ? 0 : qualifiedNameReference.otherBindings.length, qualifiedNameReference, simpleName, typeRef);
    }

    static void handleImplicit(QualifiedTypeReference qualifiedTypeReference, CtTypeReference<?> typeRef) {
        if (qualifiedTypeReference.resolvedType instanceof ProblemReferenceBinding || qualifiedTypeReference.resolvedType == null) {
            return;
        }
        JDTTreeBuilderHelper.handleImplicit(qualifiedTypeReference.resolvedType.getPackage(), qualifiedTypeReference.tokens, 0, qualifiedTypeReference, null, typeRef);
    }

    private static void handleImplicit(PackageBinding packageBinding, char[][] tokens, int countOfOtherBindings, Object qualifiedNameReference, String simpleName, CtTypeReference<?> typeRef) {
        char[][] packageNames = null;
        if (packageBinding != null) {
            packageNames = packageBinding.compoundName;
        }
        CtTypeReference<?> originTypeRef = typeRef;
        while (typeRef instanceof CtArrayTypeReference) {
            typeRef = ((CtArrayTypeReference)typeRef).getComponentType();
        }
        int off = tokens.length - 1;
        if ((off -= countOfOtherBindings) > 0) {
            if (simpleName != null) {
                if (!simpleName.equals(new String(tokens[off]))) {
                    throw new SpoonException("Unexpected field reference simple name: \"" + new String(tokens[off]) + "\" expected: \"" + simpleName + "\"");
                }
                --off;
            }
            while (off >= 0) {
                String token = new String(tokens[off]);
                if (!typeRef.getSimpleName().equals(token)) {
                    return;
                }
                CtTypeReference<?> declTypeRef = typeRef.getDeclaringType();
                if (declTypeRef != null) {
                    typeRef = declTypeRef;
                    --off;
                    continue;
                }
                CtPackageReference packageRef = typeRef.getPackage();
                if (packageRef == null) continue;
                if (packageNames != null && packageNames.length == off) {
                    return;
                }
                if (off == 0) {
                    packageRef.setImplicit(true);
                    return;
                }
                if (packageBinding == null || (packageBinding.tagBits & 0x80L) != 0L) {
                    return;
                }
                throw new SpoonException("Unexpected QualifiedNameReference tokens " + qualifiedNameReference + " for typeRef: " + originTypeRef);
            }
            typeRef.setImplicit(true);
        }
    }

    <T> CtTypeAccess<T> createTypeAccessNoClasspath(QualifiedNameReference qualifiedNameReference) {
        CtTypeReference typeReference;
        if (qualifiedNameReference.binding instanceof ProblemBinding) {
            typeReference = this.jdtTreeBuilder.getFactory().Type().createReference(CharOperation.toString(qualifiedNameReference.tokens));
        } else if (qualifiedNameReference.binding instanceof FieldBinding) {
            ReferenceBinding declaringClass = ((FieldBinding)qualifiedNameReference.binding).declaringClass;
            typeReference = this.jdtTreeBuilder.getReferencesBuilder().getTypeReference(declaringClass);
        } else {
            char[][] packageName = CharOperation.subarray(qualifiedNameReference.tokens, 0, qualifiedNameReference.tokens.length - 1);
            char[][] className = CharOperation.subarray(qualifiedNameReference.tokens, qualifiedNameReference.tokens.length - 1, qualifiedNameReference.tokens.length);
            if (packageName.length > 0) {
                try {
                    PackageBinding aPackage = this.jdtTreeBuilder.getContextBuilder().compilationunitdeclaration.scope.environment.createPackage(packageName);
                    MissingTypeBinding declaringType = this.jdtTreeBuilder.getContextBuilder().compilationunitdeclaration.scope.environment.createMissingType(aPackage, className);
                    typeReference = this.jdtTreeBuilder.getReferencesBuilder().getTypeReference(declaringType);
                }
                catch (NullPointerException e) {
                    typeReference = this.jdtTreeBuilder.getFactory().Type().createReference(qualifiedNameReference.toString());
                }
            } else {
                typeReference = this.jdtTreeBuilder.getFactory().Type().createReference(qualifiedNameReference.toString());
            }
        }
        CtTypeAccess typeAccess = this.jdtTreeBuilder.getFactory().Code().createTypeAccess(typeReference);
        int sourceStart = qualifiedNameReference.sourceStart();
        int sourceEnd = qualifiedNameReference.sourceEnd();
        typeAccess.setPosition(this.jdtTreeBuilder.getPositionBuilder().buildPosition(sourceStart, sourceEnd));
        return typeAccess;
    }

    <T> CtTypeAccess<T> createTypeAccessNoClasspath(SingleNameReference singleNameReference) {
        CtTypeReference typeReference = this.jdtTreeBuilder.getFactory().Core().createTypeReference();
        if (singleNameReference.binding == null) {
            typeReference.setSimpleName(CharOperation.charToString(singleNameReference.token));
        } else {
            typeReference.setSimpleName(CharOperation.charToString(singleNameReference.binding.readableName()));
        }
        CtReference packageOrDeclaringType = this.jdtTreeBuilder.getReferencesBuilder().getDeclaringReferenceFromImports(singleNameReference.token);
        this.jdtTreeBuilder.getReferencesBuilder().setImplicitPackageOrDeclaringType(typeReference, packageOrDeclaringType);
        return this.jdtTreeBuilder.getFactory().Code().createTypeAccess(typeReference);
    }

    CtExpression<?> createTargetFieldAccess(QualifiedNameReference qualifiedNameReference, CtFieldReference<Object> ref) {
        CtExpression<Void> target = null;
        if (JDTTreeBuilderQuery.isValidProblemBindingField(qualifiedNameReference)) {
            target = this.createTypeAccessNoClasspath(qualifiedNameReference);
        } else if (ref.isStatic()) {
            target = this.createTypeAccess(qualifiedNameReference, ref);
        } else if (!ref.isStatic() && !ref.getDeclaringType().isAnonymous()) {
            target = !JDTTreeBuilderQuery.isResolvedField(qualifiedNameReference) ? this.createTypeAccessNoClasspath(qualifiedNameReference) : this.jdtTreeBuilder.getFactory().Code().createThisAccess(this.jdtTreeBuilder.getReferencesBuilder().getTypeReference(qualifiedNameReference.actualReceiverType), true);
        }
        return target;
    }

    <T> CtParameter<T> createParameter(Argument argument) {
        CtParameter p = this.jdtTreeBuilder.getFactory().Core().createParameter();
        p.setSimpleName(CharOperation.charToString(argument.name));
        p.setVarArgs(argument.isVarArgs());
        p.setExtendedModifiers(JDTTreeBuilderQuery.getModifiers(argument.modifiers, false, false));
        if (argument.binding != null && argument.binding.type != null && argument.type == null) {
            p.setType(this.jdtTreeBuilder.getReferencesBuilder().getTypeReference(argument.binding.type));
            p.getType().setImplicit(argument.type == null);
            if (p.getType() instanceof CtArrayTypeReference) {
                ((CtArrayTypeReference)p.getType()).getComponentType().setImplicit(argument.type == null);
            }
        }
        return p;
    }

    <T, E extends CtExpression<?>> CtExecutableReferenceExpression<T, E> createExecutableReferenceExpression(ReferenceExpression referenceExpression) {
        CtTypeReference returnType;
        CtExecutableReferenceExpression executableRef = this.jdtTreeBuilder.getFactory().Core().createExecutableReferenceExpression();
        CtExecutableReference executableReference = this.jdtTreeBuilder.getReferencesBuilder().getExecutableReference(referenceExpression.binding);
        if (executableReference == null) {
            executableReference = this.jdtTreeBuilder.getFactory().Core().createExecutableReference();
            executableReference.setSimpleName(CharOperation.charToString(referenceExpression.selector));
            executableReference.setDeclaringType(this.jdtTreeBuilder.getReferencesBuilder().getTypeReference(referenceExpression.lhs.resolvedType));
        }
        executableReference.setType((returnType = executableReference.getType()) == null ? null : returnType.clone());
        executableRef.setExecutable(executableReference);
        return executableRef;
    }

    CtType<?> createType(TypeDeclaration typeDeclaration) {
        CtType type = (typeDeclaration.modifiers & 0x2000) != 0 ? this.jdtTreeBuilder.getFactory().Core().createAnnotationType() : ((typeDeclaration.modifiers & 0x4000) != 0 ? this.jdtTreeBuilder.getFactory().Core().createEnum() : ((typeDeclaration.modifiers & 0x200) != 0 ? this.jdtTreeBuilder.getFactory().Core().createInterface() : this.jdtTreeBuilder.getFactory().Core().createClass()));
        type.setExtendedModifiers(JDTTreeBuilderQuery.getModifiers(typeDeclaration.modifiers, false, false));
        this.jdtTreeBuilder.getContextBuilder().enter(type, typeDeclaration);
        if (typeDeclaration.superInterfaces != null) {
            for (TypeReference ref : typeDeclaration.superInterfaces) {
                CtTypeReference superInterface = this.jdtTreeBuilder.references.buildTypeReference(ref, null);
                type.addSuperInterface(superInterface);
            }
        }
        if (type instanceof CtClass) {
            if (typeDeclaration.superclass != null) {
                ((CtClass)type).setSuperclass(this.jdtTreeBuilder.references.buildTypeReference(typeDeclaration.superclass, (Scope)typeDeclaration.scope));
            }
            if (typeDeclaration.binding != null && (typeDeclaration.binding.isAnonymousType() || typeDeclaration.binding instanceof LocalTypeBinding && typeDeclaration.binding.enclosingMethod() != null)) {
                type.setSimpleName(JDTTreeBuilderHelper.computeAnonymousName(typeDeclaration.binding.constantPoolName()));
            } else {
                type.setSimpleName(new String(typeDeclaration.name));
            }
        } else {
            type.setSimpleName(new String(typeDeclaration.name));
        }
        return type;
    }

    CtModule createModule(ModuleDeclaration moduleDeclaration) {
        CtModule module = this.jdtTreeBuilder.getFactory().Module().getOrCreate(new String(moduleDeclaration.moduleName));
        module.setIsOpenModule(moduleDeclaration.isOpen());
        this.jdtTreeBuilder.getContextBuilder().enter(module, moduleDeclaration);
        if (moduleDeclaration.requires != null && moduleDeclaration.requires.length > 0) {
            ArrayList<CtModuleRequirement> moduleRequirements = new ArrayList<CtModuleRequirement>();
            for (ModuleStatement moduleStatement : moduleDeclaration.requires) {
                moduleRequirements.add(this.createModuleRequirement((RequiresStatement)moduleStatement));
            }
            module.setRequiredModules(moduleRequirements);
        }
        if (moduleDeclaration.exports != null && moduleDeclaration.exports.length > 0) {
            ArrayList<CtPackageExport> moduleExports = new ArrayList<CtPackageExport>();
            for (ModuleStatement moduleStatement : moduleDeclaration.exports) {
                moduleExports.add(this.createModuleExport((ExportsStatement)moduleStatement));
            }
            module.setExportedPackages(moduleExports);
        }
        if (moduleDeclaration.opens != null && moduleDeclaration.opens.length > 0) {
            ArrayList<CtPackageExport> moduleOpens = new ArrayList<CtPackageExport>();
            for (ModuleStatement moduleStatement : moduleDeclaration.opens) {
                moduleOpens.add(this.createModuleExport((OpensStatement)moduleStatement));
            }
            module.setOpenedPackages(moduleOpens);
        }
        if (moduleDeclaration.uses != null && moduleDeclaration.uses.length > 0) {
            ArrayList<CtUsedService> consumedServices = new ArrayList<CtUsedService>();
            for (ModuleStatement moduleStatement : moduleDeclaration.uses) {
                consumedServices.add(this.createUsedService((UsesStatement)moduleStatement));
            }
            module.setUsedServices(consumedServices);
        }
        if (moduleDeclaration.services != null && moduleDeclaration.services.length > 0) {
            ArrayList<CtProvidedService> moduleProvidedServices = new ArrayList<CtProvidedService>();
            for (ModuleStatement moduleStatement : moduleDeclaration.services) {
                moduleProvidedServices.add(this.createModuleProvidedService((ProvidesStatement)moduleStatement));
            }
            module.setProvidedServices(moduleProvidedServices);
        }
        module.setPosition(this.jdtTreeBuilder.getPositionBuilder().buildPosition(moduleDeclaration.declarationSourceStart, moduleDeclaration.declarationSourceEnd));
        return module;
    }

    CtUsedService createUsedService(UsesStatement usesStatement) {
        CtTypeReference typeReference = this.jdtTreeBuilder.references.getTypeReference(usesStatement.serviceInterface);
        CtUsedService usedService = this.jdtTreeBuilder.getFactory().Module().createUsedService(typeReference);
        usedService.setPosition(this.jdtTreeBuilder.getPositionBuilder().buildPosition(usesStatement.sourceStart, usesStatement.sourceEnd));
        return usedService;
    }

    CtModuleRequirement createModuleRequirement(RequiresStatement requiresStatement) {
        int sourceStart = requiresStatement.sourceStart;
        int sourceEnd = requiresStatement.sourceEnd;
        CtModuleReference ctModuleReference = this.jdtTreeBuilder.references.getModuleReference(requiresStatement.module);
        CtModuleRequirement moduleRequirement = this.jdtTreeBuilder.getFactory().Module().createModuleRequirement(ctModuleReference);
        HashSet<CtModuleRequirement.RequiresModifier> modifiers = new HashSet<CtModuleRequirement.RequiresModifier>();
        if (requiresStatement.isStatic()) {
            modifiers.add(CtModuleRequirement.RequiresModifier.STATIC);
        }
        if (requiresStatement.isTransitive()) {
            modifiers.add(CtModuleRequirement.RequiresModifier.TRANSITIVE);
        }
        moduleRequirement.setRequiresModifiers(modifiers);
        moduleRequirement.setPosition(this.jdtTreeBuilder.getPositionBuilder().buildPosition(sourceStart, sourceEnd));
        return moduleRequirement;
    }

    CtPackageExport createModuleExport(ExportsStatement exportsStatement) {
        String packageName = new String(exportsStatement.pkgName);
        int sourceStart = exportsStatement.sourceStart;
        int sourceEnd = exportsStatement.sourceEnd;
        CtPackageReference ctPackageReference = this.jdtTreeBuilder.references.getPackageReference(packageName);
        CtPackageExport moduleExport = this.jdtTreeBuilder.getFactory().Module().createPackageExport(ctPackageReference);
        if (exportsStatement.targets != null && exportsStatement.targets.length > 0) {
            ArrayList<CtModuleReference> moduleReferences = new ArrayList<CtModuleReference>();
            for (ModuleReference moduleReference : exportsStatement.targets) {
                moduleReferences.add(this.jdtTreeBuilder.references.getModuleReference(moduleReference));
            }
            moduleExport.setTargetExport(moduleReferences);
        }
        moduleExport.setPosition(this.jdtTreeBuilder.getPositionBuilder().buildPosition(sourceStart, sourceEnd));
        return moduleExport;
    }

    CtPackageExport createModuleExport(OpensStatement opensStatement) {
        String packageName = new String(opensStatement.pkgName);
        int sourceStart = opensStatement.sourceStart;
        int sourceEnd = opensStatement.sourceEnd;
        CtPackageReference ctPackageReference = this.jdtTreeBuilder.references.getPackageReference(packageName);
        CtPackageExport moduleExport = this.jdtTreeBuilder.getFactory().Module().createPackageExport(ctPackageReference);
        if (opensStatement.targets != null && opensStatement.targets.length > 0) {
            ArrayList<CtModuleReference> moduleReferences = new ArrayList<CtModuleReference>();
            for (ModuleReference moduleReference : opensStatement.targets) {
                moduleReferences.add(this.jdtTreeBuilder.references.getModuleReference(moduleReference));
            }
            moduleExport.setTargetExport(moduleReferences);
        }
        moduleExport.setPosition(this.jdtTreeBuilder.getPositionBuilder().buildPosition(sourceStart, sourceEnd));
        return moduleExport;
    }

    CtProvidedService createModuleProvidedService(ProvidesStatement providesStatement) {
        int sourceStart = providesStatement.sourceStart;
        int sourceEnd = providesStatement.sourceEnd;
        CtTypeReference provideService = this.jdtTreeBuilder.references.getTypeReference(providesStatement.serviceInterface);
        ArrayList<CtTypeReference> implementations = new ArrayList<CtTypeReference>();
        for (TypeReference typeReference : providesStatement.implementations) {
            implementations.add(this.jdtTreeBuilder.references.getTypeReference(typeReference));
        }
        CtProvidedService providedService = this.jdtTreeBuilder.getFactory().Module().createProvidedService(provideService);
        providedService.setImplementationTypes(implementations);
        providedService.setPosition(this.jdtTreeBuilder.getPositionBuilder().buildPosition(sourceStart, sourceEnd));
        return providedService;
    }
}

