/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.compiler.jdt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.ModuleReference;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.Wildcard;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.CaptureBinding;
import org.eclipse.jdt.internal.compiler.lookup.CatchParameterBinding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.IntersectionTypeBinding18;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.MissingTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.PlainPackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.PolyTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemPackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.VoidTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;
import spoon.reflect.code.CtLambda;
import spoon.reflect.declaration.CtModule;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.factory.PackageFactory;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtCatchVariableReference;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtLocalVariableReference;
import spoon.reflect.reference.CtModuleReference;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtParameterReference;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtVariableReference;
import spoon.reflect.reference.CtWildcardReference;
import spoon.support.compiler.jdt.ASTPair;
import spoon.support.compiler.jdt.ContextBuilder;
import spoon.support.compiler.jdt.JDTTreeBuilder;
import spoon.support.compiler.jdt.JDTTreeBuilderHelper;
import spoon.support.compiler.jdt.JDTTreeBuilderQuery;
import spoon.support.compiler.jdt.TreeBuilderCompiler;
import spoon.support.reflect.CtExtendedModifier;

public class ReferenceBuilder {
    private Map<TypeBinding, CtTypeReference> exploringParameterizedBindings = new HashMap<TypeBinding, CtTypeReference>();
    private boolean bounds = false;
    private final JDTTreeBuilder jdtTreeBuilder;
    final Map<TypeBinding, CtTypeReference> bindingCache = new HashMap<TypeBinding, CtTypeReference>();

    ReferenceBuilder(JDTTreeBuilder jdtTreeBuilder) {
        this.jdtTreeBuilder = jdtTreeBuilder;
    }

    private CtTypeReference<?> getBoundedTypeReference(TypeBinding binding) {
        this.bounds = true;
        CtTypeReference ref = this.getTypeReference(binding);
        this.bounds = false;
        return ref;
    }

    <T> CtTypeReference<T> buildTypeReference(TypeReference type, Scope scope) {
        return this.buildTypeReference(type, scope, false);
    }

    <T> CtTypeReference<T> buildTypeReference(TypeReference type, Scope scope, boolean isTypeCast) {
        if (type == null) {
            return null;
        }
        CtTypeReference<T> typeReference = this.getTypeReference(type.resolvedType, type);
        return this.buildTypeReferenceInternal(typeReference, type, scope, isTypeCast);
    }

    <T> CtTypeReference<T> buildTypeReference(QualifiedTypeReference type, Scope scope) {
        CtTypeReference<T> ref;
        TypeBinding receiverType;
        CtTypeReference<T> accessedType = this.buildTypeReference((TypeReference)type, scope);
        TypeBinding typeBinding = receiverType = type != null ? type.resolvedType : null;
        if (receiverType != null && (ref = this.getQualifiedTypeReference(type.tokens, receiverType, receiverType.enclosingType(), new JDTTreeBuilder.OnAccessListener(){

            @Override
            public boolean onAccess(char[][] tokens, int index) {
                return true;
            }
        })) != null) {
            accessedType = ref;
        }
        return accessedType;
    }

    private CtTypeParameterReference buildTypeParameterReference(TypeReference type, Scope scope) {
        if (type == null) {
            return null;
        }
        return (CtTypeParameterReference)this.buildTypeReferenceInternal(this.getTypeParameterReference(type.resolvedType, type), type, scope, false);
    }

    private <T> CtTypeReference<T> buildTypeReferenceInternal(CtTypeReference<T> typeReference, TypeReference type, Scope scope, boolean isTypeCast) {
        if (type == null) {
            return null;
        }
        CtTypeReference<Object> currentReference = typeReference;
        for (int position = type.getTypeName().length - 1; position >= 0 && currentReference != null; currentReference = currentReference.getDeclaringType(), --position) {
            this.jdtTreeBuilder.getContextBuilder().isBuildTypeCast = isTypeCast;
            this.jdtTreeBuilder.getContextBuilder().enter(currentReference, type);
            this.jdtTreeBuilder.getContextBuilder().isBuildTypeCast = false;
            if (type.annotations != null && type.annotations.length - 1 <= position && type.annotations[position] != null && type.annotations[position].length > 0) {
                for (Annotation annotation : type.annotations[position]) {
                    if (scope instanceof ClassScope) {
                        annotation.traverse((ASTVisitor)this.jdtTreeBuilder, (ClassScope)scope);
                        continue;
                    }
                    if (scope instanceof BlockScope) {
                        annotation.traverse((ASTVisitor)this.jdtTreeBuilder, (BlockScope)scope);
                        continue;
                    }
                    annotation.traverse((ASTVisitor)this.jdtTreeBuilder, (BlockScope)null);
                }
            }
            if (type.getTypeArguments() != null && type.getTypeArguments().length - 1 <= position && type.getTypeArguments()[position] != null && type.getTypeArguments()[position].length > 0) {
                CtTypeReference<Object> componentReference = this.getTypeReferenceOfArrayComponent(currentReference);
                componentReference.getActualTypeArguments().clear();
                for (TypeReference typeArgument : type.getTypeArguments()[position]) {
                    if (typeArgument instanceof Wildcard || typeArgument.resolvedType instanceof WildcardBinding || typeArgument.resolvedType instanceof TypeVariableBinding) {
                        componentReference.addActualTypeArgument(this.buildTypeParameterReference(typeArgument, scope));
                        continue;
                    }
                    componentReference.addActualTypeArgument(this.buildTypeReference(typeArgument, scope));
                }
            } else if ((type instanceof ParameterizedSingleTypeReference || type instanceof ParameterizedQualifiedTypeReference) && !this.isTypeArgumentExplicit(type.getTypeArguments())) {
                for (CtTypeReference<?> actualTypeArgument : currentReference.getActualTypeArguments()) {
                    actualTypeArgument.setImplicit(true);
                    if (!(actualTypeArgument instanceof CtArrayTypeReference)) continue;
                    ((CtArrayTypeReference)actualTypeArgument).getComponentType().setImplicit(true);
                }
            }
            if (type instanceof Wildcard && typeReference instanceof CtWildcardReference) {
                ((CtWildcardReference)typeReference).setBoundingType(this.buildTypeReference(((Wildcard)type).bound, scope));
            }
            this.jdtTreeBuilder.getContextBuilder().exit(type);
        }
        if (type instanceof SingleTypeReference) {
            typeReference.setSimplyQualified(true);
        } else if (type instanceof QualifiedTypeReference) {
            this.jdtTreeBuilder.getHelper();
            JDTTreeBuilderHelper.handleImplicit((QualifiedTypeReference)type, typeReference);
        }
        return typeReference;
    }

    private CtTypeReference<?> getTypeReferenceOfArrayComponent(CtTypeReference<?> currentReference) {
        while (currentReference instanceof CtArrayTypeReference) {
            currentReference = ((CtArrayTypeReference)currentReference).getComponentType();
        }
        return currentReference;
    }

    private boolean isTypeArgumentExplicit(TypeReference[][] typeArguments) {
        if (typeArguments == null) {
            return true;
        }
        boolean isGenericTypeExplicit = true;
        for (TypeReference[] typeArgument : typeArguments) {
            boolean bl = isGenericTypeExplicit = typeArgument != null && typeArgument.length > 0;
            if (isGenericTypeExplicit) break;
        }
        return isGenericTypeExplicit;
    }

    <T> CtTypeReference<T> getQualifiedTypeReference(char[][] tokens, TypeBinding receiverType, ReferenceBinding enclosingType, JDTTreeBuilder.OnAccessListener listener) {
        List<CtExtendedModifier> listPublicProtected = Arrays.asList(new CtExtendedModifier(ModifierKind.PUBLIC), new CtExtendedModifier(ModifierKind.PROTECTED));
        if (enclosingType != null && Collections.disjoint(listPublicProtected, JDTTreeBuilderQuery.getModifiers(enclosingType.modifiers, false, false))) {
            TypeBinding accessBinding;
            int i2;
            String access = "";
            CompilationUnitDeclaration[] units = ((TreeBuilderCompiler)this.jdtTreeBuilder.getContextBuilder().compilationunitdeclaration.scope.environment.typeRequestor).unitsToProcess;
            for (i2 = 0; i2 < tokens.length; ++i2) {
                char[][] qualified = (char[][])Arrays.copyOfRange(tokens, 0, i2 + 1);
                if (JDTTreeBuilderQuery.searchPackage(qualified, units) != null) continue;
                access = CharOperation.toString(qualified);
                break;
            }
            if (!access.contains(".")) {
                access = JDTTreeBuilderQuery.searchType(access, this.jdtTreeBuilder.getContextBuilder().compilationunitdeclaration.imports);
            }
            if ((accessBinding = JDTTreeBuilderQuery.searchTypeBinding(access, units)) != null && listener.onAccess(tokens, i2)) {
                TypeBinding superClassBinding = JDTTreeBuilderQuery.searchTypeBinding(accessBinding.superclass(), CharOperation.charToString(tokens[i2 + 1]));
                if (superClassBinding != null) {
                    return this.getTypeReference(superClassBinding.clone(accessBinding));
                }
                return this.getTypeReference(receiverType);
            }
            return this.getTypeReference(receiverType);
        }
        return null;
    }

    CtReference getDeclaringReferenceFromImports(char[] expectedName) {
        CompilationUnitDeclaration cuDeclaration = this.jdtTreeBuilder.getContextBuilder().compilationunitdeclaration;
        if (cuDeclaration == null) {
            return null;
        }
        LookupEnvironment environment = cuDeclaration.scope.environment;
        if (cuDeclaration.imports != null) {
            for (ImportReference anImport : cuDeclaration.imports) {
                if (!CharOperation.equals(anImport.getImportName()[anImport.getImportName().length - 1], expectedName)) continue;
                if (anImport.isStatic()) {
                    int indexDeclaring = 2;
                    if ((anImport.bits & 0x20000) != 0) {
                        indexDeclaring = 1;
                    }
                    char[][] packageName = CharOperation.subarray(anImport.getImportName(), 0, anImport.getImportName().length - indexDeclaring);
                    char[][] className = CharOperation.subarray(anImport.getImportName(), anImport.getImportName().length - indexDeclaring, anImport.getImportName().length - (indexDeclaring - 1));
                    try {
                        PackageBinding aPackage = packageName.length != 0 ? environment.createPackage(packageName) : null;
                        MissingTypeBinding declaringType = environment.createMissingType(aPackage, className);
                        this.jdtTreeBuilder.getContextBuilder().ignoreComputeImports = true;
                        CtTypeReference typeReference = this.getTypeReference(declaringType);
                        this.jdtTreeBuilder.getContextBuilder().ignoreComputeImports = false;
                        return typeReference;
                    }
                    catch (NullPointerException e) {
                        return null;
                    }
                }
                PackageBinding packageBinding = null;
                char[][] chars = CharOperation.subarray(anImport.getImportName(), 0, anImport.getImportName().length - 1);
                if (chars.length > 0) {
                    Binding someBinding = cuDeclaration.scope.findImport(chars, false, false);
                    if (someBinding != null && someBinding.isValidBinding() && someBinding instanceof PackageBinding) {
                        packageBinding = (PackageBinding)someBinding;
                    } else {
                        try {
                            packageBinding = environment.createPackage(chars);
                        }
                        catch (NullPointerException e) {
                            packageBinding = null;
                        }
                    }
                }
                if (packageBinding == null || packageBinding instanceof ProblemPackageBinding) {
                    packageBinding = new PackageBinding(chars, null, environment, environment.module){

                        @Override
                        public PlainPackageBinding getIncarnation(ModuleBinding arg0) {
                            return null;
                        }
                    };
                }
                return this.getPackageReference(packageBinding);
            }
        }
        return null;
    }

    <T> CtExecutableReference<T> getExecutableReference(MethodBinding exec) {
        ArrayList parameters;
        if (exec == null) {
            return null;
        }
        CtExecutableReference<T> ref = this.jdtTreeBuilder.getFactory().Core().createExecutableReference();
        if (exec.isConstructor()) {
            ref.setSimpleName("<init>");
            if (exec.returnType instanceof VoidTypeBinding) {
                ref.setType(this.getTypeReference((TypeBinding)exec.declaringClass, true));
            } else {
                ref.setType(this.getTypeReference(exec.returnType, true));
            }
        } else {
            ref.setSimpleName(new String(exec.selector));
            ref.setType(this.getTypeReference(exec.returnType, true));
        }
        if (exec instanceof ProblemMethodBinding) {
            if (exec.declaringClass != null && Arrays.asList(exec.declaringClass.methods()).contains(exec)) {
                ref.setDeclaringType(this.getTypeReference(exec.declaringClass));
            } else {
                CtReference declaringType = this.getDeclaringReferenceFromImports(exec.constantPoolName());
                if (declaringType instanceof CtTypeReference) {
                    ref.setDeclaringType((CtTypeReference)declaringType);
                }
            }
            if (exec.isConstructor()) {
                ref.setDeclaringType(this.getTypeReference(exec.declaringClass));
            }
            ref.setStatic(true);
        } else {
            if (exec.isConstructor() && !(exec.returnType instanceof VoidTypeBinding)) {
                ref.setDeclaringType(this.getTypeReference(exec.returnType));
            } else {
                ref.setDeclaringType(this.getTypeReference(exec.declaringClass));
            }
            ref.setStatic(exec.isStatic());
        }
        if (exec.declaringClass instanceof ParameterizedTypeBinding) {
            ref.setDeclaringType(this.getTypeReference(exec.declaringClass.actualType()));
        }
        if (exec.original() != null) {
            parameters = new ArrayList(exec.original().parameters.length);
            for (TypeBinding b : exec.original().parameters) {
                parameters.add(this.getTypeReference(b, true));
            }
            ref.setParameters(parameters);
        } else if (exec.parameters != null) {
            parameters = new ArrayList();
            for (TypeBinding b : exec.parameters) {
                parameters.add(this.getTypeReference(b, true));
            }
            ref.setParameters(parameters);
        }
        return ref;
    }

    <T> CtExecutableReference<T> getExecutableReference(AllocationExpression allocationExpression) {
        CtExecutableReference<T> ref;
        if (allocationExpression.binding != null) {
            ref = this.getExecutableReference(allocationExpression.binding);
        } else {
            ref = this.jdtTreeBuilder.getFactory().Core().createExecutableReference();
            ref.setSimpleName("<init>");
            ref.setDeclaringType(this.getTypeReference(null, allocationExpression.type));
            ArrayList parameters = new ArrayList(allocationExpression.argumentTypes.length);
            for (TypeBinding b : allocationExpression.argumentTypes) {
                parameters.add(this.getTypeReference(b, true));
            }
            ref.setParameters(parameters);
        }
        if (allocationExpression.type == null) {
            ref.setType(this.getTypeReference(allocationExpression.expectedType(), true));
        }
        return ref;
    }

    <T> CtExecutableReference<T> getExecutableReference(MessageSend messageSend) {
        if (messageSend.binding != null) {
            return this.getExecutableReference(messageSend.binding);
        }
        CtExecutableReference<T> ref = this.jdtTreeBuilder.getFactory().Core().createExecutableReference();
        ref.setSimpleName(CharOperation.charToString(messageSend.selector));
        ref.setType(this.getTypeReference(messageSend.expectedType(), true));
        if (messageSend.receiver.resolvedType == null) {
            ref.setStatic(true);
            if (messageSend.receiver instanceof SingleNameReference) {
                ref.setDeclaringType(this.jdtTreeBuilder.getHelper().createTypeAccessNoClasspath((SingleNameReference)messageSend.receiver).getAccessedType());
            } else if (messageSend.receiver instanceof QualifiedNameReference) {
                ref.setDeclaringType(this.jdtTreeBuilder.getHelper().createTypeAccessNoClasspath((QualifiedNameReference)messageSend.receiver).getAccessedType());
            }
        } else {
            ref.setDeclaringType(this.getTypeReference(messageSend.receiver.resolvedType));
        }
        if (messageSend.arguments != null) {
            ArrayList parameters = new ArrayList();
            for (Expression expression : messageSend.arguments) {
                parameters.add(this.getTypeReference(expression.resolvedType, true));
            }
            ref.setParameters(parameters);
        }
        return ref;
    }

    private CtPackageReference getPackageReference(PackageBinding reference) {
        return this.getPackageReference(new String(reference.shortReadableName()));
    }

    public CtPackageReference getPackageReference(String name) {
        if (name.isEmpty()) {
            return this.jdtTreeBuilder.getFactory().Package().topLevel();
        }
        CtPackageReference ref = this.jdtTreeBuilder.getFactory().Core().createPackageReference();
        ref.setSimpleName(name);
        return ref;
    }

    <T> CtTypeReference<T> getTypeReference(TypeBinding binding, TypeReference ref) {
        CtTypeReference<T> ctRef = this.getTypeReference(binding);
        if (ctRef != null && this.isCorrectTypeReference(ref)) {
            this.insertGenericTypesInNoClasspathFromJDTInSpoon(ref, ctRef);
        } else {
            ctRef = this.getTypeReference(ref);
        }
        if (ref instanceof SingleTypeReference) {
            ctRef.setSimplyQualified(true);
        } else if (ref instanceof QualifiedTypeReference) {
            this.jdtTreeBuilder.getHelper();
            JDTTreeBuilderHelper.handleImplicit((QualifiedTypeReference)ref, ctRef);
        }
        return ctRef;
    }

    CtTypeReference<Object> getTypeParameterReference(TypeBinding binding, TypeReference ref) {
        CtTypeParameterReference ctRef = this.getTypeReference(binding);
        if (ctRef != null && this.isCorrectTypeReference(ref)) {
            if (!(ctRef instanceof CtTypeParameterReference)) {
                CtTypeParameterReference typeParameterRef = this.jdtTreeBuilder.getFactory().Core().createTypeParameterReference();
                typeParameterRef.setSimpleName(ctRef.getSimpleName());
                typeParameterRef.setDeclaringType(ctRef.getDeclaringType());
                typeParameterRef.setPackage(ctRef.getPackage());
                ctRef = typeParameterRef;
            }
            this.insertGenericTypesInNoClasspathFromJDTInSpoon(ref, ctRef);
            return ctRef;
        }
        return this.getTypeParameterReference(CharOperation.toString(ref.getParameterizedTypeName()));
    }

    private boolean isCorrectTypeReference(TypeReference ref) {
        if (ref.resolvedType == null) {
            return false;
        }
        if (!(ref.resolvedType instanceof ProblemReferenceBinding)) {
            return true;
        }
        String[] compoundName = CharOperation.charArrayToStringArray(((ProblemReferenceBinding)ref.resolvedType).compoundName);
        String[] typeName = CharOperation.charArrayToStringArray(ref.getTypeName());
        if (compoundName.length == 0 || typeName.length == 0) {
            return false;
        }
        return compoundName[compoundName.length - 1].equals(typeName[typeName.length - 1]);
    }

    private <T> void insertGenericTypesInNoClasspathFromJDTInSpoon(TypeReference original, CtTypeReference<T> type) {
        if (original.resolvedType instanceof ProblemReferenceBinding && original.getTypeArguments() != null) {
            for (TypeReference[] typeReferences : original.getTypeArguments()) {
                if (typeReferences == null) continue;
                for (TypeReference typeReference : typeReferences) {
                    type.addActualTypeArgument(this.getTypeReference(typeReference.resolvedType));
                }
            }
        }
        if (original.isParameterizedTypeReference() && !type.isParameterized()) {
            this.tryRecoverTypeArguments(type);
        }
    }

    private void tryRecoverTypeArguments(CtTypeReference<?> type) {
        Deque<ASTPair> stack = this.jdtTreeBuilder.getContextBuilder().stack;
        if (stack.peek() == null || !(stack.peek().node instanceof AllocationExpression)) {
            return;
        }
        AllocationExpression alloc = (AllocationExpression)stack.peek().node;
        if (alloc.expectedType() == null || !(alloc.expectedType() instanceof ParameterizedTypeBinding)) {
            type.addActualTypeArgument((CtTypeReference<?>)this.jdtTreeBuilder.getFactory().Type().OMITTED_TYPE_ARG_TYPE.clone());
        } else {
            ParameterizedTypeBinding expectedType = (ParameterizedTypeBinding)alloc.expectedType();
            for (TypeBinding binding : expectedType.typeArguments()) {
                CtTypeReference typeArgRef = this.getTypeReference(binding);
                typeArgRef.setImplicit(true);
                type.addActualTypeArgument(typeArgRef);
            }
        }
    }

    <T> CtTypeReference<T> getTypeReference(TypeReference ref) {
        CtTypeReference<T> main;
        int index;
        if (ref == null) {
            return null;
        }
        CtTypeReference<T> res = null;
        CtTypeReference<T> inner = null;
        String[] namesParameterized = CharOperation.charArrayToStringArray(ref.getParameterizedTypeName());
        String nameParameterized = CharOperation.toString(ref.getParameterizedTypeName());
        String typeName = CharOperation.toString(ref.getTypeName());
        for (index = namesParameterized.length - 1; index >= 0 && (main = this.getTypeReference(namesParameterized[index])) != null; --index) {
            if (res == null) {
                res = main;
            } else {
                inner.setDeclaringType(main);
            }
            inner = main;
        }
        if (res == null) {
            return this.jdtTreeBuilder.getFactory().Type().createReference(nameParameterized);
        }
        if (inner.getPackage() == null) {
            PackageFactory packageFactory = this.jdtTreeBuilder.getFactory().Package();
            CtPackageReference packageReference = index >= 0 ? packageFactory.getOrCreate(this.concatSubArray(namesParameterized, index)).getReference() : packageFactory.topLevel();
            inner.setPackage(packageReference);
        }
        if (!res.toStringDebug().replace(", ?", ",?").endsWith(nameParameterized)) {
            return this.jdtTreeBuilder.getFactory().Type().createReference(typeName);
        }
        return res;
    }

    private String concatSubArray(String[] a, int endIndex) {
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < endIndex; ++i2) {
            sb.append(a[i2]).append('.');
        }
        sb.append(a[endIndex]);
        return sb.toString();
    }

    public <T> CtTypeReference<T> getTypeReference(String name) {
        CtTypeReference main = null;
        if (name.matches(".*(<.+>)")) {
            Pattern pattern = Pattern.compile("([^<]+)<(.+)>");
            Matcher m = pattern.matcher(name);
            main = name.startsWith("?") ? this.jdtTreeBuilder.getFactory().Core().createWildcardReference() : this.jdtTreeBuilder.getFactory().Core().createTypeReference();
            if (m.find()) {
                String[] split;
                main.setSimpleName(m.group(1));
                for (String parameter : split = m.group(2).split(",")) {
                    main.addActualTypeArgument(this.getTypeParameterReference(parameter.trim()));
                }
            }
        } else if (Character.isUpperCase(name.charAt(0))) {
            if (name.endsWith("[]")) {
                main = this.jdtTreeBuilder.getFactory().Core().createArrayTypeReference();
                name = name.substring(0, name.length() - 2);
                ((CtArrayTypeReference)main).setComponentType(this.getTypeReference(name));
            } else {
                main = this.jdtTreeBuilder.getFactory().Core().createTypeReference();
            }
            main.setSimpleName(name);
            CtReference declaring = this.getDeclaringReferenceFromImports(name.toCharArray());
            this.setPackageOrDeclaringType(main, declaring);
        } else if (name.startsWith("?")) {
            return this.jdtTreeBuilder.getFactory().Core().createWildcardReference();
        }
        return main;
    }

    private CtTypeReference<Object> getTypeParameterReference(String name) {
        CtTypeReference<Object> param = null;
        if (name.contains("extends") || name.contains("super")) {
            String[] split = name.contains("extends") ? name.split("extends") : name.split("super");
            param = this.getTypeParameterReference(split[0].trim());
            if (param instanceof CtWildcardReference) {
                param.setBoundingType(this.getTypeReference(split[split.length - 1].trim()));
            }
        } else if (name.matches(".*(<.+>)")) {
            Pattern pattern = Pattern.compile("([^<]+)<(.+)>");
            Matcher m = pattern.matcher(name);
            if (m.find()) {
                String[] split;
                param = this.jdtTreeBuilder.getFactory().Core().createTypeReference();
                param.setSimpleName(m.group(1));
                for (String parameter : split = m.group(2).split(",")) {
                    param.addActualTypeArgument(this.getTypeParameterReference(parameter.trim()));
                }
            }
        } else if (name.contains("?")) {
            param = this.jdtTreeBuilder.getFactory().Core().createWildcardReference();
        } else {
            param = this.jdtTreeBuilder.getFactory().Core().createTypeParameterReference();
            param.setSimpleName(name);
        }
        return param;
    }

    <T> CtTypeReference<T> getTypeReference(TypeBinding binding) {
        return this.getTypeReference(binding, false);
    }

    <T> CtTypeReference<T> getTypeReference(TypeBinding binding, boolean resolveGeneric) {
        CtReference ref;
        if (binding == null) {
            return null;
        }
        if (binding instanceof RawTypeBinding) {
            ref = this.getTypeReference(((ParameterizedTypeBinding)binding).genericType());
        } else if (binding instanceof ParameterizedTypeBinding) {
            if (binding.actualType() != null && binding.actualType() instanceof LocalTypeBinding) {
                ref = this.getTypeReference(binding.actualType());
            } else {
                ref = this.jdtTreeBuilder.getFactory().Core().createTypeReference();
                this.exploringParameterizedBindings.put(binding, (CtTypeReference)ref);
                if (binding.isAnonymousType()) {
                    ref.setSimpleName("");
                } else {
                    ref.setSimpleName(String.valueOf(binding.sourceName()));
                    if (binding.enclosingType() != null) {
                        ref.setDeclaringType(this.getTypeReference(binding.enclosingType()));
                    } else {
                        ref.setPackage(this.getPackageReference(binding.getPackage()));
                    }
                }
            }
            if (binding.actualType() instanceof MissingTypeBinding) {
                ref = this.getTypeReference(binding.actualType());
            }
            if (((ParameterizedTypeBinding)binding).arguments != null) {
                for (TypeBinding b : ((ParameterizedTypeBinding)binding).arguments) {
                    CtTypeReference<T> typeRefB;
                    if (this.bindingCache.containsKey(b)) {
                        ref.addActualTypeArgument(this.getCtCircularTypeReference(b));
                        continue;
                    }
                    if (!this.exploringParameterizedBindings.containsKey(b)) {
                        this.exploringParameterizedBindings.put(b, null);
                        typeRefB = this.getTypeReference(b);
                        this.exploringParameterizedBindings.put(b, typeRefB);
                        ref.addActualTypeArgument(typeRefB);
                        continue;
                    }
                    typeRefB = this.exploringParameterizedBindings.get(b);
                    if (typeRefB == null) continue;
                    ref.addActualTypeArgument((CtTypeReference<?>)typeRefB.clone());
                }
            }
        } else if (binding instanceof MissingTypeBinding) {
            ref = this.jdtTreeBuilder.getFactory().Core().createTypeReference();
            ref.setSimpleName(new String(binding.sourceName()));
            ref.setPackage(this.getPackageReference(binding.getPackage()));
            if (!this.jdtTreeBuilder.getContextBuilder().ignoreComputeImports) {
                CtReference declaring = this.getDeclaringReferenceFromImports(binding.sourceName());
                if (declaring instanceof CtPackageReference) {
                    ref.setPackage((CtPackageReference)declaring);
                } else if (declaring instanceof CtTypeReference) {
                    ref.setDeclaringType((CtTypeReference)declaring);
                }
            }
        } else if (binding instanceof BinaryTypeBinding) {
            ref = this.jdtTreeBuilder.getFactory().Core().createTypeReference();
            if (binding.enclosingType() != null) {
                ref.setDeclaringType(this.getTypeReference(binding.enclosingType()));
            } else {
                CtPackageReference packageReference = this.getPackageReference(binding.getPackage());
                ref.setPackage(packageReference);
            }
            ref.setSimpleName(new String(binding.sourceName()));
        } else if (binding instanceof TypeVariableBinding) {
            boolean oldBounds = this.bounds;
            if (binding instanceof CaptureBinding) {
                ref = this.jdtTreeBuilder.getFactory().Core().createWildcardReference();
                this.bounds = true;
            } else {
                TypeVariableBinding typeParamBinding = (TypeVariableBinding)binding;
                if (resolveGeneric) {
                    ReferenceBinding superClass = typeParamBinding.superclass;
                    ReferenceBinding[] superInterfaces = typeParamBinding.superInterfaces();
                    ReferenceBinding[] refSuperClass = null;
                    if (superClass != null && superClass.superclass() != null) {
                        if (!(superClass instanceof ParameterizedTypeBinding) || !this.exploringParameterizedBindings.containsKey(superClass)) {
                            refSuperClass = this.getTypeReference((TypeBinding)superClass, resolveGeneric);
                        }
                    } else if (superInterfaces != null && superInterfaces.length == 1) {
                        refSuperClass = this.getTypeReference((TypeBinding)superInterfaces[0], resolveGeneric);
                    }
                    if (refSuperClass == null) {
                        refSuperClass = this.jdtTreeBuilder.getFactory().Type().getDefaultBoundingType();
                    }
                    ref = refSuperClass.clone();
                } else {
                    ref = this.jdtTreeBuilder.getFactory().Core().createTypeParameterReference();
                    ref.setSimpleName(new String(binding.sourceName()));
                }
            }
            TypeVariableBinding b = (TypeVariableBinding)binding;
            if (this.bounds) {
                if (b instanceof CaptureBinding && ((CaptureBinding)b).wildcard != null) {
                    this.bounds = oldBounds;
                    return this.getTypeReference((TypeBinding)((CaptureBinding)b).wildcard, resolveGeneric);
                }
                if (b.superclass != null && b.firstBound == b.superclass) {
                    this.bounds = false;
                    this.bindingCache.put(binding, (CtTypeReference)ref);
                    if (ref instanceof CtWildcardReference) {
                        ((CtWildcardReference)ref).setBoundingType(this.getTypeReference((TypeBinding)b.superclass, resolveGeneric));
                    }
                    this.bounds = oldBounds;
                }
            }
            if (this.bounds && b.superInterfaces != null && b.superInterfaces != Binding.NO_SUPERINTERFACES) {
                this.bindingCache.put(binding, (CtTypeReference)ref);
                ArrayList bounds = new ArrayList();
                CtTypeParameterReference typeParameterReference = (CtTypeParameterReference)ref;
                if (!typeParameterReference.isDefaultBoundingType()) {
                    bounds.add(typeParameterReference.getBoundingType());
                }
                for (ReferenceBinding superInterface : b.superInterfaces) {
                    bounds.add(this.getTypeReference((TypeBinding)superInterface, resolveGeneric));
                }
                if (ref instanceof CtWildcardReference) {
                    ((CtWildcardReference)ref).setBoundingType(this.jdtTreeBuilder.getFactory().Type().createIntersectionTypeReferenceWithBounds(bounds));
                }
            }
            if (binding instanceof CaptureBinding) {
                this.bounds = false;
            }
        } else if (binding instanceof BaseTypeBinding) {
            String name = new String(binding.sourceName());
            ref = this.jdtTreeBuilder.getFactory().Core().createTypeReference();
            ref.setSimpleName(name);
        } else if (binding instanceof WildcardBinding) {
            WildcardBinding wildcardBinding = (WildcardBinding)binding;
            CtWildcardReference wref = this.jdtTreeBuilder.getFactory().Core().createWildcardReference();
            ref = wref;
            if (wildcardBinding.boundKind == 2) {
                wref.setUpper(false);
            }
            if (wildcardBinding.bound != null) {
                if (this.bindingCache.containsKey(wildcardBinding.bound)) {
                    wref.setBoundingType(this.getCtCircularTypeReference(wildcardBinding.bound));
                } else {
                    wref.setBoundingType(this.getTypeReference(((WildcardBinding)binding).bound));
                }
            }
        } else if (binding instanceof LocalTypeBinding) {
            ref = this.jdtTreeBuilder.getFactory().Core().createTypeReference();
            if (binding.isAnonymousType()) {
                ref.setSimpleName(JDTTreeBuilderHelper.computeAnonymousName(((SourceTypeBinding)binding).constantPoolName()));
                ref.setDeclaringType(this.getTypeReference(binding.enclosingType()));
            } else {
                ref.setSimpleName(new String(binding.sourceName()));
                if (((LocalTypeBinding)binding).enclosingMethod == null && binding.enclosingType() != null && binding.enclosingType() instanceof LocalTypeBinding) {
                    ref.setDeclaringType(this.getTypeReference(binding.enclosingType()));
                } else if (binding.enclosingMethod() != null) {
                    ref.setSimpleName(JDTTreeBuilderHelper.computeAnonymousName(((SourceTypeBinding)binding).constantPoolName()));
                    ref.setDeclaringType(this.getTypeReference(binding.enclosingType()));
                }
            }
        } else if (binding instanceof SourceTypeBinding) {
            ref = this.jdtTreeBuilder.getFactory().Core().createTypeReference();
            if (binding.isAnonymousType()) {
                ref.setSimpleName(JDTTreeBuilderHelper.computeAnonymousName(((SourceTypeBinding)binding).constantPoolName()));
                ref.setDeclaringType(this.getTypeReference(binding.enclosingType()));
            } else {
                ref.setSimpleName(new String(binding.sourceName()));
                if (binding.enclosingType() != null) {
                    ref.setDeclaringType(this.getTypeReference(binding.enclosingType()));
                } else {
                    ref.setPackage(this.getPackageReference(binding.getPackage()));
                }
            }
        } else if (binding instanceof ArrayBinding) {
            CtArrayTypeReference arrayref = this.jdtTreeBuilder.getFactory().Core().createArrayTypeReference();
            ref = arrayref;
            for (int i2 = 1; i2 < binding.dimensions(); ++i2) {
                CtArrayTypeReference tmp = this.jdtTreeBuilder.getFactory().Core().createArrayTypeReference();
                arrayref.setComponentType(tmp);
                arrayref = tmp;
            }
            arrayref.setComponentType(this.getTypeReference(binding.leafComponentType(), resolveGeneric));
        } else if (binding instanceof PolyTypeBinding) {
            ref = this.jdtTreeBuilder.getFactory().Type().objectType();
        } else if (binding instanceof ProblemReferenceBinding) {
            char c;
            ref = this.jdtTreeBuilder.getFactory().Core().createTypeReference();
            char[] readableName = binding.readableName();
            StringBuilder sb = new StringBuilder();
            for (int i3 = readableName.length - 1; i3 >= 0 && (c = readableName[i3]) != '.'; --i3) {
                sb.append(c);
            }
            sb.reverse();
            ref.setSimpleName(sb.toString());
            CtReference declaring = this.getDeclaringReferenceFromImports(binding.sourceName());
            this.setPackageOrDeclaringType((CtTypeReference<?>)ref, declaring);
        } else if (binding instanceof JDTTreeBuilder.SpoonReferenceBinding) {
            ref = this.jdtTreeBuilder.getFactory().Core().createTypeReference();
            ref.setSimpleName(new String(binding.sourceName()));
            ref.setDeclaringType(this.getTypeReference(binding.enclosingType()));
        } else if (binding instanceof IntersectionTypeBinding18) {
            ArrayList bounds = new ArrayList();
            for (ReferenceBinding superInterface : binding.getIntersectingTypes()) {
                bounds.add(this.getTypeReference(superInterface));
            }
            ref = this.jdtTreeBuilder.getFactory().Type().createIntersectionTypeReferenceWithBounds(bounds);
        } else {
            throw new RuntimeException("Unknown TypeBinding: " + binding.getClass() + " " + binding);
        }
        this.bindingCache.remove(binding);
        this.exploringParameterizedBindings.remove(binding);
        return ref;
    }

    private CtTypeReference<?> getCtCircularTypeReference(TypeBinding b) {
        return this.bindingCache.get(b).clone();
    }

    <T> CtVariableReference<T> getVariableReference(MethodBinding methbin) {
        CtFieldReference<T> ref = this.jdtTreeBuilder.getFactory().Core().createFieldReference();
        ref.setSimpleName(new String(methbin.selector));
        ref.setType(this.getTypeReference(methbin.returnType));
        if (methbin.declaringClass != null) {
            ref.setDeclaringType(this.getTypeReference(methbin.declaringClass));
        } else {
            ref.setDeclaringType(ref.getType());
        }
        return ref;
    }

    <T> CtFieldReference<T> getVariableReference(FieldBinding varbin) {
        CtFieldReference<T> ref = this.jdtTreeBuilder.getFactory().Core().createFieldReference();
        if (varbin == null) {
            return ref;
        }
        ref.setSimpleName(new String(varbin.name));
        ref.setType(this.getTypeReference(varbin.type));
        if (varbin.declaringClass != null) {
            ref.setDeclaringType(this.getTypeReference(varbin.declaringClass));
        } else {
            ref.setDeclaringType((CtTypeReference<?>)(ref.getType() == null ? null : ref.getType().clone()));
        }
        ref.setFinal(varbin.isFinal());
        ref.setStatic((varbin.modifiers & 8) != 0);
        return ref;
    }

    <T> CtFieldReference<T> getVariableReference(FieldBinding fieldBinding, char[] tokens) {
        CtFieldReference<T> ref = this.getVariableReference(fieldBinding);
        if (fieldBinding != null) {
            return ref;
        }
        ref.setSimpleName(CharOperation.charToString(tokens));
        return ref;
    }

    <T> CtVariableReference<T> getVariableReference(VariableBinding varbin) {
        if (varbin instanceof FieldBinding) {
            return this.getVariableReference((FieldBinding)varbin);
        }
        if (varbin instanceof LocalVariableBinding) {
            LocalVariableBinding localVariableBinding = (LocalVariableBinding)varbin;
            if (localVariableBinding.declaration instanceof Argument && localVariableBinding.declaringScope instanceof MethodScope) {
                CtParameterReference<T> ref = this.jdtTreeBuilder.getFactory().Core().createParameterReference();
                ref.setSimpleName(new String(varbin.name));
                ref.setType(this.getTypeReference(varbin.type));
                return ref;
            }
            if (localVariableBinding.declaration.binding instanceof CatchParameterBinding) {
                CtCatchVariableReference<T> ref = this.jdtTreeBuilder.getFactory().Core().createCatchVariableReference();
                ref.setSimpleName(new String(varbin.name));
                CtTypeReference<T> ref2 = this.getTypeReference(varbin.type);
                ref.setType(ref2);
                return ref;
            }
            CtLocalVariableReference<T> ref = this.jdtTreeBuilder.getFactory().Core().createLocalVariableReference();
            ref.setSimpleName(new String(varbin.name));
            CtTypeReference<T> ref2 = this.getTypeReference(varbin.type);
            ref.setType(ref2);
            return ref;
        }
        return null;
    }

    <T> CtVariableReference<T> getVariableReference(ProblemBinding binding) {
        CtFieldReference<T> ref = this.jdtTreeBuilder.getFactory().Core().createFieldReference();
        if (binding == null) {
            return ref;
        }
        ref.setSimpleName(new String(binding.name));
        ref.setType(this.getTypeReference(binding.searchType));
        return ref;
    }

    List<CtTypeReference<?>> getBoundedTypesReferences(TypeBinding[] genericTypeArguments) {
        ArrayList res = new ArrayList(genericTypeArguments.length);
        for (TypeBinding tb : genericTypeArguments) {
            res.add(this.getBoundedTypeReference(tb));
        }
        return res;
    }

    void setPackageOrDeclaringType(CtTypeReference<?> ref, CtReference declaring) {
        block10: {
            if (declaring instanceof CtPackageReference) {
                ref.setPackage((CtPackageReference)declaring);
            } else if (declaring instanceof CtTypeReference) {
                ref.setDeclaringType((CtTypeReference)declaring);
            } else if (declaring == null) {
                try {
                    Class.forName("java.lang." + ref.getSimpleName());
                    CtPackageReference javaLangPackageReference = this.jdtTreeBuilder.getFactory().Core().createPackageReference();
                    javaLangPackageReference.setSimpleName("java.lang");
                    ref.setPackage(javaLangPackageReference);
                }
                catch (ClassNotFoundException | NoClassDefFoundError e) {
                    assert (this.jdtTreeBuilder.getFactory().getEnvironment().getNoClasspath());
                    ContextBuilder ctx = this.jdtTreeBuilder.getContextBuilder();
                    if (ReferenceBuilder.containsStarImport(ctx.compilationunitdeclaration.imports)) {
                        CtPackageReference pkgRef = this.jdtTreeBuilder.getFactory().Core().createPackageReference();
                        pkgRef.setImplicit(true);
                        ref.setPackage(pkgRef);
                        break block10;
                    }
                    ref.setPackage(ctx.compilationUnitSpoon.getDeclaredPackage().getReference());
                }
            } else {
                throw new AssertionError((Object)("unexpected declaring type: " + declaring.getClass() + " of " + declaring));
            }
        }
    }

    void setImplicitPackageOrDeclaringType(CtTypeReference<?> ref, CtReference declaring) {
        CtTypeReference<?> oldDeclaring = ref.getDeclaringType();
        CtPackageReference oldPackage = ref.getPackage();
        this.setPackageOrDeclaringType(ref, declaring);
        CtTypeReference<?> currentDeclaring = ref.getDeclaringType();
        CtPackageReference currentPackage = ref.getPackage();
        if (currentDeclaring != oldDeclaring) {
            currentDeclaring.setImplicit(true);
        }
        if (currentPackage != oldPackage) {
            currentPackage.setImplicit(true);
        }
    }

    private static boolean containsStarImport(ImportReference[] imports) {
        return imports != null && Arrays.stream(imports).anyMatch(imp -> imp.toString().endsWith("*"));
    }

    public CtExecutableReference<?> getLambdaExecutableReference(SingleNameReference singleNameReference) {
        ASTPair potentialLambda = null;
        for (ASTPair astPair : this.jdtTreeBuilder.getContextBuilder().stack) {
            if (!(astPair.node instanceof LambdaExpression)) continue;
            potentialLambda = astPair;
            break;
        }
        if (potentialLambda == null) {
            return null;
        }
        LambdaExpression lambdaJDT = (LambdaExpression)potentialLambda.node;
        for (Argument argument : lambdaJDT.arguments()) {
            if (!CharOperation.equals(argument.name, singleNameReference.token)) continue;
            CtTypeReference declaringType = null;
            if (lambdaJDT.enclosingScope instanceof MethodScope) {
                declaringType = this.jdtTreeBuilder.getReferencesBuilder().getTypeReference(((MethodScope)lambdaJDT.enclosingScope).parent.enclosingSourceType());
            }
            CtLambda ctLambda = (CtLambda)potentialLambda.element;
            ArrayList parametersType = new ArrayList();
            List<CtParameter<?>> parameters = ctLambda.getParameters();
            for (CtParameter<?> parameter : parameters) {
                parametersType.add(this.getMethodParameterType(parameter));
            }
            return this.jdtTreeBuilder.getFactory().Executable().createReference(declaringType, ctLambda.getType(), ctLambda.getSimpleName(), parametersType);
        }
        return null;
    }

    private CtTypeReference<?> getMethodParameterType(CtParameter<?> param) {
        CtTypeReference<Object> paramType = param.getType();
        if (paramType instanceof CtTypeParameterReference) {
            paramType = ((CtTypeParameterReference)paramType).getBoundingType();
        }
        if (paramType == null) {
            paramType = param.getFactory().Type().OBJECT;
        }
        return paramType.clone();
    }

    public CtModuleReference getModuleReference(ModuleReference moduleReference) {
        String moduleName = new String(moduleReference.moduleName);
        CtModule module = this.jdtTreeBuilder.getFactory().Module().getModule(moduleName);
        if (module == null) {
            CtModuleReference ctModuleReference = this.jdtTreeBuilder.getFactory().Core().createModuleReference();
            ctModuleReference.setSimpleName(moduleName);
            return ctModuleReference;
        }
        return module.getReference();
    }
}

