/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.gui;

import java.util.ArrayDeque;
import java.util.Deque;
import javax.swing.tree.DefaultMutableTreeNode;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.path.CtRole;
import spoon.reflect.visitor.CtScanner;

public class SpoonTreeBuilder
extends CtScanner {
    Deque<DefaultMutableTreeNode> nodes;
    DefaultMutableTreeNode root = new DefaultMutableTreeNode("Spoon Tree Root");
    private CtRole roleInParent;

    public SpoonTreeBuilder() {
        this.nodes = new ArrayDeque<DefaultMutableTreeNode>();
        this.nodes.push(this.root);
    }

    private void createNode(Object o, CtRole roleInParent) {
        final String prefix = roleInParent == null ? "" : roleInParent.getCamelCaseName() + ": ";
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(o){
            private static final long serialVersionUID = 1L;

            private String getASTNodeName() {
                return this.getUserObject().getClass().getSimpleName().replaceAll("Impl$", "");
            }

            @Override
            public String toString() {
                String nodeName;
                if (this.getUserObject() instanceof CtNamedElement) {
                    nodeName = this.getASTNodeName() + " - " + ((CtNamedElement)this.getUserObject()).getSimpleName();
                } else {
                    String objectRepresentation;
                    try {
                        objectRepresentation = this.getUserObject().toString();
                    }
                    catch (Exception e) {
                        objectRepresentation = "Failed:" + e.getMessage();
                    }
                    nodeName = this.getASTNodeName() + " - " + objectRepresentation;
                }
                return prefix + nodeName;
            }
        };
        this.nodes.peek().add(node);
        this.nodes.push(node);
    }

    @Override
    public void scan(CtRole role, CtElement element) {
        this.roleInParent = role;
        super.scan(role, element);
    }

    @Override
    public void enter(CtElement element) {
        this.createNode(element, this.roleInParent);
        super.enter(element);
    }

    @Override
    public void exit(CtElement element) {
        this.nodes.pop();
        super.exit(element);
    }

    public DefaultMutableTreeNode getRoot() {
        return this.root;
    }
}

