/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import spoon.SpoonException;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.factory.Factory;
import spoon.reflect.path.CtRole;
import spoon.support.reflect.CtExtendedModifier;
import spoon.support.reflect.declaration.CtElementImpl;

public class CtModifierHandler
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Set<CtExtendedModifier> modifiers = CtElementImpl.emptySet();
    private CtElement element;

    public CtModifierHandler(CtElement element) {
        this.element = element;
    }

    public Factory getFactory() {
        return this.element.getFactory();
    }

    public Set<CtExtendedModifier> getExtendedModifiers() {
        return Collections.unmodifiableSet(this.modifiers);
    }

    public CtModifierHandler setExtendedModifiers(Set<CtExtendedModifier> extendedModifiers) {
        if (extendedModifiers != null && !extendedModifiers.isEmpty()) {
            this.getFactory().getEnvironment().getModelChangeListener().onSetDeleteAll(this.element, CtRole.MODIFIER, this.modifiers, new HashSet<CtExtendedModifier>(this.modifiers));
            if (this.modifiers == CtElementImpl.emptySet()) {
                this.modifiers = new HashSet<CtExtendedModifier>();
            } else {
                this.modifiers.clear();
            }
            for (CtExtendedModifier extendedModifier : extendedModifiers) {
                this.getFactory().getEnvironment().getModelChangeListener().onSetAdd(this.element, CtRole.MODIFIER, this.modifiers, extendedModifier.getKind());
                this.modifiers.add(extendedModifier);
            }
        }
        return this;
    }

    public Set<ModifierKind> getModifiers() {
        return this.modifiers.stream().map(CtExtendedModifier::getKind).collect(Collectors.toSet());
    }

    public boolean hasModifier(ModifierKind modifier) {
        return this.getModifiers().contains((Object)modifier);
    }

    public CtModifierHandler setModifiers(Set<ModifierKind> modifiers) {
        if (modifiers == null) {
            modifiers = Collections.emptySet();
        }
        this.getFactory().getEnvironment().getModelChangeListener().onSetDeleteAll(this.element, CtRole.MODIFIER, this.modifiers, new HashSet<CtExtendedModifier>(this.modifiers));
        this.modifiers.clear();
        for (ModifierKind modifier : modifiers) {
            this.addModifier(modifier);
        }
        return this;
    }

    public CtModifierHandler addModifier(ModifierKind modifier) {
        if (this.modifiers == CtElementImpl.emptySet()) {
            this.modifiers = new HashSet<CtExtendedModifier>();
        }
        this.getFactory().getEnvironment().getModelChangeListener().onSetAdd(this.element, CtRole.MODIFIER, this.modifiers, modifier);
        this.modifiers.remove(new CtExtendedModifier(modifier, true));
        this.modifiers.add(new CtExtendedModifier(modifier));
        return this;
    }

    public CtModifierHandler removeModifier(ModifierKind modifier) {
        if (this.modifiers == CtElementImpl.emptySet()) {
            return this;
        }
        this.getFactory().getEnvironment().getModelChangeListener().onSetDelete(this.element, CtRole.MODIFIER, this.modifiers, modifier);
        this.modifiers.remove(new CtExtendedModifier(modifier));
        this.modifiers.remove(new CtExtendedModifier(modifier, true));
        return this;
    }

    public CtModifierHandler setVisibility(ModifierKind visibility) {
        if (visibility != ModifierKind.PUBLIC && visibility != ModifierKind.PROTECTED && visibility != ModifierKind.PRIVATE) {
            throw new SpoonException("setVisibility could only be called with a private, public or protected argument value. Given argument: " + (Object)((Object)visibility));
        }
        if (this.hasModifier(visibility)) {
            return this;
        }
        if (this.isPublic()) {
            this.removeModifier(ModifierKind.PUBLIC);
        }
        if (this.isProtected()) {
            this.removeModifier(ModifierKind.PROTECTED);
        }
        if (this.isPrivate()) {
            this.removeModifier(ModifierKind.PRIVATE);
        }
        this.addModifier(visibility);
        return this;
    }

    public ModifierKind getVisibility() {
        if (this.isPublic()) {
            return ModifierKind.PUBLIC;
        }
        if (this.isProtected()) {
            return ModifierKind.PROTECTED;
        }
        if (this.isPrivate()) {
            return ModifierKind.PRIVATE;
        }
        return null;
    }

    public boolean isPublic() {
        return this.getModifiers().contains((Object)ModifierKind.PUBLIC);
    }

    public boolean isProtected() {
        return this.getModifiers().contains((Object)ModifierKind.PROTECTED);
    }

    public boolean isPrivate() {
        return this.getModifiers().contains((Object)ModifierKind.PRIVATE);
    }

    public boolean isAbstract() {
        return this.getModifiers().contains((Object)ModifierKind.ABSTRACT);
    }

    public boolean isStatic() {
        return this.getModifiers().contains((Object)ModifierKind.STATIC);
    }

    public boolean isFinal() {
        return this.getModifiers().contains((Object)ModifierKind.FINAL);
    }

    public int hashCode() {
        return this.getModifiers().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CtModifierHandler)) {
            return false;
        }
        CtModifierHandler other = (CtModifierHandler)obj;
        if (this.getVisibility() == null) {
            if (other.getVisibility() != null) {
                return false;
            }
        } else {
            if (other.getVisibility() == null) {
                return false;
            }
            if (!this.getVisibility().equals((Object)other.getVisibility())) {
                return false;
            }
        }
        if (this.getModifiers().size() != other.getModifiers().size()) {
            return false;
        }
        return this.getModifiers().containsAll(other.getModifiers());
    }
}

