/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.code;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import spoon.reflect.annotations.MetamodelPropertyField;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.ParentNotInitializedException;
import spoon.reflect.path.CtRole;
import spoon.reflect.visitor.CtVisitor;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.Query;
import spoon.support.reflect.code.CtStatementImpl;
import spoon.support.util.ModelList;

public class CtBlockImpl<R>
extends CtStatementImpl
implements CtBlock<R> {
    private static final long serialVersionUID = 1L;
    @MetamodelPropertyField(role={CtRole.STATEMENT})
    private final ModelList<CtStatement> statements = new ModelList<CtStatement>(){
        private static final long serialVersionUID = 1L;

        @Override
        protected CtElement getOwner() {
            return CtBlockImpl.this;
        }

        @Override
        protected CtRole getRole() {
            return CtRole.STATEMENT;
        }

        @Override
        protected int getDefaultCapacity() {
            return 3;
        }

        @Override
        protected void onSizeChanged(int newSize) {
            if (CtBlockImpl.this.isImplicit() && (newSize > 1 || newSize == 0)) {
                CtBlockImpl.this.setImplicit(false);
            }
        }
    };

    @Override
    public void accept(CtVisitor visitor) {
        visitor.visitCtBlock(this);
    }

    @Override
    public List<CtStatement> getStatements() {
        return this.statements;
    }

    @Override
    public <T extends CtStatement> T getStatement(int i2) {
        return (T)((CtStatement)this.statements.get(i2));
    }

    @Override
    public <T extends CtStatement> T getLastStatement() {
        return (T)((CtStatement)this.statements.get(this.statements.size() - 1));
    }

    private boolean shouldInsertAfterSuper() {
        try {
            CtStatement first;
            if (this.getParent() != null && this.getParent() instanceof CtConstructor && !this.getStatements().isEmpty() && (first = this.getStatements().get(0)) instanceof CtInvocation && ((CtInvocation)first).getExecutable().isConstructor()) {
                return true;
            }
        }
        catch (ParentNotInitializedException parentNotInitializedException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public <T extends CtStatementList> T insertBegin(CtStatementList statements) {
        if (this.shouldInsertAfterSuper()) {
            this.getStatements().get(0).insertAfter(statements);
            return (T)this;
        }
        ArrayList<CtStatement> copy = new ArrayList<CtStatement>(statements.getStatements());
        statements.setStatements(null);
        this.statements.addAll(0, copy);
        return (T)this;
    }

    @Override
    public <T extends CtStatementList> T insertBegin(CtStatement statement) {
        if (this.shouldInsertAfterSuper()) {
            this.getStatements().get(0).insertAfter(statement);
            return (T)this;
        }
        this.statements.add(0, statement);
        return (T)this;
    }

    @Override
    public <T extends CtStatementList> T insertEnd(CtStatement statement) {
        this.addStatement(statement);
        return (T)this;
    }

    @Override
    public <T extends CtStatementList> T insertEnd(CtStatementList statements) {
        ArrayList<CtStatement> tobeInserted = new ArrayList<CtStatement>(statements.getStatements());
        statements.setStatements(null);
        this.statements.addAll(this.statements.size(), tobeInserted);
        return (T)this;
    }

    @Override
    public <T extends CtStatementList> T insertAfter(Filter<? extends CtStatement> insertionPoints, CtStatement statement) {
        for (CtStatement ctStatement : Query.getElements(this, insertionPoints)) {
            ctStatement.insertAfter(statement);
        }
        return (T)this;
    }

    @Override
    public <T extends CtStatementList> T insertAfter(Filter<? extends CtStatement> insertionPoints, CtStatementList statements) {
        for (CtStatement ctStatement : Query.getElements(this, insertionPoints)) {
            ctStatement.insertAfter(statements);
        }
        return (T)this;
    }

    @Override
    public <T extends CtStatementList> T insertBefore(Filter<? extends CtStatement> insertionPoints, CtStatement statement) {
        for (CtStatement ctStatement : Query.getElements(this, insertionPoints)) {
            ctStatement.insertBefore(statement);
        }
        return (T)this;
    }

    @Override
    public <T extends CtStatementList> T insertBefore(Filter<? extends CtStatement> insertionPoints, CtStatementList statements) {
        for (CtStatement ctStatement : Query.getElements(this, insertionPoints)) {
            ctStatement.insertBefore(statements);
        }
        return (T)this;
    }

    @Override
    public <T extends CtStatementList> T setStatements(List<CtStatement> statements) {
        this.statements.set(statements);
        return (T)this;
    }

    @Override
    public <T extends CtStatementList> T addStatement(CtStatement statement) {
        this.statements.add(statement);
        return (T)this;
    }

    @Override
    public <T extends CtStatementList> T addStatement(int index, CtStatement statement) {
        this.statements.add(index, statement);
        return (T)this;
    }

    @Override
    public void removeStatement(CtStatement statement) {
        this.statements.remove(statement);
    }

    @Override
    public Iterator<CtStatement> iterator() {
        return this.statements.iterator();
    }

    @Override
    public R S() {
        return null;
    }

    @Override
    public CtBlock<R> clone() {
        return (CtBlock)super.clone();
    }

    @Override
    public void comment() {
        if (!this.isParentInitialized()) {
            return;
        }
        if (this.getParent() instanceof CtMethod) {
            this.getStatements().forEach(stmt -> stmt.comment());
        } else {
            super.comment();
        }
    }
}

