/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.code;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import spoon.SpoonException;
import spoon.reflect.annotations.MetamodelPropertyField;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtBodyHolder;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtLambda;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtStatement;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtIntersectionTypeReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtVisitor;
import spoon.support.UnsettableProperty;
import spoon.support.reflect.code.CtExpressionImpl;
import spoon.support.reflect.declaration.CtElementImpl;
import spoon.support.util.QualifiedNameBasedSortedSet;
import spoon.support.visitor.SignaturePrinter;

public class CtLambdaImpl<T>
extends CtExpressionImpl<T>
implements CtLambda<T> {
    @MetamodelPropertyField(role={CtRole.NAME})
    String simpleName = "";
    @MetamodelPropertyField(role={CtRole.EXPRESSION})
    CtExpression<T> expression;
    @MetamodelPropertyField(role={CtRole.BODY})
    CtBlock<?> body;
    @MetamodelPropertyField(role={CtRole.PARAMETER})
    List<CtParameter<?>> parameters = CtLambdaImpl.emptyList();
    @MetamodelPropertyField(role={CtRole.THROWN})
    Set<CtTypeReference<? extends Throwable>> thrownTypes = CtLambdaImpl.emptySet();

    @Override
    public void accept(CtVisitor visitor) {
        visitor.visitCtLambda(this);
    }

    @Override
    public String getSimpleName() {
        return this.simpleName;
    }

    public <C extends CtNamedElement> C setSimpleName(String simpleName) {
        this.getFactory().getEnvironment().getModelChangeListener().onObjectUpdate((CtElement)this, CtRole.NAME, simpleName, this.simpleName);
        this.simpleName = simpleName;
        return (C)this;
    }

    @Override
    public CtBlock<T> getBody() {
        return this.body;
    }

    public <C extends CtBodyHolder> C setBody(CtStatement statement) {
        if (statement != null) {
            CtBlock<?> body = this.getFactory().Code().getOrCreateCtBlock(statement);
            this.getFactory().getEnvironment().getModelChangeListener().onObjectUpdate((CtElement)this, CtRole.BODY, body, this.body);
            if (this.expression != null && body != null) {
                throw new SpoonException("A lambda can't have two bodys.");
            }
            if (body != null) {
                body.setParent(this);
            }
            this.body = body;
        } else {
            this.getFactory().getEnvironment().getModelChangeListener().onObjectDelete(this, CtRole.BODY, this.body);
            this.body = null;
        }
        return (C)this;
    }

    @Override
    public <R> CtMethod<R> getOverriddenMethod() {
        CtTypeReference lambdaTypeRef = this.getType();
        if (lambdaTypeRef == null) {
            return null;
        }
        if (!(lambdaTypeRef instanceof CtIntersectionTypeReference)) {
            return this.getOverriddenMethodForNormalType(lambdaTypeRef);
        }
        CtMethod<?> lambdaExecutableMethod = this.getOverriddenMethodForIntersectionType(lambdaTypeRef);
        if (lambdaExecutableMethod == null) {
            throw new SpoonException("The lambda can be based on interface, which has one method. But " + lambdaTypeRef.getQualifiedName() + " has no one");
        }
        return lambdaExecutableMethod;
    }

    private CtMethod<?> getOverriddenMethodForIntersectionType(CtTypeReference<T> lambdaTypeRef) throws SpoonException {
        CtMethod lambdaExecutableMethod = null;
        CtElement parent = lambdaTypeRef.getParent();
        CtTypeReference parentTypeReference = null;
        if (parent != null && parent instanceof CtLocalVariable) {
            parentTypeReference = ((CtLocalVariable)parent).getType();
        } else if (parent != null && parent instanceof CtAssignment) {
            parentTypeReference = ((CtAssignment)parent).getAssigned().getType();
        }
        for (CtTypeReference<?> ctTypeReference : ((CtIntersectionTypeReference)lambdaTypeRef).getBounds()) {
            CtMethod tmp = this.getOverriddenMethodForNormalType(ctTypeReference);
            if (tmp == null || lambdaExecutableMethod != null && !ctTypeReference.equals(parentTypeReference)) continue;
            lambdaExecutableMethod = tmp;
        }
        return lambdaExecutableMethod;
    }

    private <R> CtMethod<R> getOverriddenMethodForNormalType(CtTypeReference<?> lambdaTypeRef) throws SpoonException {
        CtType<?> lambdaType = lambdaTypeRef.getTypeDeclaration();
        if (!lambdaType.isInterface()) {
            throw new SpoonException("The lambda can be based on interface only. But type " + lambdaTypeRef.getQualifiedName() + " is not an interface");
        }
        Set<CtMethod<?>> lambdaTypeMethods = lambdaType.getAllMethods();
        CtMethod<?> lambdaExecutableMethod = null;
        if (lambdaTypeMethods.size() == 1) {
            lambdaExecutableMethod = lambdaTypeMethods.iterator().next();
        } else {
            for (CtMethod<?> method : lambdaTypeMethods) {
                if (this.getFactory().Method().OBJECT_METHODS.stream().anyMatch(method::isOverriding) || method.isDefaultMethod() || method.hasModifier(ModifierKind.PRIVATE) || method.hasModifier(ModifierKind.STATIC)) continue;
                if (lambdaExecutableMethod != null) {
                    throw new SpoonException("The lambda can be based on interface, which has only one method. But " + lambdaTypeRef.getQualifiedName() + " has at least two: " + lambdaExecutableMethod.getSignature() + " and " + method.getSignature());
                }
                lambdaExecutableMethod = method;
            }
        }
        return lambdaExecutableMethod;
    }

    @Override
    public List<CtParameter<?>> getParameters() {
        return CtLambdaImpl.unmodifiableList(this.parameters);
    }

    @Override
    public <C extends CtExecutable<T>> C setParameters(List<CtParameter<?>> params) {
        if (params == null || params.isEmpty()) {
            this.parameters = CtElementImpl.emptyList();
            return (C)this;
        }
        if (this.parameters == CtElementImpl.emptyList()) {
            this.parameters = new ArrayList(2);
        }
        this.getFactory().getEnvironment().getModelChangeListener().onListDeleteAll(this, CtRole.PARAMETER, this.parameters, new ArrayList(this.parameters));
        this.parameters.clear();
        for (CtParameter<?> p : params) {
            this.addParameter(p);
        }
        return (C)this;
    }

    @Override
    public <C extends CtExecutable<T>> C addParameter(CtParameter<?> parameter) {
        if (parameter == null) {
            return (C)this;
        }
        if (this.parameters == CtElementImpl.emptyList()) {
            this.parameters = new ArrayList(2);
        }
        parameter.setParent(this);
        this.getFactory().getEnvironment().getModelChangeListener().onListAdd(this, CtRole.PARAMETER, this.parameters, parameter);
        this.parameters.add(parameter);
        return (C)this;
    }

    @Override
    public boolean removeParameter(CtParameter<?> parameter) {
        if (this.parameters == CtElementImpl.emptyList()) {
            return false;
        }
        this.getFactory().getEnvironment().getModelChangeListener().onListDelete(this, CtRole.PARAMETER, this.parameters, this.parameters.indexOf(parameter), parameter);
        return this.parameters.remove(parameter);
    }

    @Override
    public Set<CtTypeReference<? extends Throwable>> getThrownTypes() {
        return this.thrownTypes;
    }

    @Override
    @UnsettableProperty
    public <C extends CtExecutable<T>> C setThrownTypes(Set<CtTypeReference<? extends Throwable>> thrownTypes) {
        return (C)this;
    }

    @Override
    public <C extends CtExecutable<T>> C addThrownType(CtTypeReference<? extends Throwable> throwType) {
        if (throwType == null) {
            return (C)this;
        }
        if (this.thrownTypes == CtElementImpl.emptySet()) {
            this.thrownTypes = new QualifiedNameBasedSortedSet<CtTypeReference<? extends Throwable>>();
        }
        throwType.setParent(this);
        this.getFactory().getEnvironment().getModelChangeListener().onSetAdd((CtElement)this, CtRole.THROWN, this.thrownTypes, throwType);
        this.thrownTypes.add(throwType);
        return (C)this;
    }

    @Override
    public boolean removeThrownType(CtTypeReference<? extends Throwable> throwType) {
        if (this.thrownTypes == CtElementImpl.emptySet()) {
            return false;
        }
        this.getFactory().getEnvironment().getModelChangeListener().onSetDelete((CtElement)this, CtRole.THROWN, this.thrownTypes, throwType);
        return this.thrownTypes.remove(throwType);
    }

    @Override
    public String getSignature() {
        SignaturePrinter pr = new SignaturePrinter();
        pr.scan(this);
        return pr.getSignature();
    }

    @Override
    public CtExecutableReference<T> getReference() {
        return this.getFactory().Executable().createReference(this);
    }

    @Override
    public CtExpression<T> getExpression() {
        return this.expression;
    }

    @Override
    public <C extends CtLambda<T>> C setExpression(CtExpression<T> expression) {
        if (this.body != null && expression != null) {
            throw new SpoonException("A lambda can't have two bodies.");
        }
        if (expression != null) {
            expression.setParent(this);
        }
        this.getFactory().getEnvironment().getModelChangeListener().onObjectUpdate((CtElement)this, CtRole.EXPRESSION, expression, this.expression);
        this.expression = expression;
        return (C)this;
    }

    @Override
    public CtLambda<T> clone() {
        return (CtLambda)super.clone();
    }
}

