/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.code;

import java.util.ArrayList;
import java.util.List;
import spoon.reflect.annotations.MetamodelPropertyField;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.path.CtRole;
import spoon.reflect.visitor.CtVisitor;
import spoon.support.reflect.code.CtExpressionImpl;
import spoon.support.reflect.declaration.CtElementImpl;

public class CtNewArrayImpl<T>
extends CtExpressionImpl<T>
implements CtNewArray<T> {
    private static final long serialVersionUID = 1L;
    @MetamodelPropertyField(role={CtRole.DIMENSION})
    List<CtExpression<Integer>> dimensionExpressions = CtNewArrayImpl.emptyList();
    @MetamodelPropertyField(role={CtRole.EXPRESSION})
    List<CtExpression<?>> expressions = CtNewArrayImpl.emptyList();

    @Override
    public void accept(CtVisitor visitor) {
        visitor.visitCtNewArray(this);
    }

    @Override
    public List<CtExpression<Integer>> getDimensionExpressions() {
        return this.dimensionExpressions;
    }

    @Override
    public List<CtExpression<?>> getElements() {
        return this.expressions;
    }

    @Override
    public <C extends CtNewArray<T>> C setDimensionExpressions(List<CtExpression<Integer>> dimensionExpressions) {
        if (dimensionExpressions == null || dimensionExpressions.isEmpty()) {
            this.dimensionExpressions = CtElementImpl.emptyList();
            return (C)this;
        }
        this.getFactory().getEnvironment().getModelChangeListener().onListDeleteAll(this, CtRole.DIMENSION, this.dimensionExpressions, new ArrayList<CtExpression<Integer>>(this.dimensionExpressions));
        this.dimensionExpressions.clear();
        for (CtExpression<Integer> expr : dimensionExpressions) {
            this.addDimensionExpression(expr);
        }
        return (C)this;
    }

    @Override
    public <C extends CtNewArray<T>> C addDimensionExpression(CtExpression<Integer> dimension) {
        if (dimension == null) {
            return (C)this;
        }
        if (this.dimensionExpressions == CtElementImpl.emptyList()) {
            this.dimensionExpressions = new ArrayList<CtExpression<Integer>>(1);
        }
        dimension.setParent(this);
        this.getFactory().getEnvironment().getModelChangeListener().onListAdd(this, CtRole.DIMENSION, this.dimensionExpressions, dimension);
        this.dimensionExpressions.add(dimension);
        return (C)this;
    }

    @Override
    public boolean removeDimensionExpression(CtExpression<Integer> dimension) {
        if (this.dimensionExpressions == CtElementImpl.emptyList()) {
            return false;
        }
        this.getFactory().getEnvironment().getModelChangeListener().onListDelete(this, CtRole.DIMENSION, this.dimensionExpressions, this.dimensionExpressions.indexOf(dimension), dimension);
        return this.dimensionExpressions.remove(dimension);
    }

    @Override
    public <C extends CtNewArray<T>> C setElements(List<CtExpression<?>> expressions) {
        if (expressions == null || expressions.isEmpty()) {
            this.expressions = CtElementImpl.emptyList();
            return (C)this;
        }
        this.getFactory().getEnvironment().getModelChangeListener().onListDeleteAll(this, CtRole.EXPRESSION, this.expressions, new ArrayList(this.expressions));
        this.expressions.clear();
        for (CtExpression<?> expr : expressions) {
            this.addElement(expr);
        }
        return (C)this;
    }

    @Override
    public <C extends CtNewArray<T>> C addElement(CtExpression<?> expression) {
        if (expression == null) {
            return (C)this;
        }
        if (this.expressions == CtElementImpl.emptyList()) {
            this.expressions = new ArrayList();
        }
        expression.setParent(this);
        this.getFactory().getEnvironment().getModelChangeListener().onListAdd(this, CtRole.EXPRESSION, this.expressions, expression);
        this.expressions.add(expression);
        return (C)this;
    }

    @Override
    public boolean removeElement(CtExpression<?> expression) {
        if (this.expressions == CtElementImpl.emptyList()) {
            return false;
        }
        this.getFactory().getEnvironment().getModelChangeListener().onListDelete(this, CtRole.EXPRESSION, this.expressions, this.expressions.indexOf(expression), expression);
        return this.expressions.remove(expression);
    }

    @Override
    public CtNewArray<T> clone() {
        return (CtNewArray)super.clone();
    }
}

