/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.cu.position;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import spoon.SpoonException;
import spoon.reflect.cu.CompilationUnit;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.cu.position.NoSourcePosition;

public class SourcePositionImpl
implements SourcePosition,
Serializable {
    private static final long serialVersionUID = 1L;
    private final int sourceStart;
    private final int sourceEnd;
    private int sourceStartline = -1;
    private final CompilationUnit compilationUnit;

    protected int searchLineNumber(int position) {
        int[] lineSeparatorPositions = this.getLineSeparatorPositions();
        if (lineSeparatorPositions == null) {
            return 1;
        }
        int length = lineSeparatorPositions.length;
        if (length == 0) {
            return 1;
        }
        int g = 0;
        int d = length - 1;
        int m = 0;
        while (g <= d) {
            m = (g + d) / 2;
            int start = lineSeparatorPositions[m];
            if (position < start) {
                d = m - 1;
                continue;
            }
            if (position > start) {
                g = m + 1;
                continue;
            }
            return m + 1;
        }
        if (position < lineSeparatorPositions[m]) {
            return m + 1;
        }
        return m + 2;
    }

    protected int searchColumnNumber(int position) {
        int i2;
        int[] lineSeparatorPositions = this.getLineSeparatorPositions();
        if (lineSeparatorPositions == null) {
            return -1;
        }
        int length = lineSeparatorPositions.length;
        if (length == 0) {
            return position;
        }
        if (lineSeparatorPositions[0] > position) {
            return position;
        }
        for (i2 = 0; i2 < lineSeparatorPositions.length - 1; ++i2) {
            if (lineSeparatorPositions[i2] >= position || lineSeparatorPositions[i2 + 1] <= position) continue;
            return position - lineSeparatorPositions[i2];
        }
        int tabCount = 0;
        int tabSize = 0;
        if (this.getCompilationUnit() != null) {
            tabSize = this.getCompilationUnit().getFactory().getEnvironment().getTabulationSize();
            String source = this.getCompilationUnit().getOriginalSourceCode();
            for (int j = lineSeparatorPositions[i2]; j < position; ++j) {
                if (source.charAt(j) != '\t') continue;
                ++tabCount;
            }
        }
        return position - lineSeparatorPositions[i2] - tabCount + tabCount * tabSize;
    }

    public SourcePositionImpl(CompilationUnit compilationUnit, int sourceStart, int sourceEnd, int[] lineSeparatorPositions) {
        SourcePositionImpl.checkArgsAreAscending(sourceStart, sourceEnd + 1);
        if (compilationUnit == null) {
            throw new SpoonException("Mandatory parameter compilationUnit is null");
        }
        this.compilationUnit = compilationUnit;
        if (compilationUnit.getLineSeparatorPositions() != lineSeparatorPositions) {
            throw new SpoonException("Unexpected lineSeparatorPositions");
        }
        this.sourceEnd = sourceEnd;
        this.sourceStart = sourceStart;
    }

    @Override
    public boolean isValidPosition() {
        return true;
    }

    @Override
    public int getColumn() {
        return this.searchColumnNumber(this.sourceStart);
    }

    @Override
    public int getEndColumn() {
        return this.searchColumnNumber(this.sourceEnd);
    }

    @Override
    public File getFile() {
        return this.compilationUnit == null ? null : this.compilationUnit.getFile();
    }

    @Override
    public int getLine() {
        if (this.sourceStartline == -1) {
            this.sourceStartline = this.searchLineNumber(this.sourceStart);
        }
        return this.sourceStartline;
    }

    @Override
    public int getEndLine() {
        return this.searchLineNumber(this.sourceEnd);
    }

    @Override
    public int getSourceEnd() {
        return this.sourceEnd;
    }

    @Override
    public int getSourceStart() {
        return this.sourceStart;
    }

    @Override
    public String toString() {
        if (this.getFile() == null) {
            return "(unknown file)";
        }
        int ln = this.getLine();
        return ln >= 1 ? "(" + this.getFile().getAbsolutePath().replace('\\', '/').replace("C:/", "/") + ":" + ln + ")" : this.getFile().getAbsolutePath().replace('\\', '/').replace("C:/", "/");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SourcePosition)) {
            return false;
        }
        if (obj instanceof NoSourcePosition) {
            return false;
        }
        SourcePosition s = (SourcePosition)obj;
        return (this.getFile() == null ? s.getFile() == null : this.getFile().equals(s.getFile())) && this.getSourceEnd() == s.getSourceEnd() && this.getSourceStart() == s.getSourceStart();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getLine();
        result = 31 * result + this.getColumn();
        result = 31 * result + (this.getFile() != null ? this.getFile().hashCode() : 1);
        return result;
    }

    @Override
    public CompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    public String getSourceDetails() {
        return this.getFragment(this.getSourceStart(), this.getSourceEnd());
    }

    protected String getFragment(int start, int end) {
        return "|" + start + ";" + end + "|" + this.getCompilationUnit().getOriginalSourceCode().substring(start, end + 1) + "|";
    }

    protected static void checkArgsAreAscending(int ... values) {
        int last = -1;
        for (int value : values) {
            if (value < 0) {
                throw new SpoonException("SourcePosition value must not be negative");
            }
            if (last > value) {
                throw new SpoonException("SourcePosition values must be ascending or equal " + Arrays.toString(values));
            }
            last = value;
        }
    }

    private int[] getLineSeparatorPositions() {
        return this.compilationUnit == null ? null : this.compilationUnit.getLineSeparatorPositions();
    }
}

