/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.declaration;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import spoon.SpoonException;
import spoon.reflect.annotations.MetamodelPropertyField;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.declaration.CtAnnotatedElementType;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtAnnotationMethod;
import spoon.reflect.declaration.CtAnnotationType;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtShadowable;
import spoon.reflect.declaration.CtType;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtVisitor;
import spoon.support.DerivedProperty;
import spoon.support.UnsettableProperty;
import spoon.support.comparator.CtLineElementComparator;
import spoon.support.reflect.code.CtExpressionImpl;
import spoon.support.reflect.eval.EvalHelper;

public class CtAnnotationImpl<A extends Annotation>
extends CtExpressionImpl<A>
implements CtAnnotation<A> {
    private static final long serialVersionUID = 1L;
    @MetamodelPropertyField(role={CtRole.ANNOTATION_TYPE})
    CtTypeReference<A> annotationType;
    @MetamodelPropertyField(role={CtRole.VALUE})
    private Map<String, CtExpression> elementValues = new TreeMap(){

        @Override
        public Set<Map.Entry<String, CtExpression>> entrySet() {
            TreeSet<Map.Entry<String, CtExpression>> result = new TreeSet<Map.Entry<String, CtExpression>>(new Comparator<Map.Entry<String, CtExpression>>(){
                final CtLineElementComparator comp = new CtLineElementComparator();

                @Override
                public int compare(Map.Entry<String, CtExpression> o1, Map.Entry<String, CtExpression> o2) {
                    return this.comp.compare(o1.getValue(), o2.getValue());
                }
            });
            result.addAll(super.entrySet());
            return result;
        }
    };
    @MetamodelPropertyField(role={CtRole.IS_SHADOW})
    boolean isShadow;

    @Override
    public void accept(CtVisitor visitor) {
        visitor.visitCtAnnotation(this);
    }

    @Override
    public <T extends CtAnnotation<A>> T addValue(String elementName, Object value) {
        if (value instanceof CtExpression) {
            return this.addValueExpression(elementName, (CtExpression)value);
        }
        return this.addValueExpression(elementName, this.convertValueToExpression(value));
    }

    private CtExpression convertValueToExpression(Object value) {
        CtExpression<Object> res;
        if (value.getClass().isArray()) {
            res = this.getFactory().Core().createNewArray();
            Object[] values = (Object[])value;
            res.setType(this.getFactory().Type().createArrayReference(this.getFactory().Type().createReference(value.getClass().getComponentType())));
            for (Object o : values) {
                res.addElement(this.convertValueToExpression(o));
            }
        } else if (value instanceof Collection) {
            res = this.getFactory().Core().createNewArray();
            Collection values = (Collection)value;
            res.setType(this.getFactory().Type().createArrayReference(this.getFactory().Type().createReference(values.toArray()[0].getClass())));
            for (Object o : values) {
                res.addElement(this.convertValueToExpression(o));
            }
        } else if (value instanceof Class) {
            res = this.getFactory().Code().createClassAccess(this.getFactory().Type().createReference((Class)value));
        } else if (value instanceof Field) {
            CtFieldReference variable = this.getFactory().Field().createReference((Field)value);
            variable.setStatic(true);
            CtTypeAccess<?> target = this.getFactory().Code().createTypeAccess(this.getFactory().Type().createReference(((Field)value).getDeclaringClass()));
            CtFieldRead<Object> fieldRead = this.getFactory().Core().createFieldRead();
            fieldRead.setVariable(variable);
            fieldRead.setTarget(target);
            fieldRead.setType(target.getAccessedType());
            res = fieldRead;
        } else if (this.isPrimitive(value.getClass()) || value instanceof String) {
            res = this.getFactory().Code().createLiteral(value);
        } else if (value.getClass().isEnum()) {
            CtTypeReference declaringClass = this.getFactory().Type().createReference(((Enum)value).getDeclaringClass());
            CtFieldReference variableRef = this.getFactory().Field().createReference(declaringClass, declaringClass, ((Enum)value).name());
            CtTypeAccess target = this.getFactory().Code().createTypeAccess(declaringClass);
            CtFieldRead fieldRead = this.getFactory().Core().createFieldRead();
            fieldRead.setVariable(variableRef);
            fieldRead.setTarget(target);
            fieldRead.setType(declaringClass);
            res = fieldRead;
        } else {
            throw new SpoonException("Please, submit a valid value.");
        }
        return res;
    }

    private boolean isPrimitive(Class c) {
        return c.isPrimitive() || c == Byte.class || c == Short.class || c == Integer.class || c == Long.class || c == Float.class || c == Double.class || c == Boolean.class || c == Character.class;
    }

    private <T extends CtAnnotation<A>> T addValueExpression(String elementName, CtExpression<?> expression) {
        if (this.elementValues.containsKey(elementName)) {
            CtExpression ctExpression = this.elementValues.get(elementName);
            if (ctExpression instanceof CtNewArray) {
                if (expression instanceof CtNewArray) {
                    List<CtExpression<?>> elements = ((CtNewArray)expression).getElements();
                    for (CtExpression<?> expInArray : elements) {
                        ((CtNewArray)ctExpression).addElement(expInArray);
                    }
                } else {
                    ((CtNewArray)ctExpression).addElement(expression);
                }
            } else {
                CtNewArray newArray = this.getFactory().Core().createNewArray();
                newArray.setType(ctExpression.getType());
                newArray.setParent(this);
                newArray.addElement(ctExpression);
                newArray.addElement(expression);
                this.elementValues.put(elementName, newArray);
            }
        } else {
            expression.setParent(this);
            this.getFactory().getEnvironment().getModelChangeListener().onMapAdd(this, CtRole.VALUE, this.elementValues, elementName, expression);
            this.elementValues.put(elementName, expression);
        }
        return (T)this;
    }

    @Override
    public <T extends CtAnnotation<A>> T addValue(String elementName, CtLiteral<?> value) {
        return this.addValueExpression(elementName, value);
    }

    @Override
    public <T extends CtAnnotation<A>> T addValue(String elementName, CtNewArray<? extends CtExpression> value) {
        return this.addValueExpression(elementName, value);
    }

    @Override
    public <T extends CtAnnotation<A>> T addValue(String elementName, CtFieldAccess<?> value) {
        return this.addValueExpression(elementName, value);
    }

    @Override
    public <T extends CtAnnotation<A>> T addValue(String elementName, CtAnnotation<?> value) {
        return this.addValueExpression(elementName, value);
    }

    private Class<?> getElementType(String name) {
        CtElement t = this.getAnnotationType().getDeclaration();
        if (t != null) {
            CtMethod method = t.getMethod(name, new CtTypeReference[0]);
            return method.getType().getActualClass();
        }
        Class<A> c = this.getAnnotationType().getActualClass();
        for (Method m : c.getMethods()) {
            if (!m.getName().equals(name)) continue;
            return m.getReturnType();
        }
        return null;
    }

    @Override
    public CtTypeReference<A> getAnnotationType() {
        return this.annotationType;
    }

    private CtExpression getDefaultExpression(String fieldName) {
        CtExpression ret = null;
        CtAnnotationType at = (CtAnnotationType)this.getAnnotationType().getDeclaration();
        if (at != null) {
            CtAnnotationMethod f = (CtAnnotationMethod)at.getMethod(fieldName, new CtTypeReference[0]);
            ret = f.getDefaultExpression();
        }
        return ret;
    }

    @Override
    public <T extends CtExpression> T getValue(String key) {
        return (T)this.getValueAsExpression(key);
    }

    @Override
    public int getValueAsInt(String key) {
        Object val = this.getValueAsObject(key);
        if (val == null) {
            throw new IllegalStateException(key + " not in the annotation");
        }
        return (Integer)val;
    }

    @Override
    public String getValueAsString(String key) {
        return (String)this.getValueAsObject(key);
    }

    @Override
    public Object getValueAsObject(String key) {
        Object expr = this.getWrappedValue(key);
        if (expr == null) {
            return null;
        }
        Object ret = EvalHelper.convertElementToRuntimeObject(expr);
        Class<?> type = this.getElementType(key);
        return this.forceObjectToType(ret, type);
    }

    private Object forceObjectToType(Object ret, Class<?> type) {
        if (type.isPrimitive()) {
            if (type == Boolean.TYPE && ret.getClass() != Boolean.TYPE) {
                return Boolean.parseBoolean(ret.toString());
            }
            if (type == Byte.TYPE && ret.getClass() != Byte.TYPE) {
                return Byte.parseByte(ret.toString());
            }
            if (type == Character.TYPE && ret.getClass() != Character.TYPE) {
                return Character.valueOf(ret.toString().charAt(0));
            }
            if (type == Double.TYPE && ret.getClass() != Double.TYPE) {
                return Double.parseDouble(ret.toString());
            }
            if (type == Float.TYPE && ret.getClass() != Float.TYPE) {
                return Float.valueOf(Float.parseFloat(ret.toString()));
            }
            if (type == Integer.TYPE && ret.getClass() != Integer.TYPE) {
                return Integer.parseInt(ret.toString());
            }
            if (type == Long.TYPE && ret.getClass() != Long.TYPE) {
                return Long.parseLong(ret.toString());
            }
            if (type == Short.TYPE && ret.getClass() != Short.TYPE) {
                return Short.parseShort(ret.toString());
            }
        }
        return ret;
    }

    private CtExpression getValueAsExpression(String key) {
        CtExpression ret = this.elementValues.get(key);
        if (ret != null) {
            return ret;
        }
        ret = this.getDefaultExpression(key);
        if (ret != null) {
            return ret;
        }
        Object value = this.getReflectValue(key);
        if (value != null) {
            return this.convertValueToExpression(value);
        }
        return null;
    }

    @Override
    public <T extends CtExpression> T getWrappedValue(String key) {
        CtTypeReference returnType;
        CtMethod method;
        T ctExpression = this.getValue(key);
        CtTypeReference<A> typeReference = this.getAnnotationType();
        CtType<A> type = typeReference.getTypeDeclaration();
        if (type != null && (method = type.getMethod(key, new CtTypeReference[0])) != null && (returnType = method.getType()) instanceof CtArrayTypeReference && !(ctExpression instanceof CtNewArray)) {
            CtNewArray newArray = this.getFactory().Core().createNewArray();
            CtArrayTypeReference typeReference2 = this.getFactory().createArrayTypeReference();
            typeReference2.setComponentType((CtTypeReference<?>)ctExpression.getType().clone());
            newArray.setType(typeReference2);
            newArray.addElement((CtExpression<?>)ctExpression.clone());
            return (T)newArray;
        }
        return ctExpression;
    }

    public Map<String, Object> getElementValues() {
        TreeMap<String, Object> res = new TreeMap<String, Object>();
        for (Map.Entry<String, CtExpression> elementValue : this.elementValues.entrySet()) {
            res.put(elementValue.getKey(), elementValue.getValue());
        }
        return res;
    }

    @Override
    public Map<String, CtExpression> getValues() {
        return Collections.unmodifiableMap(this.elementValues);
    }

    @Override
    public Map<String, CtExpression> getAllValues() {
        TreeMap<String, CtExpression> values = new TreeMap<String, CtExpression>();
        CtAnnotationType annotationType = (CtAnnotationType)this.getAnnotationType().getTypeDeclaration();
        for (CtAnnotationMethod<?> m : annotationType.getAnnotationMethods()) {
            values.put(m.getSimpleName(), m.getDefaultExpression());
        }
        values.putAll(this.elementValues);
        return Collections.unmodifiableMap(values);
    }

    private Object getReflectValue(String fieldname) {
        try {
            Class<A> c = this.getAnnotationType().getActualClass();
            Method m = c.getMethod(fieldname, new Class[0]);
            return m.getDefaultValue();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T extends CtAnnotation<A>> T setAnnotationType(CtTypeReference<? extends Annotation> annotationType) {
        if (annotationType != null) {
            annotationType.setParent(this);
        }
        this.getFactory().getEnvironment().getModelChangeListener().onObjectUpdate((CtElement)this, CtRole.TYPE, annotationType, this.annotationType);
        this.annotationType = annotationType;
        return (T)this;
    }

    @Override
    public <T extends CtAnnotation<A>> T setElementValues(Map<String, Object> values) {
        this.getFactory().getEnvironment().getModelChangeListener().onMapDeleteAll(this, CtRole.VALUE, this.elementValues, new HashMap<String, CtExpression>(this.elementValues));
        this.elementValues.clear();
        for (Map.Entry<String, Object> e : values.entrySet()) {
            this.addValue(e.getKey(), e.getValue());
        }
        return (T)this;
    }

    @Override
    public <T extends CtAnnotation<A>> T setValues(Map<String, CtExpression> values) {
        this.getFactory().getEnvironment().getModelChangeListener().onMapDeleteAll(this, CtRole.VALUE, this.elementValues, new HashMap<String, CtExpression>(this.elementValues));
        this.elementValues.clear();
        for (Map.Entry<String, CtExpression> e : values.entrySet()) {
            this.addValue(e.getKey(), e.getValue());
        }
        return (T)this;
    }

    @Override
    public CtElement getAnnotatedElement() {
        return this.getParent();
    }

    @Override
    public CtAnnotatedElementType getAnnotatedElementType() {
        CtElement annotatedElement = this.getAnnotatedElement();
        return CtAnnotation.getAnnotatedElementTypeForCtElement(annotatedElement);
    }

    @Override
    public A getActualAnnotation() {
        class AnnotationInvocationHandler
        implements InvocationHandler {
            CtAnnotation<? extends Annotation> annotation;

            AnnotationInvocationHandler(CtAnnotation<? extends Annotation> annotation) {
                this.annotation = annotation;
            }

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) {
                String fieldname = method.getName();
                if ("toString".equals(fieldname)) {
                    return CtAnnotationImpl.this.toString();
                }
                if ("annotationType".equals(fieldname)) {
                    return this.annotation.getAnnotationType().getActualClass();
                }
                return CtAnnotationImpl.this.getValueAsObject(fieldname);
            }
        }
        return (A)((Annotation)Proxy.newProxyInstance(this.annotationType.getActualClass().getClassLoader(), new Class[]{this.annotationType.getActualClass()}, (InvocationHandler)new AnnotationInvocationHandler(this)));
    }

    @Override
    public boolean isShadow() {
        return this.isShadow;
    }

    @Override
    public <E extends CtShadowable> E setShadow(boolean isShadow) {
        this.getFactory().getEnvironment().getModelChangeListener().onObjectUpdate((CtElement)this, CtRole.IS_SHADOW, isShadow, this.isShadow);
        this.isShadow = isShadow;
        return (E)this;
    }

    @Override
    public CtAnnotation<A> clone() {
        return (CtAnnotation)super.clone();
    }

    @Override
    @DerivedProperty
    public List<CtTypeReference<?>> getTypeCasts() {
        return CtAnnotationImpl.emptyList();
    }

    @Override
    @UnsettableProperty
    public <C extends CtExpression<A>> C setTypeCasts(List<CtTypeReference<?>> casts) {
        return (C)this;
    }
}

