/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.declaration;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import spoon.SpoonException;
import spoon.SpoonModelBuilder;
import spoon.reflect.annotations.MetamodelPropertyField;
import spoon.reflect.code.CtCodeElement;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.declaration.CtAnonymousExecutable;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeMember;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtVisitor;
import spoon.support.UnsettableProperty;
import spoon.support.compiler.jdt.JDTBasedSpoonCompiler;
import spoon.support.reflect.code.CtStatementImpl;
import spoon.support.reflect.declaration.CtTypeImpl;
import spoon.support.reflect.eval.VisitorPartialEvaluator;
import spoon.support.util.SignatureBasedSortedSet;

public class CtClassImpl<T>
extends CtTypeImpl<T>
implements CtClass<T> {
    private static final long serialVersionUID = 1L;
    @MetamodelPropertyField(role={CtRole.SUPER_TYPE})
    CtTypeReference<?> superClass;

    @Override
    public void accept(CtVisitor v) {
        v.visitCtClass(this);
    }

    @Override
    public List<CtAnonymousExecutable> getAnonymousExecutables() {
        ArrayList<CtAnonymousExecutable> anonymousExecutables = new ArrayList<CtAnonymousExecutable>();
        for (CtTypeMember typeMember : this.typeMembers) {
            if (!(typeMember instanceof CtAnonymousExecutable)) continue;
            anonymousExecutables.add((CtAnonymousExecutable)typeMember);
        }
        return Collections.unmodifiableList(anonymousExecutables);
    }

    @Override
    public CtConstructor<T> getConstructor(CtTypeReference<?> ... parameterTypes) {
        for (CtTypeMember typeMember : this.getTypeMembers()) {
            CtConstructor c;
            if (!(typeMember instanceof CtConstructor) || !this.hasSameParameters(c = (CtConstructor)typeMember, parameterTypes)) continue;
            return c;
        }
        return null;
    }

    @Override
    public Set<CtConstructor<T>> getConstructors() {
        SignatureBasedSortedSet<CtConstructor> constructors = new SignatureBasedSortedSet<CtConstructor>();
        for (CtTypeMember typeMember : this.typeMembers) {
            if (!(typeMember instanceof CtConstructor)) continue;
            constructors.add((CtConstructor)typeMember);
        }
        return Collections.unmodifiableSet(constructors);
    }

    @Override
    public <C extends CtClass<T>> C addAnonymousExecutable(CtAnonymousExecutable e) {
        if (e == null) {
            return (C)this;
        }
        e.setParent(this);
        this.getFactory().getEnvironment().getModelChangeListener().onListAdd(this, CtRole.ANNONYMOUS_EXECUTABLE, this.typeMembers, e);
        return (C)((CtClass)this.addTypeMember(e));
    }

    @Override
    public boolean removeAnonymousExecutable(CtAnonymousExecutable e) {
        this.getFactory().getEnvironment().getModelChangeListener().onListDelete(this, CtRole.ANNONYMOUS_EXECUTABLE, this.typeMembers, this.typeMembers.indexOf(e), e);
        return this.removeTypeMember(e);
    }

    @Override
    public CtTypeReference<?> getSuperclass() {
        return this.superClass;
    }

    @Override
    public <C extends CtClass<T>> C setAnonymousExecutables(List<CtAnonymousExecutable> anonymousExecutables) {
        this.getFactory().getEnvironment().getModelChangeListener().onListDelete(this, CtRole.ANNONYMOUS_EXECUTABLE, this.typeMembers, new ArrayList<CtAnonymousExecutable>(this.getAnonymousExecutables()));
        if (anonymousExecutables == null || anonymousExecutables.isEmpty()) {
            this.typeMembers.removeAll(this.getAnonymousExecutables());
            return (C)this;
        }
        this.typeMembers.removeAll(this.getAnonymousExecutables());
        for (CtAnonymousExecutable exec : anonymousExecutables) {
            this.addAnonymousExecutable(exec);
        }
        return (C)this;
    }

    @Override
    public <C extends CtClass<T>> C setConstructors(Set<CtConstructor<T>> constructors) {
        Set<CtConstructor<T>> oldConstructor = this.getConstructors();
        this.getFactory().getEnvironment().getModelChangeListener().onListDelete(this, CtRole.CONSTRUCTOR, this.typeMembers, oldConstructor);
        if (constructors == null || constructors.isEmpty()) {
            this.typeMembers.removeAll(oldConstructor);
            return (C)this;
        }
        this.typeMembers.removeAll(oldConstructor);
        for (CtConstructor<T> constructor : constructors) {
            this.addConstructor(constructor);
        }
        return (C)this;
    }

    @Override
    public <C extends CtClass<T>> C addConstructor(CtConstructor<T> constructor) {
        this.getFactory().getEnvironment().getModelChangeListener().onListAdd(this, CtRole.CONSTRUCTOR, this.typeMembers, constructor);
        return (C)((CtClass)this.addTypeMember(constructor));
    }

    @Override
    public void removeConstructor(CtConstructor<T> constructor) {
        this.removeTypeMember(constructor);
    }

    @Override
    public <C extends CtType<T>> C setSuperclass(CtTypeReference<?> superClass) {
        if (superClass != null) {
            superClass.setParent(this);
        }
        this.getFactory().getEnvironment().getModelChangeListener().onObjectUpdate((CtElement)this, CtRole.SUPER_TYPE, superClass, this.superClass);
        this.superClass = superClass;
        return (C)this;
    }

    @Override
    public boolean isClass() {
        return true;
    }

    @Override
    public boolean isAnonymous() {
        if ("".equals(this.getSimpleName())) {
            return true;
        }
        try {
            Integer.parseInt(this.getSimpleName());
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean isSubtypeOf(CtTypeReference<?> type) {
        return this.getReference().isSubtypeOf(type);
    }

    public <C extends CtStatement> C insertAfter(CtStatement statement) {
        CtStatementImpl.insertAfter((CtStatement)this, statement);
        return (C)this;
    }

    public <C extends CtStatement> C insertAfter(CtStatementList statements) {
        CtStatementImpl.insertAfter((CtStatement)this, statements);
        return (C)this;
    }

    public <C extends CtStatement> C insertBefore(CtStatement statement) {
        CtStatementImpl.insertBefore((CtStatement)this, statement);
        return (C)this;
    }

    public <C extends CtStatement> C insertBefore(CtStatementList statements) {
        CtStatementImpl.insertBefore((CtStatement)this, statements);
        return (C)this;
    }

    @Override
    public String getLabel() {
        return null;
    }

    @Override
    @UnsettableProperty
    public <C extends CtStatement> C setLabel(String label) {
        return (C)this;
    }

    @Override
    public <R extends CtCodeElement> R partiallyEvaluate() {
        VisitorPartialEvaluator eval = new VisitorPartialEvaluator();
        return (R)eval.evaluate(this);
    }

    @Override
    public Collection<CtExecutableReference<?>> getDeclaredExecutables() {
        Collection<CtExecutableReference<?>> declaredExecutables = super.getDeclaredExecutables();
        ArrayList<CtReference> l = new ArrayList<CtReference>(declaredExecutables.size() + this.getConstructors().size());
        l.addAll(declaredExecutables);
        for (CtExecutable ctExecutable : this.getConstructors()) {
            l.add(ctExecutable.getReference());
        }
        return Collections.unmodifiableList(l);
    }

    @Override
    public CtClass<T> clone() {
        return (CtClass)super.clone();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T newInstance() {
        try {
            JDTBasedSpoonCompiler spooner = new JDTBasedSpoonCompiler(this.getFactory());
            spooner.compile(SpoonModelBuilder.InputType.CTTYPES);
            try (NewInstanceClassloader classloader = new NewInstanceClassloader(spooner.getBinaryOutputDirectory());){
                Class<?> klass = classloader.loadClass(this.getQualifiedName());
                Object obj = klass.newInstance();
                return (T)obj;
            }
        }
        catch (Exception e) {
            throw new SpoonException(e);
        }
    }

    @Override
    public Collection<CtExecutableReference<?>> getAllExecutables() {
        Set l = (Set)super.getAllExecutables();
        for (CtConstructor<T> ctConstructor : this.getConstructors()) {
            l.add(ctConstructor.getReference());
        }
        for (CtExecutable ctExecutable : this.getAnonymousExecutables()) {
            l.add(ctExecutable.getReference());
        }
        return l;
    }

    private class NewInstanceClassloader
    extends URLClassLoader {
        NewInstanceClassloader(File binaryOutputDirectory) throws MalformedURLException {
            super(new URL[]{binaryOutputDirectory.toURI().toURL()});
        }

        @Override
        public Class<?> loadClass(String s) throws ClassNotFoundException {
            try {
                return this.findClass(s);
            }
            catch (Exception e) {
                return super.loadClass(s);
            }
        }
    }
}

