/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.declaration;

import java.util.Comparator;
import java.util.Set;
import spoon.reflect.annotations.MetamodelPropertyField;
import spoon.reflect.cu.position.NoSourcePosition;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtModule;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtShadowable;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.ParentNotInitializedException;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.visitor.CtVisitor;
import spoon.support.comparator.QualifiedNameComparator;
import spoon.support.reflect.declaration.CtNamedElementImpl;
import spoon.support.util.ModelSet;

public class CtPackageImpl
extends CtNamedElementImpl
implements CtPackage {
    private static final long serialVersionUID = 1L;
    @MetamodelPropertyField(role={CtRole.SUB_PACKAGE})
    protected ModelSet<CtPackage> packs = new ModelSet<CtPackage>((Comparator)QualifiedNameComparator.INSTANCE){
        private static final long serialVersionUID = 1L;

        @Override
        protected CtElement getOwner() {
            return CtPackageImpl.this;
        }

        @Override
        protected CtRole getRole() {
            return CtRole.SUB_PACKAGE;
        }

        @Override
        public boolean add(CtPackage pack) {
            if (pack == null) {
                return false;
            }
            if (CtPackageImpl.this.getQualifiedName().equals(pack.getQualifiedName())) {
                CtPackageImpl.this.addAllTypes(pack, CtPackageImpl.this);
                CtPackageImpl.this.addAllPackages(pack, CtPackageImpl.this);
                return false;
            }
            for (CtPackage p1 : CtPackageImpl.this.packs) {
                if (!p1.getQualifiedName().equals(pack.getQualifiedName())) continue;
                CtPackageImpl.this.addAllTypes(pack, p1);
                CtPackageImpl.this.addAllPackages(pack, p1);
                return false;
            }
            return super.add(pack);
        }
    };
    @MetamodelPropertyField(role={CtRole.CONTAINED_TYPE})
    private ModelSet<CtType<?>> types = new ModelSet<CtType<?>>(QualifiedNameComparator.INSTANCE){
        private static final long serialVersionUID = 1L;

        @Override
        protected CtElement getOwner() {
            return CtPackageImpl.this;
        }

        @Override
        protected CtRole getRole() {
            return CtRole.CONTAINED_TYPE;
        }
    };
    @MetamodelPropertyField(role={CtRole.IS_SHADOW})
    boolean isShadow;

    @Override
    public void accept(CtVisitor v) {
        v.visitCtPackage(this);
    }

    @Override
    public <T extends CtPackage> T addPackage(CtPackage pack) {
        this.packs.add(pack);
        return (T)this;
    }

    private void addAllTypes(CtPackage from, CtPackage to) {
        for (CtType<?> t : from.getTypes()) {
            for (CtType<?> t2 : to.getTypes()) {
                if (!t2.getQualifiedName().equals(t.getQualifiedName()) || t2.equals(t)) continue;
                throw new IllegalStateException("types with same qualified names and different code cannot be merged");
            }
            to.addType(t);
        }
    }

    private void addAllPackages(CtPackage from, CtPackage to) {
        for (CtPackage p : from.getPackages()) {
            to.addPackage(p);
        }
    }

    @Override
    public boolean removePackage(CtPackage pack) {
        return this.packs.remove(pack);
    }

    @Override
    public CtModule getDeclaringModule() {
        try {
            return this.getParent(CtModule.class);
        }
        catch (ParentNotInitializedException e) {
            return null;
        }
    }

    @Override
    public CtPackage getDeclaringPackage() {
        try {
            return this.getParent(CtPackage.class);
        }
        catch (ParentNotInitializedException e) {
            return null;
        }
    }

    @Override
    public CtPackage getPackage(String name) {
        for (CtPackage p : this.packs) {
            if (!p.getSimpleName().equals(name)) continue;
            return p;
        }
        return null;
    }

    @Override
    public Set<CtPackage> getPackages() {
        return this.packs;
    }

    @Override
    public String getQualifiedName() {
        if (this.getDeclaringPackage() == null || this.getDeclaringPackage().isUnnamedPackage()) {
            return this.getSimpleName();
        }
        return this.getDeclaringPackage().getQualifiedName() + "." + this.getSimpleName();
    }

    @Override
    public <T extends CtType<?>> T getType(String simpleName) {
        for (CtType<?> t : this.types) {
            if (!t.getSimpleName().equals(simpleName)) continue;
            return (T)t;
        }
        return null;
    }

    @Override
    public Set<CtType<?>> getTypes() {
        return this.types;
    }

    @Override
    public <T extends CtPackage> T setPackages(Set<CtPackage> packs) {
        this.packs.set(packs);
        return (T)this;
    }

    @Override
    public <T extends CtPackage> T setTypes(Set<CtType<?>> types) {
        this.types.set(types);
        return (T)this;
    }

    @Override
    public CtPackageReference getReference() {
        return this.getFactory().Package().createReference(this);
    }

    @Override
    public <T extends CtPackage> T addType(CtType<?> type) {
        this.types.add(type);
        return (T)this;
    }

    @Override
    public void removeType(CtType<?> type) {
        this.types.remove(type);
    }

    @Override
    public String toString() {
        return this.getQualifiedName();
    }

    @Override
    public boolean isShadow() {
        return this.isShadow;
    }

    @Override
    public <E extends CtShadowable> E setShadow(boolean isShadow) {
        this.getFactory().getEnvironment().getModelChangeListener().onObjectUpdate((CtElement)this, CtRole.IS_SHADOW, isShadow, this.isShadow);
        this.isShadow = isShadow;
        return (E)this;
    }

    @Override
    public CtPackage clone() {
        return (CtPackage)super.clone();
    }

    @Override
    public boolean isUnnamedPackage() {
        return "unnamed package".equals(this.getSimpleName());
    }

    @Override
    public boolean hasPackageInfo() {
        return !(this.getPosition() instanceof NoSourcePosition);
    }

    @Override
    public boolean isEmpty() {
        return this.getPackages().isEmpty() && this.getTypes().isEmpty();
    }
}

