/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.declaration;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import spoon.SpoonException;
import spoon.refactoring.Refactoring;
import spoon.reflect.annotations.MetamodelPropertyField;
import spoon.reflect.code.CtBlock;
import spoon.reflect.cu.CompilationUnit;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtAnnotationType;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtEnum;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtFormalTypeDeclarer;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtModifiable;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtShadowable;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeMember;
import spoon.reflect.declaration.CtTypeParameter;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.declaration.ParentNotInitializedException;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.DefaultJavaPrettyPrinter;
import spoon.reflect.visitor.EarlyTerminatingScanner;
import spoon.reflect.visitor.Query;
import spoon.reflect.visitor.chain.CtConsumer;
import spoon.reflect.visitor.filter.AllTypeMembersFunction;
import spoon.reflect.visitor.filter.NamedElementFilter;
import spoon.reflect.visitor.filter.ReferenceTypeFilter;
import spoon.support.DerivedProperty;
import spoon.support.UnsettableProperty;
import spoon.support.comparator.CtLineElementComparator;
import spoon.support.compiler.SnippetCompilationHelper;
import spoon.support.reflect.CtExtendedModifier;
import spoon.support.reflect.CtModifierHandler;
import spoon.support.reflect.declaration.CtElementImpl;
import spoon.support.reflect.declaration.CtNamedElementImpl;
import spoon.support.util.QualifiedNameBasedSortedSet;
import spoon.support.util.SignatureBasedSortedSet;
import spoon.support.visitor.ClassTypingContext;

public abstract class CtTypeImpl<T>
extends CtNamedElementImpl
implements CtType<T> {
    private static final long serialVersionUID = 1L;
    @MetamodelPropertyField(role={CtRole.TYPE_PARAMETER})
    List<CtTypeParameter> formalCtTypeParameters = CtTypeImpl.emptyList();
    @MetamodelPropertyField(role={CtRole.INTERFACE})
    Set<CtTypeReference<?>> interfaces = CtTypeImpl.emptySet();
    @MetamodelPropertyField(role={CtRole.MODIFIER})
    private CtModifierHandler modifierHandler = new CtModifierHandler(this);
    @MetamodelPropertyField(role={CtRole.TYPE_MEMBER, CtRole.FIELD, CtRole.CONSTRUCTOR, CtRole.ANNONYMOUS_EXECUTABLE, CtRole.METHOD, CtRole.NESTED_TYPE})
    List<CtTypeMember> typeMembers = CtTypeImpl.emptyList();
    @MetamodelPropertyField(role={CtRole.IS_SHADOW})
    boolean isShadow;

    @Override
    public List<CtTypeMember> getTypeMembers() {
        return Collections.unmodifiableList(this.typeMembers);
    }

    @Override
    public <C extends CtType<T>> C addTypeMember(CtTypeMember member) {
        if (member == null) {
            return (C)this;
        }
        CtLineElementComparator c = new CtLineElementComparator();
        if (member.isImplicit()) {
            return this.addTypeMemberAt(0, member);
        }
        int insertionPosition = this.typeMembers.size();
        if (member.getPosition().isValidPosition()) {
            CtTypeMember m;
            for (int i2 = this.typeMembers.size() - 1; !(i2 < 0 || (m = this.typeMembers.get(i2)).isImplicit() || m.getPosition().isValidPosition() && c.compare(member, m) > 0); --i2) {
                --insertionPosition;
            }
        }
        return this.addTypeMemberAt(insertionPosition, member);
    }

    @Override
    public <C extends CtType<T>> C addTypeMemberAt(int position, CtTypeMember member) {
        if (member == null) {
            return (C)this;
        }
        if (this.typeMembers == CtElementImpl.emptyList()) {
            this.typeMembers = new ArrayList<CtTypeMember>();
        }
        if (!this.typeMembers.stream().anyMatch(m -> m == member)) {
            member.setParent(this);
            CtRole role = CtRole.TYPE_MEMBER.getMatchingSubRoleFor(member);
            this.getFactory().getEnvironment().getModelChangeListener().onListAdd(this, role, this.typeMembers, position, member);
            if (position < this.typeMembers.size()) {
                this.typeMembers.add(position, member);
            } else {
                this.typeMembers.add(member);
            }
        }
        return (C)this;
    }

    @Override
    public boolean removeTypeMember(CtTypeMember member) {
        CtRole role = CtRole.TYPE_MEMBER.getMatchingSubRoleFor(member);
        if (this.typeMembers.size() == 1) {
            if (this.typeMembers.contains(member)) {
                this.getFactory().getEnvironment().getModelChangeListener().onListDelete(this, role, this.typeMembers, this.typeMembers.indexOf(member), member);
                this.typeMembers = CtTypeImpl.emptyList();
                return true;
            }
            return false;
        }
        if (this.typeMembers.contains(member)) {
            this.getFactory().getEnvironment().getModelChangeListener().onListDelete(this, role, this.typeMembers, this.typeMembers.indexOf(member), member);
            return this.typeMembers.remove(member);
        }
        return false;
    }

    @Override
    public <C extends CtType<T>> C setTypeMembers(List<CtTypeMember> members) {
        for (CtTypeMember typeMember : new ArrayList<CtTypeMember>(this.typeMembers)) {
            this.removeTypeMember(typeMember);
        }
        if (members == null || members.isEmpty()) {
            this.typeMembers = CtTypeImpl.emptyList();
            return (C)this;
        }
        this.typeMembers.clear();
        for (CtTypeMember typeMember : members) {
            this.addTypeMemberAt(this.typeMembers.size(), typeMember);
        }
        return (C)this;
    }

    @Override
    public <F, C extends CtType<T>> C addFieldAtTop(CtField<F> field) {
        return this.addTypeMemberAt(0, field);
    }

    @Override
    public <F, C extends CtType<T>> C addField(CtField<F> field) {
        return this.addTypeMember(field);
    }

    @Override
    public <F, C extends CtType<T>> C addField(int index, CtField<F> field) {
        return this.addTypeMemberAt(index, field);
    }

    @Override
    public <C extends CtType<T>> C setFields(List<CtField<?>> fields) {
        List<CtField<?>> oldFields = this.getFields();
        if (fields == null || fields.isEmpty()) {
            this.typeMembers.removeAll(oldFields);
            return (C)this;
        }
        this.getFactory().getEnvironment().getModelChangeListener().onListDelete(this, CtRole.FIELD, this.typeMembers, new ArrayList(oldFields));
        this.typeMembers.removeAll(oldFields);
        for (CtField<?> field : fields) {
            this.addField(field);
        }
        return (C)this;
    }

    @Override
    public <F> boolean removeField(CtField<F> field) {
        return this.removeTypeMember(field);
    }

    @Override
    public CtField<?> getField(String name) {
        for (CtTypeMember typeMember : this.typeMembers) {
            if (!(typeMember instanceof CtField) || !((CtField)typeMember).getSimpleName().equals(name)) continue;
            return (CtField)typeMember;
        }
        return null;
    }

    @Override
    public CtFieldReference<?> getDeclaredField(String name) {
        CtField<?> field = this.getField(name);
        return field != null ? this.getFactory().Field().createReference(field) : null;
    }

    @Override
    public CtFieldReference<?> getDeclaredOrInheritedField(String fieldName) {
        CtField field = (CtField)this.map(new AllTypeMembersFunction(CtField.class)).select(new NamedElementFilter<CtField>(CtField.class, fieldName)).first();
        return field == null ? null : field.getReference();
    }

    @Override
    public List<CtField<?>> getFields() {
        ArrayList<CtField> fields = new ArrayList<CtField>();
        for (CtTypeMember typeMember : this.typeMembers) {
            if (!(typeMember instanceof CtField)) continue;
            fields.add((CtField)typeMember);
        }
        return Collections.unmodifiableList(fields);
    }

    @Override
    public <N, C extends CtType<T>> C addNestedType(CtType<N> nestedType) {
        return this.addTypeMember(nestedType);
    }

    @Override
    public <N> boolean removeNestedType(CtType<N> nestedType) {
        return this.removeTypeMember(nestedType);
    }

    @Override
    public <C extends CtType<T>> C setNestedTypes(Set<CtType<?>> nestedTypes) {
        Set<CtType<?>> oldNestedTypes = this.getNestedTypes();
        this.getFactory().getEnvironment().getModelChangeListener().onListDelete(this, CtRole.NESTED_TYPE, this.typeMembers, oldNestedTypes);
        if (nestedTypes == null || nestedTypes.isEmpty()) {
            this.typeMembers.removeAll(oldNestedTypes);
            return (C)this;
        }
        this.typeMembers.removeAll(oldNestedTypes);
        for (CtType<?> nestedType : nestedTypes) {
            this.addNestedType(nestedType);
        }
        return (C)this;
    }

    @Override
    public Set<CtTypeReference<?>> getUsedTypes(boolean includeSamePackage) {
        QualifiedNameBasedSortedSet typeRefs = new QualifiedNameBasedSortedSet();
        for (CtTypeReference typeRef : Query.getReferences(this, new ReferenceTypeFilter<CtTypeReference>(CtTypeReference.class))) {
            if (!this.isValidTypeReference(typeRef) || !this.shouldIncludeSamePackage(includeSamePackage, typeRef)) continue;
            typeRefs.add(typeRef);
        }
        return typeRefs;
    }

    private boolean shouldIncludeSamePackage(boolean includeSamePackage, CtTypeReference<?> typeRef) {
        return includeSamePackage || this.getPackage() != null && CtTypeImpl.getPackageReference(typeRef).map((? super T v) -> v.equals(this.getPackage().getReference())).orElse(false) == false;
    }

    private boolean isValidTypeReference(CtTypeReference<?> typeRef) {
        return !this.isFromJavaLang(typeRef) && !typeRef.isPrimitive() && !(typeRef instanceof CtArrayTypeReference) && !"<nulltype>".equals(typeRef.toString());
    }

    private boolean isFromJavaLang(CtTypeReference<?> typeRef) {
        return typeRef.getPackage() != null && "java.lang".equals(typeRef.getPackage().toString());
    }

    private static Optional<CtPackageReference> getPackageReference(CtTypeReference<?> tref) {
        CtPackageReference pref = tref.getPackage();
        while (pref == null) {
            if ((tref = tref.getDeclaringType()) == null) {
                return Optional.empty();
            }
            pref = tref.getPackage();
        }
        return Optional.of(pref);
    }

    @Override
    public Class<T> getActualClass() {
        return this.getFactory().Type().createReference(this).getActualClass();
    }

    @Override
    public CtType<?> getDeclaringType() {
        try {
            return this.getParent(CtType.class);
        }
        catch (ParentNotInitializedException ex) {
            return null;
        }
    }

    @Override
    public <T> CtType<T> getTopLevelType() {
        CtType<Object> top = this;
        CtType<?> nextTop;
        while ((nextTop = top.getDeclaringType()) != null) {
            top = nextTop;
        }
        return top;
    }

    @Override
    public <N extends CtType<?>> N getNestedType(final String name) {
        class NestedTypeScanner
        extends EarlyTerminatingScanner<CtType<?>> {
            NestedTypeScanner() {
            }

            private boolean checkType(CtType<?> type) {
                if (type.getSimpleName().equals(name) && CtTypeImpl.this.equals(type.getDeclaringType())) {
                    this.setResult(type);
                    this.terminate();
                    return true;
                }
                return false;
            }

            public <U> void visitCtClass(CtClass<U> ctClass) {
                if (!this.checkType(ctClass)) {
                    ArrayList<CtTypeMember> typeMembers = new ArrayList<CtTypeMember>();
                    for (CtTypeMember typeMember : ctClass.getTypeMembers()) {
                        if (!(typeMember instanceof CtType) && !(typeMember instanceof CtConstructor) && !(typeMember instanceof CtMethod)) continue;
                        typeMembers.add(typeMember);
                    }
                    this.scan(typeMembers);
                }
            }

            public <U> void visitCtInterface(CtInterface<U> intrface) {
                if (!this.checkType(intrface)) {
                    ArrayList<CtTypeMember> typeMembers = new ArrayList<CtTypeMember>();
                    for (CtTypeMember typeMember : intrface.getTypeMembers()) {
                        if (!(typeMember instanceof CtType) && !(typeMember instanceof CtMethod)) continue;
                        typeMembers.add(typeMember);
                    }
                    this.scan(typeMembers);
                }
            }

            public <U extends Enum<?>> void visitCtEnum(CtEnum<U> ctEnum) {
                if (!this.checkType(ctEnum)) {
                    ArrayList<CtTypeMember> typeMembers = new ArrayList<CtTypeMember>();
                    for (CtTypeMember typeMember : ctEnum.getTypeMembers()) {
                        if (!(typeMember instanceof CtType) && !(typeMember instanceof CtConstructor) && !(typeMember instanceof CtMethod)) continue;
                        typeMembers.add(typeMember);
                    }
                    this.scan(typeMembers);
                }
            }

            @Override
            public <A extends Annotation> void visitCtAnnotationType(CtAnnotationType<A> annotationType) {
                if (!this.checkType(annotationType)) {
                    this.scan(annotationType.getNestedTypes());
                }
            }
        }
        NestedTypeScanner scanner = new NestedTypeScanner();
        scanner.scan(this);
        return (N)((CtType)scanner.getResult());
    }

    @Override
    public Set<CtType<?>> getNestedTypes() {
        QualifiedNameBasedSortedSet<CtType> nestedTypes = new QualifiedNameBasedSortedSet<CtType>();
        for (CtTypeMember typeMember : this.typeMembers) {
            if (!(typeMember instanceof CtType)) continue;
            nestedTypes.add((CtType)typeMember);
        }
        return Collections.unmodifiableSet(nestedTypes);
    }

    @Override
    public CtPackage getPackage() {
        if (this.parent instanceof CtPackage) {
            return (CtPackage)this.getParent();
        }
        if (this.parent instanceof CtType) {
            return ((CtType)this.parent).getPackage();
        }
        return null;
    }

    @Override
    public CtTypeReference<T> getReference() {
        return this.getFactory().Type().createReference(this);
    }

    @Override
    public boolean isTopLevel() {
        return this.getDeclaringType() == null && this.getPackage() != null;
    }

    @Override
    public void compileAndReplaceSnippets() {
        SnippetCompilationHelper.compileAndReplaceSnippetsIn(this);
    }

    @Override
    public Set<ModifierKind> getModifiers() {
        return this.modifierHandler.getModifiers();
    }

    @Override
    public boolean hasModifier(ModifierKind modifier) {
        return this.getModifiers().contains((Object)modifier);
    }

    public <C extends CtModifiable> C setModifiers(Set<ModifierKind> modifiers) {
        this.modifierHandler.setModifiers(modifiers);
        return (C)this;
    }

    public <C extends CtModifiable> C addModifier(ModifierKind modifier) {
        this.modifierHandler.addModifier(modifier);
        return (C)this;
    }

    public <C extends CtModifiable> C removeModifier(ModifierKind modifier) {
        this.modifierHandler.removeModifier(modifier);
        return (C)this;
    }

    public <C extends CtModifiable> C setVisibility(ModifierKind visibility) {
        this.modifierHandler.setVisibility(visibility);
        return (C)this;
    }

    @Override
    public ModifierKind getVisibility() {
        return this.modifierHandler.getVisibility();
    }

    @Override
    public Set<CtExtendedModifier> getExtendedModifiers() {
        return this.modifierHandler.getExtendedModifiers();
    }

    @Override
    public <T extends CtModifiable> T setExtendedModifiers(Set<CtExtendedModifier> extendedModifiers) {
        this.modifierHandler.setExtendedModifiers(extendedModifiers);
        return (T)this;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }

    @Override
    public boolean isLocalType() {
        return this.isParentInitialized() && this.getParent() instanceof CtBlock;
    }

    @Override
    @DerivedProperty
    public CtTypeReference<?> getSuperclass() {
        return null;
    }

    @Override
    public boolean isClass() {
        return false;
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public boolean isAnnotationType() {
        return false;
    }

    @Override
    public boolean isEnum() {
        return false;
    }

    @Override
    public boolean isGenerics() {
        for (CtTypeParameter ref : this.formalCtTypeParameters) {
            if (!ref.isGenerics()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isParameterized() {
        return !this.formalCtTypeParameters.isEmpty();
    }

    public List<CtFieldReference<?>> getAllFields() {
        final ArrayList fields = new ArrayList();
        this.map(new AllTypeMembersFunction(CtField.class)).forEach(new CtConsumer<CtField<?>>(){

            @Override
            public void accept(CtField<?> field) {
                fields.add(field.getReference());
            }
        });
        return fields;
    }

    public List<CtFieldReference<?>> getDeclaredFields() {
        if (this.typeMembers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList fields = new ArrayList(this.typeMembers.size());
        for (CtTypeMember typeMember : this.typeMembers) {
            if (!(typeMember instanceof CtField)) continue;
            fields.add((CtFieldReference<?>)((CtField)typeMember).getReference());
        }
        return fields;
    }

    @Override
    public <M, C extends CtType<T>> C addMethod(CtMethod<M> method) {
        if (method != null) {
            for (CtTypeMember typeMember : new ArrayList<CtTypeMember>(this.typeMembers)) {
                CtMethod m;
                if (!(typeMember instanceof CtMethod) || !(m = (CtMethod)typeMember).getSignature().equals(method.getSignature())) continue;
                this.removeTypeMember(m);
            }
        }
        return this.addTypeMember(method);
    }

    @Override
    public <M> boolean removeMethod(CtMethod<M> method) {
        return this.removeTypeMember(method);
    }

    @Override
    public <S, C extends CtType<T>> C addSuperInterface(CtTypeReference<S> interfac) {
        if (interfac == null) {
            return (C)this;
        }
        if (this.interfaces == CtElementImpl.emptySet()) {
            this.interfaces = new QualifiedNameBasedSortedSet();
        }
        interfac.setParent(this);
        this.getFactory().getEnvironment().getModelChangeListener().onSetAdd((CtElement)this, CtRole.INTERFACE, this.interfaces, interfac);
        this.interfaces.add(interfac);
        return (C)this;
    }

    @Override
    public <S> boolean removeSuperInterface(CtTypeReference<S> interfac) {
        this.getFactory().getEnvironment().getModelChangeListener().onSetDelete((CtElement)this, CtRole.INTERFACE, this.interfaces, interfac);
        if (this.interfaces == CtElementImpl.emptySet()) {
            return false;
        }
        if (this.interfaces.size() == 1) {
            if (this.interfaces.contains(interfac)) {
                this.interfaces = CtElementImpl.emptySet();
                return true;
            }
            return false;
        }
        return this.interfaces.contains(interfac) && this.interfaces.remove(interfac);
    }

    @Override
    public List<CtTypeParameter> getFormalCtTypeParameters() {
        return this.formalCtTypeParameters;
    }

    public <C extends CtFormalTypeDeclarer> C setFormalCtTypeParameters(List<CtTypeParameter> formalTypeParameters) {
        this.getFactory().getEnvironment().getModelChangeListener().onListDeleteAll(this, CtRole.TYPE_PARAMETER, this.formalCtTypeParameters, new ArrayList<CtTypeParameter>(this.formalCtTypeParameters));
        if (formalTypeParameters == null || formalTypeParameters.isEmpty()) {
            this.formalCtTypeParameters = CtElementImpl.emptyList();
            return (C)this;
        }
        if (this.formalCtTypeParameters == CtElementImpl.emptyList()) {
            this.formalCtTypeParameters = new ArrayList<CtTypeParameter>(2);
        }
        this.formalCtTypeParameters.clear();
        for (CtTypeParameter formalTypeParameter : formalTypeParameters) {
            this.addFormalCtTypeParameter(formalTypeParameter);
        }
        return (C)this;
    }

    public <C extends CtFormalTypeDeclarer> C addFormalCtTypeParameter(CtTypeParameter formalTypeParameter) {
        if (formalTypeParameter == null) {
            return (C)this;
        }
        if (this.formalCtTypeParameters == CtElementImpl.emptyList()) {
            this.formalCtTypeParameters = new ArrayList<CtTypeParameter>(2);
        }
        formalTypeParameter.setParent(this);
        this.getFactory().getEnvironment().getModelChangeListener().onListAdd(this, CtRole.TYPE_PARAMETER, this.formalCtTypeParameters, formalTypeParameter);
        this.formalCtTypeParameters.add(formalTypeParameter);
        return (C)this;
    }

    @Override
    public boolean removeFormalCtTypeParameter(CtTypeParameter formalTypeParameter) {
        if (this.formalCtTypeParameters == CtElementImpl.emptyList()) {
            return false;
        }
        this.getFactory().getEnvironment().getModelChangeListener().onListDelete(this, CtRole.TYPE_PARAMETER, this.formalCtTypeParameters, this.formalCtTypeParameters.indexOf(formalTypeParameter), formalTypeParameter);
        return this.formalCtTypeParameters.remove(formalTypeParameter);
    }

    @Override
    public <R> CtMethod<R> getMethod(CtTypeReference<R> returnType, String name, CtTypeReference<?> ... parameterTypes) {
        for (CtTypeMember typeMember : this.typeMembers) {
            CtMethod m;
            if (!(typeMember instanceof CtMethod) || !(m = (CtMethod)typeMember).getSimpleName().equals(name) || !m.getType().equals(returnType)) continue;
            boolean cont = m.getParameters().size() == parameterTypes.length;
            for (int i2 = 0; cont && i2 < m.getParameters().size() && i2 < parameterTypes.length; ++i2) {
                if (m.getParameters().get(i2).getType().getQualifiedName().equals(parameterTypes[i2].getQualifiedName())) continue;
                cont = false;
            }
            if (!cont) continue;
            return m;
        }
        return null;
    }

    @Override
    public <R> CtMethod<R> getMethod(String name, CtTypeReference<?> ... parameterTypes) {
        if (name == null) {
            return null;
        }
        for (CtMethod<?> candidate : this.getMethodsByName(name)) {
            if (!this.hasSameParameters(candidate, parameterTypes)) continue;
            return candidate;
        }
        return null;
    }

    protected boolean hasSameParameters(CtExecutable<?> candidate, CtTypeReference<?> ... parameterTypes) {
        if (candidate.getParameters().size() != parameterTypes.length) {
            return false;
        }
        for (int i2 = 0; i2 < candidate.getParameters().size() && i2 < parameterTypes.length; ++i2) {
            CtTypeReference ctParameterType = candidate.getParameters().get(i2).getType();
            CtTypeReference<?> parameterType = parameterTypes[i2];
            if (parameterType instanceof CtArrayTypeReference) {
                if (ctParameterType instanceof CtArrayTypeReference) {
                    if (!this.isSameParameter(candidate, ((CtArrayTypeReference)ctParameterType).getComponentType(), ((CtArrayTypeReference)parameterType).getComponentType())) {
                        return false;
                    }
                    if (((CtArrayTypeReference)ctParameterType).getDimensionCount() == ((CtArrayTypeReference)parameterType).getDimensionCount()) continue;
                    return false;
                }
                return false;
            }
            if (this.isSameParameter(candidate, ctParameterType, parameterType)) continue;
            return false;
        }
        return true;
    }

    private boolean isSameParameter(CtExecutable<?> candidate, CtTypeReference<?> ctParameterType, CtTypeReference<?> expectedType) {
        return ctParameterType.getTypeErasure().getQualifiedName().equals(expectedType.getTypeErasure().getQualifiedName());
    }

    @Override
    public Set<CtMethod<?>> getMethods() {
        SignatureBasedSortedSet<CtMethod> methods = new SignatureBasedSortedSet<CtMethod>();
        for (CtTypeMember typeMember : this.typeMembers) {
            if (!(typeMember instanceof CtMethod)) continue;
            methods.add((CtMethod)typeMember);
        }
        return Collections.unmodifiableSet(methods);
    }

    @Override
    public Set<CtMethod<?>> getMethodsAnnotatedWith(CtTypeReference<?> ... annotationTypes) {
        SignatureBasedSortedSet result = new SignatureBasedSortedSet();
        for (CtTypeMember typeMember : this.typeMembers) {
            if (!(typeMember instanceof CtMethod)) continue;
            CtMethod m = (CtMethod)typeMember;
            for (CtAnnotation<? extends Annotation> a : m.getAnnotations()) {
                if (!Arrays.asList(annotationTypes).contains(a.getAnnotationType())) continue;
                result.add(m);
            }
        }
        return result;
    }

    @Override
    public List<CtMethod<?>> getMethodsByName(String name) {
        ArrayList result = new ArrayList(1);
        for (CtTypeMember typeMember : this.typeMembers) {
            CtMethod m;
            if (!(typeMember instanceof CtMethod) || !name.equals((m = (CtMethod)typeMember).getSimpleName())) continue;
            result.add(m);
        }
        return result;
    }

    @Override
    public boolean hasMethod(CtMethod<?> method) {
        if (method == null) {
            return false;
        }
        String over = method.getSignature();
        for (CtMethod<?> m : this.getMethods()) {
            if (!m.getSignature().equals(over)) continue;
            return true;
        }
        CtTypeReference<?> superCl = this.getSuperclass();
        try {
            if (superCl != null && superCl.getTypeDeclaration().hasMethod(method)) {
                return true;
            }
        }
        catch (SpoonException spoonException) {
            // empty catch block
        }
        for (CtTypeReference<?> interf : this.getSuperInterfaces()) {
            try {
                if (!interf.getTypeDeclaration().hasMethod(method)) continue;
                return true;
            }
            catch (SpoonException spoonException) {
            }
        }
        return false;
    }

    @Override
    public String getQualifiedName() {
        if (this.isTopLevel()) {
            if (this.getPackage() != null && !this.getPackage().isUnnamedPackage()) {
                return this.getPackage().getQualifiedName() + "." + this.getSimpleName();
            }
            return this.getSimpleName();
        }
        if (this.getDeclaringType() != null) {
            return this.getDeclaringType().getQualifiedName() + "$" + this.getSimpleName();
        }
        return this.getSimpleName();
    }

    @Override
    public Set<CtTypeReference<?>> getSuperInterfaces() {
        return this.interfaces;
    }

    @Override
    public <C extends CtType<T>> C setMethods(Set<CtMethod<?>> methods) {
        Set<CtMethod<?>> allMethods = this.getMethods();
        this.getFactory().getEnvironment().getModelChangeListener().onListDelete(this, CtRole.METHOD, this.typeMembers, new ArrayList(allMethods));
        this.typeMembers.removeAll(allMethods);
        if (methods == null || methods.isEmpty()) {
            return (C)this;
        }
        for (CtMethod<?> meth : methods) {
            this.addMethod(meth);
        }
        return (C)this;
    }

    @Override
    @UnsettableProperty
    public <C extends CtType<T>> C setSuperclass(CtTypeReference<?> superClass) {
        return (C)this;
    }

    @Override
    public <C extends CtType<T>> C setSuperInterfaces(Set<CtTypeReference<?>> interfaces) {
        if (interfaces == null || interfaces.isEmpty()) {
            this.interfaces = CtElementImpl.emptySet();
            return (C)this;
        }
        if (this.interfaces == CtElementImpl.emptySet()) {
            this.interfaces = new QualifiedNameBasedSortedSet();
        }
        this.getFactory().getEnvironment().getModelChangeListener().onSetDeleteAll(this, CtRole.INTERFACE, this.interfaces, new HashSet(this.interfaces));
        this.interfaces.clear();
        for (CtTypeReference<?> anInterface : interfaces) {
            this.addSuperInterface(anInterface);
        }
        return (C)this;
    }

    @Override
    public Collection<CtExecutableReference<?>> getDeclaredExecutables() {
        if (this.getMethods().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<CtReference> l = new ArrayList<CtReference>(this.getMethods().size());
        for (CtExecutable ctExecutable : this.getMethods()) {
            l.add(ctExecutable.getReference());
        }
        return Collections.unmodifiableList(l);
    }

    @Override
    public Collection<CtExecutableReference<?>> getAllExecutables() {
        SignatureBasedSortedSet l = new SignatureBasedSortedSet();
        for (CtMethod<?> m : this.getAllMethods()) {
            l.add((CtExecutableReference<?>)m.getReference());
        }
        return l;
    }

    @Override
    public Set<CtMethod<?>> getAllMethods() {
        final HashSet l = new HashSet();
        final ClassTypingContext ctc = new ClassTypingContext(this);
        this.map(new AllTypeMembersFunction(CtMethod.class)).forEach(new CtConsumer<CtMethod<?>>(){

            @Override
            public void accept(CtMethod<?> currentMethod) {
                for (CtMethod alreadyVisitedMethod : l) {
                    if (!ctc.isSameSignature(currentMethod, alreadyVisitedMethod)) continue;
                    return;
                }
                l.add(currentMethod);
            }
        });
        return Collections.unmodifiableSet(l);
    }

    @Override
    public CtTypeReference<?> getTypeErasure() {
        return this.getReference();
    }

    @Override
    public boolean isShadow() {
        return this.isShadow;
    }

    @Override
    public <E extends CtShadowable> E setShadow(boolean isShadow) {
        this.getFactory().getEnvironment().getModelChangeListener().onObjectUpdate((CtElement)this, CtRole.IS_SHADOW, isShadow, this.isShadow);
        this.isShadow = isShadow;
        return (E)this;
    }

    @Override
    public CtType<T> clone() {
        return (CtType)super.clone();
    }

    @Override
    public boolean isPublic() {
        return this.modifierHandler.isPublic();
    }

    @Override
    public boolean isPrivate() {
        return this.modifierHandler.isPrivate();
    }

    @Override
    public boolean isProtected() {
        return this.modifierHandler.isProtected();
    }

    @Override
    public boolean isFinal() {
        return this.modifierHandler.isFinal();
    }

    @Override
    public boolean isStatic() {
        return this.modifierHandler.isStatic();
    }

    @Override
    public boolean isAbstract() {
        return this.modifierHandler.isAbstract();
    }

    @Override
    public CtType<?> copyType() {
        return Refactoring.copyType(this);
    }

    @Override
    public boolean isArray() {
        return this.getSimpleName().contains("[");
    }

    @Override
    public String toStringWithImports() {
        DefaultJavaPrettyPrinter printer = (DefaultJavaPrettyPrinter)this.getFactory().getEnvironment().createPrettyPrinter();
        CompilationUnit cu = this.getFactory().createCompilationUnit();
        cu.addDeclaredType(this);
        return printer.printCompilationUnit(cu);
    }
}

