/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.eval;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import spoon.reflect.code.CtAnnotationFieldAccess;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtCatch;
import spoon.reflect.code.CtCatchVariable;
import spoon.reflect.code.CtComment;
import spoon.reflect.code.CtConditional;
import spoon.reflect.code.CtDo;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtFieldWrite;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtSynchronized;
import spoon.reflect.code.CtThrow;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.code.CtVariableWrite;
import spoon.reflect.code.CtWhile;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.eval.PartialEvaluator;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtScanner;
import spoon.support.util.RtHelper;

public class VisitorPartialEvaluator
extends CtScanner
implements PartialEvaluator {
    boolean flowEnded = false;
    CtElement result;

    Number convert(CtTypeReference<?> type, Number n) {
        if (type.getActualClass() == Integer.TYPE || type.getActualClass() == Integer.class) {
            return n.intValue();
        }
        if (type.getActualClass() == Byte.TYPE || type.getActualClass() == Byte.class) {
            return n.byteValue();
        }
        if (type.getActualClass() == Long.TYPE || type.getActualClass() == Long.class) {
            return n.longValue();
        }
        if (type.getActualClass() == Float.TYPE || type.getActualClass() == Float.class) {
            return Float.valueOf(n.floatValue());
        }
        if (type.getActualClass() == Short.TYPE || type.getActualClass() == Short.class) {
            return n.shortValue();
        }
        return n;
    }

    @Override
    protected void exit(CtElement e) {
        this.result = null;
    }

    @Override
    public <R extends CtElement> R evaluate(R element) {
        if (element == null) {
            return null;
        }
        element.accept(this);
        if (this.result != null) {
            CtElement r = this.result;
            this.result = null;
            if (element.isParentInitialized()) {
                r.setParent(element.getParent());
            }
            return (R)r;
        }
        return (R)element.clone();
    }

    void setResult(CtElement element) {
        this.result = element;
    }

    @Override
    public <T> void visitCtBinaryOperator(CtBinaryOperator<T> operator) {
        CtExpression<?> left = this.evaluate(operator.getLeftHandOperand());
        CtExpression<?> right = this.evaluate(operator.getRightHandOperand());
        if (left instanceof CtLiteral && right instanceof CtLiteral) {
            Object leftObject = ((CtLiteral)left).getValue();
            Object rightObject = ((CtLiteral)right).getValue();
            CtLiteral<Object> res = operator.getFactory().Core().createLiteral();
            switch (operator.getKind()) {
                case AND: {
                    res.setValue((Boolean)leftObject != false && (Boolean)rightObject != false);
                    break;
                }
                case OR: {
                    res.setValue((Boolean)leftObject != false || (Boolean)rightObject != false);
                    break;
                }
                case EQ: {
                    if (leftObject == null) {
                        res.setValue(leftObject == rightObject);
                        break;
                    }
                    res.setValue(leftObject.equals(rightObject));
                    break;
                }
                case NE: {
                    if (leftObject == null) {
                        res.setValue(leftObject != rightObject);
                        break;
                    }
                    res.setValue(!leftObject.equals(rightObject));
                    break;
                }
                case GE: {
                    res.setValue(((Number)leftObject).doubleValue() >= ((Number)rightObject).doubleValue());
                    break;
                }
                case LE: {
                    res.setValue(((Number)leftObject).doubleValue() <= ((Number)rightObject).doubleValue());
                    break;
                }
                case GT: {
                    res.setValue(((Number)leftObject).doubleValue() > ((Number)rightObject).doubleValue());
                    break;
                }
                case LT: {
                    res.setValue(((Number)leftObject).doubleValue() < ((Number)rightObject).doubleValue());
                    break;
                }
                case MINUS: {
                    res.setValue(this.convert(operator.getType(), ((Number)leftObject).doubleValue() - ((Number)rightObject).doubleValue()));
                    break;
                }
                case MUL: {
                    res.setValue(this.convert(operator.getType(), ((Number)leftObject).doubleValue() * ((Number)rightObject).doubleValue()));
                    break;
                }
                case DIV: {
                    res.setValue(this.convert(operator.getType(), ((Number)leftObject).doubleValue() / ((Number)rightObject).doubleValue()));
                    break;
                }
                case PLUS: {
                    if (leftObject instanceof String || rightObject instanceof String) {
                        res.setValue("" + leftObject + rightObject);
                        break;
                    }
                    res.setValue(this.convert(operator.getType(), ((Number)leftObject).doubleValue() + ((Number)rightObject).doubleValue()));
                    break;
                }
                case BITAND: {
                    if (leftObject instanceof Boolean) {
                        res.setValue((Boolean)leftObject & (Boolean)rightObject);
                        break;
                    }
                    res.setValue(((Number)leftObject).intValue() & ((Number)rightObject).intValue());
                    break;
                }
                case BITOR: {
                    if (leftObject instanceof Boolean) {
                        res.setValue((Boolean)leftObject | (Boolean)rightObject);
                        break;
                    }
                    res.setValue(((Number)leftObject).intValue() | ((Number)rightObject).intValue());
                    break;
                }
                case BITXOR: {
                    if (leftObject instanceof Boolean) {
                        res.setValue((Boolean)leftObject ^ (Boolean)rightObject);
                        break;
                    }
                    res.setValue(((Number)leftObject).intValue() ^ ((Number)rightObject).intValue());
                    break;
                }
                default: {
                    throw new RuntimeException("unsupported operator " + (Object)((Object)operator.getKind()));
                }
            }
            this.setResult(res);
        } else if (left instanceof CtLiteral || right instanceof CtLiteral) {
            CtExpression<?> expr;
            CtLiteral literal;
            if (left instanceof CtLiteral) {
                literal = (CtLiteral)left;
                expr = right;
            } else {
                literal = (CtLiteral)right;
                expr = left;
            }
            Object o = literal.getValue();
            CtLiteral<Boolean> res = operator.getFactory().Core().createLiteral();
            switch (operator.getKind()) {
                case AND: {
                    if (((Boolean)o).booleanValue()) {
                        this.setResult(expr);
                    } else {
                        res.setValue(false);
                        this.setResult(res);
                    }
                    return;
                }
                case OR: {
                    if (((Boolean)o).booleanValue()) {
                        res.setValue(true);
                        this.setResult(res);
                    } else {
                        this.setResult(expr);
                    }
                    return;
                }
                case BITOR: {
                    if (o instanceof Boolean && ((Boolean)o).booleanValue()) {
                        res.setValue(true);
                        this.setResult(res);
                    }
                    return;
                }
            }
        }
    }

    @Override
    public <R> void visitCtBlock(CtBlock<R> block) {
        CtBlock b = block.getFactory().Core().createBlock();
        for (CtStatement s : block.getStatements()) {
            CtStatement res = this.evaluate(s);
            if (res != null) {
                if (res instanceof CtStatement) {
                    b.addStatement(res);
                } else {
                    b.addStatement(s.clone());
                }
            }
            if (!this.flowEnded) continue;
            break;
        }
        this.setResult(b);
    }

    @Override
    public void visitCtDo(CtDo doLoop) {
        CtDo w = doLoop.clone();
        w.setLoopingExpression(this.evaluate(doLoop.getLoopingExpression()));
        w.setBody(this.evaluate(doLoop.getBody()));
        this.setResult(w);
    }

    @Override
    public <T> void visitCtFieldRead(CtFieldRead<T> fieldRead) {
        this.visitFieldAccess(fieldRead);
    }

    @Override
    public <T> void visitCtFieldWrite(CtFieldWrite<T> fieldWrite) {
        this.visitFieldAccess(fieldWrite);
    }

    private <T> void visitFieldAccess(CtFieldAccess<T> fieldAccess) {
        Object target;
        Class<?> actualClass;
        if ("class".equals(fieldAccess.getVariable().getSimpleName()) && (actualClass = fieldAccess.getVariable().getDeclaringType().getActualClass()) != null) {
            CtLiteral<Class<?>> literal = fieldAccess.getFactory().Core().createLiteral();
            literal.setValue(actualClass);
            this.setResult(literal);
            return;
        }
        if ("length".equals(fieldAccess.getVariable().getSimpleName()) && (target = fieldAccess.getTarget()) instanceof CtNewArray) {
            CtNewArray newArr = (CtNewArray)target;
            CtLiteral<Integer> literal = fieldAccess.getFactory().createLiteral(newArr.getElements().size());
            this.setResult(literal);
            return;
        }
        String fieldName = fieldAccess.getVariable().getSimpleName();
        CtType<?> typeDeclaration = fieldAccess.getVariable().getDeclaringType().getTypeDeclaration();
        CtField<Object> f = typeDeclaration != null ? typeDeclaration.getField(fieldName) : fieldAccess.getVariable().getFieldDeclaration();
        if (f != null && f.getModifiers().contains((Object)ModifierKind.FINAL) && !fieldAccess.getVariable().getDeclaringType().isSubtypeOf(fieldAccess.getFactory().Type().ENUM)) {
            this.setResult(this.evaluate(f.getDefaultExpression()));
            return;
        }
        this.setResult(fieldAccess.clone());
    }

    @Override
    public <T> void visitCtAnnotationFieldAccess(CtAnnotationFieldAccess<T> annotationFieldAccess) {
        CtVariable f = annotationFieldAccess.getVariable().getDeclaration();
        this.setResult(this.evaluate(f.getDefaultExpression()));
    }

    @Override
    public void visitCtFor(CtFor forLoop) {
        CtStatement evaluateStatement;
        List<CtStatement> lst = forLoop.getForInit();
        for (CtStatement s : new ArrayList<CtStatement>(lst)) {
            evaluateStatement = this.evaluate(s);
            if (evaluateStatement == null) continue;
            forLoop.addForInit(evaluateStatement);
        }
        forLoop.setExpression(this.evaluate(forLoop.getExpression()));
        lst = forLoop.getForUpdate();
        for (CtStatement s : new ArrayList<CtStatement>(lst)) {
            evaluateStatement = this.evaluate(s);
            if (evaluateStatement == null) continue;
            forLoop.addForUpdate(evaluateStatement);
        }
        this.setResult(forLoop.clone());
    }

    @Override
    public void visitCtIf(CtIf ifElement) {
        CtExpression<Boolean> r = this.evaluate(ifElement.getCondition());
        if (r instanceof CtLiteral) {
            CtLiteral l = (CtLiteral)r;
            if (((Boolean)l.getValue()).booleanValue()) {
                this.setResult((CtElement)this.evaluate((CtElement)ifElement.getThenStatement()));
            } else if (ifElement.getElseStatement() != null) {
                this.setResult((CtElement)this.evaluate((CtElement)ifElement.getElseStatement()));
            } else {
                this.setResult(ifElement.getFactory().Code().createComment("if removed", CtComment.CommentType.INLINE));
            }
        } else {
            CtIf ifRes = ifElement.getFactory().Core().createIf();
            ifRes.setCondition(r);
            boolean thenEnded = false;
            boolean elseEnded = false;
            ifRes.setThenStatement((CtStatement)this.evaluate((CtElement)ifElement.getThenStatement()));
            if (this.flowEnded) {
                thenEnded = true;
                this.flowEnded = false;
            }
            if (ifElement.getElseStatement() != null) {
                ifRes.setElseStatement((CtStatement)this.evaluate((CtElement)ifElement.getElseStatement()));
            }
            if (this.flowEnded) {
                elseEnded = true;
                this.flowEnded = false;
            }
            this.setResult(ifRes);
            if (thenEnded && elseEnded) {
                this.flowEnded = true;
            }
        }
    }

    @Override
    public <T> void visitCtInvocation(CtInvocation<T> invocation) {
        CtInvocation i2 = invocation.getFactory().Core().createInvocation();
        i2.setExecutable(invocation.getExecutable());
        i2.setTypeCasts(invocation.getTypeCasts());
        boolean constant = true;
        i2.setTarget((CtExpression)this.evaluate((CtElement)invocation.getTarget()));
        if (i2.getTarget() != null && !(i2.getTarget() instanceof CtLiteral)) {
            constant = false;
        }
        for (CtExpression<?> e : invocation.getArguments()) {
            CtExpression<?> re = this.evaluate(e);
            if (!(re instanceof CtLiteral)) {
                constant = false;
            }
            i2.addArgument(re);
        }
        if (i2.getExecutable().getSimpleName().equals("<init>")) {
            this.setResult(i2);
            return;
        }
        if (constant) {
            CtElement executable = invocation.getExecutable().getDeclaration();
            CtType aType = invocation.getParent(CtType.class);
            CtTypeReference<?> execDeclaringType = invocation.getExecutable().getDeclaringType();
            if (executable != null && aType != null && invocation.getType() != null && execDeclaringType != null && execDeclaringType.isSubtypeOf((CtTypeReference<?>)aType.getReference())) {
                CtBlock b = (CtBlock)this.evaluate(executable.getBody());
                this.flowEnded = false;
                CtStatement last = b.getStatements().get(b.getStatements().size() - 1);
                if (last instanceof CtReturn && ((CtReturn)last).getReturnedExpression() instanceof CtLiteral) {
                    this.setResult(((CtReturn)last).getReturnedExpression());
                    return;
                }
            } else {
                try {
                    Object r = RtHelper.invoke(i2);
                    if (this.isLiteralType(r)) {
                        CtLiteral l = invocation.getFactory().Core().createLiteral();
                        l.setValue(r);
                        this.setResult(l);
                        return;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.setResult(i2);
    }

    private boolean isLiteralType(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof String) {
            return true;
        }
        if (object instanceof Number) {
            return true;
        }
        if (object instanceof Character) {
            return true;
        }
        return object instanceof Class;
    }

    @Override
    public <T> void visitCtField(CtField<T> f) {
        CtNamedElement r = f.clone();
        r.setDefaultExpression(this.evaluate(f.getDefaultExpression()));
        this.setResult(r);
    }

    @Override
    public <T> void visitCtLocalVariable(CtLocalVariable<T> localVariable) {
        CtStatement r = localVariable.clone();
        r.setDefaultExpression(this.evaluate(localVariable.getDefaultExpression()));
        this.setResult(r);
    }

    @Override
    public <T> void visitCtCatchVariable(CtCatchVariable<T> catchVariable) {
        CtNamedElement r = catchVariable.clone();
        r.setDefaultExpression(this.evaluate(catchVariable.getDefaultExpression()));
        this.setResult(r);
    }

    @Override
    public <R> void visitCtReturn(CtReturn<R> returnStatement) {
        CtReturn<R> r = returnStatement.getFactory().Core().createReturn();
        r.setReturnedExpression(this.evaluate(returnStatement.getReturnedExpression()));
        this.setResult(r);
        this.flowEnded = true;
    }

    @Override
    public void visitCtSynchronized(CtSynchronized synchro) {
        CtSynchronized s = synchro.clone();
        s.setBlock(this.evaluate(synchro.getBlock()));
        this.setResult(s);
    }

    @Override
    public void visitCtThrow(CtThrow throwStatement) {
        CtThrow r = throwStatement.getFactory().Core().createThrow();
        r.setThrownExpression(this.evaluate(throwStatement.getThrownExpression()));
        this.setResult(r);
        this.flowEnded = true;
    }

    @Override
    public void visitCtCatch(CtCatch catchBlock) {
        super.visitCtCatch(catchBlock);
        this.flowEnded = false;
    }

    @Override
    public <T> void visitCtUnaryOperator(CtUnaryOperator<T> operator) {
        CtExpression<T> operand = this.evaluate(operator.getOperand());
        if (operand instanceof CtLiteral) {
            Object object = ((CtLiteral)operand).getValue();
            CtLiteral<Serializable> res = operator.getFactory().Core().createLiteral();
            switch (operator.getKind()) {
                case NOT: {
                    res.setValue(Boolean.valueOf((Boolean)object == false));
                    break;
                }
                case NEG: {
                    res.setValue(this.convert(operator.getType(), -1L * ((Number)object).longValue()));
                    break;
                }
                default: {
                    throw new RuntimeException("unsupported operator " + (Object)((Object)operator.getKind()));
                }
            }
            this.setResult(res);
            return;
        }
        this.setResult(operator.clone());
    }

    @Override
    public <T> void visitCtVariableRead(CtVariableRead<T> variableRead) {
        this.visitVariableAccess(variableRead);
    }

    @Override
    public <T> void visitCtVariableWrite(CtVariableWrite<T> variableWrite) {
        this.visitVariableAccess(variableWrite);
    }

    private <T> void visitVariableAccess(CtVariableAccess<T> variableAccess) {
        CtElement v = variableAccess.getVariable().getDeclaration();
        if (v != null && v.hasModifier(ModifierKind.FINAL) && v.getDefaultExpression() != null) {
            this.setResult(this.evaluate(v.getDefaultExpression()));
        } else {
            this.setResult(variableAccess.clone());
        }
    }

    @Override
    public <T, A extends T> void visitCtAssignment(CtAssignment<T, A> variableAssignment) {
        CtStatement a = variableAssignment.clone();
        a.setAssignment(this.evaluate(a.getAssignment()));
        this.setResult(a);
    }

    @Override
    public void visitCtWhile(CtWhile whileLoop) {
        CtWhile w = whileLoop.clone();
        w.setLoopingExpression(this.evaluate(whileLoop.getLoopingExpression()));
        if (whileLoop.getLoopingExpression() instanceof CtLiteral && !((Boolean)((CtLiteral)whileLoop.getLoopingExpression()).getValue()).booleanValue()) {
            this.setResult(null);
            return;
        }
        w.setBody(this.evaluate(whileLoop.getBody()));
        this.setResult(w);
    }

    @Override
    public <T> void visitCtConditional(CtConditional<T> conditional) {
        CtExpression<Boolean> r = this.evaluate(conditional.getCondition());
        if (r instanceof CtLiteral) {
            CtLiteral l = (CtLiteral)r;
            if (((Boolean)l.getValue()).booleanValue()) {
                this.setResult(this.evaluate(conditional.getThenExpression()));
            } else {
                this.setResult(this.evaluate(conditional.getElseExpression()));
            }
        } else {
            CtConditional<T> ifRes = conditional.getFactory().Core().createConditional();
            ifRes.setCondition(r);
            ifRes.setThenExpression(this.evaluate(conditional.getThenExpression()));
            ifRes.setElseExpression(this.evaluate(conditional.getElseExpression()));
            this.setResult(ifRes);
        }
    }
}

