/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.reference;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.util.Collections;
import java.util.Set;
import spoon.Launcher;
import spoon.SpoonException;
import spoon.reflect.annotations.MetamodelPropertyField;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtEnum;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtVisitor;
import spoon.support.SpoonClassNotFoundException;
import spoon.support.reflect.reference.CtVariableReferenceImpl;
import spoon.support.util.RtHelper;

public class CtFieldReferenceImpl<T>
extends CtVariableReferenceImpl<T>
implements CtFieldReference<T> {
    private static final long serialVersionUID = 1L;
    @MetamodelPropertyField(role={CtRole.DECLARING_TYPE})
    CtTypeReference<?> declaringType;
    @MetamodelPropertyField(role={CtRole.IS_FINAL})
    boolean fina = false;
    @MetamodelPropertyField(role={CtRole.IS_STATIC})
    boolean stat = false;

    @Override
    public void accept(CtVisitor visitor) {
        visitor.visitCtFieldReference(this);
    }

    @Override
    public Member getActualField() {
        Class<?> clazz;
        CtTypeReference<?> typeRef = this.getDeclaringType();
        if (typeRef == null) {
            throw new SpoonException("Declaring type of field " + this.getSimpleName() + " isn't defined");
        }
        try {
            clazz = typeRef.getActualClass();
        }
        catch (SpoonClassNotFoundException e) {
            if (this.getFactory().getEnvironment().getNoClasspath()) {
                Launcher.LOGGER.info("The class " + typeRef.getQualifiedName() + " of field " + this.getSimpleName() + " is not on class path. Problem ignored in noclasspath mode");
                return null;
            }
            throw e;
        }
        try {
            if (clazz.isAnnotation()) {
                return clazz.getDeclaredMethod(this.getSimpleName(), new Class[0]);
            }
            return clazz.getDeclaredField(this.getSimpleName());
        }
        catch (NoSuchFieldException | NoSuchMethodException e) {
            throw new SpoonException("The field " + this.getQualifiedName() + " not found", e);
        }
    }

    @Override
    protected AnnotatedElement getActualAnnotatedElement() {
        return (AnnotatedElement)((Object)this.getActualField());
    }

    @Override
    public CtField<T> getDeclaration() {
        return this.fromDeclaringType();
    }

    private CtField<T> fromDeclaringType() {
        if (this.declaringType == null) {
            return null;
        }
        CtElement type = this.declaringType.getDeclaration();
        if (type != null) {
            return type.getField(this.getSimpleName());
        }
        return null;
    }

    @Override
    public CtField<T> getFieldDeclaration() {
        if (this.declaringType == null) {
            return null;
        }
        CtType<?> type = this.declaringType.getTypeDeclaration();
        if (type != null) {
            CtField<?> ctField = type.getField(this.getSimpleName());
            if (ctField == null && type instanceof CtEnum) {
                return ((CtEnum)type).getEnumValue(this.getSimpleName());
            }
            return ctField;
        }
        return null;
    }

    @Override
    public CtTypeReference<?> getDeclaringType() {
        return this.declaringType;
    }

    @Override
    public String getQualifiedName() {
        CtTypeReference<?> declaringType = this.getDeclaringType();
        if (declaringType != null) {
            return this.getDeclaringType().getQualifiedName() + "#" + this.getSimpleName();
        }
        return "<unknown>#" + this.getSimpleName();
    }

    @Override
    public boolean isFinal() {
        return this.fina;
    }

    @Override
    public boolean isStatic() {
        return this.stat;
    }

    @Override
    public <C extends CtFieldReference<T>> C setDeclaringType(CtTypeReference<?> declaringType) {
        if (declaringType != null) {
            declaringType.setParent(this);
        }
        this.getFactory().getEnvironment().getModelChangeListener().onObjectUpdate((CtElement)this, CtRole.DECLARING_TYPE, declaringType, this.declaringType);
        this.declaringType = declaringType;
        return (C)this;
    }

    @Override
    public <C extends CtFieldReference<T>> C setFinal(boolean fina) {
        this.getFactory().getEnvironment().getModelChangeListener().onObjectUpdate((CtElement)this, CtRole.IS_FINAL, fina, this.fina);
        this.fina = fina;
        return (C)this;
    }

    @Override
    public <C extends CtFieldReference<T>> C setStatic(boolean stat) {
        this.getFactory().getEnvironment().getModelChangeListener().onObjectUpdate((CtElement)this, CtRole.IS_STATIC, stat, this.stat);
        this.stat = stat;
        return (C)this;
    }

    @Override
    public Set<ModifierKind> getModifiers() {
        CtVariable v = this.getDeclaration();
        if (v != null) {
            return v.getModifiers();
        }
        if (this.isParentInitialized() && this.getParent() instanceof CtFieldAccess && ((CtFieldAccess)this.getParent()).getTarget() instanceof CtTypeAccess) {
            return CtFieldReferenceImpl.emptySet();
        }
        Member m = this.getActualField();
        if (m != null) {
            return RtHelper.getModifiers(m.getModifiers());
        }
        return Collections.emptySet();
    }

    @Override
    public CtFieldReference<T> clone() {
        return (CtFieldReference)super.clone();
    }
}

