/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.reference;

import java.lang.reflect.AnnotatedElement;
import java.util.List;
import java.util.Objects;
import spoon.SpoonException;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtFormalTypeDeclarer;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeParameter;
import spoon.reflect.reference.CtActualTypeContainer;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtVisitor;
import spoon.support.DerivedProperty;
import spoon.support.UnsettableProperty;
import spoon.support.reflect.reference.CtTypeReferenceImpl;

public class CtTypeParameterReferenceImpl
extends CtTypeReferenceImpl<Object>
implements CtTypeParameterReference {
    private static final long serialVersionUID = 1L;

    @Override
    public boolean isDefaultBoundingType() {
        return this.getBoundingType().equals(this.getFactory().Type().getDefaultBoundingType());
    }

    @Override
    public void accept(CtVisitor visitor) {
        visitor.visitCtTypeParameterReference(this);
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public Class<Object> getActualClass() {
        return this.getBoundingType().getActualClass();
    }

    @Override
    @DerivedProperty
    public List<CtTypeReference<?>> getActualTypeArguments() {
        return CtTypeParameterReferenceImpl.emptyList();
    }

    @Override
    @UnsettableProperty
    public <C extends CtActualTypeContainer> C setActualTypeArguments(List<? extends CtTypeReference<?>> actualTypeArguments) {
        return (C)this;
    }

    @Override
    @UnsettableProperty
    public <C extends CtActualTypeContainer> C addActualTypeArgument(CtTypeReference<?> actualTypeArgument) {
        return (C)this;
    }

    @Override
    @UnsettableProperty
    public boolean removeActualTypeArgument(CtTypeReference<?> actualTypeArgument) {
        return false;
    }

    @Override
    @DerivedProperty
    public CtTypeReference<?> getBoundingType() {
        CtTypeReference<?> typeRef;
        CtTypeParameter typeParam = this.getDeclaration();
        if (typeParam != null && (typeRef = typeParam.getSuperclass()) != null) {
            return typeRef;
        }
        return this.getFactory().Type().getDefaultBoundingType();
    }

    @Override
    protected AnnotatedElement getActualAnnotatedElement() {
        return null;
    }

    @Override
    public CtTypeParameter getDeclaration() {
        if (!this.isParentInitialized()) {
            return null;
        }
        CtElement e = this;
        CtElement parent = this.getParent();
        if (parent instanceof CtTypeParameter && Objects.equals(this.getSimpleName(), ((CtTypeParameter)parent).getSimpleName())) {
            return (CtTypeParameter)parent;
        }
        if (parent instanceof CtTypeReference) {
            if (!parent.isParentInitialized()) {
                CtTypeReference typeReference = (CtTypeReference)parent;
                e = typeReference.getTypeDeclaration();
                if (e == null) {
                    return null;
                }
            } else {
                parent = parent.getParent();
            }
        }
        if (parent instanceof CtExecutableReference) {
            CtExecutable parent2;
            CtExecutableReference parentExec = (CtExecutableReference)parent;
            e = Objects.nonNull(parentExec.getDeclaringType()) && !parentExec.getDeclaringType().equals(e) ? ((parent2 = parentExec.getExecutableDeclaration()) instanceof CtMethod ? parent2 : e.getParent(CtFormalTypeDeclarer.class)) : e.getParent(CtFormalTypeDeclarer.class);
        } else if (!(e instanceof CtFormalTypeDeclarer)) {
            e = e.getParent(CtFormalTypeDeclarer.class);
        }
        while (e != null) {
            CtTypeParameter result = this.findTypeParamDeclaration((CtFormalTypeDeclarer)e, this.getSimpleName());
            if (result != null) {
                return result;
            }
            e = e.getParent(CtFormalTypeDeclarer.class);
        }
        return null;
    }

    private CtTypeParameter findTypeParamDeclaration(CtFormalTypeDeclarer type, String refName) {
        for (CtTypeParameter typeParam : type.getFormalCtTypeParameters()) {
            if (!typeParam.getSimpleName().equals(refName)) continue;
            return typeParam;
        }
        return null;
    }

    @Override
    public CtType<Object> getTypeDeclaration() {
        return this.getDeclaration();
    }

    @Override
    public CtTypeReference<?> getTypeErasure() {
        CtTypeParameter typeParam = this.getDeclaration();
        if (typeParam == null) {
            throw new SpoonException("Cannot resolve type erasure of the type parameter reference, which is not able to found it's declaration.");
        }
        return typeParam.getTypeErasure();
    }

    @Override
    public boolean isSubtypeOf(CtTypeReference<?> type) {
        return this.getTypeDeclaration().isSubtypeOf(type);
    }

    @Override
    public CtTypeParameterReference clone() {
        return (CtTypeParameterReference)super.clone();
    }

    @Override
    public boolean isGenerics() {
        if (this.getDeclaration() instanceof CtTypeParameter) {
            return true;
        }
        return this.getBoundingType() != null && this.getBoundingType().isGenerics();
    }

    protected boolean isWildcard() {
        return false;
    }

    @Override
    public boolean isSimplyQualified() {
        return false;
    }

    @Override
    @UnsettableProperty
    public CtTypeParameterReferenceImpl setSimplyQualified(boolean isSimplyQualified) {
        return this;
    }
}

