/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.sniper.internal;

import java.util.List;
import spoon.SpoonException;
import spoon.reflect.declaration.CtCompilationUnit;
import spoon.reflect.path.CtRole;
import spoon.support.sniper.internal.AbstractSourceFragmentPrinter;
import spoon.support.sniper.internal.ChangeResolver;
import spoon.support.sniper.internal.ElementSourceFragment;
import spoon.support.sniper.internal.ModificationStatus;
import spoon.support.sniper.internal.MutableTokenWriter;
import spoon.support.sniper.internal.PrinterEvent;
import spoon.support.sniper.internal.SourceFragment;
import spoon.support.sniper.internal.TokenPrinterEvent;
import spoon.support.sniper.internal.TokenType;

abstract class AbstractSourceFragmentContextCollection
extends AbstractSourceFragmentPrinter {
    protected AbstractSourceFragmentContextCollection(MutableTokenWriter mutableTokenWriter, List<SourceFragment> fragments, ChangeResolver changeResolver) {
        super(mutableTokenWriter, changeResolver, fragments);
    }

    @Override
    public boolean knowsHowToPrint(PrinterEvent event) {
        if (!this.hasNextChildToken()) {
            return false;
        }
        if (event instanceof TokenPrinterEvent) {
            TokenPrinterEvent tpe = (TokenPrinterEvent)event;
            if (tpe.isWhitespace()) {
                return true;
            }
            if (TokenType.KEYWORD.equals((Object)tpe.getTokenType())) {
                for (SourceFragment f : this.childFragments) {
                    if (!f.getSourceCode().contains(tpe.getToken())) continue;
                    return true;
                }
                return false;
            }
            if (tpe.getType() == TokenType.IDENTIFIER) {
                return this.findIndexOfNextChildTokenByType(TokenType.IDENTIFIER) >= 0;
            }
            return this.findIndexOfNextChildTokenByValue(tpe.getToken()) >= 0;
        }
        CtRole role = event.getRole();
        if (role == CtRole.COMMENT) {
            return true;
        }
        if (role != null) {
            return this.findIndexOfNextChildTokenOfRole(0, role) >= 0;
        }
        if (event.getElement() instanceof CtCompilationUnit) {
            return this.findIndexOfNextChildTokenOfElement(event.getElement()) >= 0;
        }
        throw new SpoonException("Unexpected PrintEvent: " + event.getClass());
    }

    @Override
    protected ModificationStatus isFragmentModified(SourceFragment fragment) {
        return ModificationStatus.UNKNOWN;
    }

    protected String getSuffixSpace() {
        SourceFragment item;
        if (this.childFragments.size() > 0 && ElementSourceFragment.isSpaceFragment(item = (SourceFragment)this.childFragments.get(this.childFragments.size() - 1))) {
            return item.getSourceCode();
        }
        return null;
    }

    @Override
    public void onFinished() {
        String suffix = this.getSuffixSpace();
        if (suffix != null) {
            this.mutableTokenWriter.writeCodeSnippet(suffix);
        }
    }
}

