/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.sniper.internal;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import spoon.SpoonException;
import spoon.reflect.code.CtComment;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.cu.CompilationUnit;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.cu.SourcePositionHolder;
import spoon.reflect.cu.position.NoSourcePosition;
import spoon.reflect.declaration.CtCompilationUnit;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtModifiable;
import spoon.reflect.meta.ContainerKind;
import spoon.reflect.meta.RoleHandler;
import spoon.reflect.meta.impl.RoleHandlerHelper;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtLocalVariableReference;
import spoon.reflect.visitor.EarlyTerminatingScanner;
import spoon.support.Experimental;
import spoon.support.reflect.CtExtendedModifier;
import spoon.support.reflect.cu.position.SourcePositionImpl;
import spoon.support.sniper.internal.CollectionSourceFragment;
import spoon.support.sniper.internal.SourceFragment;
import spoon.support.sniper.internal.TokenSourceFragment;
import spoon.support.sniper.internal.TokenType;

@Experimental
public class ElementSourceFragment
implements SourceFragment {
    public static final ElementSourceFragment NO_SOURCE_FRAGMENT = new ElementSourceFragment(null, null);
    private final SourcePositionHolder element;
    private final RoleHandler roleHandlerInParent;
    private ElementSourceFragment nextSibling;
    private ElementSourceFragment firstChild;
    private static final Set<String> separators = new HashSet<String>(Arrays.asList("->", "::", "..."));
    private static final Set<String> operators;
    private static final String[] javaKeywordsJoined;
    private static final Set<String> javaKeywords;
    private static final List<StringMatcher> matchers;

    public ElementSourceFragment(SourcePositionHolder element, RoleHandler roleHandlerInParent) {
        this.element = element;
        this.roleHandlerInParent = roleHandlerInParent;
    }

    public int getStart() {
        if (this.firstChild != null) {
            return Math.min(this.getSourcePosition().getSourceStart(), this.firstChild.getStart());
        }
        return this.getSourcePosition().getSourceStart();
    }

    public int getEnd() {
        if (this.firstChild != null) {
            return Math.max(this.getSourcePosition().getSourceEnd() + 1, this.firstChild.getLastSibling().getEnd());
        }
        return this.getSourcePosition().getSourceEnd() + 1;
    }

    public SourcePosition getSourcePosition() {
        return this.element.getPosition();
    }

    public String toString() {
        String result = "|" + this.getStart() + ", " + this.getEnd() + "|" + this.getSourceCode() + "|";
        if (this.element instanceof CtElement) {
            return ((CtElement)this.element).toStringDebug() + result;
        }
        return result;
    }

    @Override
    public String getSourceCode() {
        return this.getSourceCode(this.getStart(), this.getEnd());
    }

    public String getSourceCode(int start, int end) {
        String src = this.getOriginalSourceCode();
        if (src != null) {
            return src.substring(start, end);
        }
        return null;
    }

    public static ElementSourceFragment createSourceFragmentsFrom(CtElement element) {
        ElementSourceFragment rootFragment = new ElementSourceFragment(element, null);
        final ArrayDeque<ElementSourceFragment> parents = new ArrayDeque<ElementSourceFragment>();
        parents.push(rootFragment);
        new EarlyTerminatingScanner<Void>(){

            @Override
            public <T> void visitCtFieldReference(CtFieldReference<T> reference) {
                this.enter(reference);
                this.scan(CtRole.DECLARING_TYPE, reference.getDeclaringType());
                this.scan(CtRole.ANNOTATION, reference.getAnnotations());
                this.exit(reference);
            }

            @Override
            public <T> void visitCtField(CtField<T> f) {
                if (f.isPartOfJointDeclaration()) {
                    return;
                }
                super.visitCtField(f);
            }

            @Override
            public <T> void visitCtLocalVariable(CtLocalVariable<T> localVar) {
                if (localVar.isPartOfJointDeclaration()) {
                    return;
                }
                super.visitCtLocalVariable(localVar);
            }

            @Override
            public <T> void visitCtLocalVariableReference(CtLocalVariableReference<T> reference) {
                this.enter(reference);
                this.exit(reference);
            }

            @Override
            protected void enter(CtElement e) {
                if (((ElementSourceFragment)parents.peek()).getElement() == e) {
                    return;
                }
                if (e instanceof CtCompilationUnit) {
                    return;
                }
                ElementSourceFragment currentFragment = ((ElementSourceFragment)parents.peek()).addChild(this.scannedRole, e);
                if (currentFragment != null) {
                    parents.push(currentFragment);
                    if (e instanceof CtModifiable) {
                        CtModifiable modifiable = (CtModifiable)e;
                        Set<CtExtendedModifier> modifiers = modifiable.getExtendedModifiers();
                        for (CtExtendedModifier ctExtendedModifier : modifiers) {
                            currentFragment.addChild(CtRole.MODIFIER, ctExtendedModifier);
                        }
                    }
                }
            }

            @Override
            protected void exit(CtElement e) {
                if (e instanceof CtCompilationUnit) {
                    return;
                }
                ElementSourceFragment topFragment = (ElementSourceFragment)parents.peek();
                if (topFragment != null && topFragment.getElement() == e) {
                    parents.pop();
                }
            }
        }.setVisitCompilationUnitContent(true).scan(element.getRoleInParent(), element);
        return rootFragment;
    }

    private ElementSourceFragment addChild(CtRole roleInParent, SourcePositionHolder otherElement) {
        SourcePosition otherSourcePosition = otherElement.getPosition();
        if (otherSourcePosition instanceof SourcePositionImpl && !(otherSourcePosition.getCompilationUnit() instanceof NoSourcePosition.NullCompilationUnit)) {
            ElementSourceFragment otherFragment = new ElementSourceFragment(otherElement, this.getRoleHandler(roleInParent, otherElement));
            this.addChild(otherFragment);
            return otherFragment;
        }
        return null;
    }

    private RoleHandler getRoleHandler(CtRole roleInParent, SourcePositionHolder otherElement) {
        SourcePositionHolder parent = this.element;
        if (parent == null && otherElement instanceof CtElement) {
            parent = ((CtElement)otherElement).getParent();
        }
        if (parent instanceof CtElement) {
            CtElement ele = (CtElement)parent;
            return RoleHandlerHelper.getRoleHandler(ele.getClass(), roleInParent);
        }
        return null;
    }

    public ElementSourceFragment add(ElementSourceFragment other) {
        if (this == other) {
            throw new SpoonException("SourceFragment#add must not be called twice for the same SourceFragment");
        }
        CMP cmp = this.compare(other);
        switch (cmp) {
            case OTHER_IS_AFTER: {
                this.addNextSibling(other);
                return this;
            }
            case OTHER_IS_BEFORE: {
                other.addNextSibling(this);
                return other;
            }
            case OTHER_IS_CHILD: {
                this.addChild(other);
                return this;
            }
            case OTHER_IS_PARENT: {
                other.addChild(this);
                return other;
            }
        }
        throw new SpoonException("Unexpected compare result: " + (Object)((Object)cmp));
    }

    private void addChild(ElementSourceFragment fragment) {
        this.firstChild = this.firstChild == null ? fragment : this.firstChild.add(fragment);
    }

    private void addNextSibling(ElementSourceFragment sibling) {
        this.nextSibling = this.nextSibling == null ? sibling : this.nextSibling.add(sibling);
    }

    private ElementSourceFragment getLastSibling() {
        ElementSourceFragment lastSibling = this;
        while (lastSibling.nextSibling != null) {
            lastSibling = lastSibling.nextSibling;
        }
        return lastSibling;
    }

    private CMP compare(ElementSourceFragment other) {
        if (other == this) {
            throw new SpoonException("SourcePositionImpl#addNextSibling must not be called twice for the same SourcePosition");
        }
        if (this.getEnd() <= other.getStart()) {
            return CMP.OTHER_IS_AFTER;
        }
        if (other.getEnd() <= this.getStart()) {
            return CMP.OTHER_IS_BEFORE;
        }
        if (this.getStart() <= other.getStart() && this.getEnd() >= other.getEnd()) {
            return CMP.OTHER_IS_CHILD;
        }
        if (this.getStart() >= other.getStart() && this.getEnd() <= other.getEnd()) {
            return CMP.OTHER_IS_PARENT;
        }
        throw new SpoonException("Cannot compare this: [" + this.getStart() + ", " + this.getEnd() + "] with other: [\"" + other.getStart() + "\", \"" + other.getEnd() + "\"]");
    }

    public ElementSourceFragment getNextSibling() {
        return this.nextSibling;
    }

    public ElementSourceFragment getFirstChild() {
        return this.firstChild;
    }

    public ElementSourceFragment getSourceFragmentOf(SourcePositionHolder element, int start, int end) {
        int myEnd = this.getEnd();
        if (myEnd <= start) {
            if (this.nextSibling == null) {
                return null;
            }
            return this.getRootFragmentOfElement(this.nextSibling.getSourceFragmentOf(element, start, end));
        }
        int myStart = this.getStart();
        if (myStart <= start) {
            if (myEnd >= end) {
                if (myStart == start && myEnd == end) {
                    if (element != null && this.getElement() != element) {
                        if (this.firstChild == null) {
                            throw new SpoonException("There is no source fragment for element " + element.toString() + ". There is one for class " + this.getElement().toString());
                        }
                        return this.firstChild.getSourceFragmentOf(element, start, end);
                    }
                    return this;
                }
                if (this.firstChild == null) {
                    if (element != null && this.getElement() != element) {
                        throw new SpoonException("There is no source fragment for element " + element.getClass() + ". There is one for class " + this.getElement().getClass());
                    }
                    return this;
                }
                ElementSourceFragment child = this.getRootFragmentOfElement(this.firstChild.getSourceFragmentOf(element, start, end));
                if (child != null) {
                    return child;
                }
                if (element != null && this.getElement() != element) {
                    throw new SpoonException("There is no source fragment for element " + element.getClass() + ". There is one for class " + this.getElement().getClass());
                }
                return this;
            }
            throw new SpoonException("Invalid start/end interval. It overlaps multiple fragments.");
        }
        return null;
    }

    private ElementSourceFragment getRootFragmentOfElement(ElementSourceFragment childFragment) {
        if (childFragment != null && this.getElement() != null && childFragment.getElement() == this.getElement()) {
            return this;
        }
        return childFragment;
    }

    public SourcePositionHolder getElement() {
        return this.element;
    }

    public List<SourceFragment> getChildrenFragments() {
        if (this.element instanceof CtLiteral) {
            return Collections.singletonList(new TokenSourceFragment(this.getSourceCode(), TokenType.LITERAL));
        }
        ArrayList<SourceFragment> children = new ArrayList<SourceFragment>();
        int off = this.getStart();
        for (ElementSourceFragment child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            this.forEachConstantFragment(off, child.getStart(), cf -> children.add((SourceFragment)cf));
            children.add(child);
            off = child.getEnd();
        }
        this.forEachConstantFragment(off, this.getEnd(), cf -> children.add((SourceFragment)cf));
        return children;
    }

    public List<SourceFragment> getGroupedChildrenFragments() {
        List<SourceFragment> flatChildren = this.getChildrenFragments();
        ArrayList<SourceFragment> result = new ArrayList<SourceFragment>();
        int i2 = 0;
        while (i2 < flatChildren.size()) {
            SourceFragment child = flatChildren.get(i2);
            if (child instanceof TokenSourceFragment) {
                result.add(child);
                ++i2;
                continue;
            }
            if (child instanceof ElementSourceFragment) {
                ElementSourceFragment esf = (ElementSourceFragment)child;
                ContainerKind kind = esf.getContainerKindInParent();
                if (kind == ContainerKind.SINGLE) {
                    result.add(child);
                    ++i2;
                    continue;
                }
                HashSet<CtRole> foundRoles = new HashSet<CtRole>();
                foundRoles.add(this.checkNotNull(esf.getRoleInParent()));
                ArrayList<SourceFragment> childrenInSameCollection = new ArrayList<SourceFragment>();
                SourceFragment spaceChild = this.removeSuffixSpace(result);
                if (spaceChild != null) {
                    childrenInSameCollection.add(spaceChild);
                }
                childrenInSameCollection.add(esf);
                int lastOfSameRole = ElementSourceFragment.findIndexOfLastChildTokenOfRoleHandler(flatChildren, i2, esf.getRoleInParent());
                ++i2;
                while (i2 <= lastOfSameRole) {
                    child = flatChildren.get(i2);
                    childrenInSameCollection.add(child);
                    CtRole role = null;
                    if (child instanceof ElementSourceFragment) {
                        ElementSourceFragment esf2 = (ElementSourceFragment)child;
                        role = esf2.getRoleInParent();
                    }
                    if (role != null && role != CtRole.COMMENT && foundRoles.add(role)) {
                        lastOfSameRole = Math.max(lastOfSameRole, ElementSourceFragment.findIndexOfLastChildTokenOfRoleHandler(flatChildren, i2 + 1, role));
                    }
                    ++i2;
                }
                result.add(new CollectionSourceFragment(childrenInSameCollection));
                continue;
            }
            throw new SpoonException("Unexpected SourceFragment of type " + child.getClass());
        }
        return result;
    }

    private SourceFragment removeSuffixSpace(List<SourceFragment> list) {
        SourceFragment lastChild;
        if (list.size() > 0 && ElementSourceFragment.isSpaceFragment(lastChild = list.get(list.size() - 1))) {
            list.remove(list.size() - 1);
            return lastChild;
        }
        return null;
    }

    private <T> T checkNotNull(T o) {
        if (o == null) {
            throw new SpoonException("Unexpected null value");
        }
        return o;
    }

    private static int findIndexOfLastChildTokenOfRoleHandler(List<SourceFragment> childFragments, int start, CtRole role) {
        return ElementSourceFragment.findIndexOfPreviousFragment(childFragments, start, ElementSourceFragment.filter(ElementSourceFragment.class, fragment -> fragment.getRoleInParent() == role));
    }

    private void forEachConstantFragment(int start, int end, Consumer<SourceFragment> consumer) {
        if (start == end) {
            return;
        }
        if (start > end) {
            throw new SpoonException("Inconsistent start/end. Start=" + start + " is greater then End=" + end);
        }
        String sourceCode = this.getOriginalSourceCode();
        if (sourceCode.length() == 0) {
            return;
        }
        StringBuilder buff = new StringBuilder();
        CharType lastType = null;
        for (int off = start; off < end; ++off) {
            char c = sourceCode.charAt(off);
            CharType type = CharType.fromChar(c);
            if (type != lastType) {
                if (lastType != null) {
                    this.onCharSequence(lastType, buff, consumer);
                    buff.setLength(0);
                }
                lastType = type;
            }
            buff.append(c);
        }
        this.onCharSequence(lastType, buff, consumer);
    }

    private void onCharSequence(CharType type, StringBuilder buff, Consumer<SourceFragment> consumer) {
        if (type == CharType.SPACE) {
            consumer.accept(new TokenSourceFragment(buff.toString(), TokenType.SPACE));
            return;
        }
        char[] str = new char[buff.length()];
        buff.getChars(0, buff.length(), str, 0);
        int off = 0;
        while (off < str.length) {
            int lenOfIdentifier = this.detectJavaIdentifier(str, off);
            if (lenOfIdentifier > 0) {
                String identifier = new String(str, off, lenOfIdentifier);
                if (javaKeywords.contains(identifier)) {
                    consumer.accept(new TokenSourceFragment(identifier, TokenType.KEYWORD));
                } else {
                    consumer.accept(new TokenSourceFragment(identifier, TokenType.IDENTIFIER));
                }
                off += lenOfIdentifier;
                continue;
            }
            StringMatcher longestMatcher = null;
            for (StringMatcher strMatcher : matchers) {
                if (!strMatcher.isMatch(str, off)) continue;
                longestMatcher = strMatcher.getLonger(longestMatcher);
            }
            if (longestMatcher == null) {
                consumer.accept(new TokenSourceFragment(str.toString(), TokenType.CODE_SNIPPET));
                return;
            }
            consumer.accept(new TokenSourceFragment(longestMatcher.toString(), longestMatcher.getType()));
            off += longestMatcher.getLength();
        }
    }

    private int detectJavaIdentifier(char[] buff, int start) {
        char c;
        int len = buff.length;
        int o = start;
        if (start <= len && Character.isJavaIdentifierStart(c = buff[o])) {
            ++o;
            while (o < len && Character.isJavaIdentifierPart(c = buff[o])) {
                ++o;
            }
        }
        return o - start;
    }

    private String getOriginalSourceCode() {
        CompilationUnit cu = this.getSourcePosition().getCompilationUnit();
        if (cu != null) {
            return cu.getOriginalSourceCode();
        }
        return null;
    }

    public CtRole getRoleInParent() {
        return this.roleHandlerInParent != null ? this.roleHandlerInParent.getRole() : null;
    }

    public ContainerKind getContainerKindInParent() {
        if (this.roleHandlerInParent != null && this.roleHandlerInParent.getRole() != CtRole.COMMENT) {
            return this.roleHandlerInParent.getContainerKind();
        }
        return ContainerKind.SINGLE;
    }

    static int findIndexOfNextFragment(List<SourceFragment> fragments, int start, Predicate<SourceFragment> test) {
        while (start < fragments.size()) {
            SourceFragment fragment = fragments.get(start);
            if (test.test(fragment)) {
                return start;
            }
            ++start;
        }
        return -1;
    }

    static int findIndexOfPreviousFragment(List<SourceFragment> fragments, int start, Predicate<SourceFragment> test) {
        for (int i2 = fragments.size() - 1; i2 >= start; --i2) {
            if (!test.test(fragments.get(i2))) continue;
            return i2;
        }
        return -1;
    }

    static Predicate<SourceFragment> checkCollectionItems(Predicate<SourceFragment> predicate) {
        return fragment -> {
            if (fragment instanceof CollectionSourceFragment) {
                CollectionSourceFragment collectionFragment = (CollectionSourceFragment)fragment;
                for (SourceFragment itemFragment : collectionFragment.getItems()) {
                    if (!predicate.test(itemFragment)) continue;
                    return true;
                }
                return false;
            }
            return predicate.test((SourceFragment)fragment);
        };
    }

    static <T extends SourceFragment> Predicate<SourceFragment> filter(Class<T> clazz, Predicate<T> predicate) {
        return fragment -> {
            if (clazz.isInstance(fragment)) {
                return predicate.test(fragment);
            }
            return false;
        };
    }

    static boolean isSpaceFragment(SourceFragment fragment) {
        return fragment instanceof TokenSourceFragment && ((TokenSourceFragment)fragment).getType() == TokenType.SPACE;
    }

    static boolean isCommentFragment(SourceFragment fragment) {
        return fragment instanceof ElementSourceFragment && ((ElementSourceFragment)fragment).getElement() instanceof CtComment;
    }

    static {
        "(){}[];,.:@=<>?&|".chars().forEach(c -> separators.add(new String(Character.toChars(c))));
        operators = new HashSet<String>(Arrays.asList("=", ">", "<", "!", "~", "?", ":", "==", "<=", ">=", "!=", "&&", "||", "++", "--", "+", "-", "*", "/", "&", "|", "^", "%", "<<", ">>", ">>>", "+=", "-=", "*=", "/=", "&=", "|=", "^=", "%=", "<<=", ">>=", ">>>="));
        javaKeywordsJoined = new String[]{"abstract continue for new switch", "assert default goto package synchronized", "boolean do if private this", "break double implements protected throw", "byte else import public throws", "case enum instanceof return transient", "catch extends int short try", "char final interface static void", "class finally long strictfp volatile", "const float native super while"};
        javaKeywords = new HashSet<String>();
        for (String str : javaKeywordsJoined) {
            StringTokenizer st = new StringTokenizer(str, " ");
            while (st.hasMoreTokens()) {
                javaKeywords.add(st.nextToken());
            }
        }
        matchers = new ArrayList<StringMatcher>();
        separators.forEach(s -> matchers.add(new StringMatcher((String)s, TokenType.SEPARATOR)));
        operators.forEach(s -> matchers.add(new StringMatcher((String)s, TokenType.OPERATOR)));
    }

    private static final class StringMatcher {
        private final TokenType type;
        private final char[] chars;

        private StringMatcher(String str, TokenType type) {
            this.type = type;
            this.chars = str.toCharArray();
        }

        public boolean isMatch(char[] buffer, int pos) {
            int len = this.chars.length;
            if (pos + len > buffer.length) {
                return false;
            }
            int i2 = 0;
            while (i2 < this.chars.length) {
                if (this.chars[i2] != buffer[pos]) {
                    return false;
                }
                ++i2;
                ++pos;
            }
            return true;
        }

        public String toString() {
            return new String(this.chars);
        }

        public int getLength() {
            return this.chars.length;
        }

        public StringMatcher getLonger(StringMatcher m) {
            if (m != null && m.getLength() > this.getLength()) {
                return m;
            }
            return this;
        }

        public TokenType getType() {
            return this.type;
        }
    }

    private static enum CharType {
        SPACE,
        NON_SPACE;


        static CharType fromChar(char c) {
            return Character.isWhitespace(c) ? SPACE : NON_SPACE;
        }
    }

    private static enum CMP {
        OTHER_IS_BEFORE,
        OTHER_IS_AFTER,
        OTHER_IS_CHILD,
        OTHER_IS_PARENT;

    }
}

