/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.sniper.internal;

import spoon.compiler.Environment;
import spoon.reflect.code.CtComment;
import spoon.reflect.visitor.DefaultTokenWriter;
import spoon.reflect.visitor.PrinterHelper;
import spoon.reflect.visitor.TokenWriter;

public class MutableTokenWriter
implements TokenWriter {
    private final TokenWriter delegate;
    private boolean muted = false;

    public MutableTokenWriter(Environment env) {
        this.delegate = new DefaultTokenWriter(new PrinterHelper(env));
    }

    public boolean isMuted() {
        return this.muted;
    }

    public void setMuted(boolean muted) {
        this.muted = muted;
    }

    @Override
    public TokenWriter writeSeparator(String token) {
        if (this.isMuted()) {
            this.getPrinterHelper().setShouldWriteTabs(false);
            return this;
        }
        this.delegate.writeSeparator(token);
        return this;
    }

    @Override
    public TokenWriter writeOperator(String token) {
        if (this.isMuted()) {
            this.getPrinterHelper().setShouldWriteTabs(false);
            return this;
        }
        this.delegate.writeOperator(token);
        return this;
    }

    @Override
    public TokenWriter writeLiteral(String token) {
        if (this.isMuted()) {
            this.getPrinterHelper().setShouldWriteTabs(false);
            return this;
        }
        this.delegate.writeLiteral(token);
        return this;
    }

    @Override
    public TokenWriter writeKeyword(String token) {
        if (this.isMuted()) {
            this.getPrinterHelper().setShouldWriteTabs(false);
            return this;
        }
        this.delegate.writeKeyword(token);
        return this;
    }

    @Override
    public TokenWriter writeIdentifier(String token) {
        if (this.isMuted()) {
            this.getPrinterHelper().setShouldWriteTabs(false);
            return this;
        }
        this.delegate.writeIdentifier(token);
        return this;
    }

    @Override
    public TokenWriter writeCodeSnippet(String token) {
        if (this.isMuted()) {
            this.getPrinterHelper().setShouldWriteTabs(false);
            return this;
        }
        this.delegate.writeCodeSnippet(token);
        return this;
    }

    @Override
    public TokenWriter writeComment(CtComment comment) {
        if (this.isMuted()) {
            this.getPrinterHelper().setShouldWriteTabs(false);
            return this;
        }
        this.delegate.writeComment(comment);
        return this;
    }

    @Override
    public TokenWriter writeln() {
        if (this.isMuted()) {
            this.getPrinterHelper().setShouldWriteTabs(false);
            return this;
        }
        this.delegate.writeln();
        return this;
    }

    @Override
    public TokenWriter incTab() {
        if (this.isMuted()) {
            return this;
        }
        this.delegate.incTab();
        return this;
    }

    @Override
    public TokenWriter decTab() {
        if (this.isMuted()) {
            return this;
        }
        this.delegate.decTab();
        return this;
    }

    @Override
    public PrinterHelper getPrinterHelper() {
        return this.delegate.getPrinterHelper();
    }

    @Override
    public void reset() {
        if (this.isMuted()) {
            return;
        }
        this.delegate.reset();
    }

    @Override
    public TokenWriter writeSpace() {
        if (this.isMuted()) {
            this.getPrinterHelper().setShouldWriteTabs(false);
            return this;
        }
        this.delegate.writeSpace();
        return this;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public void directPrint(String text) {
        int len = text.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char c = text.charAt(i2);
            this.getPrinterHelper().setShouldWriteTabs(false);
            this.getPrinterHelper().write(c);
        }
    }

    public TokenWriter write(String text) {
        if (this.isMuted()) {
            return this;
        }
        this.directPrint(text);
        return this;
    }
}

